<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;
use common\components\CHelper;
$product = \common\models\Product::find()->asArray()->andWhere(['display'=>1])->orderBy('ordid desc,updatetime desc,id desc')->limit(8)->all();
foreach ($product as $key => $value) {
    if($product[$key]['url']){
        $product[$key]['target'] = "_blank";
    }else{
        $product[$key]['url'] = Yii::$app->urlManager->createUrl(['product/detail','id'=>$value['id']]);
        $product[$key]['target'] = "_self";
    }
    $product[$key]['thumb'] = $value['thumb']?CHelper::attach($value['thumb'],'product/thumb'):RESOURCE_DIR.Yii::$app->params['product_no_thumb'];
}
$news = \common\models\Article::find()->asArray()->andWhere(['display'=>1])->orderBy('ordid desc,updatetime desc,id desc')->limit(3)->all();
foreach ($news as $key => $value) {
    $news[$key]['brief'] = strip_tags($value['content']);
    $news[$key]['brief'] = CHelper::cutStr($news[$key]['brief'],120);
    if($news[$key]['url']){
        $news[$key]['target'] = "_blank";
    }else{
        $news[$key]['url'] = Yii::$app->urlManager->createUrl(['news/detail','id'=>$value['id']]);
        $news[$key]['target'] = "_self";
    }
    $news[$key]['thumb'] = $value['thumb']?CHelper::attach($value['thumb'],'article/thumb'):RESOURCE_DIR.Yii::$app->params['news_no_thumb'];
}
$link = \common\models\Link::find()->asArray()->andWhere(['display'=>1,'type'=>1])->orderBy('ordid desc,id desc')->all();
foreach ($link as $key => $value) {
    $link[$key]['link_logo'] = CHelper::attach($value['link_logo'],'link');
}
$about_category = \common\models\About::getCache();
$product_category = \common\models\ProductCategory::getCache();
$news_category = \common\models\ArticleCategory::getCache();
AppAsset::register($this);
$this->seo_title = Yii::$app->params['seo_title'];
$this->seo_keywords = Yii::$app->params['seo_keywords'];
$this->seo_description = Yii::$app->params['seo_description'];
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
  <meta charset="<?= Yii::$app->charset ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <?= Html::csrfMetaTags() ?>
  <title><?= ($this->seo_title?Html::encode($this->seo_title):Yii::$app->params['sitename']); ?></title>
  <?= $this->seo_keywords?$this->registerMetaTag(['name'=>'keywords','content'=>Html::encode($this->seo_keywords)]):''; ?>
  <?= $this->seo_description?$this->registerMetaTag(['name'=>'description','content'=>Html::encode($this->seo_description)]):''; ?>
  <?php $this->head() ?>
  <?= $this->registerMetaTag(['name'=>'author','content'=>Yii::$app->params['author']]); ?>
  <?= $this->registerMetaTag(['name'=>'copyright','content'=>Yii::$app->params['copyright']]); ?>
  <?= $this->registerCssFile($this->theme->getUrl('css/amazeui.css'));?>
  <?= $this->registerCssFile($this->theme->getUrl('css/common.min.css'));?>
<?= $this->registerCssFile($this->theme->getUrl('css/index.min.css'));?>
  <link rel="shortcut icon" href="<?php echo Yii::$app->params['sitedir'];?>favicon.ico" />
</head>
<body>
<?php $this->beginBody() ?>
<div class="layout">
<!--===========layout-header================-->
<div class="layout-header am-hide-sm-only">
  <div class="header-box" data-am-sticky>
    <!--header start-->
      <div class="container">
        <div class="header">
          <div class="am-g">
            <div class="am-u-lg-2 am-u-sm-12">
              <div class="logo">
                <a href=""><img src="<?= Yii::$app->params['logo']?CHelper::attach(Yii::$app->params['logo'],'logo'):RESOURCE_DIR.'logo.png'; ?>" alt="" /></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    <!--header end-->
    <!--nav start-->
    <div class="nav-contain">
      <div class="nav-inner">
        <?php echo frontend\widgets\NavWidget::widget();?>
      </div>
    </div>
    <!--nav end-->
  </div>
</div>
<?php



?>


    <!--===========layout-container================-->
    <div class="layout-container">
      <div class="index-page">
        <div data-am-widget="tabs" class="am-tabs am-tabs-default">
          <div class="am-tabs-bd">
          <?php
            $ad = frontend\widgets\AdWidget::widget(['alias'=>'yunduo_index_focus','limit'=>4]);
            $ad = json_decode($ad,1);
            foreach ($ad['list'] as $key => $value) {
          ?>
            <div data-tab-panel-<?php echo $key;?> class="am-tab-panel <?php if($key==0){?>am-active<?php }?>">
              <div class="index-banner" style="background-image:url(<?php echo $value['img'];?>)">
                <div class="index-mask"></div>
              </div>
            </div>
            <?php }?>
          </div>

          <ul class="am-tabs-nav am-cf index-tab">
          <?php
            foreach ($ad['list'] as $key => $value) {
          ?>
            <li <?php if($key==0){?>class="am-active"<?php }?>>
              <a href="[data-tab-panel-0] am-g">
                <div class="am-u-md-3 am-u-sm-3 am-padding-right-0">
                </div>
                <div class="school-item-right am-u-md-9 am-u-sm-9 am-text-left">
                  <strong class="promo_slider_nav--item_title"><?php echo $value['title'];?></strong>
                </div>
              </a>
            </li>
            <?php }?>
          </ul>
        </div>
      </div>
    </div>


    <div class="section">
      <div class="container">
        <div class="section--header">
            <h2 class="section--title">推荐产品</h2>
        </div>
        <!--index-container start-->
        <div class="index-container">
          <div class="am-g">
          <?php foreach($product as $key=>$value){?>
            <div class="am-u-md-3">
                <div class="features_item">
                    <a href="<?php echo $value['url'];?>" target="_blank">
                    <img src="<?php echo $value['thumb'];?>" alt="<?php echo Html::encode($value['name']);?>" width="262" height="198">
                    <h3 class="features_item--title"><?php echo Html::encode($value['name']);?></h3>
                    </a>
                </div>
            </div>
            <?php }?>
          </div>
          <div class="index-more">
            <a href="<?php echo Yii::$app->urlManager->createUrl(['product/index']);?>" class="am-btn am-btn-secondary">查看更多&nbsp;&nbsp;>></a>
          </div>
        </div>
        <!--index-container end-->
      </div>
    </div>
    
  <!--promo_detailed start-->
  <div class="section">
    <div class="section--header">
        <h2 class="section--title">最新资讯</h2>
    </div>
    <div class="promo_detailed">
    <div class="promo_detailed-container" >
      <div class="container index-container">
        <div class="am-g">
          <div class="am-u-md-12">
            <ul class="promo_detailed--list">
            <?php foreach($news as $key=>$value){?>
              <li class="promo_detailed--list_item">
                <span class="promo_detailed--list_item_icon">
                  <img src="<?php echo $value['thumb'];?>" width="180" height="110"/>
                </span>
                <dl>
                  <dt><a href="<?php echo $value['url'];?>" target="_blank"><?php echo Html::encode($value['title']);?></a></dt>
                  <dd>
                    <?php echo Html::encode($value['brief']);?>
                  </dd>
                </dl>
              </li>
              <?php }?>
              
            </ul>
          </div>
            <div class="index-more">
            <a href="<?php echo Yii::$app->urlManager->createUrl(['news/index']);?>" class="am-btn am-btn-secondary">查看更多&nbsp;&nbsp;>></a>
          </div>
        </div>
      </div>
    </div>
  </div>
  </div>
  
  <!--promo_detailed end-->
  </div>

  <!--customer-logo start-->
    <div class="customer-logo">
      <div class="container">
        <div class="am-g">
        <?php foreach($link as $key=>$value){?>
          <div class="am-u-md-2 am-u-sm-4 customer-box">
            <a href="<?php echo $value['link_url'];?>" target="_blank">
              <img class="normal-logo" width="180" height="50" src="<?= $value['link_logo']; ?>" alt="<?= Html::encode($value['link_name']);?>" />
            </a>
          </div>
          <?php }?>
        </div>
      </div>
    </div>
  <!--customer-logo end-->



    <!--===========layout-footer================-->
  <div class="layout-footer">
    <div class="footer">
      <div style="background-color:#383d61" class="footer--bg"></div>
      <div class="footer--inner">
        <div class="container">
          <div class="footer_main">
            <div class="am-g">
              <div class="am-u-md-2 ">
                <div class="footer_main--column">
                  <strong class="footer_main--column_title">关于我们</strong>
                  <ul class="footer_navigation">
                  <?php foreach($about_category as $key=>$value){?>
                    <li class="footer_navigation--item"><a target="_blank" href="<?php echo Yii::$app->urlManager->createUrl(['about/detail','id'=>$value['id']]);?>" class="footer_navigation--link"><?php echo $value['title'];?></a></li>
                <?php }?>
                  </ul>
                </div>
              </div>
              
              <div class="am-u-md-2 ">
                <div class="footer_main--column">
                  <strong class="footer_main--column_title">产品中心</strong>
                  <ul class="footer_navigation">
                  <?php foreach($product_category as $key=>$value){?>
                    <li class="footer_navigation--item"><a target="_blank" href="<?php echo Yii::$app->urlManager->createUrl(['product/list','cid'=>$key]);?>" class="footer_navigation--link"><?php echo $value;?></a></li>
                <?php }?>
                  </ul>
                </div>
              </div>

              <div class="am-u-md-2 ">
                <div class="footer_main--column">
                  <strong class="footer_main--column_title">新闻中心</strong>
                  <ul class="footer_navigation">
                  <?php foreach($news_category as $key=>$value){?>
                    <li class="footer_navigation--item"><a target="_blank" href="<?php echo Yii::$app->urlManager->createUrl(['news/list','cid'=>$key]);?>" class="footer_navigation--link"><?php echo $value;?></a></li>
                <?php }?>
                  </ul>
                </div>
              </div>

              <div class="am-u-md-3 ">
                <div class="footer_main--column">
                  <strong class="footer_main--column_title">联系我们</strong>
                  <ul class="footer_contact_info">
                    <?php if(Yii::$app->params['tel']){?>
                    <li class="footer_contact_info--item"><i class="am-icon-phone"></i><span>服务专线：<?php echo Yii::$app->params['tel'];?></span></li>
                    <?php }?>
                    <?php if(Yii::$app->params['email']){?>
                    <li class="footer_contact_info--item"><i class="am-icon-envelope-o"></i><span><?php echo Yii::$app->params['email'];?></span></li>
                    <?php }?>
                    <?php if(Yii::$app->params['address']){?>
                    <li class="footer_contact_info--item"><i class="am-icon-map-marker"></i><span><?php echo Yii::$app->params['address'];?></span></li>
                    <?php }?>
                  </ul>
                </div>
              </div>
              <div class="am-u-md-3 ">
                <div class="footer_main--column">
                  <strong class="footer_main--column_title">&nbsp;</strong>
                  <div class="footer_qrcode"><img width="120" height="120" src="<?php echo RESOURCE_DIR.Yii::$app->params['weixin_qrcode'];?>">
                    <p>微信公众号</p>
                  </div>
                </div>
              </div>
              <div class="am-u-md-12 ">
                <div class="footer_main--column powerby">
                  <strong>Copyright &copy; <?= date('Y') ?> <a href="http://yunduocms.com" target="_blank">yunduocms.com</a></strong> All Right Reserved <br />
                  Powered by <a href="http://yunduocms.com" target="_blank">云朵CMS v1.0</a> <?= Yii::$app->params['statistics']; ?>
                  网站备案：<?= Yii::$app->params['icp']; ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php $this->registerJsFile($this->theme->getUrl('js/jquery-2.1.0.js'));?>
  <?php $this->registerJsFile($this->theme->getUrl('js/amazeui.js'));?>
<?php $this->endBody() ?>
</body>

</html>
<?php $this->endPage() ?>