<?php
namespace frontend\widgets;

use Yii;
use yii\base\Widget;
use common\models\Article;
use common\components\CHelper;
use yii\helpers\Html;
class HotNewsWidget extends Widget
{
    public $limit;
    
    public function init()
    {
        parent::init();
        $this->limit = $this->limit?$this->limit:3;
    }
    
    public function run()
    {
    	$data = Article::find()->andWhere(['display'=>1]);
        $list = $data->asArray()->orderBy('click desc,updatetime desc,id desc')->limit($this->limit)->all();
        $list = $this->_format_list($list);
    	return $this->render('/widgets/hotnews',[
    		'list'=>$list,
    	]);
    }
    private function _format_list($list){
        foreach ($list as $key => $value) {
        	$list[$key]['title'] = Html::encode(CHelper::cutStr($value['title'],15));
            if($list[$key]['url']){
                $list[$key]['target'] = "_blank";
            }else{
                $list[$key]['url'] = Yii::$app->urlManager->createUrl(['news/detail','id'=>$value['id']]);
                $list[$key]['target'] = "_self";
            }
        }
        return $list;
    }
}