<?php
namespace frontend\widgets;

use Yii;
use yii\base\Widget;
use common\models\ArticleCategory;
use common\components\CHelper;
use yii\helpers\Html;
class NewsCategoryWidget extends Widget
{
    public $limit;
    public $active_id;
    
    public function init()
    {
        parent::init();
        $this->limit = $this->limit?$this->limit:100;
        $this->active_id = $this->active_id?$this->active_id:0;
    }
    
    public function run()
    {
    	$data = ArticleCategory::find()->andWhere(['display'=>1]);
        $list = $data->asArray()->orderBy('ordid desc,id asc')->limit($this->limit)->all();
        $list = $this->_format_list($list);
    	return $this->render('/widgets/news_category',[
    		'list'=>$list,
            'active_id'=>$this->active_id,
    	]);
    }
    private function _format_list($list){
        foreach ($list as $key => $value) {
        	$list[$key]['name'] = Html::encode(CHelper::cutStr($value['name'],15));
            $list[$key]['url'] = Yii::$app->urlManager->createUrl(['news/list','cid'=>$value['id'],'page'=>1]);
        }
        return $list;
    }
}