<?php

use yii\db\Migration;

class m170523_070338_ad extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%ad}}', [
            'id' => 'int(10) unsigned NOT NULL AUTO_INCREMENT',
            'display' => 'tinyint(1) NOT NULL DEFAULT \'1\'',
            'categoryid' => 'int(10) NOT NULL',
            'title' => 'varchar(100) NOT NULL',
            'note' => 'varchar(230) NOT NULL',
            'ordid' => 'int(10) unsigned NOT NULL',
            'addtime' => 'int(10) unsigned NOT NULL',
            'starttime' => 'int(10) unsigned NOT NULL',
            'deadline' => 'int(11) NOT NULL DEFAULT \'0\'',
            'img' => 'varchar(255) NOT NULL',
            'url' => 'varchar(255) NOT NULL',
            'explain' => 'varchar(255) NOT NULL',
            'PRIMARY KEY (`id`)'
        ], "ENGINE=InnoDB DEFAULT CHARSET=utf8");
        
        /* 索引设置 */
        $this->createIndex('category','{{%ad}}','categoryid',0);
        
        /* 外键约束设置 */
        $this->addForeignKey('fk_ad_category_8938_00','{{%ad}}', 'categoryid', '{{%ad_category}}', 'id', 'CASCADE', 'CASCADE' );
        
        /* 表数据 */
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%ad}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

