<?php

use yii\db\Migration;

class m170523_070338_route_rule extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%route_rule}}', [
            'id' => 'int(10) unsigned NOT NULL AUTO_INCREMENT',
            'name' => 'varchar(30) NOT NULL',
            'controller' => 'varchar(30) NOT NULL',
            'action' => 'varchar(30) NOT NULL',
            'rule' => 'varchar(100) NOT NULL',
            'status' => 'tinyint(1) unsigned NOT NULL',
            'PRIMARY KEY (`id`)'
        ], "ENGINE=MyISAM  DEFAULT CHARSET=utf8");
        
        /* 索引设置 */
        
        
        /* 表数据 */
        $this->insert('{{%route_rule}}',['id'=>'4','name'=>'新闻频道页','controller'=>'news','action'=>'index','rule'=>'news/index_<page(\\d+)>','status'=>'1']);
        $this->insert('{{%route_rule}}',['id'=>'2','name'=>'新闻详情页','controller'=>'news','action'=>'detail','rule'=>'news_<id(\\d+)>','status'=>'1']);
        $this->insert('{{%route_rule}}',['id'=>'21','name'=>'产品详情页','controller'=>'product','action'=>'detail','rule'=>'product_<id(\\d+)>','status'=>'1']);
        $this->insert('{{%route_rule}}',['id'=>'20','name'=>'产品列表页','controller'=>'product','action'=>'list','rule'=>'product/list_<cid(\\d+)>_<page(\\d+)>','status'=>'1']);
        $this->insert('{{%route_rule}}',['id'=>'19','name'=>'产品频道页','controller'=>'product','action'=>'index','rule'=>'product','status'=>'1']);
        $this->insert('{{%route_rule}}',['id'=>'18','name'=>'关于我们','controller'=>'about','action'=>'detail','rule'=>'about_<id(\\d+)>','status'=>'1']);
        $this->insert('{{%route_rule}}',['id'=>'17','name'=>'新闻列表页','controller'=>'news','action'=>'list','rule'=>'news/list_<cid(\\d+)>_<page(\\d+)>','status'=>'1']);
        $this->insert('{{%route_rule}}',['id'=>'16','name'=>'首页','controller'=>'site','action'=>'index','rule'=>'/','status'=>'1']);
        $this->insert('{{%route_rule}}',['id'=>'22','name'=>'招贤纳士','controller'=>'job','action'=>'index','rule'=>'job','status'=>'1']);
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%route_rule}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

