<?php
use install\assets\AppAsset;
use yii\helpers\Html;

/* @var $this \yii\web\View */
/* @var $content string */

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>"/>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
  <link rel="shortcut icon" href="<?php echo Yii::$app->params['sitedir'];?>favicon.ico" />
  <style type="text/css">
  	.button-wrap{margin-bottom: 50px;}
  </style>
</head>
<body>
<?php $this->beginBody() ?>
<div class="container">
	<div class="row">
		<div class="col-md-12">
			<div class="page-header">
			  <h1>云朵CMS <small>安装向导</small></h1>
			</div>
    	</div>
	</div>
	<div class="row">
		<div class="col-md-3">
			<div class="list-group">
			  <a class="list-group-item <?php if(Yii::$app->controller->action->id=='index'){?>active<?php }?>">安装协议</a>
			  <a class="list-group-item <?php if(Yii::$app->controller->action->id=='step1'){?>active<?php }?>">【第一步】环境检测</a>
			  <a class="list-group-item <?php if(Yii::$app->controller->action->id=='step2'){?>active<?php }?>">【第二步】数据库配置</a>
			  <a class="list-group-item installing <?php if(Yii::$app->controller->action->id=='step3'){?>active<?php }?>">【第三步】开始安装</a>
			  <a class="list-group-item <?php if(Yii::$app->controller->action->id=='step4'){?>active<?php }?>">【第四步】网站管理员</a>
			  <a class="list-group-item <?php if(Yii::$app->controller->action->id=='finish'){?>active<?php }?>">【第五步】安装完成</a>
			</div>
    	</div>
		<div class="col-md-9">
			<?= $content ?>
    	</div>
	</div>
</div>
<footer class="footer" style="margin-top:30px;">
    <div class="container">
        <p class="pull-left"><strong>Copyright &copy; <?= date('Y') ?> <a href="http://yunduocms.com" target="_blank">yunduocms.com</a></strong> All Right Reserved <?= Yii::$app->params['icp']; ?></p>

        <p class="pull-right">Powered by <a href="http://yunduocms.com" target="_blank">云朵CMS v1.0</a> <?= Yii::$app->params['statistics']; ?></p>
    </div>
</footer>
<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
