<?php

/**
 *--------------------------------------
 * article category
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-07
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ArticleCategoryCtrlr extends ManageCtrlr {
	public function list_category() {
		$_acl = M('ArticleCategory')->get_categoryList();
		$act = new ATree($_acl, array('article_category_id', 'ac_parent_id', 'ac_sub_category'));

		$_ACL = $act->get_leaf(0);
		$this->assign('_ACL', $_ACL);

		$this->display('article_category/list_category');
	}

	/* add category */
	public function add_category() {
		$acParentId = ARequest::get('ac_parent_id');
		$_ACI = array();
		if(0 < $acParentId) {
			$_ACI = M('ArticleCategory')->get_categoryInfo($acParentId);
		}
		if(empty($_ACI['ac_tpl'])) {
			$_ACI['ac_tpl'] = 'show_category.php';
		}
		if(empty($_ACI['ac_a_tpl'])) {
			$_ACI['ac_a_tpl'] = 'show_article.php';
		}
		$this->assign('_ACI', $_ACI);

		// template list
		$_C = require (CFG_PATH.D_S.'comm.php');
		$_TPLS = list_file(C('TE.TPL_PATH').D_S.$_C['TE']['TPL_THEME'].D_S.'home');
		$this->assign('_TPLS', $_TPLS);

		$_is_batch = ARequest::get('is_batch');
		if(1 == $_is_batch) {
			$this->display('article_category/add_batch_category');
		}
		else {
			$this->display('article_category/add_category');
		}
	}
	public function add_category_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$result = M('ArticleCategory')->add_category($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_ARTICLE_CATEGORY').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('article_category/list_category'));
		}

		M('Log')->add_log(L('ADD_ARTICLE_CATEGORY').': ID['.$result['data'].']');
		$this->success(L('ADD_SUCCESS'), Url::U('article_category/list_category'));
	}

	/* add batch category */
	public function add_batch_category_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$_acNameList = trim_array(explode("\n", $data['ac_name_list']));
		unset($data['ac_name_list']);

		$_L_ID = array();
		foreach($_acNameList as $acName) {
			if(empty($acName)) {
				continue;
			}
			$data['ac_name'] = $acName;
			$result = M('ArticleCategory')->add_category($data);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('ADD_ARTICLE_CATEGORY').': '.$result['error'], 0);
				$this->error($result['error'], Url::U('article_category/list_category'));
			}

			$_L_ID[] = $result['data'];
		}
		$_L_ID = implode(', ', $_L_ID);
		M('Log')->add_log(L('ADD_ARTICLE_CATEGORY').': ID['.$_L_ID.']');

		$this->success(L('ADD_SUCCESS'), Url::U('article_category/list_category'));
	}

	/* edit category */
	public function edit_category() {
		$articleCategoryId = ARequest::get('article_category_id');

		$_ACI = M('ArticleCategory')->get_categoryInfo($articleCategoryId);
		if(empty($_ACI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('article_category/list_category'));
		}
		$this->assign('_ACI', $_ACI);

		// template list
		$_C = require (CFG_PATH.D_S.'comm.php');
		$_TPLS = list_file(C('TE.TPL_PATH').D_S.$_C['TE']['TPL_THEME'].D_S.'home');
		$this->assign('_TPLS', $_TPLS);

		$this->display('article_category/edit_category');
	}
	public function edit_category_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		if(!isset($data['ac_addon_field'])) {
			$data['ac_addon_field'] = array();
		}

		$result = M('ArticleCategory')->edit_category($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_ARTICLE_CATEGORY').': ID['.$data['article_category_id'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('article_category/list_category'));
		}
		M('Log')->add_log(L('EDIT_ARTICLE_CATEGORY').': ID['.$data['article_category_id'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('article_category/list_category'));
	}

	/* update category count */
	public function update_count_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$articleCategoryId = ARequest::get('article_category_id');
		$articleCategoryId = is_array($articleCategoryId) ? $articleCategoryId : explode(',', $articleCategoryId);
		$_L_ID = implode(', ', $articleCategoryId);

		foreach($articleCategoryId as $articleCategoryId) {
			$result = M('ArticleCategory')->update_count($articleCategoryId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('UPDATE_ARTICLE_CATEGORY_COUNT').': ID['.$articleCategoryId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('article_category/list_category'));
			}
		}

		M('Log')->add_log(L('UPDATE_ARTICLE_CATEGORY_COUNT').': ID['.$_L_ID.']');
		$this->success(L('UPDATE_SUCCESS'), Url::U('article_category/list_category'));
	}

	/* delete category */
	public function delete_category_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$articleCategoryId = ARequest::get('article_category_id');
		$articleCategoryId = is_array($articleCategoryId) ? $articleCategoryId : explode(',', $articleCategoryId);
		$_L_ID = implode(', ', $articleCategoryId);

		/* reverse to delete sub category first */
		$articleCategoryId = array_reverse($articleCategoryId);
		foreach($articleCategoryId as $articleCategoryId) {
			$result = M('ArticleCategory')->delete_category($articleCategoryId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_ARTICLE_CATEGORY').': ID['.$articleCategoryId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('article_category/list_category'));
			}
		}

		M('Log')->add_log(L('DELETE_ARTICLE_CATEGORY').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('article_category/list_category'));
	}

	/* get category list select */
	public function _get_category_select() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$data = array('data' => 0);

		$_ACL = M('ArticleCategory')->get_categoryList();

		$articleCategoryId = intval(ARequest::get('article_category_id'));
		$selectType = 'current' == ARequest::get('select_type') ? 'current' : 'sub';
		$exclude = !preg_match('/[^\d\,]/i', ARequest::get('exclude')) ? explode(',', ARequest::get('exclude')) : array();

		$categorySelect = M('ArticleCategory')->get_categorySelect($_ACL, $articleCategoryId, $selectType, $exclude);
		$data = array('data' => 1, 'info' => $categorySelect);
		$this->ajax_return($data);
	}

	/* get category default setting */
	public function _get_category_default() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$data = array('data' => 0);

		$articleCategoryId = intval(ARequest::get('article_category_id'));
		$articleId = intval(ARequest::get('article_id'));
		$_ACI = M('ArticleCategory')->get_categoryInfo($articleCategoryId);
		if(empty($_ACI)) {
			$this->ajax_return($data);
		}
		if($articleId > 0) {
			$_AI = M('Article')->get_articleInfo($articleId);
			foreach($_ACI['ac_addon_field'] as $k => $v) {
				if(isset($_AI[$v['key']])) {
					$_ACI['ac_addon_field'][$k]['value'] = $_AI[$v['key']];
				}
			}
		}
		$info = array(
			'ac_tpl' => $_ACI['ac_tpl'],
			'a_tpl' => $_ACI['ac_a_tpl'],
			'addon_field' => $_ACI['ac_addon_field'],
		);

		$data = array('data' => 1, 'info' => $info);
		$this->ajax_return($data);
	}

	/* sort category */
	public function _sort_category_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$sort = ARequest::get('sort');
		$data = array();
		foreach($sort as $id => $_data) {
			$data['article_category_id'] = $id;
			$data['ac_parent_id'] = $_data['pid'];
			$data['ac_display_order'] = $_data['order'];
			$result = M('ArticleCategory')->edit_category($data);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('SORT_ARTICLE_CATEGORY').': ID['.$id.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('article_category/list_category'));
			}
		}

		M('Log')->add_log(L('SORT_ARTICLE_CATEGORY'));
		$this->success(L('SORT_SUCCESS'), Url::U('article_category/list_category'));
	}

}

?>