<?php

/**
 *--------------------------------------
 * extension
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-08-19
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ExtensionCtrlr extends ManageCtrlr {
	public function list_extension() {
		if(!dir_writable(RUNTIME_PATH.D_S.'ext')) {
			$this->error(L('DIR_READONLY', null, array('dir' => 'app/rt/extension')), Url::U('index/show_system_info'));
		}

		$_EL = M('Extension')->get_extensionList(ARequest::get('e_type'));
		$this->assign('_EL', $_EL);
		$this->display('extension/list_extension');
	}

	public function show_extension() {
		$hashcode = ARequest::get('e_hashcode');
		$_EI = M('Extension')->get_extensionInfo($hashcode);
		if(empty($_EI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('extension/list_extension'));
		}
		$this->assign('_EI', $_EI);
		$this->display('extension/show_extension');
	}

	public function install_extension() {
		$hashcode = ARequest::get('e_hashcode');
		$_EI = M('Extension')->get_extensionInfo($hashcode);
		if(empty($_EI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('extension/list_extension'));
		}
		$this->assign('_EI', $_EI);
		$this->display('extension/install_extension');
	}
	public function install_extension_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$_EI = M('Extension')->get_extensionInfo(ARequest::get('e_hashcode'));
		if(empty($_EI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('extension/list_extension'));
		}
		$_EI['file_list'] = ARequest::get('file_list');
		$_EI['e_manage_menu'] = ARequest::get('e_manage_menu');

		$result = M('Extension')->install_extension($_EI);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('INSTALL_EXTENSION').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('extension/list_extension'));
		}

		M('Log')->add_log(L('INSTALL_EXTENSION').': '.$_EI['e_name'].'['.$_EI['e_alias'].']');
		$this->success(L('INSTALL_SUCCESS'), Url::U('extension/list_extension'));
	}

	public function uninstall_extension_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$_EI = M('Extension')->get_extensionInfo(ARequest::get('e_hashcode'));
		if(empty($_EI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('extension/list_extension'));
		}

		$result = M('Extension')->uninstall_extension($_EI);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('UNINSTALL_EXTENSION').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('extension/list_extension'));
		}

		M('Log')->add_log(L('UNINSTALL_EXTENSION').': '.$_EI['e_name'].'['.$_EI['e_alias'].']');
		$this->success(L('UNINSTALL_SUCCESS'), Url::U('extension/list_extension'));
	}

	public function delete_extension_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$_EI = M('Extension')->get_extensionInfo(ARequest::get('e_hashcode'));
		if(empty($_EI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('extension/list_extension'));
		}

		if(1 == $_EI['e_status']) {
			$this->error(L('EXTENSION_IS_USED'), Url::U('extension/list_extension'));
		}

		if(!clear_dir(RUNTIME_PATH.D_S.'ext'.D_S.$_EI['e_hashcode'], true, array(), true)) {
			M('Log')->add_log(L('DELETE_EXTENSION').': '.$_EI['e_name'].'['.$_EI['e_alias'].']', 0);
			$this->error(L('DELETE_FAILED'), Url::U('extension/list_extension'));
		}

		M('Log')->add_log(L('DELETE_EXTENSION').': '.$_EI['e_name'].'['.$_EI['e_alias'].']');
		$this->success(L('DELETE_SUCCESS'), Url::U('extension/list_extension'));
	}

	public function package_extension() {
		$this->display('extension/package_extension');
	}
	public function package_extension_do() {
		$data = ARequest::get();
		if(MAGIC_QUOTES_GPC) {
			$data = stripslashes_array($data);
		}

		if(!check_token()) {
			M('Log')->add_log(L('PACKAGE_EXTENSION').': '.$data['e_name'].'['.$data['e_alias'].'] '.L('DATA_INVALID'), 0);
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}
		unset($data['timeKey']);
		unset($data['token']);

		if(empty($data['e_hashcode']) or L('EMPTY') == $data['e_hashcode']) {
			$data['e_hashcode'] = md5($data['e_alias'].'|'.$data['e_author'].'|'.$data['e_author_email']);
		}

		$data['e_instruction'] = base64_encode($data['e_instruction']);

		$_tmpFile = DATA_PATH.D_S.'_file.tmp';

		$tmpName = $_FILES['e_install_sql_upload']['tmp_name'];
		if(is_uploaded_file($tmpName)) {
			@move_uploaded_file($tmpName, $_tmpFile);
			$data['e_install_sql'] = file_get_contents($_tmpFile);
			@unlink($_tmpFile);
		}
		$data['e_install_sql'] = base64_encode($data['e_install_sql']);

		$tmpName = $_FILES['e_uninstall_sql_upload']['tmp_name'];
		if(is_uploaded_file($tmpName)) {
			@move_uploaded_file($tmpName, $_tmpFile);
			$data['e_uninstall_sql'] = file_get_contents($_tmpFile);
			@unlink($_tmpFile);
		}
		$data['e_uninstall_sql'] = base64_encode($data['e_uninstall_sql']);

		$tmpName = $_FILES['e_install_php_upload']['tmp_name'];
		if(is_uploaded_file($tmpName)) {
			@move_uploaded_file($tmpName, $_tmpFile);
			$data['e_install_php'] = file_get_contents($_tmpFile);
			@unlink($_tmpFile);
		}
		$data['e_install_php'] = base64_encode($data['e_install_php']);

		$tmpName = $_FILES['e_uninstall_php_upload']['tmp_name'];
		if(is_uploaded_file($tmpName)) {
			@move_uploaded_file($tmpName, $_tmpFile);
			$data['e_uninstall_php'] = file_get_contents($_tmpFile);
			@unlink($_tmpFile);
		}
		$data['e_uninstall_php'] = base64_encode($data['e_uninstall_php']);

		/* language */
		$data['e_lang'] = array();
		if(!empty($_FILES['e_lang_upload'])) {
			$langset = get_langset();
			foreach($_FILES['e_lang_upload']['name'] as $k => $name) {
				$langName = strtolower(substr($name, 0, -4));
				if(array_key_exists($langName, $langset)) {
					$tmpName = $_FILES['e_lang_upload']['tmp_name'][$k];
					if(is_uploaded_file($tmpName)) {
						@move_uploaded_file($tmpName, $_tmpFile);
						$data['e_lang'][$langName] = base64_encode(file_get_contents($_tmpFile));
						@unlink($_tmpFile);
					}
				}
			}
		}

		$tmpName = $_FILES['e_route_upload']['tmp_name'];
		if(is_uploaded_file($tmpName)) {
			@move_uploaded_file($tmpName, $_tmpFile);
			$data['e_route'] = file_get_contents($_tmpFile);
			@unlink($_tmpFile);
		}
		$data['e_route'] = base64_encode($data['e_route']);

		M('Log')->add_log(L('PACKAGE_EXTENSION').': '.$data['e_name'].'['.$data['e_alias'].']');

		load('encode_file#func');
		$data['file_list'] = get_fileListEncode($data['file_list']);

		$filename = $data['e_type'].'-'.parse_name($data['e_alias'], 1).'-v'.str_replace('.', '_', $data['e_version']).'-'.str_replace('-', '', $data['e_publish_date']).(ARequest::get('compressed') ? '.loga_ext' : '.loga_ext_src');
		if(ARequest::get('compressed')) {
			unset($data['compressed']);
		}
		output_logaPackage($filename, serialize($data), ARequest::get('compressed'));
	}

	public function upload_extension() {
		$this->display('extension/upload_extension');
	}
	public function upload_extension_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$tmpName = $_FILES['loga_package_file']['tmp_name'];
		if(!is_uploaded_file($tmpName)) {
			$this->error(L('NOTHING_UPLOAD'), AServer::get_preUrl());
		}
		$packageFile = DATA_PATH.D_S.'_loga_package.tmp';
		move_uploaded_file($tmpName, $packageFile);

		load('encode_file#func');
		$_EI = ARequest::get('compressed') ? deserialize(gzdecode(file_get_contents($packageFile))) : deserialize(file_get_contents($packageFile));
		@unlink($packageFile);
		if(!is_array($_EI) or !isset($_EI['e_hashcode']) or ($_EI['e_hashcode'] != md5($_EI['e_alias'].'|'.$_EI['e_author'].'|'.$_EI['e_author_email']))) {
			M('Log')->add_log(L('UPLOAD_EXTENSION').': '.L('DATA_FORMAT_INVALID'), 0);
			$this->error(L('DATA_FORMAT_INVALID'), AServer::get_preUrl());
		}

		$extDir = RUNTIME_PATH.D_S.'ext'.D_S.$_EI['e_hashcode'];
		mk_dir($extDir);
		$filename = $extDir.D_S.'_extension.php';
		if(is_file($filename) and 0 == ARequest::get('overwrite')) {
			M('Log')->add_log(L('UPLOAD_EXTENSION').': '.$_EI['e_name'].'['.$_EI['e_alias'].']'.L('EXTENSION_EXIST'), 0);
			$this->error($_EI['e_name'].'['.$_EI['e_alias'].']'.L('EXTENSION_EXIST'), AServer::get_preUrl());
		}

		/* deal with files */
		if(!empty($_EI['file_list'])) {
			foreach($_EI['file_list'] as $k => $file) {
				file_put_contents($extDir.D_S.md5($file['filename']), $file['content']);
				unset($_EI['file_list'][$k]['content']);
			}
		}

		$content = "<?php\r\n".PFA_ACCESS_CHECK."return ".var_export($_EI, true).";\r\n?>";

		file_put_contents($filename, $content);
		M('Log')->add_log(L('UPLOAD_EXTENSION').': '.$_EI['e_name'].'['.$_EI['e_alias'].']');
		$this->success(L('UPLOAD_SUCCESS'), Url::U('extension/list_extension'));
	}

	/* get extension hashcode */
	public function _get_extension_hashcode() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$extensionAlias = ARequest::get('e_alias');
		$extensionAuthor = ARequest::get('e_author');
		$extensionAuthorEmail = ARequest::get('e_author_email');
		if(empty($extensionAlias) or empty($extensionAuthor) or empty($extensionAuthorEmail)) {
			$this->ajax_return(L('EMPTY'));
		}
		$this->ajax_return(md5($extensionAlias.'|'.$extensionAuthor.'|'.$extensionAuthorEmail));
	}
}

?>