<?php

/**
 *--------------------------------------
 * Hash URL
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2017-05-16
 * @copyright	: (c)2017 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class HashUrlCtrlr extends ManageCtrlr {
	public function list_hash_url() {
		$where = array();
		/* filter content */
		$huTitle = ARequest::get('hu_title');
		if(!empty($huTitle)) {
			$where['hu_title'] = array('LIKE', '%'.$huTitle.'%');
		}

		/* get paging and list */
		$_PG = '';
		$_HUL = '';
		$rowsNum = M('HashUrl')->where($where)->count();
		if(0 < $rowsNum) {
			$orderBy = ARequest::get('order_by') ? ARequest::get('order_by') : 'hash_url_id';
			$orderTurn = ARequest::get('order_turn') ? ARequest::get('order_turn') : 'desc';
			$pageSize = (ARequest::get('page_size') > 0 ? ARequest::get('page_size') : 20);
			$p = new APage($rowsNum, $pageSize, Url::U('hash_url/list_hash_url?hu_title='.$huTitle.'&order_by='.$orderBy.'&order_turn='.$orderTurn.'&page_size='.$pageSize.'&'.C('VAR.PAGE').'=_page_'));
			$_PG = $p->get_paging();

			$_HUL = M('HashUrl')->get_hashUrlList($where, "`{$orderBy}` {$orderTurn}", $p->get_limit());
		}
		$this->assign('_PG', $_PG);
		$this->assign('_HUL', $_HUL);

		$this->display('hash_url/list_hash_url');
	}

	public function add_hash_url() {
		$this->display('hash_url/add_hash_url');
	}
	public function add_hash_url_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		$data['hu_add_time'] = NOW_TIME;

		$result = M('HashUrl')->add_hashUrl($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_HASH_URL').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('hash_url/list_hash_url'));
		}

		M('Log')->add_log(L('ADD_HASH_URL').': ID['.$result['data'].']');
		$this->success(L('ADD_SUCCESS'), Url::U('hash_url/list_hash_url'));
	}

	public function edit_hash_url() {
		$hashUrlId = ARequest::get('hash_url_id');
		$_HUI = M('HashUrl')->get_hashUrlInfo($hashUrlId);
		if(empty($_HUI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('hash_url/list_hash_url'));
		}
		$this->assign('_HUI', $_HUI);

		$this->display('hash_url/edit_hash_url');
	}
	public function edit_hash_url_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		$result = M('HashUrl')->edit_hashUrl($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_HASH_URL').': ID['.$data['hash_url_id'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('hash_url/list_hash_url'));
		}
		M('Log')->add_log(L('EDIT_HASH_URL').': ID['.$data['hash_url_id'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('hash_url/list_hash_url'));
	}

	public function delete_hash_url_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$hashUrlId = ARequest::get('hash_url_id');
		$hashUrlId = is_array($hashUrlId) ? $hashUrlId : explode(',', $hashUrlId);
		$_L_ID = implode(', ', $hashUrlId);

		foreach($hashUrlId as $hashUrlId) {
			$result = M('HashUrl')->delete_hashUrl($hashUrlId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_HASH_URL').': ID['.$hashUrlId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('hash_url/list_hash_url'));
			}
		}

		M('Log')->add_log(L('DELETE_HASH_URL').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('hash_url/list_hash_url'));
	}

}

?>