<?php

/**
 *--------------------------------------
 * log
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-06-29
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class LogCtrlr extends ManageCtrlr {
	public function list_log() {
		/* filter status */
		$lStatus = ARequest::get('l_status') ? ARequest::get('l_status') : '';
		if('f' == $lStatus) {
			$where['__LOG__.l_status'] = array('EQ', 0);
		}
		elseif('s' == $lStatus) {
			$where['__LOG__.l_status'] = array('EQ', 1);
		}

		/* language */
		$lang = ARequest::get('lang') ? ARequest::get('lang') : LANG_NAME;
		$where['__LOG__.lang'] = array('EQ', $lang);

		/* get paging and list */
		$_PG = '';
		$_LL = '';
		$rowsNum = M('Log')->where($where)->count();
		if(0 < $rowsNum) {
			$orderBy = 'l_time';
			$orderTurn = ARequest::get('order_turn') ? ARequest::get('order_turn') : 'desc';
			$pageSize = (ARequest::get('page_size') > 0 ? ARequest::get('page_size') : 20);
			$p = new APage($rowsNum, $pageSize, Url::U('log/list_log?l_status='.$lStatus.'&lang='.$lang.'&order_by='.$orderBy.'&order_turn='.$orderTurn.'&page_size='.$pageSize.'&'.C('VAR.PAGE').'=_page_'));
			$_PG = $p->get_paging();

			$_LL = M('Log')->get_logList($where, "`{$orderBy}` {$orderTurn}", $p->get_limit());
		}
		$this->assign('_PG', $_PG);
		$this->assign('_LL', $_LL);

		$this->display('log/list_log');
	}

	public function download_log() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		/* filter status */
		$lStatus = ARequest::get('l_status') ? ARequest::get('l_status') : '';
		if('f' == $lStatus) {
			$where['__LOG__.l_status'] = array('EQ', 0);
		}
		elseif('s' == $lStatus) {
			$where['__LOG__.l_status'] = array('EQ', 1);
		}

		/* language */
		$lang = ARequest::get('lang') ? ARequest::get('lang') : LANG_NAME;
		$where['__LOG__.lang'] = array('EQ', $lang);

		/* get paging and list */
		$_PG = '';
		$_LL = '';
		$rowsNum = M('Log')->where($where)->count();
		if(0 < $rowsNum) {
			$orderBy = 'l_time';
			$orderTurn = ARequest::get('order_turn') ? ARequest::get('order_turn') : 'desc';
			$pageSize = (ARequest::get('page_size') > 0 ? ARequest::get('page_size') : 20);
			$p = new APage($rowsNum, $pageSize, Url::U('log/download_log?l_status='.$lStatus.'&lang='.$lang.'&order_by='.$orderBy.'&order_turn='.$orderTurn.'&page_size='.$pageSize.'&'.C('VAR.PAGE').'=_page_'));
			$_PG = $p->get_paging();

			$_LL = M('Log')->get_logList($where, "`{$orderBy}` {$orderTurn}", $p->get_limit());
		}
		$this->assign('_PG', $_PG);
		$this->assign('_LL', $_LL);

		if(!empty($_LL)) {
			M('Log')->add_log(L('DOWNLOAD_LOG'));
			header('Cache-Control: no-cache, must-revalidate');
			header('Content-type:application/vnd.ms-excel; charset='.C('APP.CHARSET'));
			header('Content-Disposition:filename=log_'.$lang.'_'.date('YmdHi', NOW_TIME).'.xls');

			$this->assign('_LL', $_LL);
			$data = $this->fetch('log/download_log');
			echo ($data);
			exit;
		}
		else {
			M('Log')->add_log(L('DOWNLOAD_LOG').': '.L('EMPTY'), 0);
			$this->error(L('EMPTY'), Url::U('log/list_log'));
		}
	}

	public function delete_old_log() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$where = array();
		$where['l_time'] = array('LT', NOW_TIME - 86400 * 30);
		$result = M('Log')->where($where)->delete();
		if(false === $result) {
			M('Log')->add_log(L('DELETE_OLD_LOG'), 0);
			$this->error(L('DELETE_FAILED'), Url::U('log/list_log'));
		}
		M('Log')->add_log(L('DELETE_OLD_LOG'));
		$this->success(L('DELETE_SUCCESS'), Url::U('log/list_log'));
	}

}

?>