<?php

/**
 *--------------------------------------
 * login
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-06-27
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class LoginCtrlr extends Ctrlr {
	public function __construct() {
		parent::__construct();

		/* check entry */
		session_start();
		if(!isset($_SESSION['admin_enter']) or 1 != $_SESSION['admin_enter']) {
			redirect(Url::U('home@index/index'));
			exit();
		}

		$timeKey = NOW_TIME;
		$_TK = array('timeKey' => $timeKey, 'token' => substr(md5(UUID.AServer::get_clientId().$timeKey), 8, 8));
		$this->assign('_TK', $_TK);
	}

	public function index() {
		if(ASession::get('login') and 'on' != ASession::get('LOCK_SCREEN_SWITCH')) {
			redirect(Url::U('index/index'));
		}
		/* language set */
		$this->assign('_LS', get_langset());

		/* Manage Captcha Switch */
		$mcs = M('Option')->get_option('interaction/manage_captcha');
		$this->assign('mcs', $mcs);

		$this->display('login');
	}

	public function login_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		check_interaction('login', true, true);

		$maxTryTimes = 9; /* max try time */
		$lockIntervalTime = 600; /* login interval time */

		$ip = md5(CLIENT_IP);

		$lockTime = F('_lock_time/_'.$ip);

		if(NOW_TIME - ($lockTime + $lockIntervalTime) < 0) {
			$timeLeft = intval((F('_lock_time/_'.$ip) + $lockIntervalTime - NOW_TIME) / 60) + 1;
			$info = L('LOCK_TIME_LEFT_TIPS', null, array('time_left' => $timeLeft));
			$this->error($info, AServer::get_preUrl());
		}

		$email = strtolower(ARequest::get('email'));
		if(!AFilter::is_email($email)) {
			$this->error(L('VERIFY_FAILED'), AServer::get_preUrl());
		}
		$password = md5($email.ARequest::get('password'));
		$_AI = M('Option')->get_option('administrator');

		if($_AI['email'] != $email or $_AI['password'] != $password) {
			M('Log')->add_log(L('LOGIN'), 0);

			$timesLeft = $maxTryTimes - ASession::get('err_times');
			if(0 < $timesLeft) {
				ASession::set('err_times', ASession::get('err_times') + 1);
				$info = L('CHECK_SCREEN_LOCK_TIMES_LEFT_TIPS', null, array('times_left' => $timesLeft));
				$this->error($info, Url::U('login/index'));
			}
			F('_lock_time/_'.$ip, NOW_TIME);
			ASession::set('err_times', 0);
			$timeLeft = intval($lockIntervalTime / 60);
			$info = L('LOCK_TIME_LEFT_TIPS', null, array('time_left' => $timeLeft));
			$this->error($info, Url::U('login/index'));
		}

		/* set session */
		ASession::regenerate_id();
		ASession::set('login', true);

		$langset = get_langset();
		$lang = strtolower(ARequest::get(C('VAR.LANG')));
		if(!empty($lang) and array_key_exists($lang, $langset)) {
			ACookie::set('lang', $lang);
		}

		/* unlock screen, clear error time */
		ASession::set('LOCK_SCREEN_SWITCH', 'off');
		ASession::set('err_times', 0);
		F('_lock_time/_'.$ip, null);

		M('Log')->add_log(L('LOGIN'));

		$this->success(L('LOGIN_SUCCESS'), AServer::get_preUrl());
	}

	public function lock_screen() {
		ASession::set('LOCK_SCREEN_SWITCH', 'on');
	}
	public function _check_screen_lock() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$data = 0;

		$maxTryTimes = 9; /* max try time */
		$lockIntervalTime = 600; /* login interval time */
		$ip = md5(CLIENT_IP);
		$lockTime = F('_lock_time/_'.$ip);

		if(NOW_TIME - ($lockTime + $lockIntervalTime) < 0) {
			$timeLeft = intval((F('_lock_time/_'.$ip) + 600 - NOW_TIME) / 60) + 1;
			$info = L('LOCK_TIME_LEFT_TIPS', null, array('time_left' => $timeLeft));
			$this->ajax_return(array('data' => $data, 'info' => $info));
		}

		$_AI = M('Option')->get_option('administrator');
		$lockPassword = md5($_AI['email'].md5(ARequest::get('lock_password')));

		if($_AI['password'] != $lockPassword) {
			$timesLeft = $maxTryTimes - ASession::get('err_times');
			if(0 < $timesLeft) {
				ASession::set('err_times', ASession::get('err_times') + 1);
				$info = L('CHECK_SCREEN_LOCK_TIMES_LEFT_TIPS', null, array('times_left' => $timesLeft));
				$this->ajax_return(array('data' => $data, 'info' => $info));
			}
			F('_lock_time/_'.$ip, NOW_TIME);
			ASession::set('err_times', 0);
			$timeLeft = intval($lockIntervalTime / 60);
			$info = L('LOCK_TIME_LEFT_TIPS', null, array('time_left' => $timeLeft));
			$this->ajax_return(array('data' => $data, 'info' => $info));
		}
		$data = 1;
		$info = L('LOGIN_SUCCESS');
		ASession::set('LOCK_SCREEN_SWITCH', 'off');
		ASession::set('err_times', 0);
		F('_lock_time/_'.$ip, null);
		$this->ajax_return(array('data' => $data, 'info' => $info));
	}

	public function logout_do() {
		ASession::clear();
		$this->success(L('LOGOUT_SUCCESS'), Url::U('login/index'));
	}
}

?>