<?php

/**
 *--------------------------------------
 * manage
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-06-27
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ManageCtrlr extends Ctrlr {
	public function __construct() {
		parent::__construct();

		/* check entry */
		session_start();
		if(!isset($_SESSION['admin_enter']) or 1 != $_SESSION['admin_enter']) {
			redirect(Url::U('home@index/index'));
			exit();
		}

		/* check login and lock screen */
		if(!ASession::get('login') or 'on' == ASession::get('LOCK_SCREEN_SWITCH')) {
			redirect(Url::U('login/index'));
			exit();
		}

		/* limit permission */
		if(!ASession::get('limit_permission')) {
			ASession::set('limit_permission', get_limitPermission());
		}
		/* current permission code */
		$permissionCode = CTRLR_NAME.':'.ACTN_NAME;
		/* check permission */
		if(in_array($permissionCode, ASession::get('limit_permission'))) {
			$this->error(L('PERMISSION_LIMIT'), Url::U('index/index'));
		}

		$LICENCE = function_exists('get_licence') ? get_licence() : null;
		$this->assign('LICENCE', $LICENCE);

		$timeKey = NOW_TIME;
		$_TK = array('timeKey' => $timeKey, 'token' => substr(md5(UUID.AServer::get_clientId().$timeKey), 8, 8));
		$this->assign('_TK', $_TK);

		$this->assign('_LS', get_langset());
		$this->assign('_PS', get_platformset());
	}
}

?>