<?php

/**
 *--------------------------------------
 * article review
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-10
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ArticleReviewCtrlr extends IndexCtrlr {
	protected $_o;

	public function __construct() {
		parent::__construct();

		$this->_o = EO('article_review');
	}

	public function list_review() {
		$articleId = intval(ARequest::get('article_id'));
		$sort = ARequest::get('sort');
		if('support' == $sort) {
			$order = '`ar_support_count` DESC';
		}
		elseif('oppose' == $sort) {
			$order = '`ar_oppose_count` DESC';
		}
		else {
			$order = '`ar_add_time` DESC';
		}

		$pageSign = md5('AR|'.$articleId.'|'.get_guidString($order).'|'.intval($_GET[C('VAR.PAGE')]));
		$_ai = S('_ai'.$pageSign);
		if(empty($_ai)) {
			$_ai = M('Article')->where(array('article_id' => array('EQ', $articleId)))->field('article_id,a_title,a_review_switch,article_category_id')->find();
			if(empty($_ai)) {
				halt('', true, true);
			}
			$_aci = M('ArticleCategory')->where(array('article_category_id' => array('EQ', $_ai['article_category_id'])))->field('ac_review_switch')->find();

			$_E = array(
				'REVIEW_IS_OFF' => 404
			);
			$_ai['error'] = '';
			if(!$this->_o['switch'] or !$_aci['ac_review_switch'] or !$_ai['a_review_switch']) {
				$_ai['error'] = $_E['REVIEW_IS_OFF'];
			}
			S('_ai'.$pageSign, $_ai);
		}

		$this->assign('_V', $_ai);

		/* get paging and list */
		$_PG = S('_PG'.$pageSign);
		$_L = S('_L'.$pageSign);
		if(empty($_L)) {
			$where = array();
			$where['__ARTICLE_REVIEW__.article_id'] = array('EQ', $articleId);
			$where['ar_status'] = array('GT', 0);

			$rowsNum = M('ArticleReview')->get_reviewCount($where);
			if(0 < $rowsNum) {
				$p = new APage($rowsNum, $this->_o['page_size'], Url::U('article_review/list_review?article_id='.$articleId.'&sort='.$sort.'&'.C('VAR.PAGE').'=_page_'));
				$_PG = $p->get_paging();

				$_L = M('ArticleReview')->get_reviewList($where, $order, $p->get_limit());
				S('_PG'.$pageSign, $_PG);
				S('_L'.$pageSign, $_L);
			}
		}
		$this->assign('_PG', $_PG);
		$this->assign('_L', $_L);

		$this->assign('_GCAP', 'home@article_review/list_review');

		$this->assign('_CP', array(
			array('name' => L('HOME'), 'url' => Url::U('home@index/index')),
			array('name' => $_ai['a_title'], 'url' => Url::U('home@article/show_article?article_id='.$_ai['article_id'])),
			array('name' => L('REVIEW_LIST'), 'url' => ''))
		);

		if('clip' == ARequest::get('type')) {
			$this->display('home/clip/list_article_review');
		}
		elseif(IS_AJAX) {
			$this->display('home/ajax/list_article_review');
		}
		else {
			$this->display('home/list_article_review');
		}
	}

	public function add_review() {
		$articleId = intval(ARequest::get('article_id'));
		$_ai = M('Article')->where(array('article_id' => array('EQ', $articleId)))->field('article_id,a_title,a_review_switch,article_category_id')->find();
		if(empty($_ai)) {
			halt('', true, true);
		}
		$_aci = M('ArticleCategory')->where(array('article_category_id' => array('EQ', $_ai['article_category_id'])))->field('ac_review_switch')->find();

		$_E = array(
			'REVIEW_IS_OFF' => 404
		);
		$_ai['error'] = '';
		if(!$this->_o['switch'] or !$_aci['ac_review_switch'] or !$_ai['a_review_switch']) {
			$_ai['error'] = $_E['REVIEW_IS_OFF'];
		}

		$this->assign('_V', $_ai);

		$this->assign('_GCAP', 'home@article_review/add_review');

		$this->assign('_CP', array(
			array('name' => L('HOME'), 'url' => Url::U('home@index/index')),
			array('name' => L('ADD_REVIEW'), 'url' => ''))
		);

		if(IS_AJAX) {
			$this->display('home/ajax/add_article_review');
		}
		else {
			$this->display('home/add_article_review');
		}
	}
	public function add_review_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		check_interaction('feedback');

		$articleId = intval(ARequest::get('article_id'));

		$_ai = M('Article')->where(array('article_id' => array('EQ', $articleId)))->field('a_review_switch,article_category_id')->find();
		$_aci = M('ArticleCategory')->where(array('article_category_id' => array('EQ', $_ai['article_category_id'])))->field('ac_review_switch')->find();
		if(!$this->_o['switch'] or !$_aci['ac_review_switch'] or !$_ai['a_review_switch']) {
			$this->error(L('REVIEW_IS_OFF'), AServer::get_preUrl());
		}

		$data = array();
		$data['ar_author'] = AFilter::text(ARequest::get('ar_author'), 20) ? AFilter::text(ARequest::get('ar_author'), 20) : '';
		$data['article_id'] = $articleId;
		$data['article_category_id'] = $_ai['article_category_id'];

		$arQouteId = ARequest::get('ar_qoute_id') ? intval(ARequest::get('ar_qoute_id')) : 0;
		if($arQouteId > 0) {
			$_t_ari = $_ARI = M('ArticleReview')->get_reviewInfo($arQouteId);
			if(!empty($_t_ari) and $_t_ari['article_id'] == $articleId) {
				$data['ar_qoute'] = ($_t_ari['ar_author'] ? $_t_ari['ar_author'] : L('GUEST')).'['.hide_ip($_t_ari['ar_add_ip']).']: '.$_t_ari['ar_content'];
			}
		}

		$data['ar_content'] = trim(str_replace(array("\r\n", "\n"), "<br />", AFilter::text(ARequest::get('ar_content'), 500)));
		if(empty($data['ar_content'])) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data['ar_add_time'] = NOW_TIME;
		$data['ar_add_ip'] = CLIENT_IP;

		/* content need filter or article need audit */
		$report = false;
		$_o_i = M('Option')->get_option('interaction');
		if($_o_i['auto_report'] > 0 and !M('Report')->report_check(array($data['ar_author'], $data['ar_content']))) {
			if(2 == $_o_i['auto_report']) {
				$data['ar_status'] = 2;
			}
			else {
				$data['ar_status'] = 0;
			}
			$report = true;
		}
		elseif($_o_i['feedback_check']) {
			$data['ar_status'] = 0;
		}
		else {
			$data['ar_status'] = 1;
		}

		$result = M('ArticleReview')->add_review($data);

		ACookie::set('author', $data['ar_author']);

		if(!empty($result['error'])) {
			$this->error($result['error'], AServer::get_preUrl());
		}

		$this->success(L('ADD_SUCCESS'), AServer::get_preUrl());
	}

	/* get count */
	public function _get_count() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$articleReviewId = intval(ARequest::get('article_review_id'));
		$type = ARequest::get('type');
		if('do_support' == $type) {
			if(!I('feedback_short', 1)) {
				$this->ajax_return(array('data' => 0, 'info' => L('_TRY_LATER_')));
			}
			M('ArticleReview')->field_inc('ar_support_count', array('article_review_id' => array('EQ', $articleReviewId)));
			I('feedback_short');
			$this->ajax_return(array('data' => 1, 'info' => L('SUPPORT_SUCCESS')));
		}
		elseif('do_oppose' == $type) {
			if(!I('feedback_short', 1)) {
				$this->ajax_return(array('data' => 0, info => L('_TRY_LATER_')));
			}
			M('ArticleReview')->field_inc('ar_oppose_count', array('article_review_id' => array('EQ', $articleReviewId)));
			I('feedback_short');
			$this->ajax_return(array('data' => 1, 'info' => L('OPPOSE_SUCCESS')));
		}
	}
}

?>