<?php

/**
 *--------------------------------------
 * guestbook
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-10
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class GuestbookCtrlr extends IndexCtrlr {
	protected $_o;

	public function __construct() {
		parent::__construct();

		$this->_o = EO('guestbook');
		if(!$this->_o['switch']) {
			halt(L('GUESTBOOK_IS_OFF'), true, true);
		}
	}

	public function list_guestbook() {
		$this->assign('_GCAP', 'home@guestbook/list_guestbook');

		$_V = array('error' => '');

		$_R_ = ARequest::get();
		/* query guestbook message */
		if(!empty($_R_['g_no'])) {
			$_E = array(
				'GUESTBOOK_INEXISTENCE' => 401,
				'GUESTBOOK_PENDING' => 402
			);
			$_PG = '';

			$where = array();
			$gNo = trim(AFilter::text($_R_['g_no'], 64));
			$where['__GUESTBOOK__.g_no'] = array('EQ', $gNo);
			$gPassword = $_R_['g_password'] ? md5($_R_['g_password']) : '';
			$where['__GUESTBOOK__.g_password'] = array('EQ', $gPassword);

			$_L = M('Guestbook')->get_guestbookList($where, '`g_add_time` DESC', '0,1');
			if(empty($_L)) {
				$_V['error'] = $_E['GUESTBOOK_INEXISTENCE'];
			}
			elseif(0 == $_L[0]['g_status']) {
				$_V['error'] = $_E['GUESTBOOK_PENDING'];
			}
		}
		else {
			$pageSign = md5('GL|'.LANG_NAME.'|'.intval($_GET[C('VAR.PAGE')]));
			/* get paging and list */
			$_PG = S('_PG'.$pageSign);
			$_L = S('_L'.$pageSign);
			if(empty($_L)) {
				$where = array();
				$where['__GUESTBOOK__.g_status'] = array('GT', 0);
				$where['__GUESTBOOK__.g_password'] = array('EQ', '');

				$rowsNum = M('Guestbook')->where($where)->count();
				if(0 < $rowsNum) {
					$p = new APage($rowsNum, $this->_o['page_size'], Url::U('guestbook/list_guestbook?'.C('VAR.PAGE').'=_page_'));
					$_PG = $p->get_paging();

					$_L = M('Guestbook')->get_guestbookList($where, '`g_add_time` DESC', $p->get_limit());
					S('_PG'.$pageSign, $_PG);
					S('_L'.$pageSign, $_L);
				}
			}
		}
		$this->assign('_V', $_V);
		$this->assign('_PG', $_PG);
		$this->assign('_L', $_L);

		$this->assign('_CP', array(
			array('name' => L('HOME'), 'url' => Url::U('home@index/index')),
			array('name' => L('GUESTBOOK'), 'url' => ''))
		);

		if(IS_AJAX) {
			$this->display('home/ajax/list_guestbook');
		}
		else {
			$this->display('home/list_guestbook');
		}
	}

	public function add_guestbook() {
		$this->assign('_GCAP', 'home@guestbook/add_guestbook');

		$this->assign('_CP', array(
			array('name' => L('HOME'), 'url' => Url::U('home@index/index')),
			array('name' => L('GUESTBOOK'), 'url' => ''))
		);

		if(IS_AJAX) {
			$this->display('home/ajax/add_guestbook');
		}
		else {
			$this->display('home/add_guestbook');
		}
	}

	public function add_guestbook_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		check_interaction('feedback');

		$data = array();
		$data['g_no'] = M('Guestbook')->get_guestbookNo();

		$gPassword = AString::rand_number(0, 9999);
		$data['g_password'] = (1 == ARequest::get('g_private')) ? md5($gPassword) : '';

		$data['g_author'] = trim(AFilter::text(ARequest::get('g_author'), 96));
		$data['g_email'] = trim(AFilter::text(ARequest::get('g_email'), 96));
		if(!AFilter::is_email($data['g_email'])) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}
		$data['g_content'] = trim(str_replace(array("\r\n", "\n"), "<br />", AFilter::text(ARequest::get('g_content'), 500)));
		if(empty($data['g_author']) or empty($data['g_content'])) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data['g_add_time'] = NOW_TIME;
		$data['g_add_ip'] = CLIENT_IP;

		/* content need filter need audit */
		$report = false;
		$_o_i = M('Option')->get_option('interaction');
		if($_o_i['auto_report'] > 0 and !M('Report')->report_check(array($data['g_author'], $data['g_content']))) {
			if(2 == $_o_i['auto_report']) {
				$data['g_status'] = 2;
			}
			else {
				$data['g_status'] = 0;
			}
			$report = true;
		}
		elseif($_o_i['feedback_check']) {
			$data['g_status'] = 0;
		}
		else {
			$data['g_status'] = 1;
		}

		$result = M('Guestbook')->add_guestbook($data);

		ACookie::set('author', $data['g_author']);
		ACookie::set('email', $data['g_email']);

		if(!empty($result['error'])) {
			$this->error($result['error'], AServer::get_preUrl());
		}

		if(!empty($data['g_password'])) {
			$this->success(L('ADD_GUESTBOOK_SUCCESS_QUERY_TIP', null, array('no' => $data['g_no'], 'password' => $gPassword)));
		}
		$this->success(L('ADD_GUESTBOOK_SUCCESS_TIP'), AServer::get_preUrl());

	}

}

?>