<?php

/**
 *--------------------------------------
 * Hash URL
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2017-05-16
 * @copyright	: (c)2017 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class HashUrlCtrlr extends IndexCtrlr {
	public function go() {
		$hash = trim(ARequest::get('hu_hash'));
		if(empty($hash) or !is_string($hash) or !preg_match("/[a-zA-Z0-9]{32}$/", $hash)) {
			halt('', true, true);
		}

		$where = array('hu_hash' => array('EQ', $hash));

		$_HUI = M('HashUrl')->where($where)->find();
		if(empty($_HUI)) {
			halt('', true, true);
		}

		/* increace visit count */
		M('HashUrl')->field_inc('hu_visit_count', $where);

		$this->success($_HUI['hu_note'], $_HUI['hu_src']);
	}

}

?>