<?php

/**
 *--------------------------------------
 * ad space
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-06
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class AdSpaceModl extends Modl {
	public function get_spaceList($status = true, $lang = true) {
		$_ASL = F('_asl/'.LANG_NAME.'_'.($status ? 1 : 0).'_'.($lang ? 1 : 0));
		if(empty($_ASL)) {
			$_ASL = $this->select();
			if(!empty($_ASL)) {
				foreach($_ASL as $k => $space) {
					$_ASL[$k]['as_name'] = unserialize($space['as_name']);
					$_ASL[$k]['as_default'] = unserialize($space['as_default']);
					if(MAGIC_QUOTES_GPC) {
						$_ASL[$k]['as_name'] = stripslashes_array($_ASL[$k]['as_name']);
						$_ASL[$k]['as_default'] = stripslashes_array($_ASL[$k]['as_default']);
					}
					if($lang) {
						$_ASL[$k]['as_name'] = get_itemL($_ASL[$k]['as_name']);
						$_ASL[$k]['as_default'] = get_itemL($_ASL[$k]['as_default']);
					}
					if($status and 1 != $space['as_status']) {
						unset($_ASL[$k]);
					}
				}
			}
			F('_asl/'.LANG_NAME.'_'.($status ? 1 : 0).'_'.($lang ? 1 : 0), $_ASL);
		}
		return $_ASL;
	}

	public function get_spaceInfo($asAlias, $lang = true) {
		$_ASI = F('_asi/'.$asAlias.LANG_NAME.'_'.($lang ? 1 : 0));
		if(empty($_ASI)) {
			$_ASI = $this->where(array('as_alias' => array('EQ', $asAlias)))->find();
			if(!empty($_ASI)) {
				$_ASI['as_name'] = unserialize($_ASI['as_name']);
				$_ASI['as_default'] = unserialize($_ASI['as_default']);
				if(MAGIC_QUOTES_GPC) {
					$_ASI['as_name'] = stripslashes_array($_ASI['as_name']);
					$_ASI['as_default'] = stripslashes_array($_ASI['as_default']);
				}
				if($lang) {
					$_ASI['as_name'] = get_itemL($_ASI['as_name']);
					$_ASI['as_default'] = get_itemL($_ASI['as_default']);
				}
			}
			F('_asi/'.$asAlias.LANG_NAME.'_'.($lang ? 1 : 0), $_ASI);
		}
		return $_ASI;
	}

	public function add_space($data) {
		$result = array('data' => '', 'error' => '');

		$data['as_alias'] = strtolower($data['as_alias']);
		$data['as_name'] = serialize($data['as_name']);
		$data['as_default'] = serialize($data['as_default']);
		if(MAGIC_QUOTES_GPC) {
			$data['as_name'] = addslashes($data['as_name']);
			$data['as_default'] = addslashes($data['as_default']);
		}

		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $data['as_alias'];

		clear_dir(DATA_PATH.D_S.'_asl');

		return $result;
	}

	public function edit_space($data) {
		$result = array('data' => '', 'error' => '');

		$data['as_alias'] = strtolower($data['as_alias']);
		if(isset($data['as_name'])) {
			$data['as_name'] = serialize($data['as_name']);
			if(MAGIC_QUOTES_GPC) {
				$data['as_name'] = addslashes($data['as_name']);
			}
		}
		if(isset($data['as_default'])) {
			$data['as_default'] = serialize($data['as_default']);
			if(MAGIC_QUOTES_GPC) {
				$data['as_default'] = addslashes($data['as_default']);
			}
		}

		if(false === $this->update($data)) {
			$result['error'] = L('EDIT_FAILED');
			return $result;
		}

		clear_dir(DATA_PATH.D_S.'_asl');
		clear_dir(DATA_PATH.D_S.'_asi');

		return $result;
	}

	public function delete_space($asAlias) {
		$result = array('data' => '', 'error' => '');

		if(false === $this->delete($asAlias)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		/* delete ad */
		$adId = M('Ad')->field('ad_id')->where(array('as_alias' => array('EQ', $asAlias)))->select();
		if(!empty($adId)) {
			foreach($adId as $adId) {
				M('Ad')->delete_ad($adId['ad_id']);
			}
		}

		clear_dir(DATA_PATH.D_S.'_asl');
		clear_dir(DATA_PATH.D_S.'_asi');

		return $result;
	}
}

?>