<?php

/**
 *--------------------------------------
 * flink
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-08-20
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class FlinkModl extends Modl {
	public function get_flinkCount($where = array()) {
		$where['lang'] = array('EQ', LANG_NAME);
		return $this->where($where)->count();
	}

	public function get_flinkList($where = array(), $order = '', $limit = 200) {
		$where['__FLINK__.lang'] = array('EQ', LANG_NAME);
		$_FL = $this->join('__FLINK_CATEGORY__ AS fc ON fc.fc_alias = __FLINK__.fc_alias')->where($where)->order($order)->limit($limit)->select();
		if(!empty($_FL)) {
			foreach($_FL as $k => $f) {
				$_FL[$k]['fc_name'] = unserialize($f['fc_name']);
				if(MAGIC_QUOTES_GPC) {
					$_FL[$k]['fc_name'] = stripslashes_array($_FL[$k]['fc_name']);
				}
				$_FL[$k]['fc_name'] = get_itemL($_FL[$k]['fc_name']);
			}
		}
		return $_FL;
	}

	public function get_flinkInfo($flinkId) {
		$where = array();
		$where['flink_id'] = array('EQ', $flinkId);
		$where['lang'] = array('EQ', LANG_NAME);

		$_FI = $this->join('__FLINK_CATEGORY__ AS fc ON fc.fc_alias = __FLINK__.fc_alias')->where($where)->find();
		if(!empty($_FI)) {
			$_FI['fc_name'] = unserialize($_FI['fc_name']);
			if(MAGIC_QUOTES_GPC) {
				$_FI['fc_name'] = stripslashes_array($_FI['fc_name']);
			}
			$_FI['fc_name'] = get_itemL($_FI['fc_name']);
		}
		return $_FI;
	}

	public function add_flink($data) {
		$result = array('data' => '', 'error' => '');

		if(isset($data['f_site_logo'])) {
			$data['f_site_logo'] = AFilter::url($data['f_site_logo'], 255);
		}

		$data['lang'] = LANG_NAME;
		unset($data['flink_id']);
		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $_t_id;

		return $result;
	}

	public function edit_flink($data) {
		$result = array('data' => '', 'error' => '');

		if(isset($data['f_site_logo'])) {
			$data['f_site_logo'] = AFilter::url($data['f_site_logo'], 255);
		}

		unset($data['lang']);
		if(false === $this->update($data)) {
			$result['error'] = L('EDIT_FAILED');
			return $result;
		}

		return $result;
	}

	public function delete_flink($flinkId) {
		$result = array('data' => '', 'error' => '');

		if(false === $this->delete($flinkId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		return $result;
	}

}

?>