<?php

/**
 *--------------------------------------
 * hash URL
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2017-05-16
 * @copyright	: (c)2017 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class HashUrlModl extends Modl {
	public function get_hashUrl($url, $title = '', $note = '') {
		$_HUI = $this->where(array('hu_src' => array('EQ', $url)))->find();
		if(!empty($_HUI)) {
			return Url::U('home@hash_url/go?hu_hash='.$_HUI['hu_hash']);
		}
		else {
			$url = AFilter::url($url);
			$hash = md5(UUID.'|'.$url);
			$data = array();
			$data['hu_hash'] = $hash;
			$data['hu_src'] = $url;
			$data['hu_title'] = $title;
			$data['hu_note'] = $note;
			$data['hu_add_time'] = NOW_TIME;
			$data['hu_visit_count'] = 0;
			$this->insert($data);
			return Url::U('home@hash_url/go?hu_hash='.$hash);
		}
	}

	public function get_hashUrlList($where = array(), $order = '', $limit = 10) {
		$_HUL = $this->where($where)->order($order)->limit($limit)->select();
		return $_HUL;
	}

	public function get_hashUrlInfo($hashUrlId) {
		$_HUI = $this->where(array('hash_url_id' => array('EQ', $hashUrlId)))->find();
		return $_HUI;
	}
	public function add_hashUrl($data) {
		$result = array('data' => '', 'error' => '');

		if(isset($data['hu_src'])) {
			$data['hu_src'] = AFilter::url($data['hu_src'], 255);
			if(!isset($data['hu_hash'])) {
				$data['hu_hash'] = md5(UUID.'|'.$data['hu_src']);
			}
		}

		unset($data['hash_url_id']);
		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $_t_id;

		return $result;
	}

	public function edit_hashUrl($data) {
		$result = array('data' => '', 'error' => '');

		if(isset($data['hu_src'])) {
			$data['hu_src'] = AFilter::url($data['hu_src'], 255);
			if(!isset($data['hu_hash'])) {
				$data['hu_hash'] = md5(UUID.'|'.$data['hu_src']);
			}
		}

		if(false === $this->update($data)) {
			$result['error'] = L('UPDATE_FAILED');
			return $result;
		}

		return $result;
	}

	public function delete_hashUrl($hashUrlId) {
		$result = array('data' => '', 'error' => '');

		if(false === $this->delete($hashUrlId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		return $result;
	}
}

?>