<?php

/**
 *--------------------------------------
 * index
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-06-28
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class IndexModl extends Modl {
	public function __construct() {
		$this->autoCheckFields = false;
		parent::__construct();
	}

	public function get_manageMenu() {
		/* get extension list */
		$_EML = M('Extension')->get_extensionMenu();

		/* all menu */
		$_M = array(
			array(
				'm_name' => L('CONTENT'),
				'm_alias' => 'content',
				'm_sub_key' => 'm_content',
				'm_sub' => array(
					array(
						'm_group_name' => L('CONTENT'),
						'm_alias' => 'content',
						'm_menus' => array(
							array(
								'm_name' => L('ARTICLE_CATEGORY'),
								'm_alias' => 'article_category',
								'm_url' => 'article_category/list_category'),
							array(
								'm_name' => L('ARTICLE'),
								'm_alias' => 'article',
								'm_url' => 'article/list_article'),
							array(
								'm_name' => L('ARTICLE_REVIEW'),
								'm_alias' => 'article_review',
								'm_url' => 'article_review/list_review'),
							)),
					)),
			array(
				'm_name' => L('SYSTEM'),
				'm_alias' => 'system',
				'm_sub_key' => 'm_system',
				'm_sub' => array(
					array(
						'm_group_name' => L('SYSTEM'),
						'm_alias' => 'system',
						'm_menus' => array(
							array(
								'm_name' => L('OPTION'),
								'm_alias' => 'option',
								'm_url' => 'option/edit_option_site'),
							array(
								'm_name' => L('MENU'),
								'm_alias' => 'menu',
								'm_url' => 'menu/list_menu'),
							array(
								'm_name' => L('LOG'),
								'm_alias' => 'log',
								'm_url' => 'log/list_log'),
							)),
					)),
			array(
				'm_name' => L('MAINTENANCE'),
				'm_alias' => 'maintenance',
				'm_sub_key' => 'm_maintenance',
				'm_sub' => array(
					array(
						'm_group_name' => L('TOOL'),
						'm_alias' => 'tool',
						'm_menus' => array(
							array(
								'm_name' => L('CLEAR_CACHE'),
								'm_alias' => 'clear_cache',
								'm_url' => 'cache/clear_cache'),
							array(
								'm_name' => L('FILE_EXPLORE'),
								'm_alias' => 'file_explore',
								'm_url' => 'file_explore/list_file'),
							array(
								'm_name' => L('DATABASE'),
								'm_alias' => 'database',
								'm_url' => 'database/list_table'),
							)),
					array(
						'm_group_name' => L('SAFETY'),
						'm_alias' => 'safety',
						'm_menus' => array(
							array(
								'm_name' => L('BAN_IP'),
								'm_alias' => 'ban_ip',
								'm_url' => 'ban_ip/list_ip'),
							)),
					)),
			array(
				'm_name' => L('STANDALONE_MOUDLE'),
				'm_alias' => 'standalone_moudle',
				'm_sub_key' => 'm_extension',
				'm_sub' => array(
					array(
						'm_group_name' => L('STANDALONE_MOUDLE'),
						'm_alias' => 'standalone_moudle',
						'm_menus' => array(
							array(
								'm_name' => L('AD'),
								'm_alias' => 'ad',
								'm_url' => 'ad_space/list_space'),
							array(
								'm_name' => L('FLINK'),
								'm_alias' => 'flink',
								'm_url' => 'flink/list_flink'),
							array(
								'm_name' => L('GUESTBOOK'),
								'm_alias' => 'guestbook',
								'm_url' => 'guestbook/list_guestbook'),
							array(
								'm_name' => L('SINGLE_PAGE'),
								'm_alias' => 'single_page',
								'm_url' => 'single_page/list_single_page'),
							array(
								'm_name' => L('SUBSCRIBE'),
								'm_alias' => 'subscribe',
								'm_url' => 'subscribe/list_subscribe'),
							array(
								'm_name' => L('HASH_URL'),
								'm_alias' => 'hash_url',
								'm_url' => 'hash_url/list_hash_url'),
							),
						),
					)),
			array(
				'm_name' => L('EXTENSION'),
				'm_alias' => 'extension',
				'm_sub_key' => 'm_extension',
				'm_sub' => array(
					array(
						'm_group_name' => L('EXTENSION_MANAGE'),
						'm_alias' => 'extension_manage',
						'm_menus' => array(
							array(
								'm_name' => L('EXTENSION_LIST'),
								'm_alias' => 'list_extension',
								'm_url' => 'extension/list_extension'),
							array(
								'm_name' => L('PACKAGE_EXTENSION'),
								'm_alias' => 'package_extension',
								'm_url' => 'extension/package_extension'))),
					array(
						'm_group_name' => L('INSTALLED_EXTENSION'),
						'm_alias' => 'plugin',
						'm_menus' => $_EML),
					)));

		/* check permission */
		$_limit = get_limitPermission(true);
		/* filter menu */
		foreach($_M as $k => $menu) {
			foreach($menu['m_sub'] as $k_sub => $m_sub) {
				foreach($m_sub['m_menus'] as $k_menu => $m) {
					$mUrl = explode('?', $m['m_url']);
					if(in_array($mUrl[0], $_limit)) {
						unset($_M[$k]['m_sub'][$k_sub]['m_menus'][$k_menu]);
						continue;
					}
					$_M[$k]['m_sub'][$k_sub]['m_menus'][$k_menu]['m_url'] = Url::U($m['m_url']);
				}
				if(empty($_M[$k]['m_sub'][$k_sub]['m_menus'])) {
					unset($_M[$k]['m_sub'][$k_sub]);
				}
			}
			if(empty($_M[$k]['m_sub'])) {
				unset($_M[$k]);
			}
		}

		return $_M;
	}
}

?>