<?php

/**
 *--------------------------------------
 * report
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-07
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ReportModl extends Modl {
	public function __construct() {
		$this->autoCheckFields = false;
		parent::__construct();
	}

	/* filter_content */
	public function filter_content($content) {
		$_o_i = M('Option')->get_option('interaction');
		if(is_array($content)) {
			foreach($content as $key => $val) {
				$content[$key] = $this->filter_content($val);
			}
			return $content;
		}
		else {
			$filterWords = explode('|', $_o_i['filter_words']);
			foreach($filterWords as $word) {
				$word = trim($word);
				if(empty($word)) {
					continue;
				}
				$replaceStr = str_repeat($_o_i['filter_replace'], AString::mstrlen($word));
				$content = str_replace($word, $replaceStr, $content);
			}
			return $content;
		}
	}

	/* report check */
	public function report_check($content) {
		$_o_i = M('Option')->get_option('interaction');
		if(is_array($content)) {
			foreach($content as $c) {
				if(!$this->report_check($c)) {
					return 0;
				}
			}
			return 1;
		}

		$filterWords = explode('|', $_o_i['filter_words']);
		foreach($filterWords as $word) {
			$word = trim($word);
			if(empty($word)) {
				continue;
			}
			if(strstr($content, $word)) {
				return 0;
			}
		}
		return 1;
	}
}

?>