<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:@MANAGE-}</title>
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}fea/css/fea.g.min.css" />
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}css/calendar.css" />
<link rel="stylesheet" type="text/css" href="{-:*__STYLE__-}css/common.css" />
{-if:'rtl'==_LD_-}
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}fea/css/fea.g.rtl.min.css" />
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}css/calendar-rtl.css" />
<link rel="stylesheet" type="text/css" href="{-:*__STYLE__-}css/common-rtl.css" />
{-:/if-}
<script src="{-:*__RES__-}js/calendar/calendar.js"></script>
<script src="{-:*__RES__-}js/calendar/lang/{-:*LANG_NAME-}.js"></script>
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}',
	EDITOR: {
		BASE_PATH: '{-:*__RES__-}js/editor/',
		PLUGIN_PATH: '{-:*__RES__-}js/editor/plugins/',
		UPLOAD_JSON: '{-url:editorjson/upload-}',
		FILE_MANAGER_JSON: '{-url:editorjson/file_manage-}',
		FORM_DATA : {
			'timeKey' : '{-:$_TK["timeKey"]-}',
			'token' : '{-:$_TK["token"]-}'
		}
	},
	URL : {
		GET_SINGLE_PAGE_SELECT : '{-url:admin@single_page/_get_single_page_select-}',
		GET_GROUP : '{-url:admin@single_page/_get_group-}',
		GET_HTML_NAMING : '{-url:admin@single_page/_get_html_naming-}'
	},
	EDIT_HTML_NAMING : false
};
</script>
</head>

<body>
<div class="container margin">

<form id="formEdit" action="" method="post">
<ul class="subnav subnav-tab" data-switcher="{'connect':'#tabContent'}">
	<li class="active"><a href="#">{-:@EDIT_SINGLE_PAGE-}</a></li>
	<li><a href="#">{-:@ADVANCED-}</a></li>
</ul>
<div id="tabContent" class="switcher">
	<table class="formTable margin">
		<tr>
			<td class="inputTitle">{-:@TITLE-}</td>
			<td class="inputTitle">{-:@GROUP-}</td>
		</tr>
		<tr>
			<td class="inputArea">
				<input type="text" name="sp_title" validate="/\S+/" value="{-:$_SPI['sp_title']-}" class="control-input input-inline" maxlength="96" size="50">
				<span class="text-danger">*</span> <span class="text-muted">{-:@SP_TITLE_TIP-}</span>
			</td>
			<td class="inputArea">
				<input id="sp_group" type="text" name="sp_group" validate="/\S+/" value="{-:$_SPI['sp_group']-}" class="control-input input-inline" maxlength="32" size="16">
				<select id="sp_group_select" class="control-input input-inline">
					<option value="">{-:@SELECT-}</option>
				{-foreach:$_SPGL,$spg-}
					<option {-if:$spg['sp_group']==$_SPI['sp_group']-} selected="selected"{-:/if-} value="{-:$spg['sp_group']-}">{-:$spg['sp_group']-}</option>
				{-:/foreach-}
				</select>
				<span class="text-muted">{-:@SP_GROUP_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@PARENT_PAGE-}</td>
			<td class="inputTitle">{-:@DISPLAY_ORDER-}</td>
		</tr>
		<tr>
			<td class="inputArea">
				<input id="sp_parent_id" type="hidden" value="{-:$_SPI['sp_parent_id']-}" name="sp_parent_id" />
				<span id="ac_parent_id_single_page_select" class="single_page_select" to='#sp_parent_id' sp_group="{-:$_SPI['sp_group']-}" exclude="{-:$_SPI['single_page_id']-}"></span>
				<span class="text-muted">{-:@SP_PARENT_PAGE_TIP-}</span>
			</td>
			<td class="inputArea">
				<input class="control-input input-inline" type="text" value="{-:$_SPI['sp_display_order']-}" name="sp_display_order" maxlength="10" size="4"> <span class="text-muted">{-:@SP_DISPLAY_ORDER_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@CONTENT-} <span class="text-muted text-normal">{-:@SP_CONTENT_TIP-}</span></td>
			<td class=""></td>
		</tr>
		<tr>
			<td colspan="2" class="inputArea">
				<textarea class="editor" name="sp_content" style="height:480px;">{-:$_SPI['sp_content']|htmlspecialchars-}</textarea>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@KEYWORDS-}</td>
			<td class=""></td>
		</tr>
		<tr>
			<td class="inputArea">
				<input class="control-input input-inline" type="text" value="{-:$_SPI['sp_keywords']-}" name="sp_keywords" maxlength="255" size="50">
			</td>
			<td class="inputTip">
				{-:@SP_KEYWORDS_TIP-}
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@DESCRIPTION-}</td>
			<td class=""></td>
		</tr>
		<tr>
			<td class="inputArea">
				<textarea class="control-input input-inline" name="sp_description" style="width:360px;height:70px;">{-:$_SPI['sp_description']-}</textarea>
			</td>
			<td class="inputTip">
				{-:@SP_DESCRIPTION_TIP-}
			</td>
		</tr>
	</table>
	<table class="formTable margin">
		<tr>
			<td class="inputTitle">{-:@IS_HTML-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<label><input type="radio" value="0" name="sp_is_html"{-if:0==$_SPI['sp_is_html']-} checked="checked"{-:/if-}> {-:@OFF-}</label>
				<label><input type="radio" value="1" name="sp_is_html"{-if:1==$_SPI['sp_is_html']-} checked="checked"{-:/if-}> {-:@ON-}</label>
			</td>
			<td class="inputArea">
				<span class="text-muted">{-:@SP_IS_HTML_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@TEMPLATE-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<select name="sp_tpl" class="control-input input-inline">
					{-foreach:$_TPLS,$tpl-}
					<option value="{-:$tpl['file']-}"{-if:$tpl['file']==$_SPI['sp_tpl']-} selected="selected"{-:/if-}>{-:$tpl['name']-}</option>
					{-:/foreach-}
				</select>
			</td>
			<td class="inputTip">
				<span class="text-danger">*</span> <span class="text-muted">{-:@SP_TPL_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@HTML_NAMING-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<input class="control-input input-inline" type="text" value="{-:$_SPI['sp_html_naming']-}" name="sp_html_naming" maxlength="96" size="50">
			</td>
			<td class="inputTip">
				<span class="text-muted">{-:@SP_HTML_NAMING_TIP-}</span>
			</td>
		</tr>
	</table>
</div>
<div id="operation" class="margin">
	<input name="timeKey" type="hidden" value="{-:$_TK['timeKey']-}">
	<input name="token" type="hidden" value="{-:$_TK['token']-}">
	<input type="hidden" value="{-:$_SPI['single_page_id']-}" name="single_page_id">
	<span class="btn btn-info submit" action="{-url:admin@single_page/edit_single_page_do-}" to="#formEdit">{-:@SUBMIT-}</span>
	<input class="btn" type="reset" value="{-:@RESET-}">
	<a class="btn" href="{-url:admin@single_page/list_single_page?sp_group={$_SPI['sp_group']}-}">{-:@BACK-}</a>
	<label class="text-mi"><input type="checkbox" name="build_now" value="1" checked="checked" /> {-:@BUILD_NOW-}</label>
</div><!--/#operation-->
</form>

</div>
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__RES__-}js/editor/editor.js"></script>
<script src="{-:*__RES__-}js/editor/lang/{-:*LANG_NAME-}.js"></script>
<script src="{-:*__STYLE__-}js/common.js"></script>
<script src="{-:*__STYLE__-}js/calendar.js"></script>
<script src="{-:*__STYLE__-}js/admin.js"></script>
<script src="{-:*__STYLE__-}js/editor.js"></script>
<script src="{-:*__STYLE__-}js/single_page.js"></script>
</body>
</html>