/*jslint regexp: true, nomen: true, sloppy: true */
(function(win, doc, undefined) {
	/* util */
	/* judge objet type */
	function type(obj, name) {
		if(name) {
			if('window' === name) {
				/* jshint eqeqeq: false */
				return obj != null && obj == obj.window;
			}
			else if('document' === name) {
				return type(obj) === 'document' || type(obj) === 'htmldocument';
			}
			else if('array' === name && Array.isArray) {
				return Array.isArray(obj);
			}
			return type(obj) === name;
		}

		// get type
		if(obj === null){
			return 'null';
		}
		var t = typeof obj;
		if(t !== 'object'){
			return t;
		}
		var c = {}.toString.call(obj).slice(8, -1).toLowerCase();
		/* jshint eqeqeq: false */
		if(c !== 'object' || obj.constructor == Object){
			return c;
		}
		// IE678
		if(obj == obj.document && obj.document != obj) {
			return 'window';
		}
		else if(obj.nodeType === 9) {
			return 'htmldocument';
		}
		else if(isFinite(obj.length) && obj.item) {
			return 'htmlcollection';
		}
		return c;
	}
	/* extend object */
	function extend() {
		var args = [].slice.call(arguments),
			override = typeof args[args.length -1] === 'boolean' ? args.pop() : true,
			target = args[0],
			source, i = 1, property;
		while(source = args[i++]) {
			for(property in source) {
				if(Object.prototype.hasOwnProperty.call(source, property) && (override || !(property in target))) {
					if(type(source[property], 'array')) {
						target[property] = [];
						extend(target[property], source[property]);
					}
					else if(type(source[property], 'object')) {
						target[property] = {};
						extend(target[property], source[property]);
					}
					else {
						target[property] = source[property];
					}
				}
			}
		}
		return target;
	}
	/* break when calback return true */
	function each(arr, callback) {
		if(type(arr, 'array')) {
			for(var i = 0, len = arr.length; i < len; i++) {
				if(callback(arr[i], i, arr)) {
					break;
				}
			}
		}
	}

	/* private */
	var expose = +new Date();
	/* get current script */
	function _getCurrentScript() {
		// FF,Chrome
		if(doc.currentScript) {
			return doc.currentScript.src;
		}
		var stack;
		try {
			var a = {};
			a.b();
		}
		catch(e) {
			stack = e.fileName || e.sourceURL || e.stack || e.stacktrace;
		}
		// IE10
		if(stack) {
			var absPath = /((?:http|https|file):\/\/.*?\/[^:]+)(?::\d+)?:\d+/.exec(stack)[1];
			if(absPath) {
				return absPath;
			}
		}
		// IE5-9
		var isLtIE8 = ('' + doc.querySelector).indexOf('[native code]') === -1;
		for(var scripts = doc.scripts,
			i = scripts.length - 1,
			script; script = scripts[i--];) {
			if(script.className !== expose && script.readyState === 'interactive') {
				script.className = expose;
				// if less than ie 8, must get abs path by getAttribute(src, 4)
				return isLtIE8 ? script.getAttribute('src', 4) : script.src;
			}
		}
	}
	/* get dirname of path: a/b/c.js?foo=1#d/e --> a/b/ */
	function _dirname(path) {
		var m = path.match(/[^?#]*\//);
		return m ? m[0] : './';
	}

	/* LOGA */
	var version = '0.1.0',
		LOGA = {};
	win.LOGA = LOGA;
	extend(LOGA, {
		version: version,
		base: _dirname(_getCurrentScript()),
		util: {
			type: type,
			extend: extend,
			each: each
		},
		LANG: {},
		L: function(key) {
			return undefined == LOGA.LANG[key] ? key : LOGA.LANG[key];
		}
	});
})(window, window.document);

/* language */
(function (win, LOGA) {
	'use strict';

	document.write('<script src="' + LOGA.base + 'lang/' + GV.LANG_NAME + '.js"><\/script>');

})(window, LOGA);
