/* common */
(function ($, LOGA) {

var GV = window.GV || {};
GV.IS_UPLOADING = false;
window.GV = GV;

/* submit form; .submit[to=form id, action=form action] */
$(document).on('blur', '[validate]', function() {
	$(this).removeClass('input-danger');
	var tipNodeId = ('#' + $(this).attr('name') + '__tip').replace(/[\[\]\"\']/g, '');

	$(tipNodeId).find('.tip').remove();
	var rule = $(this).attr('validate');
	if('' != rule) {
		reg = eval(rule);
		if(!reg.test($(this).val())) {
			$(this).addClass('input-danger');
			$(tipNodeId).append('<span class="tip text-danger"><br />' + LOGA.L('INPUT_FORMAT_ERROR') + '</span>');
		}
	}
})
.on('submit', 'form', function() {
	$(this).find('[validate]').trigger('blur');
	var numWarnings = $('.input-danger', this).length;
	if(numWarnings) {
		$(this).find('.input-danger').first().focus();
		alert(LOGA.L('INPUT_FORMAT_ERROR'));
		return false;
	}
	if(GV.IS_UPLOADING) {
		alert(LOGA.L('UPLOADING'));
		return false;
	}
})
.on('click', '.submit', function() {
	$($(this).attr('to')).attr('action', $(this).attr('action'));
	$($(this).attr('to')).submit();
});

$(document).on('click', '.delete_confirm', function() {
	return confirm(LOGA.L('DELETE_CONFIRM')) ? true : false;
});

$(document).on('focus', '#vcodeInput', function() {
	if('' == $('#vcodeImg').html()){
		$('#vcodeImg').html('<img class="pointer" src="'+GV.URL.VCODE+'&t='+ Math.random() +'" onclick="this.src += \'&\' + Math.random();" />');
	}
});

$.FEA.gotop();

})(jQuery, LOGA);
