/*
	scripts.js
	
	License: GNU General Public License v2.0
	License URI: http://www.gnu.org/licenses/gpl-2.0.html
	
	Copyright: (c) 2013 Alexander "Alx" Agnarson, http://alxmedia.se
*/

jQuery(document).ready(function($) {

/*  Scroll to top
/* ------------------------------------ */
	$('a#to-top').click(function() {
		$('html, body').animate({scrollTop:0},'slow');
		return false;
	});
	
/*  Comments / pingbacks tabs
/* ------------------------------------ */	
    $(".comment-tabs li").click(function() {
        $(".comment-tabs li").removeClass('active');
        $(this).addClass("active");
        $(".comment-tab").hide();
        var selected_tab = $(this).find("a").attr("href");
        $(selected_tab).fadeIn();
        return false;
    });

/*  Download count +1 on click
/* ------------------------------------ */
	jQuery('.btn-1 a').click(function() {
		jQuery('.hugs strong').html(function(i, val) { return val*1+1 });
	});	
	
/*  Table odd row class
/* ------------------------------------ */
	$('table tr:odd').addClass('alt');

/*  Fancybox
/* ------------------------------------ */

	// Make all images that link to images into a lightbox
	jQuery("a[href$='.jpg'],a[href$='.png'],a[href$='.gif'],a[href$='.jpeg']").fancybox();

	// Make all images within a Wordpress gallery that link to an image into a lightbox gallery
	jQuery(".gallery a[href$='.jpg'],.gallery a[href$='.png'],.gallery a[href$='.gif'],.gallery a[href$='.jpeg']").attr('rel','gallery');

	// Make all items with a class fancybox into a lightbox
	jQuery(".fancybox").fancybox();

/*  Mobile menu smooth toggle height
/* ------------------------------------ */	
	$('.nav-toggle').on('click', function() {
		slide($('.nav-wrap .nav', $(this).parent()));
	});
	 
	function slide(content) {
		var wrapper = content.parent();
		var contentHeight = content.outerHeight(true);
		var wrapperHeight = wrapper.height();
	 
		wrapper.toggleClass('expand');
		if (wrapper.hasClass('expand')) {
		setTimeout(function() {
			wrapper.addClass('transition').css('height', contentHeight);
		}, 10);
	}
	else {
		setTimeout(function() {
			wrapper.css('height', wrapperHeight);
			setTimeout(function() {
			wrapper.addClass('transition').css('height', 0);
			}, 10);
		}, 10);
	}
	 
	wrapper.one('transitionEnd webkitTransitionEnd transitionend oTransitionEnd msTransitionEnd', function() {
		if(wrapper.hasClass('open')) {
			wrapper.removeClass('transition').css('height', 'auto');
		}
	});
	}
	
});