<?php
/* * *********************************************************
 * [cml] (C)2012 - 3000 cml http://linhecheng.com
 * @Author  linhecheng<linhechengbush@live.com>
 * @Date: 13-6-26 上午11:23
 * @version  1.0 
 * cml框架惯例配置文件
 * *********************************************************** */

defined('CML_PATH') || exit();

return array(
	//调试模式  默认关闭
	'APP_DEBUG' => false,
	'DB_FIELDS_CACHE' => true, //线上模式是否开启数据库字段缓存

	//数据库配置
	'DEFAULT_DB' => array(
		'DRIVER' => 'MySql', //数据库驱动
		'MASTER' => array(           
			'HOST' => 'localhost', //数据库主机
			'USERNAME' => 'root', //数据库用户名
			'PASSWORD' => '', //数据库密码
			'DBNAME' => 'cmlphp', //数据库名
			'CHARSET' => 'utf8', //数据库编码
			'TABLEPREFIX' => 'sun_', //数据表前缀 
			'PCONNECT' => false, //是否开启数据库长连接 
			'ENGINE' => ''//数据库引擎 
		),
		'SLAVES'=>array(),
	),
	// 缓存服务器的配置
	'DEFAULT_CACHE' => array(
		'ON' => 0, //为1则启用，或者不启用
		'DRIVER' => 'Memcache',
		'HOST' => '127.0.0.1',
		'PORT' => '11211',
		'PREFIX' => 'cml_',
		'MORE_SERVER' => false, //是否有多台memcache
		/**
		假如有多台服务器设置为数组如下 需要(PECL memcache >= 2.0.0)支持 php自己实现一致性hash性能太低
		'MORE_SERVER' => array(
			array(
				'HOST' => '127.0.0.1',
				'PORT' => '11212',
			),
			array(
				'HOST' => '127.0.0.1',
				'PORT' => '11213',
			),
		 ),
		 */
	),
	/**
	//文件缓存
	'DEFAULT_CACHE' => array(
		'ON' => 0, //为1则启用，或者不启用
		'DRIVER' => 'File',
		'PREFIX' => 'cml_'
	),
	//apc缓存
	'DEFAULT_CACHE' => array(
		'ON' => 0, //为1则启用，或者不启用
		'DRIVER' => 'Apc',
		'PREFIX' => 'cml_'
	),
	//Redis缓存
	'DEFAULT_CACHE' => array(
		'ON' => 0, //为1则启用，或者不启用
		'DRIVER' => 'Redis',
		'HOST' => '127.0.0.1',
		'PORT' => '11211',
		'PREFIX' => 'cml_'
	),
	*/

	//模板设置
	'TMPL_THEME' =>'', //默认只有单主题
	'TMPL_TEMPLATE_SUFFIX' => '.html',     // 默认模板文件后缀
	'TMPL_LEFT_DEPER' => '{', //模板左定界符
	'TMPL_RIGHT_DEPER' => '}', //模板右定界符
	'TMPL_ACTION_ERROR' => CML_PATH.'/Views/operate_jump.tpl', // 默认错误跳转对应的模板文件
	'TMPL_ACTION_SUCCESS' => CML_PATH.'/Views/operate_jump.tpl', // 默认成功跳转对应的模板文件
	'TMPL_EXCEPTION' => CML_PATH.'/Views/cml_exception.tpl', // 默认成功跳转对应的模板文件
	'DEFAULT_CHARSET' => 'utf-8', // 默认输出编码
	'TMPL_CONTENT_TYPE' => 'text/html', // 默认模板输出类型
	'HTTP_CACHE_CONTROL' => 'private', // 网页缓存控制
	'OUTPUT_ENCODE' => true, // 页面压缩输出 

	/*分模块设置*/
	'APP_MODULE'=> false, //默认关闭

	/* URL设置 */
	'URL_CASE_INSENSITIVE' => false,   // 默认false 表示URL区分大小写 true则表示不区分大小写
	'URL_MODEL' => 1,       // URL访问模式,可选参数0、1、2、3,代表以下四种模式：
	// 0 (普通模式); 1 (PATHINFO 模式显示index.php); 2 (PATHINFO 不显示index.php); 3 (兼容模式)  默认为PATHINFO 模式，提供最好的用户体验和SEO支持
	'URL_PATHINFO_DEPR' => '/',	// PATHINFO模式下，各参数之间的分割符号  
	'URL_HTML_SUFFIX' => '.html',  // URL伪静态后缀设置  
	'URL_DEFAULT_MODULE' => 'Site', //默认模块
	'URL_DEFAULT_CONTROLLER' => 'Index', //默认控制器
	'URL_DEFAULT_ACTION' => 'index', //默认操作
	/*URL路由设置*/
	'URL_ROUTER_ON' => false, //开启路由
	'URL_ROUTE_RULES'=> array(		
		//'blog/:aid\d' =>'Index/read', //查看单篇文章路由
		//'category/:cid\d/:p\d' =>'Index/index', //文章分类查看分页路由       
		//'search/:keywords/:p'=>'Index/index',//搜索分页路由        
	),

	/* 系统变量名称设置 */  
	'VAR_MODULE' => 'm',		// 默认模块获取变量
	'VAR_CONTROLLER' => 'c',		// 默认控制器获取变量
	'VAR_ACTION' => 'a',		// 默认操作获取变量
	'VAR_PATHINFO' => 's',	// PATHINFO 兼容模式获取变量例如 ?s=/module/action/id/1中的s ,后面的分隔符/取决于URL_PATHINFO_DEPR

	/*安全过滤*/
	'AUTH_KEY'=>'a5et3e41d', //Encry加密key
	'CHECK_CSRF' => 1, //检查csrf跨站攻击 0、不检查，1、只检查post数据提交方式，2、get/post都检查 默认只检查post
	'FORM_TOKEN'=> 0, //表单令牌 0不开启，1开启

	/*语言包设置*/
	'LANG' =>'zh-cn',  //读取zh-cn.php文件

	/*cookie设置*/
	'COOKIE_PREFIX'=> 'cml_', //cookie前缀 
	'COOKIE_EXPIRE' => 0,    // Coodie有效期
	'COOKIE_DOMAIN' => '',      // Cookie有效域名
	'COOKIE_PATH' => '/',     // Cookie路径
	'UserAuthId' => 'CmlUserAuth',  //用户登录成功之后的cookie标识

	/*Session设置*/
	'SESSION_PREFIX' => 'cml_', //session前缀
	'SESSION_USER' => 0, //SESSION保存位置自定义 0不开启、1开启
	'SESSION_USER_LOC' => 'db', //自定义保存SESSION的位置时 定义保存的地方  db、cache两种
);