<?php
/* * *********************************************************
 * [cml] (C)2012 - 3000 cml http://linhecheng.com
 * @Author  linhecheng<linhechengbush@live.com>
 * @Date: 13-6-26 上午11:23
 * @version  1.0 
 * cml框架 系统默认控制器类
 * *********************************************************** */

defined('CML_PATH') || exit();

class CmlController
{

	/**
	 * 运行对应的控制器
	 *
	 * @return void
	 */
	final public function run()
	{
		//检测csrf跨站攻击
		CmlSecure::checkCsrf(C('CHECK_CSRF'));

		// 关闭GPC过滤 防止数据的正确性受到影响 在db层防注入
		if(get_magic_quotes_gpc()) {
			CmlSecure::stripslashes($_GET);
			CmlSecure::stripslashes($_POST);
			CmlSecure::stripslashes($_COOKIE);
			CmlSecure::stripslashes($_REQUEST); 
		}

		//session保存方式自定义
		if(C('SESSION_USER')) {
			CmlSession::init();
		} else {
			ini_get('session.auto_start') || session_start(); //自动开启session
		}

		// 网页字符编码
		header('Content-Type:'.C('TMPL_CONTENT_TYPE').'; charset='.C('DEFAULT_CHARSET'));

		//如果有子类中有init()方法 执行Init() eg:做权限控制
		if(method_exists($this, "init")){
			$this->init();
		}

		//根据动作去找对应的方法
		$method = $_GET[C('VAR_ACTION')];
		if(method_exists($this, $method)){
			$this->$method();
		}else if($GLOBALS['APP_DEBUG']) {
			throw_exception(L('_ACTION_NOT_FOUND_', null, $_GET[C('VAR_ACTION')]));
		} else {
			show404Page();
		}
	}

	/**
	 * 魔术方法 有不存在的属性的时候执行
	 *
	 * @access public
	 * @param string $name 属性
	 *
	 * @return CmlModel
	 */
	public function __get($name)
	{
		if($name == 'model') {
			return M();
		} else {
			return CmlView::getInstance()->args[$name];
		}
	}

	/**
	 * 获取db实例  这边可用__call但是为了代码提示还是写出
	 *
	 * @param array $conf;
	 *
	 * @return DbMysql | DbPdoMysql
	 */
	public function db($conf = 'DEFAULT_DB')
	{
		return $this->model->db($conf);
	}

	/**
	 * 获取cache实例 这边可用__call但是为了代码提示还是写出
	 *
	 * @param array $conf;
	 *
	 * @return CacheApc | CacheFile | CacheMemcache | CacheRedis
	 */
	public function cache($conf = 'DEFAULT_CACHE')
	{
		return $this->model->cache($conf);
	}

	/**
	 * 以Json格式返回Ajax请求
	 *
	 * @param array $data
	 *
	 * @return void
	 */
	public function ajaxReturn($data = array())
	{
		exit(json_encode($data));
	}

	/**
	 * 重定向
	 *
	 * @param string $url
	 * @param int $time
	 *
	 * @return void
	 */
	public function redirect($url, $time = 0)
	{
		if (!headers_sent()) {
			($time === 0) && header("Location: {$url}");
			header("refresh:{$time};url={$url}");
		} else {
			exit("<meta http-equiv='Refresh' content='{$time};URL={$url}'>");
		}
	}

	/**
	 * 操作错误跳转的快捷方法
	 *
	 * @param string $message 错误信息
	 * @param string $jumpUrl 页面跳转地址
	 * @param mixed $ajax 是否为Ajax方式 当数字时指定跳转时间
	 *
	 * @return void
	 */
	public function error($message = null, $jumpUrl = '', $ajax = false)
	{
		$this->jump(is_null($message ) ? L('_OPERATION_FAIL_') : $message, 0, $jumpUrl, $ajax);
	}

	/**
	 * 操作成功跳转的快捷方法
	 *
	 * @param string $message 提示信息
	 * @param string $jumpUrl 页面跳转地址
	 * @param mixed $ajax 是否为Ajax方式 当数字时指定跳转时间
	 *
	 * @return void
	 */
	public function success($message = null, $jumpUrl = '', $ajax = false)
	{
		$this->jump(is_null($message ) ? L('_OPERATION_SUCCESS_') : $message, 1, $jumpUrl, $ajax);
	}

	/**
	 * 登录超时快捷方法
	 *
	 * @param string $message 提示信息
	 * @param string $jumpUrl 跳转地址
	 *
	 * @return void
	 */
	public function timeout($message = '', $jumpUrl = '')
	{
		$this->jump($message, 301, $jumpUrl, true);
	}

	/**
	 * 跳转操作
	 * 调用模板显示 默认为CmlPHP/Views/目录下面的operate_jump.tpl页面
	 * 提示页面为可配置 支持模板标签
	 *
	 * @param string $message 提示信息
	 * @param Boolean $status 状态
	 * @param string $jumpUrl 页面跳转地址
	 * @param mixed $ajax 是否为Ajax方式 当数字时指定跳转时间
	 * @param int $closeWin 是否关闭窗口
	 *
	 * @return void
	 */
	private function jump($message, $status = 1, $jumpUrl = '', $ajax = false, $closeWin = false)
	{
		if(C('APP_MODULE') && !empty($jumpUrl) && (count(explode('/',$jumpUrl)) !== 3)) $jumpUrl = CML_MODULE_NAME.'/'.$jumpUrl;
		$jumpUrl == '' || $jumpUrl = U($jumpUrl, '', false, 0);
		if(true === $ajax || CmlSecure::isAjax()) {// AJAX提交
			//这边是按dwzJs框架来定制返回的 如果用其它框架可根据需求修改返回值
			$data['navTabId'] = $_REQUEST['navTabId'];
			if($_REQUEST['close']) {
				$data['callbackType'] = 'closeCurrent';
			}
			$data['statusCode'] = $status;
			$data['message'] = $message;
			$this->ajaxReturn($data);
		}

		is_int($ajax) && CmlView::assign('waitSecond', $ajax);
		$closeWin && CmlView::assign('jumpUrl', 'javascript:window.close();'); //关闭窗口
		CmlView::assign('statusCode', $status);   // 状态
		CmlView::assign('message', $message);// 提示信息

		$waitSecond = $status ? 1 : 3;
		is_int($ajax) || CmlView::assign('waitSecond', $waitSecond); //跳转时间

		if(!empty($jumpUrl)) {
			CmlView::assign('jumpUrl', $jumpUrl);
		} else {
			// 默认操作成功自动返回操作前页面 错误返回上页
			$status ? CmlView::assign('jumpUrl', isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '') : CmlView::assign('jumpUrl','javascript:history.back(-1);');
		}
		if($status) { //发送成功信息
			CmlView::display(C('TMPL_ACTION_SUCCESS'), 1);
		}else{
			CmlView::display(C('TMPL_ACTION_ERROR'), 1);
			// 中止执行  避免出错后继续执行
			exit ;
		}
	}
}