<?php
/* * *********************************************************
 * [cml] (C)2012 - 3000 cml http://linhecheng.com
 * @Author  linhecheng<linhechengbush@live.com>
 * @Date: 13-6-26 上午11:23
 * @version  1.0 
 * cml框架 缓存驱动抽象类基类
 * *********************************************************** */
defined('CML_PATH') || exit();

abstract class CacheBase
{

	public function __get($var)
	{
		return $this->get($var);
	}

	public function __set($key, $val)
	{
		return $this->set($key, $val);
	}

	abstract public function __construct();

	/**
	 * 根据key取值
	 *
	 * @param $key
	 *
	 * @return mixed
	 */
	abstract public function get($key);

	/**
	 * 存储对象
	 *
	 * @param $key
	 * @param $value
	 * @param int $expire
	 *
	 * @return bool
	 */
	abstract public function set($key, $value, $expire = 0);

	/**
	 * 更新对象
	 *
	 * @param $key
	 * @param $value
	 * @param int $expire
	 *
	 * @return bool|int
	 */
	abstract public function update($key, $value, $expire = 0);

	/**
	 * 删除对象
	 *
	 * @param $key
	 *
	 * @return bool
	 */
	abstract public function delete($key);

	/**
	 * 清洗已经存储的所有元素
	 *
	 * @return bool
	 */
	abstract public function truncate();

	/**
	 * 自增
	 *
	 * @param $key
	 * @param int $val
	 *
	 * @return bool
	 */
	abstract public function increment($key, $val = 1);

	/**
	 * 自减
	 *
	 * @param $key
	 * @param int $val
	 *
	 * @return bool
	 */
	abstract public function decrement($key, $val = 1);

}