﻿
function AjaxObj() {
	this.responseText = null;
	var s = document.createElement('div');
	s.style.display = 'none';
	var n = 'iframe' + new Date().getTime();
	s.innerHTML = '<iframe src="about:blank" id="' + n + '" name="' + n + '"></iframe>';
	var bd=document.body;
	bd.insertBefore(s,bd.firstChild);
	this.iframe = s.firstChild;

	this.post = function(url,data) {
		if (typeof data == 'string' && data != '') {
			var f = document.createElement('form');
			f.name	 = 'ajaxform';
			f.target = n;
			f.method = 'post';
			f.action = url;
			var ds = data.split("&");
			for (var i = 0; i < ds.length; i++) {
				if (ds[i]) {
					var v	 = ds[i];
					var el	 = document.createElement('input');
					el.type  = 'hidden';
					el.name  = v.substr(0,v.indexOf('='));
					el.value = v.substr(v.indexOf('=')+1);
					f.appendChild(el);
				}
			}
			document.body.insertBefore(f,document.body.childNodes[0]);
			f.submit();
			document.body.removeChild(f);
			
		} else if (typeof data == 'object') {
			var s = data.getAttribute('action');
			if (typeof s == 'object') {
				var p = s.parentNode;
				p.removeChild(s);
				data.setAttribute('action', url);
				p.appendChild(s);
			} else {
				data.setAttribute('action', url);
			}
			data.target = n;
			data.submit();
		} else {
			self.frames&&self.frames[n].location.replace(url);//让iframe没有浏览历史
			//this.iframe.src=url;
		}
	}
	this.clearhistroy = function() {
		self.frames&&self.frames[n].location.replace('about:blank');
	}
}
function XMLhttp() {
	this.request = null;
	this.recall	 = null;
	this.time    = null;
	this.t       = null;
	this.sArray  = new Array();
	this.last	 = 0;
}

XMLhttp.prototype = {

	send : function(url,data,callback) {
		if (this.request == null) {
			this.request = new AjaxObj();
		}
		this.request.responseText = '';

		var nowtime	= new Date().getTime();
		if (nowtime - this.last < 1500) {
			clearTimeout(this.t);
			this.t = setTimeout(function(){ajax.send(url,data,callback)},1500+this.last-nowtime);
			return;
		}
		this.last = nowtime;
		url	+= (url.indexOf("?") >= 0) ? "&nowtime=" + nowtime : "?nowtime=" + nowtime;
		if (typeof verifyhash != 'undefined') {
			url += '&verify=' + verifyhash;
		}
		this.request.post(url,data);
		this.recall = callback;
		if (typeof this.recall == "function") {
			if (this.request.iframe.attachEvent) {
				this.request.iframe.detachEvent('onload',ajax.load);
				this.request.iframe.attachEvent('onload',ajax.load);
			} else {
				this.request.iframe.addEventListener('load',ajax.load,true);
			}
		}
	},

	load : function() {
		if(!ajax.request.iframe.contentWindow){
			return false;
		}
		var _innerText=ajax.request.iframe.contentWindow.document.documentElement.innerText;
		var _textContent=ajax.request.iframe.contentWindow.document.documentElement.textContent;
		if(_innerText==undefined&&_textContent==undefined){
			return false;
		}
		if(-[1,]){
				ajax.request.responseText=_textContent;
		}else{
				var rules = /<!\[CDATA\[([\s\S]+)\]\]>/.exec(_innerText);
				if(rules && rules[1]){
					ajax.request.responseText=rules[1].replace(/^\s+|\s+$/g,'');
				}else{
					var xmlDoc=ajax.request.iframe.contentWindow.document.XMLDocument;
					if(xmlDoc){
						ajax.request.responseText=xmlDoc.text;
					}else{
						ajax.request.responseText=_innerText;
					}
				}
		}
		
		if (ajax.request.iframe.detachEvent) {
			ajax.request.iframe.detachEvent('onload',ajax.load);
		} else {
			ajax.request.iframe.removeEventListener('load',ajax.load,true);
		}
		//try{if (ajax.request.iframe.location.href == 'about:blank'){return '';}}catch(e){}
		if (typeof(ajax.recall) == 'function') {
			ajax.recall();
			ajax.doscript();
		}
		//fixed for tt browser (register page)
		if (typeof ajaxclearhistory == 'undefined')ajax.request.clearhistroy();
	},

	XmlDocument : function(obj) {
		return (!-[1,]) ? ajax.request.iframe.contentWindow.document.XMLDocument : ajax.request.iframe.contentWindow.document;
	},

	submit : function(obj,recall) {
		if (typeof recall == 'undefined' || typeof recall != 'function') {
			recall = ajax.guide;
		}
		ajax.send(obj.getAttribute('action'), obj, recall);
		closep();
	},

	get : function(newread,border,cb,focus) {
		var temp = newread ? newread : read;
		var no_run_script = false;
		if (ajax.request.responseText.indexOf('NO_RUN_SCRIPT') == 0){
			ajax.request.responseText = ajax.request.responseText.substring(13);
			no_run_script = true;
		}
		if (ajax.request.responseText != null && ajax.request.responseText.indexOf('<') != -1 && !no_run_script) {
			temp.setMenu(this.runscript(ajax.request.responseText), '', border);
			temp.menupz(temp.obj);
			if(cb){
				cb();
			}
			//聚焦
			if(focus){
				try{
				var inputs=temp.menu.getElementsByTagName("input");
				for(var i=0,len=inputs.length;i<len;i++){
					var _input=inputs[i];
					if(_input.type=="text" && !_input.disabled && _input.style.display != 'none'){
						setTimeout(function(){
							_input.focus();
						},100)
						return;
					}
				}
				}catch(e){}
			}
		} else {
			closep();
			ajax.guide();
		}
		
	},

	runscript : function (html) {
		if (html.indexOf('<script') == -1) return html;
		var _=this;
		html = html.replace(/<script(.*?)>([^\x00]*?)<\/script>/ig, function($1, $2, $3) {
			_.sArray.push({'attribute' : $2, 'code' : $3});
			return '';
		});
		return html;
	},

	doscript : function() {
		for (var i = 0; i < this.sArray.length; i++) {
			var id = path = code = '';
			if (this.sArray[i]['attribute'].match(/\s*id\="([\w\_]+?)"/i)) {
				id = RegExp.$1;
			}
			if (this.sArray[i]['attribute'].match(/\s*src\="(.+?)"/i)) {
				path = RegExp.$1;
			} else {
				code = this.sArray[i]['code'];
			}
			loadjs(path, code, id);
		}
		this.sArray = new Array();
	},
	
	showError : function(message,time){
		var control = document.getElementById('pw_box'),
			popout = getElementsByClassName('popout',control)[0],
			msgBoxs = getElementsByClassName('wrongTip',popout),
			box = msgBoxs.length ? msgBoxs[0] : null;
			popBottom = getElementsByClassName('popBottom',control);
			if(!box) {	
				
				box = document.createElement('div');
				box.className = 'wrongTip';
				box.innerHTML = message;
				popBottom[0].parentNode.insertBefore(box,popBottom[0]);
			}
			box.style.display = '';
			box.innerHTML = message;
			if(time == undefined) time = 3;	
			clearTimeout(this.showTime);
			this.showTime = setTimeout(function(){box.style.display = 'none';},time * 1000);
			return false;
	},

	guide : function(callback) {
		if (ajax.request.responseText == null) {
			ajax.request.responseText = '您请求的页面出错啦!';
		}
		var rText = ajax.request.responseText.split('\t');

		/*主题印戳*/
		if(operateOverPrint(rText)){
			return false;
		}
		if (rText[1] != 'nextto') {
			showDialog('', rText[0], 2, callback ? callback : null);
		}
		if (typeof(rText[1]) != 'undefined' && in_array(rText[1],['jump','nextto','reload'])) {
			if (rText[1] == 'jump') {
				setTimeout("window.location.href='"+rText[2]+"';",200);
			} else if (rText[1] == 'nextto') {
				sendmsg(rText[2],rText[3],rText[4]);
			} else if (rText[1] == 'reload') {
				setTimeout("window.location.reload();",2000);
			}
		}
	},

	clear : function() {
		if (IsElement('ajax_guide')) document.body.removeChild(getObj('ajax_guide'));
	},

	convert : function(str) {
		if (typeof(str)=='string') {
			return str.replace(/\&/g,'%26');
		}
		return str;
	},

	quickpost : function(event,obj) {
		if ((event.ctrlKey && event.keyCode == 13) || (event.altKey && event.keyCode == 83)) {
			try{obj.ajaxsubmit.click();}catch(e){}
		}
	}
}

var ajax = new XMLhttp();
function sendmsg(url,data,id,callback) {//callback 07-05扩展,用来执行html生成之后的回调,不影响之前代码
	var e=getEvent();
	if(e.preventDefault){
		e.preventDefault();
	}else{
		e.returnValue=false;
	}
	read.obj = (!!id&&typeof id === 'string') ? getObj(id) :(typeof id=="object")?id:null;
	read.guide();
	setTimeout(function(){ajax.send(url,data,function(){
		ajax.get();
		callback && callback();
	});},100);
}
function objCheck(obj) {
	if (typeof(obj)=='string') {
		obj	= getObj(obj);
	}
	return obj;
}

function setCurrent(src,dst,css) {
	var o = null;
	if (IsElement(src)) {
		o = getObj(src);
	} else if (dst && IsElement(dst)) {
		o = getObj(dst);
	}
	if (o) o.className += ' ' + css;
}

function strlen(str){
	var len = 0;
	var s_len = str.length = (is_ie && str.indexOf('\n')!=-1) ? str.replace(/\r?\n/g, '_').length : str.length;
	window.charset?0:charset="";
	var c_len = charset == 'utf-8' ? 3 : 2;
	for(var i=0;i<s_len;i++){
		len += str.charCodeAt(i) < 0 || str.charCodeAt(i) > 255 ? c_len : 1;
	}
	return len;
}

function substr(str, len) {
	if(!str || !len) {
		return '';
	}
	var a = 0;
	var i = 0;
	var temp = '';
	var c_len = charset == 'utf-8' ? 3 : 2;
	for (i=0;i<str.length;i++) {
		if (str.charCodeAt(i)>255) {
			a+=c_len;
		} else {
			a++;
		}
		if(a > len) {
			return temp;
		}
		temp += str.charAt(i);
	}
	return str;
}

function initCheckTextNum(textareaid,warnid,num,nodisplay) {
	var textareaobj = getObj(textareaid);
	var nodisplay = nodisplay ? false : true;/* if choose true the limit nums will not display else will display*/
	try{if (document.addEventListener) {
		textareaobj.addEventListener("input",function(){checkTextNum(textareaobj,warnid,num,nodisplay);},false);
	} else if (document.attachEvent){
		textareaobj.attachEvent("onpropertychange",function(){checkTextNum(textareaobj,warnid,num,nodisplay);});
	}}catch(e){}
}

function checkTextNum(textareaid,warnid,num,nodisplay) {

	if (typeof(textareaid) == 'string') {
		var textareaobj = getObj(textareaid);
	} else {
		var textareaobj = textareaid;
	}
	var str_length = strlen(textareaobj.value);
	if (!objCheck(getObj(warnid))) {
		return false;
	}
	var warn = getObj(warnid);
	if (str_length > num) {
		warn.style.display = '';
		warn.style.color = '';
		warn.innerHTML = '<font color=red>已超出'+(str_length-num)+'字节</font>';
	} else {
		if(nodisplay){
			warn.style.display = '';
			warn.innerHTML = '剩余'+(num-str_length)+'字节';
		}else if(warn.style.display == ''){
			warn.style.display = 'none';
		}
	}
}
function SetCookie(name,value) {
	expires = new Date();
	expires.setTime(expires.getTime()+(86400*365*1000));
	document.cookie=name+"="+escape(value)+"; expires="+expires.toGMTString()+"; path=/";
}

function FetchCookie(name) {
	var start = document.cookie.indexOf(name);
	var end = document.cookie.indexOf(";",start);
	return start==-1 ? null : unescape(document.cookie.substring(start+name.length+1,(end>start ? end : document.cookie.length)));
}

function showOverPrint(obj,isMulti){
	var url = obj.getAttribute("url");
	if (!isMulti) {
		sendmsg(url,'',obj.id);
		return false;
	}
	var overprintTids = getObj('overprinttids').value;
	sendmsg(url,'tidarray=' + overprintTids,obj.id);
	return false;
}

function operateOverPrint(text){
	/*主题印戳*/
	if (typeof(text[1]) != 'undefined' && in_array(text[1],['overprint'])) {
		var overprint = getObj("read_overprint");
		if(overprint && typeof(text[2]) != 'undefined'){
			var img = overprint.getElementsByTagName("img")[0];
			if(!img){
				img = document.createElement("img");
				img.src = text[2];
				overprint.appendChild(img);
			}else{
				img.src = text[2];/*图标切换*/
			}
			if(text[2] == ""){
				overprint.removeChild(img);
			}
		}
		/*是否存在后续操作*/
		if(typeof(text[3]) == 'undefined'){
			showDialog('',text[0],2);
		}
		if(typeof(text[3]) != 'undefined' && text[3] == "nextto"){
			sendmsg(text[4],text[5],text[6]);
		}
		return true;;
	}else{
		return false;
	}
}
function showViewLog(url,data,id){
	read.obj = (typeof id == 'undefined' || !id) ? null : getObj(id);
	read.guide();
	setTimeout(function(){ajax.send(url,data,function(){
		ajax.get();
		document.body.onmousedown = function(event){
			closep();
			document.body.onmousedown = function(){};
		}
		var box = getObj("pw_box");
		if(box){
			box.onmousedown = function(evt){
				if(evt){
		    		evt.stopPropagation();
		    	}else{
		    		event.cancelBubble = true;
		    	}
			}
		}
	});},100);
}
function uploadFile(ajaxForm,callback)
{
	ajax.send(url, ajaxForm.cloneNode(true), callback);
}


(function(){
	var UA = {};
	var ua = navigator.userAgent.toLowerCase(),s;
	(s = ua.match(/msie ([\d.]+)/)) ? UA.ie = s[1] :
	(s = ua.match(/firefox\/([\d.]+)/)) ? UA.firefox = s[1] :
	(s = ua.match(/chrome\/([\d.]+)/)) ? UA.chrome = s[1] :
	(s = ua.match(/opera.([\d.]+)/)) ? UA.opera = s[1] :
	(s = ua.match(/version\/([\d.]+).*safari/)) ? UA.safari = s[1] : 0;
	window.UA=UA;
})();
var is_ie =!!UA.ie;
var is_gecko=!!UA.firefox;
var is_webkit=!!UA.chrome;
var is_safari =!!UA.safari;
var is_ie6 = UA.ie==6;
if(is_ie6){
	try{ 
		document.execCommand("BackgroundImageCache", false, true);
	}catch(e){}
}
//comatibility.js
(function () {
if(!window.opera && !is_ie){
	if (window.HTMLElement) {
		var hp = HTMLElement.prototype;
		function _attachEvent(o,e,h) {
			e=/^onmousewheel$/i.test(e)?"DOMMouseScroll":e.replace(/^on/i,"");
			return o.addEventListener(e, h, false)
		}		
		hp.attachEvent = function(e, h) {
			return _attachEvent(this,e,h)
		};
		window.attachEvent = function(e, h){
			return _attachEvent(window, e, h)
		};
		document.attachEvent = function(e, h){
			return _attachEvent(window, e, h)
		};
		function _detachEvent(o, e, h) {
			e=/^onmousewheel$/i.test(e)?"DOMMouseScroll":e.replace(/^on/i,"");
			return o.removeEventListener(e, h, false)
		}
		hp.detachEvent = function(e, h){
			return _detachEvent(this, e, h)
		};
		window.detachEvent = function(e, h){
			return _detachEvent(window, e, h)
		};
		document.detachEvent = function(e, h){
			return _detachEvent(window, e, h)
		};
		hp.__defineGetter__("children", function() {
			var tmp = [];
			var j = 0;
			var n;
			for (var i=0; i<this.childNodes.length; i++) {
				n = this.childNodes[i];
				if (n.nodeType == 1) {
					tmp[j++] = n;
					if (n.name) {
						if (!tmp[n.name])tmp[n.name] = [];
						tmp[n.name][tmp[n.name].length] = n
					}
					if (n.id) tmp[n.id] = n
				}
			}
			return tmp
		});
		hp.__defineGetter__("currentStyle", function() {
			return this.ownerDocument.defaultView.getComputedStyle(this, null)
		});
		hp.__defineSetter__("outerHTML", function(sHTML) {
			var r = this.ownerDocument.createRange();
			r.setStartBefore(this);
			var df = r.createContextualFragment(sHTML);
			this.parentNode.replaceChild(df, this);
			return sHTML
		});
		hp.__defineGetter__("outerHTML", function(){
			var attr;
			var attrs=this.attributes;
			var str="<"+this.tagName;
			for(var i=0;i<attrs.length;i++){
				attr=attrs[i];
				if(attr.specified)str+=" "+attr.name+'="'+attr.value+'"'
			}return str+">"+this.innerHTML+"</"+this.tagName+">"
		});
		hp.__defineSetter__("innerText",function (sText){
			var parsedText=document.createTextNode(sText);
			this.innerHTML=parsedText;
			return parsedText
		});
		hp.__defineGetter__("innerText",function (){
			var r=this.ownerDocument.createRange();
			r.selectNodeContents(this);
			return r.toString ()
		});
	
		hp.__defineGetter__("uniqueID",function (){
			if(!this.id){
				this.id="control_"+parseInt(Math.random()*1000000)
			}
			return this.id
		});
		hp.setCapture=function (){
			document.onselectstart=function (){
				return false
			};
			window.captureEvents(Event.MOUSEMOVE|Event.MOUSEUP)
		};
		hp.releaseCapture=function (){
			document.onselectstart=null;
			window.releaseEvents(Event.MOUSEMOVE);
			window.releaseEvents(Event.MOUSEUP)
		}
	}
}
})();

var gIsPost = true;
var getObj = function(id){
	if(!id){
		return false;
	}
	return document.getElementById(id);
};
if (location.href.indexOf('/simple/') != -1) {
	getObj('headbase')?getObj('headbase').href = location.href.substr(0,location.href.indexOf('/simple/')+1):0;
} else if (location.href.indexOf('.html')!=-1 && 0) {
	var base = location.href.replace(/^(http(s)?:\/\/(.*?)\/)[^\/]*\/[0-9]+\/[0-9]{4,6}\/[0-9]+\.html$/i,'$1');
	if (base != location.href) {
		getObj('headbase')?getObj('headbase').href = base:0;
	}
}
//通用domready
(function(win,doc){
	var dom = [];
	dom.isReady  = false;
	win.onReady = function(fn){
		if ( dom.isReady ) {
			fn()
		} else {
			dom.push( fn );
		}
	}
	dom.fireReady = function() {
		if ( !dom.isReady ) {
			if ( !doc.body ) {
				return setTimeout( dom.fireReady, 16 );
			}
			dom.isReady = 1;
			if ( dom.length ) {
				for(var i = 0, fn;fn = dom[i];i++)
					fn()
			}
		}
	}
	if ( doc.readyState === "complete" ) {
		dom.fireReady();
	}else if(-[1,] ){
		doc.addEventListener( "DOMContentLoaded", function() {
	  		doc.removeEventListener( "DOMContentLoaded",  arguments.callee , false );
	  		dom.fireReady();
		}, false );
	}else {
		doc.attachEvent("onreadystatechange", function() {
		  if ( doc.readyState == "complete" ) {
			doc.detachEvent("onreadystatechange", arguments.callee );
			dom.fireReady();
		  }
	});
	(function(){
		if ( dom.isReady ) {
			return;
		}
		var node = new Image();
		try {
			node.doScroll();
			node = null;
		} catch( e ) {
			setTimeout( arguments.callee, 64 );
			return;
		}
	  	dom.fireReady();
	})();
  }
})(window,document);

(function(win){
	/**
	 *通用事件处理函数
	 */
	// http://dean.edwards.name/weblog/2005/10/add-event/
	win.addEvent = function(element, type, handler) {
		if (element.addEventListener) {
			element.addEventListener(type, handler, false);
		} else {
			if (!handler.$$guid) handler.$$guid = addEvent.guid++;
			if (!element.events) element.events = {};
			var handlers = element.events[type];
			if (!handlers) {
				handlers = element.events[type] = {};
				if (element["on" + type]) {
					handlers[0] = element["on" + type];
				}
			}
			handlers[handler.$$guid] = handler;
			element["on" + type] = handleEvent;
		}
	};
	addEvent.guid = 1;
	win.removeEvent=function(element, type, handler) {
		if (element.removeEventListener) {
			element.removeEventListener(type, handler, false);
		} else {
			if (element.events && element.events[type]) {
				delete element.events[type][handler.$$guid];
			}
		}
	};
	function handleEvent(event) {
		var returnValue = true;
		event = event || fixEvent(((this.ownerDocument || this.document || this).parentWindow || window).event);
		var handlers = this.events[event.type];
		for (var i in handlers) {
			this.$$handleEvent = handlers[i];
			if (this.$$handleEvent(event) === false) {
				returnValue = false;
			}
		}
		return returnValue;
	};
	function fixEvent(event) {
		event.preventDefault = fixEvent.preventDefault;
		event.stopPropagation = fixEvent.stopPropagation;
		return event;
	};
	fixEvent.preventDefault = function() {
		this.returnValue = false;
	};
	fixEvent.stopPropagation = function() {
		this.cancelBubble = true;
	};
})(window);
/**
 *验证码的，点其他地方消失的事件添加。
 */
function PW_popEvent (obj){
	if (!obj){return false;}
	//判断a元素是否包含b元素
	var contains = document.compareDocumentPosition ? function(a, b){
		return !!(a.compareDocumentPosition(b) & 16);
	} : function(a, b){
		return a !== b && (a.contains ? a.contains(b) : true);
	};
   document.body.onmousedown=function(e) {
		var e = window.event || e,
			elem = e.srcElement || e.target;
		if(!contains(obj,elem) && elem.id!=='showpwd'){
			obj.style.display = 'none';
		}
	};
}
function getElementsByClassName (className, parentElement){
	if (parentElement && typeof(parentElement)=='object') {
		var elems = parentElement.getElementsByTagName("*");
	} else {
		var elems = (document.getElementById(parentElement)||document.body).getElementsByTagName("*");
	}
	var result=[];
	for (i=0; j=elems[i]; i++) {
	   if ((" "+j.className+" ").indexOf(" "+className+" ")!=-1) {
			result.push(j);
	   }
	}
	return result;
}
var contains = document.compareDocumentPosition ? function(a, b){
		return !!(a.compareDocumentPosition(b) & 16);
	} : function(a, b){
		return a !== b && (a.contains ? a.contains(b) : true);
	};

function ietruebody() {
	return (document.compatMode && document.compatMode!="BackCompat" && !is_webkit)? document.documentElement : document.body;
}
function getTop() {
	return window.pageYOffset || ietruebody().scrollTop;
}
function getLeft() {
	return window.pageXOffset || ietruebody().scrollLeft;
}
function IsElement(id) {
	return document.getElementById(id) != null ? true : false;
}
function CopyCode(obj) {
	if (typeof obj != 'object') {
		if (is_ie) {
			if(window.clipboardData.setData("Text",obj)){
				alert('复制成功！');
			}
		} else {
			prompt('按Ctrl+C复制内容', obj);
		}
	} else if (is_ie) {
		var lis = obj.getElementsByTagName('li'), ar = [];
		for(var i=0,l=lis.length; i<l; i++){
			ar.push(lis[i].innerText);
		}
		if(window.clipboardData.setData('Text', ar.join("\r\n") ) ){
			alert('复制成功！');
		}
	} else {
		function openClipWin(){
			var lis = obj.getElementsByTagName('li'), ar = [];
			for(var i=0,l=lis.length; i<l; i++){
				ar.push(lis[i].textContent);
			}
			window.clip = new ZeroClipboard.Client();
			clip.setHandCursor( true );
			
			clip.addEventListener('complete', function (client, text) {
				alert("复制成功!" );
				closep();
			});
			clip.setText(ar.join("\r\n"));
			var clipEle = getObj('clipWin');
			if (!clipEle){
				var clipEle = document.createElement('div');
				clipEle.innerHTML = '<div class="popout"><table border="0" cellspacing="0" cellpadding="0"><tbody><tr><td class="bgcorner1"></td><td class="pobg1"></td><td class="bgcorner2"></td></tr><tr><td class="pobg4"></td><td><div class="popoutContent">\
<div class="p10"><a href="javascript:closep();" class="adel">关闭</a>提示</div><div class="popBottom"><span class="btn2"><span><button type="button">点击这里复制代码</button></span></span></div></div></td><td class="pobg2"></td></tr><tr><td class="bgcorner4"></td><td class="pobg3"></td><td class="bgcorner3"></td></tr></tbody></table></div>';
				//clipEle.innerHTML = '<p id="d_clip_button">提示</p>';
				clipEle.style.display = 'none';
				document.body.appendChild(clipEle);
			}
			read.open(clipEle, null, 2);
			var btn = getObj('pw_box').getElementsByTagName('button')[0];
			clip.glue(btn);
			//clip.glue( 'd_clip_button', 'd_clip_container' );
		}//彈窗
		
		if (!window.clip){
			var script = document.createElement('script');
			script.src = 'js/ZeroClipboard.js';
			script.onload = function(){
				ZeroClipboard.setMoviePath( 'js/ZeroClipboard.swf' );
				openClipWin();
			};
			document.body.appendChild(script);
		}else{
			openClipWin();
		}
	}
	return false;
}
function Addtoie(value,title) {
	try{
		is_ie ? window.external.AddFavorite(value,title) : window.sidebar.addPanel(title,value,"");
	  }catch(err){
	    txt = "1、抱歉，您的IE注册表值被修改，导致不支持收藏，您可按照以下方法修改。\n\n"
	    txt += "2、打开注册表编辑器，右键点击HKEY_CLASSES_ROOT查找'C:/\WINDOWS/\system32/\shdocvw.dll'。 \n\n"
	    txt += "3、点击(默认)，把'C:/\WINDOWS/\system32/\shdocvw.dll'修改为'C:/\WINDOWS/\system32/\ieframe.dll'，重启IE浏览器。\n\n"
		is_ie ? alert(txt) : alert("抱歉，您的浏览器不支持，请使用Ctrl+D进行添加\n\n")
	  }
}

var ifcheck = true;
function CheckAll(form,match) {
	for (var i = 0,j = form.elements.length; i < j; i++) {
		var e = form.elements[i];
		if (e.type == 'checkbox' && (typeof match == 'undefined' || e.name.match(match))) {
			e.checked = ifcheck;
		}
	}
	ifcheck = ifcheck == true ? false : true;
}

function showcustomquest(qid,id){
	var id = id || 'customquest';
	getObj(id).style.display = qid==-1 ? '' : 'none';
}
function showCK(){
	var ckcode = getObj('ckcode');
	ckcode.style.display="";
	ckcode.style.zIndex="1000000";
	if (ckcode.src.indexOf('ck.php') == -1) {
		ckcode.src = 'ck.php?nowtime=' + new Date().getTime();
	}
}
function setTab(m,n){
	var tli=document.getElementById("menu"+m).getElementsByTagName("li");
	var mli=document.getElementById("main"+m).getElementsByTagName("div");
	for(var i=0,j=tli.length;i<j;i++){
		tli[i].className=i==n?"hover":"";
		mli[i].style.display=i==n?"block":"none";
	}
}
function changeState() {
	var msg = ajax.request.responseText;
	if (msg == 1) {
		getObj('stealth').className = '';
		getObj('iconimg').title = HEADER_HIDE;
		getObj('online_state').innerHTML = '<img src="'+IMG_PATH+'/stealth.png" align="absmiddle" alt="隐身" />隐身';
	} else {
		getObj('stealth').className = 'hide';
		getObj('iconimg').title = HEADER_ONLINE;
		getObj('online_state').innerHTML = '<img src="'+IMG_PATH+'/online.png" align="absmiddle" alt="在线" />在线';
	}
}
function showcustomquest_l(qid){
	getObj('customquest_l').name = 'customquest';
	getObj('customquest_l').style.display = qid==-1 ? '' : 'none';
}

function checkinput(obj,val){
	if (obj.className.indexOf('gray')!=-1) {
		obj.value = '';
		obj.className = obj.className.replace('gray', 'black');
	} else if (val && obj.value=='') {
		obj.value = obj.defaultValue = val;
		if (obj.className.indexOf('black') == -1) {
			obj.className += ' gray';
		} else {
			obj.className = obj.className.replace('black', 'gray');
		}
	}
}
var mt;
function showLoginDiv(){
	mt = setTimeout(function(){
		read.open('user-login','show-login',2,26);
		getObj('pwuser').focus();
	},200);
	//mt = setTimeout('read.open(\'user-login\',\'show-login\',2,26);getObj(\'pwuser\').focus();',200);
	document.onmousedown = function (e) {
		var e = window.event || e;
		var o = e.srcElement || e.target;
		if (!issrc(o)) {
			read.close();
			document.onmousedown = null;
		}
	}
}
function issrc(o) {
	var k = 0;
	while (o) {
		if (o == read.menu) {
			return true;
		}
		if (o.tagName.toLowerCase() == 'body' || ++k>10) {
			break;
		}
		o = o.parentNode;
	}
	return false;
}

function imgResize(o, size) {
	if (o.width > o.height) {
		if (o.width > size) o.width = size;
	} else {
		if (o.height > size) o.height = size;
	}
	try{
		var next = getObj('next');
		var pre = getObj('pre');
		next.coords = '0 0 ' + ',' + o.width/2 + ',' + o.height;
		pre.coords = o.width/2 + ' 0 ' + ',' + o.width + ',' + o.height;
	}catch(e){}
}
function ajaxurl(o, ep) {
	if (typeof o == 'object') {var url = o.href;read.obj = o;} else {var url = o;}
	ajax.send(url + ((typeof ep == 'undefined' || !ep) ? '' : ep), '', ajax.get);
	return false;
}

function sendurl(o,id) {
	read.obj = o;
	sendmsg(o.href,'',id);
	return false;
}
function showAnnouce(){
	var annouce = getObj('annouce_div');
	annouce.style.display = annouce.style.display == 'none' ? '' : 'none';
}

function showCK(){
	var a = getObj('ckcode2') || getObj('ckcode');
	a.style.display="";
	if (a.src.indexOf('ck.php') == -1) {
		a.src = 'ck.php?nowtime=' + new Date().getTime();
	}
}
function showConInfo(uid,cyid){
	ajax.send('apps.php?q=group&a=uintro&cyid='+cyid+'&uid='+uid,'',ajax.get);
}

/*
userCard = {
	t1	 : null,
	t2	 : null,
	menu : null,
	//uids : '',
	data : {},
	init : function() {
		var els = getElementsByClassName('userCard');
		for (i = 0; i < els.length; i++) {
			if (els[i].id) {
				var sx = els[i].id.split('_');
				//userCard.uids += (userCard.uids ? ',' : '') + sx[3];
				els[i].onmouseover = function() {
					var _ = this;
					clearTimeout(userCard.t2);
					userCard.t1 = setTimeout(function(){userCard.show(_.id);}, 800);
				}
				els[i].onmouseout = function() {
					clearTimeout(userCard.t1);
					if (userCard.menu) userCard.t2 = setTimeout(function(){userCard.menu.close();},500);
				}
			}
		}
	},
	show : function(id) {
		var sx = id.split('_');
		if (typeof userCard.data[sx[3]] == 'undefined') {
			try {
				ajax.send(getObj('headbase').href + 'pw_ajax.php?action=showcard&uid=' + sx[3]+ '&rnd='+Math.random(), '', function() {
					userCard.data[sx[3]] = ajax.runscript(ajax.request.responseText);
					userCard.show(id);
				})
			} catch(e){}
			return;
		}
		userCard.menu ? 0 : userCard.menu = new PwMenu('userCard');
		userCard.menu.menu.style.zIndex = 9;
		userCard.menu.obj = getObj(sx[1] + '_' + sx[2]) || getObj(id);
		userCard.menu.setMenu(userCard.data[sx[3]], '', 1);
		userCard.menu.menupz(userCard.menu.obj,21);
	}
}
*/

var Class = function(aBaseClass, aClassDefine) {
	function class_() {
		this.Inherit = aBaseClass;
		for (var member in aClassDefine) {
			try{this[member] = aClassDefine[member];}catch(e){}		//针对opera,safri浏览器的只读属性的过滤
		}
	}
	class_.prototype = aBaseClass;
	return  new class_();
};
var New = function(aClass, aParams) {
	function new_()	{
		this.Inherit = aClass;
		if (aClass.Create) {
			aClass.Create.apply(this, aParams);
		}
	}
	new_.prototype = aClass;
	return  new new_();
};
/* end */

function imgLoopClass(){
	this.timeout   = 2000;
	this.currentId = 0;
	this.tmp       = null;
	this.wrapId    = 'x-pics';
	this.tag       = 'A';
	this.wrapNum   = 0;
	this.total     = 10;
}
imgLoopClass.prototype = {
	/*对象选择器*/
	$ : function(id){
		return document.getElementById(id);
	},
	/*图片显示*/
	display : function(pics,currentId){
		for(i=0,len=pics.length;i<len;i++){
			if(i==currentId){
				var current = pics[i];
			}
			pics[i].style.display = "none";
		}
		current.style.display = "";
	},
	/*获取所有标签对象*/
	gets : function(){
		var wrapId = this.wrapId+this.wrapNum;
		var obj = this.$(wrapId);
		if(!obj){
			return false;
		}
		return this.$(wrapId).getElementsByTagName(this.tag);
	},
	/*轮显*/
	alternate : function(){
		var pictures = this.gets();
		if(!pictures){
			return false;
		}
		var length = pictures.length;
		this.currentId = this.currentId ? this.currentId : 0;
		if(this.currentId+1>length){
			this.currentId = 0;
		}
		this.display(pictures,this.currentId);
		this.currentId = this.currentId+1;
	},
	/*循环器*/
	loop : function(){
		this.alternate();
		var _this = this;
		t = setTimeout(function(){
			_this.loop();
		},this.timeout);
	},

	/*单页面多个图片轮播，最多十个*/
	imginit : function(){
		for(i=0;i<this.total;i++){
			var obj = this.$(this.wrapId+i);
			if(!obj){
				continue;
			}
			imgloop(i);/*调用外部通用接口*/
		}
	},

	init : function(){

	}
}
/*图片轮播调用接口*/
var imgloops = new imgLoopClass();
/*特殊图片轮播调用*/
function imgloop(num){
	var imgloops = new imgLoopClass();
	imgloops.wrapNum = num;
	imgloops.loop();
}
/*任务中心弹出控制*/
showJobPOP = function(){
	var pop = getObj("jobpop") || 0;
	var newjob = getObj("newjob");
	if(newjob){
		var num = newjob.getAttribute("num");
		if(!num){
			window.location.href = "jobcenter.php";
			return false;
		}
	}
	if(pop){
		pop.style.display='';
	}else{
		openjobpop("&job=show");/*必须显示*/
	}
	return false;
}
/*弹出任务中心界面*/
function openjobpop(param){
	var param = param || '';
	ajax.send('pw_ajax.php?action=jobpop',param,function(){
		jobCenterRun(ajax.request.responseText);
	});
}
//所有的删除确定
function checkDel(sub,str){
	if(confirm(str))
		sub.form.submit();
}

function insertContentToTextArea(textAreaObj, codeText) {
	var startPostionOffset = codeText.length;
	textAreaObj.focus();
	if (document.selection) {
		var selection = document.selection.createRange();
		selection.text = codeText.replace(/\\r?\\n/g, '\\r\\n');
		selection.moveStart('character', - codeText.replace(/\\r/g,'').length + startPostionOffset);
		selection.moveEnd('character', - codeText.length + startPostionOffset);
		selection.select();
	} else if (typeof textAreaObj.selectionStart != 'undefined') {
		var prepos = textAreaObj.selectionStart;
		textAreaObj.value = textAreaObj.value.substr(0,prepos) + codeText + textAreaObj.value.substr(textAreaObj.selectionEnd);
		textAreaObj.selectionStart = prepos + startPostionOffset;
		textAreaObj.selectionEnd = prepos + startPostionOffset;
	}
}

function displayElement(elementId, isDisplay) {
	if (undefined == isDisplay) {
		getObj(elementId).style.display = getObj(elementId).style.display == 'none' ? '' : 'none';
	} else {
		getObj(elementId).style.display = isDisplay ? '' : 'none';
	}
}
function preview_img(id){
	var photype = getObj('p_'+id);
	if(getObj('q_'+id)){
		getObj('q_'+id).value = "";
	}
	var patn = /\.jpg$|\.jpeg$|\.png|\.bmp|\.gif$/i;
	if(patn.test(photype.value)){
		var Preview = getObj('preview_'+id);

		if (is_gecko || is_webkit) {
			Preview.src = photype.files[0].getAsDataURL();
		} else if (is_ie) {
			Preview.src="images/90.png";
			photype.select();
			var val = document.selection.createRange().text;
			Preview.filters.item("DXImageTransform.Microsoft.AlphaImageLoader").src = val;
			Preview.filters.item("DXImageTransform.Microsoft.AlphaImageLoader").sizingMethod = 'scale';
		}
	} else {
		showDialog('error','您选择的似乎不是图像文件。',2);
	}
}

var Attention = {
	add : function(obj, touid, recommend) {
		ajax.send('pw_ajax.php?action=addattention&touid=' + touid + (recommend ? '&recommend=' + recommend : ''), '', function() {
			var rText = ajax.request.responseText.split('\t');
			if (rText[0] == 'success') {
				obj.innerHTML = '关注中';
				obj.className = obj.className.replace('follow', 'following gray');
				obj.onclick = '';
				
				if (obj.name) {
					getObj(obj.name+'_'+touid).innerHTML = parseInt(getObj(obj.name+'_'+touid).innerHTML) + 1;
				}
				
			} else {
				ajax.guide();
			}
		});
		return false;
	},
	del : function(touid) {
		ajax.send('pw_ajax.php?action=delattention&touid=' + touid, '', function() {
			var rText = ajax.request.responseText.split('\t');
			if (rText[0] == 'success') {
				window.location.reload();
			} else {
				ajax.guide();
			}
		});
		return false;
	}
};

function getBaseUrl() {
	var baseURL = document.baseURI || getHeadBase() || document.URL;
	if (baseURL && baseURL.match(/(.*)\/([^\/]?)/)) {
		baseURL = RegExp.$1 + "/";
	}
	return baseURL;
}
function getHeadBase() {
	return getObj('headbase') ? getObj('headbase').href : null;
}
//获取元素精确样式
function getStyle(ele,style){
	if(document.defaultView){
		return document.defaultView.getComputedStyle(ele,null)[style];
	}else{
		return ele.currentStyle[style];
	}
}
//获取事件对象
function getEvent(){
   if(document.all)
   {
		return window.event;//如果是ie
   }
   var func=getEvent.caller;
   while(func!=null)
   {
	   var arg0=func.arguments[0];
	   if(arg0)
	   {
		   if((arg0.constructor==Event || arg0.constructor ==MouseEvent)
		   ||(typeof(arg0)=="object" && arg0.preventDefault && arg0.stopPropagation))
		   {
		   return arg0;
		   }
	   }
		   func=func.caller;
	   }
	   return null;
}
//操作元素样式
function hasClass(obj,className){
		var classname = ' ' + className + ' ';
		var cname=obj.className;
		if ((' ' + cname + ' ').indexOf(classname) > -1) return true;
		return false;
}
function addClass(obj,className){
		if(hasClass(obj,className)){
			return false;
		}
		if(obj.className){
		obj.className+=" "+className;
		}else{
			obj.className=className;
		}
}
function removeClass(obj,className){
		if(!hasClass(obj,className)){
			return false;
		}
		var cname=' '+obj.className+' ';
		obj.className=cname.replace(' '+className+' ',"").replace(/^\s+|\s+$/,"");
}
function toggleClass(obj,className){
	  if(hasClass(obj,className)){
			removeClass(obj,className);
	  }else{
			addClass(obj,className);
	  }
}
function JSONParse(text){
	var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;
	var j;
	if (cx.test(text)) {
		text = text.replace(cx, function (a) {
			return '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
		});
	}
	if (/^[\],:{}\s]*$/.
test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@').
replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']').
replace(/(?:^|:|,)(?:\s*\[)+/g, ''))) {
		j = eval('(' + text + ')');
		return j;
	}
	showDialog('error','数据格式错误，无法解析');
}

function ddSliderPlayers(elementId,handleId, pauseTime, currentClassName) {
	try {
		if (typeof ddSliderPlayer == 'undefined')
			ddSliderPlayer = {};
	} catch (e) {
		ddSliderPlayer = {};
	}
	var elementObj = document.getElementById(elementId);
	var handler = document.getElementById(handleId);
	ddSliderPlayer[elementId] = new DDSliderPlayer(elementObj, handler, pauseTime, currentClassName);

	elementObj.onmouseover = function() {
		ddSliderPlayer[elementId].pause();
	}
	elementObj.onmouseout = function() {
		ddSliderPlayer[elementId].play();
	};
	return ddSliderPlayer;
}
function DDSliderPlayer(elementObj, handler, pauseTime, currentClassName) {
	this.id = elementObj.id;
	this.timer;
	this.curScreen = 0;
	this.elementObj = elementObj;
	this.pauseTime = (undefined == pauseTime) ? 3000 : pauseTime * 1000;
	this.currentClassName = (currentClassName == undefined) ? 'sel' : currentClassName;
	this.pics = getElementsByClassName('switchItem',elementObj);
	this.handlers = getElementsByClassName('switchNavItem',handler);
	this.maxScreen = this.pics.length > this.handlers.length ? this.handlers.length : this.pics.length;
	for (i=0;i<this.handlers.length;i++) {
		this.handlers[i].setAttribute("index", i);
		var id=this.id;
		this.handlers[i].onmouseover=function(){
			var u = this.getAttribute('index');
			ddSliderPlayer[id].go(u).pause();
		}
		this.handlers[i].onmouseout=function(){
			ddSliderPlayer[id].play();
		}
	}
	this.go();
	if (pauseTime)
		this.play();
}
DDSliderPlayer.prototype.pause = function(){
	this.pauseTime && clearInterval(this.timer);
	this.timer = null;
};
DDSliderPlayer.prototype.play = function(){
	if (!this.timer&&this.pauseTime) this.timer = setInterval('ddSliderPlayer.'+this.id+'.go()', this.pauseTime);
};
DDSliderPlayer.prototype.go = function(t){
	this.curScreen = t===undefined ? this.curScreen : t;
	this.curScreen %= this.maxScreen;
	for (i=0;i<this.maxScreen;i++) {
		if (i == this.curScreen) {
			this.handlers[i].className = 'switchNavItem '+this.currentClassName;
			this.pics[i].style.display = '';
		} else {
			this.handlers[i].className = 'switchNavItem';
			this.pics[i].style.display = "none" ;
		}
	}
	++this.curScreen;
	return this;
}
function ddHSlider(offX,eleid) {
	document.getElementById(eleid).scrollLeft+=offX;
}