<?php
// $Id: calendar.php,v 1.16 2009/05/11 21:13:21 saschalorenz Exp $

if(!empty($_REQUEST['action'])) {
	include_once "config.inc";
	if (file_exists("local_config.inc")) include_once "local_config.inc";
	include_once "functions.inc";
	if (file_exists("language/calendar.".$_REQUEST['calendarlanguage'].".inc")) include_once "language/calendar.".$_REQUEST['calendarlanguage'].".inc";

	if (isset($_REQUEST['album'])) {
		$album = get_magic_quotes_gpc()==1 ? stripslashes($_REQUEST['album']) : $_REQUEST['album'];
		if (file_exists(makeAlbumPath(iconv("UTF-8", $filename_encoding, $album)) . "/album.inc")) {
			include_once(makeAlbumPath(iconv("UTF-8", $filename_encoding, $album)) . "/album.inc");
		}
	}

	define('FPDF_FONTPATH','font/');
	require('ufpdf.php');

	if(isset($sessionpath) && ($sessionpath != "")) session_save_path($sessionpath);
	if(isset($sessionname) && ($sessionname != "")) session_name($sessionname);
	if (!headers_sent()) @session_start();

	if($cal_only_for_admin and empty($_SESSION['admin'])) {
		echo "You are not allowed to create a calendar!";
		exit;
	}
	$year = 1*$_POST["year"];
	if(!is_numeric($year) || $year<1970 || $year > 2037) {
		echo "Invalid year!";
		exit;
	}

	$pdf= new ufpdf();
	$pdf->AddFont('FreeSans', '', 'freesans.php');
	$pdf->AddFont('FreeSans', 'B', 'freesansb.php');
	$pdf->SetAutoPageBreak(false);
	$pdf->SetMargins(0,0,0);
	$pdf->SetCreator("TFTgallery ".TFT_VERSION." http://www.tftgallery.org/");
	
	$album_path=$album_directory;
	$pictures = array();
	for($i=0;$i<13;$i++) {
		if(isset($_POST["sheet".$i])) {
			array_push($pictures,$album_directory."/".$_POST["sheet".$i]);
		} else {
			array_push($pictures,"");
		}
	}

	$easterdate = easter_date($year);

	foreach ($easter as $day) {
		$datearray = getdate(strtotime($day.' days', $easterdate));
	    array_push($holiday,$datearray["mday"]*100+$datearray["mon"]);
	}

	foreach ($easter1 as $day) {
		$datearray = getdate(strtotime($day.' days', $easterdate));
	    array_push($holiday1,$datearray["mday"]*100+$datearray["mon"]);
	}

	extraholidays();

	for($i=0;$i<=12;$i++) {
	  $pdf->addPage();
	  $file = iconv("UTF-8",$filename_encoding,$pictures[$i]);
  	  $file = get_magic_quotes_gpc()==1 ? stripslashes($file) : $file;
		if(is_file($file)) {
				$imageinfo = @getimagesize($file);
				if(!empty($imageinfo)) {
					$ext = "";
					switch ($imageinfo[2]) {
						case 1: // GIF
							$image = imagecreatefromgif($file);
							$file = "tempimage$i.png";
							$ext = "png";
							imagepng($image, $file);
							imagedestroy($image);
							break;
						case 2: // JPEG
							$ext = "jpeg";
							break;
						case 3: // PNG
							$ext = "png";
							break;
						default: // else
							$ext = "";
							break;
					}
					if(($ext != "")) {
						$factorx = 190 / $imageinfo[0];
						$factory = 190 / $imageinfo[1];
						$factor = ($factorx > $factory) ? $factory : $factorx;
						$xmargin = (190/2)-($imageinfo[0]*$factor)/2;
						$ymargin = (190/2)-($imageinfo[1]*$factor)/2;
						$pdf->Image($file, 10+$xmargin, 10+$ymargin, $imageinfo[0]*$factor, $imageinfo[1]*$factor, $ext);
						if(substr($file, 0, 9)=="tempimage")
							@unlink($file);
					}
				}
			}
	  if($i==0) {
	  	  $pdf->SetFont('FreeSans','B',120);
	      $titlewidth=$pdf->GetStringWidth($_POST["title"]);
	      if($titlewidth>190)
	      	$pdf->SetFont('FreeSans','B',120/$titlewidth*170);
	  	  $pdf->SetTextColor(0,0,0);
	  	  $pdf->SetXY(10,203);
	  	  $pdf->Cell(190, 100, $_POST["title"], 0, 1,"C");
	  } else {
		  $pdf->SetFont('FreeSans','B',25);
		  $pdf->SetTextColor(0,0,0);
		  $pdf->SetXY(10,203);
		  $pdf->Cell(190, 20, $month[$i]." ".$year,0, 1,"C");

		  $pdf->SetFont('FreeSans','',10);
		  $pdf->SetXY(10,220);
		  $pdf->MultiCell(22, 3.5, $days[0], 0, "C");

		  for($day=1;$day<=7;$day++) {
			$pdf->SetXY(24+$day*22,220);
			$pdf->MultiCell(22, 3.5, $days[$day], 0, "C");
		  }
		  $pdf->SetFont('FreeSans','B',25);
		  $firstday = mktime(0, 0, 0, $i, 1, $year); // first day of the month
		  $week = date("W",$firstday); // current week
		  $lastday = date("t",$firstday); // how much days in this month
		  $weekday = date("w",$firstday); // day of the week
		  if($firstdayofweek==0 && $weekday==0) $week++; // the week number should be the same as in ISO 8601 even if the week begins with sundays.
		  $firstweek = $week;
		  if($weekday<$firstdayofweek) $weekday+=7;
		  for($day=1; $day<=$lastday; $day++) {
			if($weekday==$firstdayofweek || $day == 1) {
				$pdf->SetXY(10,230+($week-$firstweek)*10);
				$pdf->SetTextColor(128,128,128);
				$pdf->Cell(22, 15, "".$week*1, 0, 1, "R");
			}
			$pdf->SetXY(24+($weekday-$firstdayofweek+1)*22,230+($week-$firstweek)*10);
			if(in_array($day*100+$i,$holiday) || ($weekday == $markedweekday)) {
				$pdf->SetTextColor(255,0,0);
			} else if(in_array($day*100+$i,$holiday1)) {
				$pdf->SetTextColor(255,128,128);
			} else
				$pdf->SetTextColor(0,0,0);

			$pdf->Cell(22, 15, "".$day, 0, 1, "R");
			$weekday++;
			if($weekday==$firstdayofweek+7) $weekday=$firstdayofweek;
			if($weekday==$firstdayofweek || $weekday>$firstdayofweek+6) {
				$week++;
				if($i==12 && $day > 28-$firstdayofweek) {
					$firstweek = -$week+$firstweek+1;
					$week = 1;
				}
				$weekday==$firstdayofweek;
			}
		  }
	  }
	  $pdf->SetXY(10,287);
	  $pdf->SetTextColor(192,192,192);
	  $pdf->SetFont('FreeSans','B',5);
	  $pdf->Cell(190, 5, "generated by TFTgallery", 0, 1, "R", 0, "http://www.tftgallery.org/");
	}
	$pdf->Output("calendar".$year.".pdf","D");
} else {

	// to avoid malfunction because of unexpected direct call
	if(!defined("TFT_VERSION")) {
		include_once("404.php");
		exit();
	}

	if($cal_only_for_admin and empty($_SESSION['admin'])) {
		echo "You are not allowed to create a calendar!";
	} else {
		if(!empty($_REQUEST["album"])) {
			$album = iconv("UTF-8", $filename_encoding, $_REQUEST["album"]);
			$album = get_magic_quotes_gpc()==1 ? stripslashes($album) : $album;
			$album_path = $album=="" ? $album_directory : "$album_directory/$album";

			if(!checkAlbumParamter()) die("specified album directory is not valid!");

			$pwpath = "$album_directory/$album/passwd";
			if(file_exists($pwpath) && !(isset($_SESSION["pw".crc32($album)]) && ($_SESSION["pw".crc32($album)] == true))) {
				die("You are not allowed to get a PDF from ".$album);
			}

			$liste = getFilelist($album);
			if(count($liste)<1) die("no displayable image in the specified directory!");
		} elseif($_REQUEST['mode']=='cart' and is_array($_SESSION['cart'])) {
			$liste = $_SESSION['cart'];
			$album_path=$album_directory;
			$album = "";
		} else {
			die("no album directory specified");
		}
		if(file_exists("language/calendar.".$calendar_def_lang.".inc"))
			include_once "language/calendar.".$calendar_def_lang.".inc";
		else
			include_once "language/calendar.multilingual.inc";
		include_once "language/calendarlang.inc";
		echo "<h3>$txt_createcalendar</h3>";
		echo "<p>$txt_assoc_images</p>";
?>
<script language="JavaScript" type="text/javascript">
function TFTCalendarClickAt(nr) {
	document.imageselector[nr].checked=true;
}

function TFTCalendarAddPhotos() {
	imageurl = "";
	for(i=0;i<document.imageselector.image.length;i++) {
		if(document.imageselector.image[i].checked==true) {
			imageurl = document.imageselector.image[i].value;
			document.imageselector.image[i].checked = false;
		}
	}
	if(imageurl=="")
		return;
	//else
		//alert(imageurl);
	for(var eig in document.imageselector) {
		//alert(eig);
		if(eig.substr(0,5)=="sheet") {
			if(document.imageselector[eig].checked==true) {
				document.send[eig].value=imageurl;
				document.imageselector[eig].checked=false;
			}
		}
	}
	TFTCalendarShowPhotos();
}

function TFTCalendarRemovePhotos() {
	for(var eig in document.imageselector) {
		if(eig.substr(0,5)=="sheet") {
			if(document.imageselector[eig].checked==true) {
				document.send[eig].value='';
				document.imageselector[eig].checked=false;
			}
		}
	}
	TFTCalendarShowPhotos();
}

function TFTCalendarRemoveAllPhotos() {
	for(var eig in document.imageselector) {
		if(eig.substr(0,5)=="sheet") {
			document.send[eig].value='';
			document.imageselector[eig].checked=false;
		}
	}
	TFTCalendarShowPhotos();
}

function TFTCalendarShowPhotos() {
	for(var eig in document.send) {
		if((eig.substr(0,5)=="sheet")) {
			if(document.send[eig].value!="") {
				var innerImage = document.createElement("img");
				innerImage.className = "thumbnail";
				innerImage.src = "<?php echo $tft_subdir; ?>/image.php?scale=1&file="+document.send[eig].value;
				document.getElementById("info"+eig).style.display="inline";
				document.getElementById("info"+eig).title=document.send[eig].value;
				while(document.getElementById("thumb"+eig).firstChild != null) {
					document.getElementById("thumb"+eig).removeChild(document.getElementById("thumb"+eig).firstChild);
				}
				document.getElementById("thumb"+eig).appendChild(innerImage);
				document.getElementById("thumb"+eig).style.display="none";
				document.getElementById("thumb"+eig).style.position="absolute";
			} else {
				document.getElementById("info"+eig).style.display="none";
				document.getElementById("info"+eig).title="";
				document.getElementById("thumb"+eig).style.display="none";
			}
		}
	}
}

function TFTCalendarShowThumb(id,display) {
	document.getElementById(id).style.display = display;
}

function TFTCalendarScroll(direction) {
	document.getElementById('TFTCalenderPics').scrollTop = document.getElementById('TFTCalenderPics').scrollTop + direction*document.getElementById('TFTCalenderPics').clientHeight;
}
</script>
<?php
		echo "<form name='imageselector' class='thumbform'>";
		echo "<center><table border='0'><tr><td><div style='text-align:center; cursor:pointer;' onclick='TFTCalendarScroll(-1);'>&#x25b2;</div>";
		echo "<div id='TFTCalenderPics' style='width:".($thumb_width+70)."px; height:".($thumb_height+20)."px; overflow:hidden;'>";
		$i = 0;
		foreach($liste as $picture) {
			if (preg_match($pic_extentions,$picture)) {
				$url = makeURL("",array("showcart"=>"1","pic"=>"$album/$picture"));
				list($img_src,$new_x,$new_y,$old_x,$old_y,$is_picture,$is_icon) = makeScaledFileURL($album."/".$picture,1);
				$sizes = $new_x==0 ? "" : "width='$new_x' height='$new_y'";
				echo "<span style='display:block; width:".($thumb_width+70)."px; height:".($thumb_height+20)."px; overflow:hidden;'><input type=\"radio\" name=\"image\" value=\"".iconv($filename_encoding, "UTF-8", $album."/".$picture)."\" /> <img onclick='TFTCalendarClickAt($i);' class='thumbnail' style='vertical-align:middle;' src='$tft_subdir/$img_src' $sizes /></span>";
				$i++;
			}
		}
		echo "</div><div style='text-align:center;  cursor:pointer;' onclick='TFTCalendarScroll(+1);'>&#x25bc;</td>";
		echo "<td><table border='0'><tr>";
		foreach($month as $number=>$monthname) {
			echo "<td style='text-align:left;'><input class='checkbox' type=\"checkbox\" name=\"sheet".$number."\" value=\"chosen\" />$monthname";
			echo "<span id='infosheet$number' title='' style='display:none;' onmouseover='TFTCalendarShowThumb(\"thumbsheet$number\", \"block\");'  onmouseout='TFTCalendarShowThumb(\"thumbsheet$number\", \"none\");'> <img src='$tft_subdir/images/Info.gif' border='0' /></span>";
			echo "<span id='thumbsheet$number' style='display:none;'></span>";
			echo "</td>\n";
			echo (bcmod($number,3)==0 ? "</tr><tr>" : "");
		}
		echo "<td colspan='3'><input class='submit' type='button' value='$txt_cal_addphotos' onclick='TFTCalendarAddPhotos();' /> <input type='button' class='submit' value='$txt_cal_removephotos' onclick='TFTCalendarRemovePhotos();' /> <input class='submit' type='button' value='$txt_cal_removeallphotos' onclick='TFTCalendarRemoveAllPhotos();' /></td>";
		echo "</tr></table>";
		echo "</td></tr></table></center>";
		echo "</form>";
		echo "<form action=\"$tft_subdir/calendar.php\" class=\"thumbform\" name=\"send\" method=\"post\">\n";
		echo makeHiddenVars(array("showcalendar"=>"true"));
		if(isset($_REQUEST["album"])) {
			echo makeHiddenVars(array("album"=>$_REQUEST["album"]));
		}
		echo "<p>";
		foreach($month as $number=>$monthname) {
			echo "<input type='hidden' name='sheet$number' value='' />\n";
		}
		echo "</p>";
		echo "<p>$txt_cal_enteryear <input class='text' type=\"text\" size=\"10\" name=\"year\" value=\"";
		$today=getdate();
		$year=$today["year"];
		if($today["mon"]>8) $year++;
		echo $year."\" /></p>";
		echo "<p>$txt_cal_entertitle <input class='text' type=\"text\" size=\"30\" name=\"title\" value=\"";
		$today=getdate();
		$year=$today["year"];
		if($today["mon"]>8) $year++;
		echo $year."\" /></p>";
		echo "<p>$txt_cal_chooseregion <select name='calendarlanguage' size='1'>";
		$fd = opendir("language");
		while($file = readdir($fd)) {
			if(preg_match("/^calendar\.([a-z\-]+)\.inc$/i",$file,$matches) && is_file("language/$file")) {
				echo "\n<option value='".$matches[1]."'";
				$ulang_code = strtolower($matches[1]);
				if($ulang_code==$calendar_def_lang) echo " selected=\"selected\"";
				echo ">";
				echo isset($country[$ulang_code]) ? $country[$ulang_code] : $ulang_code;
				echo "</option>";
			}
		}
		closedir($fd);
		echo "</select></p>";

		echo "<input type=\"submit\" class=\"submit\" name=\"action\" value=\"$txt_createcalendar\" />";
		echo "</form>";
	}
}
?>
