<?php
// $Id: config.inc,v 1.61 2009/07/14 22:30:00 saschalorenz Exp $

// Directory which contains the albums and pictures.
$album_directory = "albums";

// Directory where thumbnails are created/cached
// (check if the script has write-permission to this!)
$data_directory = "data";

// Size of the thumbnails (maximum values)
$thumb_width = 180;
$thumb_height = 135;

// Quality of the jpegs created for thumbnails
$thumb_quality = 50;

// Size of the thumbnail-table
$rows_per_page = 2;
$pics_per_row = 4;

// Maximum sizes of the pictures
$max_picture_width = 850;
$max_picture_height = 480;

// Generate scaled version on server if original is this much greater
$max_picture_scaling = 1.5;

// Quality of the jpegs created for server scaled images
$server_scaled_quality = 50;

// Cache scaled version of pictures
$server_scaled_caching = true;

// Shorten thumbnail/scaled image filenames (true = thumbnail.jpg; false = thumbnail.jpg.jpg)
$use_short_names = true;

// Used unless the browser requests a supported language
$language = "en";

// Specify which style you want to use. Look at the styles subdirectory to see which files are available
$standard_style = "formnavi_cucumbercool.css";

// Specify if you want to use <table>-based layout. Default is true if you use MS Internet Explorer.
//$table_layout = preg_match("/[\(\; \t]MSIE[\)\; \t]/i",$_SERVER["HTTP_USER_AGENT"]);
$table_layout = false;

// Only show the files that match this regular expression.
$pic_extentions = "/\.(jpg|jpeg|gif|png)$/i"; 
// ones we can't generate thumbnails for
$other_extentions = "/\.(mov|wmv|avi|mpg|mpeg|asx|asf|mp4|mp3|wma|wav|ogg|ra|ram|mid|midi|tif|tiff|bmp)$/i";	
// Treat these files as annotations if they match another file
//$annotation_extentions = array('wav','mp3','txt','htm');
$annotation_extentions = false;

// Show filenames or descriptions under each thumbnail
//  0: Neither
//  1: filenames only
//  2: descriptions only
//  3: filenames and description both (on seperate lines)
//  4: descriptions if available filenames if not
$show_thumbnail_text = 1;
// no descriptions in the thumbnails any more because especially with large descriptions the design gets worse

// select which version of GD is enabled on your web server:
//  0: no GD at all; No thumbnails are created. You have to create them by yourself...
//  1: GD 1.x; Not so nice thumbnails (don't use this if you have GD 2.x, really ugly thumbs!)
//  2: GD 2.x; Nice looking thumbnails (default)
// 10: ImageMagick; $im_path must be set to full path of convert program like: $im_path = '/usr/bin/convert';
$gd_available = 2;
$im_path = "/usr/bin/convert";

// Define the logging-level. Valid values are:
// 0: disable logging
// 1: only log errors
// 2: log errors and warnings
// 3: verbose logging (recommended just for debugging)
$log_level = 0;

// default thumbnails if custom thumbnails can't be created
$thumb_map = array (
	'default'	=> 'images/default_unknown.gif',
	'/\.(jpg|jpeg|gif|png|bmp|tif|tiff)/i'	=> 'images/default_photo.gif',
	'/\.(mov|wmv|avi|mpg|mpeg|asf|asx|mp4)/i'	=> 'images/default_video.gif',
	'/\.(mp3|wma|wav|mp3|ogg|ra|ram|mid|midi)/i'	=> 'images/default_audio.gif',
);

// map to which icons to use for different annotation types
$annotation_icon_map = array (
	'default' => 'images/anno_default.gif',
	'/\.(mp3|wma|wav|mp3|ogg|ra|ram|mid|midi)/i' => 'images/anno_sound.gif',
	'/\.(txt|htm|html|doc)/i' => 'images/anno_text.gif'
);

// false = all users may create a PDF file
$pdf_only_for_admin = true;

$pdf_pics_per_row = 1;
$pdf_rows_per_page = 1;

// sets black background color
$pdf_slideshow = 1;

// resolution of the PDF file (72 dpi)
$pdf_pagex = 1600;
$pdf_pagey = 1200;

// true: small images are expanded to fit in the page
$pdf_expandimages = true;

// false: all users may create a ZIP file
$zip_only_for_admin = true;

// false: only the selected directory is zipped
$zip_include_subdirs = true;

// false: everyone can create carts
$cart_only_for_admin = false;

// false: everyone can create calendars
$cal_only_for_admin = true;

$searchengine = true;

// standard file permission value
// 0744 shouldn't be used really...the "7" gives a chance of being executed (a big no-no!)
$file_permissions = 0644; 
$subdir_permissions = 0755;

// sorting of navigation bar (0=no sorting, 1=by name asc, 2=by date asc, -1=by name desc, -2=by date desc;
$navsorting = 1;

// text shown below the thumbnails
// %DATE% is substituted with the current date using the PHP function date("Y-m-d")
// %MDATE% is substituted with the modification date using the PHP function date("Y-m-d")
// %MDATETIME% is substituted with the modification date using the PHP function date("Y-m-d H:i")
$thumbnail_text = "";

// text shown below the scaled images
$scaledpic_text = "";

// if the original picture should be displayed, leave "false". If the image should not be displayed
// (e. g. because the scaled images have a text underneath and the original images have not), set the 
// alternative URL here
$dontshoworigpic = false;

// here you see an example if you want to prevent users to see the original image file.
// dontshoworigpic = "javascript:alert(\"The gallery admin has forbidden to see the original picture!\");";

// sets language of administration area
$adminlangfile = "adminlang.en.inc";

// please specify the character set how the filenames are encoded 
$filename_encoding = "ISO-8859-1";

// please specify the character set how the URLs are encoded 
$URL_encoding = "ISO-8859-1";

// if album information should be cached to improve performance, set the seconds here, otherwise set 0
$album_cache = 300;

// TFTgallery navigation mode (1 = albums on the left side, 2 = albums with "pulldown" form field)
$tft_navigation = 2;

// TFTgallery title
$txt_title = "TFTgallery";

// TFTgallery welcome message
$txt_welcome_message = "Welcome to the TFTgallery Demo";

// TFTgallery session name
$sessionname = "TFTgalleryID";

// allow deep linking of images
$allowdeeplink = true;

// session save path
$sessionpath = "";

// standard album being displayed at startup
$standard_album = "";

// if no standard album is specified you can set the gallery behaviour:
// either show the welcome message or show all the albums
$show_welcome_message = true;

// enable EXIF data output
$exif = true;

// formats the %DATE% and %MDATE% variable
$date_format = "%Y-%m-%d";

// formats the %MDATETIME% variable
$date_time_format = "%Y-%m-%d %H:%M:%S";

$mediaplugin = true;

$show_number_of_images = true;

// only use lightbox2 when all scaled pictures have been created! Otherwise your gallery won't work!
$use_lightbox2 = false;

// sorting of images (0=no sorting, 1=by name asc, 2=by date asc, -1=by name desc, -2=by date desc;
$imgsorting = 1;

// automatic image rotation due to EXIF orientation tag
$autorotate = true;

// TFTgallery diashow
$diashow_only_for_admin = false;
$diashow_delay = 10000;

// Thumbnails maximum pages before/after current page
// 0 show all pages
$thumbnail_max_pages = 2;

$album_theme = "";

// original file output inside the 'more options' tab or not?
$originalFileInMoreOptionsTab = true;

// fudge factor, taken from http://us.php.net/manual/en/function.imagecreatefromjpeg.php comment by dmhouse at gmail dot com from 08-Aug-2007 10:37
// only change this value if images cannot be created because PHP gets out of memory. Use http://tftgallery.org/fudge.zip to get the right value for you.
$fudge_factor = 1.7;
?>