<?php
// $Id: exif.inc.php,v 1.5 2009/03/07 23:59:45 saschalorenz Exp $
function getEXIFLanguageInclude($language) {
	// setup browser requested language
	// default
	if(file_exists("exif.$language.inc")) {
		$lang_inc = "exif.$language.inc";
	} else {
		$lang_inc = "exif.en.inc";
	}
	// url over-ride
	if (isset($_REQUEST['lang']) && file_exists("language/exif.${_REQUEST['lang']}.inc")) {
		$lang_inc = "exif." . $_REQUEST['lang'] . ".inc";
	}
	// personal setting
	elseif (isset($_REQUEST['personal_language']) && file_exists("language/exif.${_REQUEST['personal_language']}.inc")) {
		$lang_inc = "exif.${_REQUEST['personal_language']}.inc";
	} 
	// browser setting
	elseif (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
		$requested_lang_inc = "exif." . substr($_SERVER['HTTP_ACCEPT_LANGUAGE'],0,2) . ".inc";
		if (file_exists("language/" . $requested_lang_inc)) {
			$lang_inc = $requested_lang_inc;
		}
	}
	return $lang_inc;
}

function show_exif_data($file) {
	global $language;
	if(!function_exists("exif_read_data"))
		return false;
	if(!file_exists($file))
		return false;
	$imagetype = exif_imagetype($file);
	if($imagetype!=2 && $imagetype!=7 && $imagetype!=8)
		return false;
	$exif = exif_read_data($file, 0, true);
	// if no EXIF data is found then display nothing
	if($exif===false)
		return false;
	if(!isset($exif["IFD0"]) || !isset($exif["EXIF"]))
		return false;

	include "language/".getEXIFLanguageInclude($language);

	$camera = (isset($exif["IFD0"]["Make"]) ? ($exif["IFD0"]["Make"]." &nbsp; ") : "");
	$camera .= (isset($exif["IFD0"]["Model"]) ? ($exif["IFD0"]["Model"]) : "");

	if(!isset($exif["IFD0"]["XResolution"]) || !isset($exif["IFD0"]["YResolution"]) || !isset($exif["IFD0"]["ResolutionUnit"])) {
		$resolution = $txt_exif_notavailable;
	} else {
		list($numerator, $denominator) = split("/", $exif["IFD0"]["XResolution"]);
		if($denominator!=0) {
			$resolution = round($numerator/$denominator)." x ";
		} else {
			$resolution = $exif["IFD0"]["XResolution"]." x ";
		}
		list($numerator, $denominator) = split("/", $exif["IFD0"]["YResolution"]);
		if($denominator!=0) {
			$resolution = round($numerator/$denominator)." ";
		} else {
			$resolution = $exif["IFD0"]["YResolution"]." ";
		}
		switch($exif["IFD0"]["ResolutionUnit"]) {
			case 2: $resolution .= "dpi";
				break;
			case 3: $resolution .= "dpcm";
				break;
			default: $resolution .= "dp?";
				break;
		}
	}

	if(!isset($exif["EXIF"]["ExposureTime"])) {
		$exp_time = $txt_exif_notavailable;
	} else {
		list($numerator, $denominator) = split("/", $exif["EXIF"]["ExposureTime"]);
		if($numerator!=0) {
			$exp_time = "1/".round($denominator/$numerator)." s";
		} else {
			$exp_time = $exif["EXIF"]["ExposureTime"]." s";
		}
	}

	if(!isset($exif["EXIF"]["ExposureProgram"])) {
		$exp_prog = $txt_exif_notavailable;
	} else {
		if(isset($txt_exif_exp_prog_values[$exif["EXIF"]["ExposureProgram"]])) {
			$exp_prog = $txt_exif_exp_prog_values[$exif["EXIF"]["ExposureProgram"]];
		} else {
			$exp_prog = $txt_exif_exp_prog_values[-1];
		}
	}

	if(!isset($exif["IFD0"]["Orientation"])) {
		$orientation = $txt_exif_notavailable;
	} else {
		if(isset($txt_exif_orient_values[$exif["IFD0"]["Orientation"]])) {
			$orientation = $txt_exif_orient_values[$exif["IFD0"]["Orientation"]];
		} else {
			$orientation = $txt_exif_orient_values[-1];
		}
	}

	if(!isset($exif["EXIF"]["DateTimeOriginal"])) {
		$date_taken = $txt_exif_notavailable;
	} else {
		list($year, $month, $day, $hour, $minute, $second) = split("[ :]", $exif["EXIF"]["DateTimeOriginal"]);
		$date_taken = strftime($date_format,mktime($hour, $minute, $second, $month, $day, $year));
	}

	if(!isset($exif["EXIF"]["ISOSpeedRatings"])) {
		$iso = $txt_exif_notavailable;
	} else {
		$iso = $exif["EXIF"]["ISOSpeedRatings"];
	}

	if(!isset($exif["EXIF"]["FocalLength"])) {
		$focal_length = $txt_exif_notavailable;
	} else {
		list($numerator, $denominator) = split("/", $exif["EXIF"]["FocalLength"]);
		if($denominator!=0) {
			$focal_length = round($numerator/$denominator,2)." mm";
		} else {
			$focal_length = $exif["EXIF"]["FocalLength"]." mm";
		}
	}

	if(!isset($exif["EXIF"]["FNumber"])) {
		$f_number = $txt_exif_notavailable;
	} else {
		list($numerator, $denominator) = split("/", $exif["EXIF"]["FNumber"]);
		if($denominator!=0) {
			$f_number = "f/".round($numerator/$denominator,2);
		} else {
			$f_number = "f/".$exif["EXIF"]["FNumber"];
		}
	}

	if(!isset($exif["EXIF"]["Flash"])) {
		$flash = $txt_exif_notavailable;
	} else {
		if(isset($txt_exif_flash_values[$exif["EXIF"]["Flash"]])) {
			$flash = $txt_exif_flash_values[$exif["EXIF"]["Flash"]];
		} else {
			$flash = $txt_exif_flash_values[-1];
		}
	}

	if(!isset($exif["EXIF"]["MeteringMode"])) {
		$metermode = $txt_exif_notavailable;
	} else {
		if(isset($txt_exif_meter_mode_value[$exif["EXIF"]["MeteringMode"]])) {
			$metermode = $txt_exif_meter_mode_value[$exif["EXIF"]["MeteringMode"]];
		} else {
			$metermode = $txt_exif_meter_mode_value[-1];
		}
	}

	if(!isset($exif["EXIF"]["DigitalZoomRatio"])) {
		$digzoom = $txt_exif_notavailable;
	} else {
		list($numerator, $denominator) = split("/", $exif["EXIF"]["DigitalZoomRatio"]);
		if($denominator!=0) {
			$digzoom = round($numerator/$denominator)."x";
		} else {
			$digzoom = $exif["EXIF"]["DigitalZoomRatio"]."x";
		}
	}

	if(!isset($exif["GPS"]) || 
		!isset($exif["GPS"]["GPSLatitudeRef"]) ||
		!isset($exif["GPS"]["GPSLongitudeRef"]) ||
		!isset($exif["GPS"]["GPSAltitudeRef"]) ||
		!isset($exif["GPS"]["GPSLatitude"]) ||
		!isset($exif["GPS"]["GPSLongitude"]) ||
		!isset($exif["GPS"]["GPSAltitude"])
	) {
		$gpsinfo = $txt_exif_notavailable;
		$gpsalt = $txt_exif_notavailable;
	} else {
		$signx = $exif["GPS"]["GPSLatitudeRef"]=="N" ? 1 : -1;
		list($numdegx, $denomdegx) = split("/", $exif["GPS"]["GPSLatitude"][0]);
		list($numminx, $denomminx) = split("/", $exif["GPS"]["GPSLatitude"][1]);
		list($numsecx, $denomsecx) = split("/", $exif["GPS"]["GPSLatitude"][2]);
		$signy = $exif["GPS"]["GPSLongitudeRef"]=="E" ? 1 : -1;
		list($numdegy, $denomdegy) = split("/", $exif["GPS"]["GPSLongitude"][0]);
		list($numminy, $denomminy) = split("/", $exif["GPS"]["GPSLongitude"][1]);
		list($numsecy, $denomsecy) = split("/", $exif["GPS"]["GPSLongitude"][2]);
		$signalt = ord($exif["GPS"]["GPSAltitudeRef"])==1 ? -1 : 1;
		list($numalt, $denomalt) = split("/", $exif["GPS"]["GPSAltitude"]);

		if($denomdegx * $denomminx * $denomsecx * $denomdegy * $denomminy * $denomsecy * $denomalt != 0) {
			$gpscoordx = $signx * round(($numdegx/$denomdegx) + ($numminx/$denomminx)/60 + ($numsecx/$denomsecx)/3600,5);
			$gpscoordy = $signy * round(($numdegy/$denomdegy) + ($numminy/$denomminy)/60 + ($numsecy/$denomsecy)/3600,5);
			$gpsaltitude = $signalt * round($numalt/$denomalt,5);
			$gpsinfo = $txt_exif_direction[$exif["GPS"]["GPSLatitudeRef"]]." ".($numdegx/$denomdegx)."° ".round($numminx/$denomminx + $numsecx/$denomsecx/60,3)."' ";
			$gpsinfo.= $txt_exif_direction[$exif["GPS"]["GPSLongitudeRef"]]." ".($numdegy/$denomdegy)."° ".round($numminy/$denomminy + $numsecy/$denomsecy/60,3)."' ";
			$gmlink = "http://maps.google.com/maps?q=".$exif["GPS"]["GPSLatitudeRef"]." ".($numdegx/$denomdegx)."° ".round($numminx/$denomminx + $numsecx/$denomsecx/60,3)." ".$exif["GPS"]["GPSLongitudeRef"]." ".($numdegy/$denomdegy)."° ".round($numminy/$denomminy + $numsecy/$denomsecy/60,3);
			$gpsinfo.= " <a href=\"$gmlink\" target=\"_blank\">$txt_exif_googlemaps</a>";
			$gpsalt = $gpsaltitude." m";
		} else {
			$gpsinfo = $txt_exif_notavailable;
			$gpsalt = $txt_exif_notavailable;
		}
	}

	$retval = "<table class='exif'>";
	//$retval.= "<caption class='exif'>$txt_exif_header</caption>";
	$retval.= "<tr class='exif'>";
	$retval.= "<td class='exif_key'>$txt_exif_camera</td>";
	$retval.= "<td colspan=\"5\" class='exif_value'>$camera</td></tr>\n";
	$retval.= "<tr class='exif'>";
	$retval.= "<td class='exif_key'>$txt_exif_date</td>";
	$retval.= "<td class='exif_value'>$date_taken</td>";
	$retval.= "<td class='exif_key'>$txt_exif_resolution</td>";
	$retval.= "<td class='exif_value'>$resolution</td>";
	$retval.= "<td class='exif_key'>$txt_exif_orientation</td>";
	$retval.= "<td class='exif_value'>$orientation</td></tr>\n";
	$retval.= "<tr class='exif'>";
	$retval.= "<td class='exif_key'>$txt_exif_exp_time</td>";
	$retval.= "<td class='exif_value'>$exp_time</td>";
	$retval.= "<td class='exif_key'>$txt_exif_exp_prog</td>";
	$retval.= "<td class='exif_value'>$exp_prog</td>";
	$retval.= "<td class='exif_key'>$txt_exif_iso</td>";
	$retval.= "<td class='exif_value'>$iso</td></tr>\n";
	$retval.= "<tr class='exif'>";
	$retval.= "<td class='exif_key'>$txt_exif_focal_length</td>";
	$retval.= "<td class='exif_value'>$focal_length</td>";
	$retval.= "<td class='exif_key'>$txt_exif_f_number</td>";
	$retval.= "<td class='exif_value'>$f_number</td>";
	$retval.= "<td class='exif_key'>$txt_exif_meter_mode</td>";
	$retval.= "<td class='exif_value'>$metermode</td></tr>\n";
	$retval.= "<tr class='exif'>";
	$retval.= "<td class='exif_key'>$txt_exif_flash</td>";
	$retval.= "<td colspan=\"3\" class='exif_value'>$flash</td>";
	$retval.= "<td class='exif_key'>$txt_exif_dig_zoom</td>";
	$retval.= "<td class='exif_value'>$digzoom</td></tr>\n";
	$retval.= "<tr class='exif'>";
	if(isset($exif["GPS"])) {
		$retval.= "<td class='exif_key'>$txt_exif_gps_pos</td>";
		$retval.= "<td colspan=\"3\" class='exif_value'>$gpsinfo</td>";
		$retval.= "<td class='exif_key'>$txt_exif_gps_alt</td>";
		$retval.= "<td class='exif_value'>$gpsalt</td></tr>\n";
	}
	$retval.= "</table>";
	return $retval;
}
?>