<?php
// $Id: functions.inc,v 1.105 2009/07/14 23:00:58 saschalorenz Exp $
/* Functions.inc: Includes all the functions needed by TFTGallery. The file is split up
 * in serveral sections (e.g. URL-handling, helper-functions, etc.)
 */

/* BEGIN SECTION: Constants
 *
 *	Define some constants.
 */

define ("TFT_VERSION", "0.13");
define ("TFT_INFO", 3);
define ("TFT_WARNING", 2);
define ("TFT_ERROR", 1);

/* END SECTION: Constants
 */

/* BEGIN SECTION: URL-handling
 *
 * Functions to make handling of URLs easier.
 */

// setGlobal(): promote a request variable to global scope
// $name: variable name
function setGlobal($name,$option = false) {
	global $filename_encoding;
	if (isset($_REQUEST[$name])) {
		$GLOBALS[$name] = iconv("UTF-8", $filename_encoding, $_REQUEST[$name]);
	} elseif ($option!==false && isset($_REQUEST[$option])) {
		$GLOBALS[$name] = iconv("UTF-8", $filename_encoding, $_REQUEST[$option]);
	}
	if(isset($GLOBALS[$name]) && get_magic_quotes_gpc()==1) {
		$GLOBALS[$name] = stripslashes($GLOBALS[$name]);
    }
}


// setupStickyURLOptions(): setup sticky options global variable
function setupStickyURLOptions() {
	global $sticky_options,$EmbeddedStickyUrlOptions;
	$sticky_options_match = '/^(lang|tl|style|debug'.$EmbeddedStickyUrlOptions.')$/i';
	$sticky_options = array();
	if (isset($_GET)) {
		foreach($_GET as $option => $value) {
			if (preg_match($sticky_options_match,$option)) {
				$sticky_options[$option] = $value;
			}
		}
	}
}


// setStickyOption(): set the value of a sticky option
// $option: option name
// $value: option value
function setStickyOption($option,$value = false) {
	global $sticky_options;
	$sticky_options[$option] = $value;
}


// unsetStickyOption(): clear the value of a sticky option
// $option: option name
function unsetStickyOption($option) {
	global $sticky_options;
	unset($sticky_options[$option]);
}


// makeURL(): properly format a url
// $page: base URL, may be a null string
// $option: [array] of option, keys are option name, values are option values
function makeURL($page,$params = array(),$no_sticky = false) {
	global $sticky_options,$filename_encoding;
	$url = "$page?";
	$first = true;
	// add all the params, encoded as needed
	foreach($params as $param => $value) {
		$url .= ($first ? "" : "&amp;") . "$param=" . rawurlencode(iconv($filename_encoding, "UTF-8", $value));
		$first = false;
	}
	// add any sticky options
	if (!$no_sticky and is_array($sticky_options)) {
		foreach($sticky_options as $option => $value) {
			if (!isset($params[$option])) {
				$url .= ($first ? "" : "&amp;") . "$option=" . rawurlencode($value);
				$first = false;
			}
		}
	}
	return $url;
}

// makeHiddenVars(): generate a string of hidden variables for user params and sticky options
// $params: [array] of option, keys are option name, values are option values
function makeHiddenVars($params = array(),$no_sticky = false) {
	global $sticky_options;
	$output = '';

	// add all the params, encoded as needed
	foreach($params as $param => $value) {
		$output .= "<input type=\"hidden\" name=\"$param\" value=\"$value\" />\n";
	}
	// add any sticky options
	if (!$no_sticky) {
		foreach($sticky_options as $option => $value) {
			if (!isset($params[$option])) {
				$output .= "<input type=\"hidden\" name=\"$option\" value=\"$value\" />\n";
			}
		}
	}
	return $output;
}

/* END SECTION: URL-handling
 */

/* BEGIN SECTION: Settings
 *
 * Functions to handle the settings of TFTGallery.
 */

// albumInclude(): detect and process album specific config files
// $album: relative album path
// doesn't work because variables are not global
function albumInclude($album) {
	if (file_exists(makeAlbumPath($album) . "/album.inc")) {
		include_once(makeAlbumPath($album) . "/album.inc");
	}
}

// albumStyleSheet(): detect album specific css stylesheet
// $album: relative album path
function albumStyleSheet($album) {
	global $album_directory;
	$sspath=$album."/album.css";
	if(file_exists($album_directory.($album=="" ? "" : "/").$sspath)) {
		return $sspath;
	}
	return false;
}

// getLanguageInclude(): returns the inc-file for the right language
// $language: the language requested by the browser
function getLanguageInclude($language) {
	// setup browser requested language
	// url over-ride
	if (isset($_REQUEST['lang']) && file_exists("language/strings.${_REQUEST['lang']}.inc")) {
		$lang_inc = $_REQUEST['lang'];
	}
	// personal setting
	elseif (isset($_REQUEST['personal_language']) && file_exists("language/strings.${_REQUEST['personal_language']}.inc")) {
		$lang_inc = $_REQUEST['personal_language'];
	}
	// browser setting
	elseif (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
		if(!isset($_SESSION["language_used"])) {
			$j = preg_match_all("/([A-Za-z]+)(\-[A-Za-z]+)?(;q=([0-9.]+))?/",$_SERVER['HTTP_ACCEPT_LANGUAGE'],$bla);
			$blubb = array();
			for($i=0;$i<$j;$i++) {
				$q = $bla[4][$i];
				if($q=="") $q = 1;
				$blubb[] = $bla[1][$i].$bla[2][$i];
				// if "en-us" is chosen, use "en", too
				if($bla[2][$i]!="")
					$blubb[] = $bla[1][$i];
			}
			// fallback if no language specified
			$blubb[] = $language;
			//krsort($blubb);
			foreach($blubb as $qty=>$langcode) {
				if(file_exists("language/strings.".$langcode.".inc")) {
					$lang_inc = $langcode;
					break;
				}
			}
			$_SESSION["language_used"] = $lang_inc;
		} else {
			$lang_inc = $_SESSION["language_used"];
		}
	} else
		// default
		$lang_inc = $language;

	return "strings.$lang_inc.inc";
}

// checkAlbumParamter(): verify that album param refers to a folder that exists
function checkAlbumParamter() {
	global $album_path;
	if(strpos("/".$album_path."/","/../")===false)
		return is_dir($album_path);
	else
		return false;
}
/* END SECTION: Settings
 */

/* BEGIN SECTION: File-handling
 *
 * Functions to work with files and directories
 */

// Function upload is called to upload a file upon near-perfect validation (added by raevin 09/02/2007, modified by saschalorenz 2007-09-03)
function fileupload($filearray, $dir, $replace) {
	global $filename_encoding, $pic_extentions, $other_extentions, $mimetypes, $admintext, $file_permissions;
	$tmp = $filearray['tmp_name'];
	$true = iconv("UTF-8", $filename_encoding, $filearray['name']);
	// Following if statement not really needed, but kept anyways (is good to have, to reduce work on server)
	if($tmp!="") {
		// Get mime type of image file with PHP's help
		$mtype = isset($filearray['type']) ? $filearray['type'] : "";
		// Got a mime type, was found in the mime type array (mimetypes.inc.php) ad we have an actual file
		if(empty($mtype) || ((!empty($mtype) && in_array($mtype, $mimetypes)))) {
			// protection for the vulnerability: http://xforce.iss.net/xforce/xfdb/30731
			// First lets handle image uploading (if getimagesize() fails, not a proper image)
			if((preg_match($pic_extentions,$true) && $imgsize=getimagesize($tmp)) || preg_match($other_extentions,$true)) {
				if(isset($imgsize)) {
					// IE MIME sniffing protection (enables cross site scripting attacks)
					// see http://www.h-online.com/security/Risky-MIME-sniffing-in-Internet-Explorer--/features/112589
					$valid_ext=image_type_to_extension($imgsize[2]);
					preg_match("/(.+)\.([^\.]+)$/",$true,$extension);
					if($valid_ext!==false && $extension[2]!==$valid_ext) {
						$true = $extension[1].$valid_ext;
					}
				}
				if(file_exists($dir.$true)) {
					switch($replace) {
					case 1: // replace -> nothing to be done
						break;
					case 2: // rename
						preg_match("/(.+)\.([^\.]+)$/",$true,$extension);
						for($appendix=1;$appendix<100;$appendix++) {
							$true = $extension[1]." (".$appendix.").".$extension[2];
							if(!file_exists($dir.$true)) break;
						}
						if($appendix == 100) // to avoid a replace every new file is refused
							$true = "";
						else
							printf($admintext[510]."<br />",$true);
						break;
					case 3: // ignore
						$true = "";
						break;
					}
				}
				if(($true != "") && (move_uploaded_file($tmp, $dir.$true))) {
					//chmod($dir.$true, 0444); // Don't let user choose permissions, make image read-only (modified by raevin 09/02/2007)
					chmod($dir.$true, $file_permissions); // yes but then the images can only be deleted using the "file viewer" (by saschalorenz 2007-09-03)
					echo $admintext[500]."<br />\n";
					printf($admintext[501]."<br />\n",$filearray['name']);
					printf($admintext[502]."<br /><br />",$filearray['size']);
				} else
					printf($admintext[503]." ".$admintext[511]."<br />",$filearray['name']);
			} else
				printf($admintext[503]." ".$admintext[512]."<br />",$filearray['name']);
		} else
			printf($admintext[503]." ".$admintext[513]." ".$mtype."<br />",$filearray['name']);
	}
}

// getPictureList() returns list of all files in a directory or virtual directory
// $album: relative path to album
function getPictureList($album){
	$dir = makeAlbumPath($album);
//echo "### $dir " . file_exists("$dir/virtual.txt") . "<br/>\n";
	if (file_exists("$dir/virtual.txt")) {
		$lines = file("$dir/virtual.txt");
		$list = array();
		foreach($lines as $line) {
			if (substr($line,0,1)=='#') {
				$voption = substr($line,1);
			} elseif (trim($line)!=="") {
				$line = trim($line);
				if (preg_match("/^-([^\-0-9]*)([0-9]+)([^\-0-9]+)-([^\-0-9]*)([0-9]+)([^\-0-9]*)$/",$line,$tag)) {
					$width = strlen($tag[2]);
					$prefix = $tag[1];
					$begin = 1 * $tag[2];
					$postfix = $tag[3];
					$end = 1 * $tag[5];
					//echo "width = $width<br/>\n";
					//echo "prefix = $prefix<br/>\n";
					//echo "postfix = $postfix<br/>\n";
					//echo "begin = $begin<br/>\n";
					//echo "end = $end<br/>\n";
					if ($begin!=0 && $end!=0 && $begin<$end) {
						for ($i = $begin; $i <= $end; $i++) {
							$num = "0000000000000000" . $i;
							$file = $prefix . substr($num,strlen($num)-$width) . $postfix;
							if (file_exists($file)) {
								$list[] = $file;
							}
						}
					}
				} else {
					$list[] = trim($line);
				}
			} else {
				$list[] = "zzzz";
			}
		}
		reset($list);
	} else if(isset($_SESSION["TFTalbums"])) {
		$elements = explode("/", $album);
		$folder = array_shift($elements);
		$folderlist = ($folder!='' ? $_SESSION["TFTalbums"][$folder] : array("subalbums" => $_SESSION["TFTalbums"]));
		$list = array();
		while(count($elements)>0) {
			$folder = array_shift($elements);
			if($folder != "") {
				$folderlist = $folderlist["subalbums"][$folder];
			}
		}
		if(isset($folderlist["subalbums"])) {
			foreach($folderlist["subalbums"] as $key=>$value) {
				if(isset($_SESSION['admin']) || (substr($key,0,1)!=".")) {
					$list[] = $key."/";
				}
			}
		}
		if(isset($folderlist["files"])) {
			foreach($folderlist["files"] as $key=>$value) {
				if(isset($_SESSION['admin']) || (substr($value,0,1)!=".")) {
					$list[] = $value;
				}
			}
		}
	} else {
		$list = getFilelist($album);
	}
	return $list;
}

function makeAlbumPath($album) {
	global $album_directory;
	return $album=="" ? $album_directory : "$album_directory/$album";
}

// getFilelist() returns list of all files (relative paths from $data_directory)in a directory
// $album: relative path to album directory
function getFilelist($album){
	global $pic_extentions, $other_extentions, $imgsorting;
	$dir = makeAlbumPath($album);
	$list = array();
//echo "'$dir'";
	$fd = opendir($dir);
	//$i = 0;
	while($file = readdir($fd)){
		// skip files and directories begining with .
		if(substr($file,0,1)=='.') {
			continue;
		}
		if(is_file("$dir/$file") && is_readable("$dir/$file") && (preg_match($pic_extentions,$file) || preg_match($other_extentions,$file))) {
			switch($imgsorting) {
				case 0: // no sorting
					$list[$file]="";
					break;
				case 1:
				case -1:	// name
					$list[$file]=$file;
					break;
				case 2:
				case -2: // date
					$list[$file]=filemtime("$dir/$file");
					break;
			}
			//$i++;
		} elseif(is_dir("$dir/$file") && @file_exists("$dir/$file/.")) { // subdirectory is readable and executable: http://de.php.net/manual/de/function.is-executable.php
			switch($imgsorting) {
				case 0: // no sorting
					$list[$file."/"]="";
					break;
				case 1:
				case -1:	// name
					$list[$file."/"]=$file;
					break;
				case 2:
				case -2: // date
					$list[$file."/"]=filemtime("$dir/$file");
					break;
			}
			//$i++;
		}
	}
	closedir($fd);
	if($imgsorting<0) arsort($list);
	if($imgsorting>0) asort($list);
	reset($list);
	return array_keys($list);
}

// makeDataPath($dest): create a data directory recursively
// $dest: destination directory
function makeDataPath($dest) {
	global $data_directory, $subdir_permissions;
	// create folders as needed
	$elements = explode("/", $dest);
	$cwd = getcwd();
	chdir($data_directory);
	foreach($elements as $subdir) {
		if($subdir=='') // double slashs for example
			continue;
		if(!file_exists($subdir))
			@mkdir($subdir, $subdir_permissions);
		@chmod($subdir, $subdir_permissions);
		chdir($subdir);
	}
	chdir($cwd);
}

// getThumbnailDescription($album,$pic): get any description
// $album: album
// $pic: picture
function getThumbnailDescription($album,$pic) {
	global $album_directory,$data_directory;
	$desc = "$album_directory/$album/$pic";
	if(file_exists("$desc.txt"))
		return nl2br(htmlentities(file_get_contents("$desc.txt")));
	elseif(file_exists("$desc.html"))
		return file_get_contents("$desc.html");
	elseif(file_exists("$data_directory/description/$album/$pic.txt"))
		return nl2br(htmlentities(file_get_contents("$data_directory/description/$album/$pic.txt")));
	elseif(file_exists("$data_directory/description/$album/$pic.html"))
		return file_get_contents("$data_directory/description/$album/$pic.html");
	else
		return '';
}

// showThumbnailDescription($description):
// $description: text
function showThumbnailDescription($description){
	if(!empty($description)) {
		echo "<div class='picture_description'>\n";
		echo $description;
		echo "</div>\n";
	}
}

// deleteThumbs(): recursively delete thumbnails from an album
// $flag: controls what to do: 0 means clear, 1 means optimize
// $album: the album to clear thumbs from
function deleteThumbs($flag=1, $type="thumbs",$album="",$recursive=true) {
	global $debug, $album_directory, $data_directory, $admintext, $filename_encoding;
	echo $admintext[206]." ".iconv($filename_encoding, "UTF-8", $album)."...<br>\n";
	$dir = $album=="" ? "$album_directory" : "$album_directory/$album";
	$picList = array();
	if ($flag!=0 && is_dir($dir) && ($handle = opendir($dir))!=FALSE) {
		while (false!==($name = readdir($handle))){
			if (is_file("$dir/$name")) {
				$tname = $name;
				$picList[$tname] = true;
			}
		}
		if ($debug) {
			echo "\n";
			print_r($picList);
			echo "\n";
		}
	}

	$dir = $album=="" ? "$data_directory/".$type : "$data_directory/".$type."/$album";
	if(is_dir($dir) && ($handle = opendir($dir))!==FALSE) {
		while (false!==($name = readdir($handle))) {
			if($name != "." && $name != "..") {
				if(is_dir("$dir/$name")) {
					if($recursive && strlen($album)<100)
						deleteThumbs($flag, $type, ($album=="" ? $name : "$album/$name"));
				} else {
					if($type=="thumbs") {
						$typelang=$admintext[28];
					} else {
						$typelang=$admintext[29];
					}
					// check if there is a picture for this thumbnail
					if($flag==0 || !isset($picList[$name])) {
						// no picture found, so delete the thumbnail
						echo "&nbsp;&nbsp;&nbsp;".$admintext[208]." ".iconv($filename_encoding, "UTF-8", $album."/".$name)." $typelang<br>\n";
						unlink("$dir/$name");
					}
					else{
						// Picture does exists, so keep if we are just optimizing
						echo "&nbsp;&nbsp;&nbsp;".$admintext[207]." ".iconv($filename_encoding, "UTF-8", $album."/".$name)." $typelang<br>\n";
					}
				}
			}
		}
		closedir($handle);
		if($debug)
			echo "\n".$admintext[206]." '$album' " . ($album!="" ? $admintext[208]." '$dir'\n" : "\n") ;
		if($album!="" && $recursive)
			@rmdir($dir);
	}
}

// setForceReload(): forces all instances of TFTgallery to reload the album list
function setForceReload() {
	global $data_directory,$file_permissions;
	$fp = fopen("$data_directory/forceReload","w");
	if($fp) {
		fclose($fp);
		chmod("$data_directory/forceReload",$file_permissions);
	}
	$_SESSION["TFTalbums-lastmod"] = 0;
}

function getForceReload() {
	global $data_directory;
	if(isset($_SESSION["TFTalbums-lastmod"]) && file_exists("$data_directory/forceReload") && (@filemtime("$data_directory/forceReload") > $_SESSION["TFTalbums-lastmod"])) {
		$_SESSION["TFTalbums-lastmod"] = 0;
	}
}

/* END SECTION: File-handling
 */

/* BEGIN SECTION: Server Scaling-functions
 *
 * Some small functions to do the dirty work...
 */


// validScaledFileExists(): determins if the picture already has an existing scaled
// $pic: relative path to picture
// $size: 1 - thumbnail, 2 - scaled
function validScaledFileExists($pic,$size = 1){
	global $album_directory, $gd_available;
	$scaled_time = 0;
	$scaled_file_path = getScaledFilePath($pic,$size);
	$pic_path = "$album_directory/$pic";
	@$scaled_time = filemtime($scaled_file_path);
	@$pic_time = filemtime($pic_path);
	// compare mod dates of picture and scaled
	// use out-of-date scaled file if GD is not available
	if (function_exists('logh')) {
		logh("Scaled_file: '$scaled_file_path' $scaled_time Pic: '$pic_path' $pic_time");
	}
	if ($scaled_time!==FALSE && (!$gd_available || $pic_time<$scaled_time)) {
		$result = true;
	} else {
		$result = false;
	}
	return $result;
}

// getScaledFilePath($pic): generate proper scaled file path
// $pic: relative path to picture
// $size: 1 - thumbnail, 2 - scaled
function getScaledFilePath($pic, $size = 1){
	global $data_directory, $use_short_names;
	$folder = $size==1 ? "thumbs" : "scaled";
	$ext = $use_short_names ? (preg_match("/\.(jpg|jpeg)/i",$pic) ? "" : ".jpg") : ".jpg";
	return "$data_directory/$folder/${pic}$ext";
}

// getPicturePath($pic): generate proper scaled file path
// $pic: path to picture relative to $album_directory
function getPicturePath($pic) {
	global $album_directory;
	return "$album_directory/$pic";
}

// scaleWidthHeight() scale width & heigh to fit in target width and height
// $width - original width
// $width - original height
// $target_x - target width
// $target_y - target height
function scaleWidthHeight($width,$height,$target_x,$target_y) {
	$new_width=$new_height=0;
	if ($width==0 || $height==0) {
		$new_width = $target_x;
		$new_height = $target_y;
	} elseif ($width<=$target_x && $height<=$target_y) {
		$new_width = $width;
		$new_height = $height;
	} elseif (($width / $height) > ($target_x / $target_y)){
		$new_width = $target_x;
		$new_height = ($target_x / $width) * $height;
	} else {
		$new_height = $target_y;
		$new_width = ($target_y / $height) * $width;
	}
	return array(round($new_width),round($new_height));
}

// makeScaledFileURL() makes URL to reference or create proper size image
// $pic: path to picture relative to $album_directory
// $size: 1 - thumbnail, 2 - scaled
// returns list($url,$new_width,$new_height,$old_width,$old_height,$is_picture,$is_icon)
function makeScaledFileURL($pic,$size) {
	global $max_picture_width, $max_picture_height, $max_picture_scaling, $thumb_width, $thumb_height, $thumb_map, $other_extentions, $pic_extentions, $gd_available, $scaledpic_text, $thumbnail_text, $URL_encoding, $filename_encoding, $autorotate;
	$pic_path = getPicturePath($pic);
	// assume using original
	$url = makeURL("image.php",array("file"=>$pic,"scale"=>$size));
	//$url = strtr(rawurlencode(iconv($filename_encoding, $URL_encoding, $pic_path)),array("%2F"=>"/"));
	if (!preg_match($pic_extentions,$pic)) {
		$is_icon = true;
		$is_picture = false;
		$url = "images/default_error.gif";
		if(preg_match($other_extentions,$pic)){
			$url = isset($thumb_map['default']) ? $thumb_map['default'] : "images/default_unknown.gif";
			foreach($thumb_map as $pat => $filename) {
				if (strpos($pat,"/")!==false && preg_match($pat,$pic)) {
					$url = "$filename";
					break;
				}
			}
		}
		$elements = getimagesize($url);
		$width = $x = $elements[0];
		$height = $y = $elements[1];
	} else {
		$is_icon = false;
		$is_picture = true;
		$scaled_path = getScaledFilePath($pic,$size);
		$elements = getimagesize($pic_path);
		if ($elements===false) {
			$no_size = true;
			$img_type = false;
			$x = $y = 0;
		} else {
			$no_size = false;
			$x = $elements[0];
			$y = $elements[1];
			$img_type = $elements[2]>=1 && $elements[1]<=3;
		}
		$width = $x;
		$height = $y;
		if ($size==1) {
			// too big?
			if ($no_size || !$img_type || $x>$thumb_width || $y>$thumb_height) {
				// use existing?
				if (validScaledFileExists($pic,$size)) {
					//$url = strtr(rawurlencode(iconv($filename_encoding, $URL_encoding, $scaled_path)),array("%2F"=>"/"));
					$url = makeURL("image.php",array("file"=>$pic,"scale"=>$size));
					list($width,$height,$yadyada) = getimagesize($scaled_path);
				}
				// generate
				elseif ($gd_available) {
					$url = makeURL("scaler.php",array("picture" => $pic, "size" => $size),true);
					if (!$no_size) {
						if($autorotate && function_exists("exif_read_data")) {
							$exif = @exif_read_data($pic_path, 0, true);
							if(($exif!==false) && isset($exif["IFD0"]) && isset($exif["IFD0"]["Orientation"])) {
								switch($exif["IFD0"]["Orientation"]) {
									case 6: // Rotate 90°
									case 8: // Rotate 270°
										$tmp = $x;
										$x = $y;
										$y = $tmp;
										break;
								}
							}
						}
						list($width,$height) = scaleWidthHeight($x,$y,$thumb_width,$thumb_height);
					}
				} else {
					// force client side scaling for thumbnails
					list($width,$height) = scaleWidthHeight($x,$y,$thumb_width,$thumb_height);
				}
			}
		} else {
			// too big?
			if ($no_size || !$img_type || $x*$y > $max_picture_width*$max_picture_height*$max_picture_scaling) {
				// use existing?
				if (validScaledFileExists($pic,$size)) {
					//$url = strtr(rawurlencode(iconv($filename_encoding, $URL_encoding, $scaled_path)),array("%2F"=>"/"));
					$url = makeURL("image.php",array("file"=>$pic,"scale"=>$size));
					list($width,$height,$yadyada) = getimagesize($scaled_path);
				}
				// generate
				elseif ($gd_available) {
					$url = makeURL("scaler.php",array("picture" => $pic, "size" => $size),true);
					if(!$no_size) {
						if($autorotate && function_exists("exif_read_data")) {
							$exif = @exif_read_data($pic_path, 0, true);
							if(($exif!==false) && isset($exif["IFD0"]) && isset($exif["IFD0"]["Orientation"])) {
								switch($exif["IFD0"]["Orientation"]) {
									case 6: // Rotate 90°
									case 8: // Rotate 270°
										$tmp = $x;
										$x = $y;
										$y = $tmp;
										break;
								}
							}
						}
						list($width,$height) = scaleWidthHeight($x,$y,$max_picture_width,$max_picture_height);
						// is image rotated? then rotate width/height
					}
				} else {
					// force client side scaling for thumbnails
					list($width,$height) = scaleWidthHeight($x,$y,$max_picture_width,$max_picture_height);
				}
			}
		}
	}
	return array($url,$width,$height,$x,$y,$is_picture,$is_icon);
}

/* END SECTION: Server Scaling
 */

/* BEGIN SECTION: Helper-functions
 *
 * Some small functions to do the dirty work...
 */

// reverse_strrchr(): returns the characters preceeding the last occurance of the needle
// $haystack: target
// $needle: search string
function reverse_strrchr($haystack, $needle) {
	$pos = strrpos($haystack, $needle);
	if($pos===false) {
		return $haystack;
	}
	return substr($haystack, 0, $pos + 1);
}

// d(): outout string if in debug mode
// $s string to output
function d($s) {
	global $debug;
	if ($debug) {
		echo $s . "<br/>\n";
	}
}

// setTextDefault():
// $name name of variable to set
// $value value to assign to variable with name $name
function setTextDefault($name,$value) {
	global $override_language;
	if(!isset($GLOBALS[$name]) or $override_language)
		$GLOBALS[$name] = $value;
}

// log2file(): log a message of specified priority to the log file
// $message message to log
// $priority priority of message
function log2File($message, $priority) {
	if($GLOBALS["log_level"] >= $priority){
		// compose the logstring:
		switch($priority){
			case TFT_ERROR:
				$logstring = "(EE) ";
				break;

			case TFT_WARNING:
				$logstring = "(WW) ";
				break;

			case TFT_INFO:
				$logstring = "(II) ";
				break;

			default:
				return;
		}
		$logstring = $logstring . date("d.m.Y/H:i:s") . " " . $message . "\r\n";

		if($fh = @fopen("gallery.log", "a"))
		{
			fwrite($fh, $logstring);
			fclose($fh);
		}

	}
}

// maskDescription($description): cuts dangerous HTML code out of the description
// $description: given description
// $output: clean description
function maskDescription($description) {
	return str_ireplace(array('</form','</input','</textarea','</script','</object','</embed'),'',
	str_ireplace(array('<form','<input','<textarea','<script','<object','<embed'),'',$description)
	);
}
/* END SECTION: Helper-functions
 */

/* BEGIN SECTION: scaler-functions
 *
 * scale images
 */

// createScaled($pic): creates a scaled for an specified image and saves it.
// $pic: path to the picture
// $output: send jpeg to output
function createScaled($pic,$size = 1,$output = true, $force=false) {
	global $gd_available, $data_directory, $album_directory, $thumb_width, $thumb_height, $max_picture_width, $max_picture_height, $max_picture_scaling, $subdir_permissions, $server_scaled_caching, $autorotate;
	$dest = getScaledFilePath($pic,$size);
	if (function_exists('logh')) {
		logh("Create destination: $dest");
	}

	if ($size==1) {
		$x = $thumb_width;
		$y = $thumb_height;
	} elseif ($size==2) {
		$x = $max_picture_width;
		$y = $max_picture_height;
	}
	// create folders as needed
	$elements = explode("/", $dest);
	$cwd = getcwd();
	chdir($data_directory);
	if($server_scaled_caching) {
		for($i = 1; $i < (count($elements) - 1); $i++){
			@mkdir($elements[$i], $subdir_permissions);
			@chmod($elements[$i], $subdir_permissions);
			chdir($elements[$i]);
		}
	}
	chdir($cwd);
	// calculate size of sized depending on _height/_width
	list($image_x, $image_y, $type, $attr) = getimagesize("$album_directory/$pic");
	if(($type < 1) || ($type > 3)) {
		if (function_exists('logh')) {
			logh("not a picture!");
		}
	return(false);
	}
	if (function_exists('logh')) {
		logh("Original size: $image_x by $image_y");
	}

	$degrees = 0;
	/* rotating images with EXIF orientation tag */
	if($autorotate && function_exists("exif_read_data")) {
		$exif = @exif_read_data("$album_directory/$pic", 0, true);
		if(($exif!==false) && isset($exif["IFD0"]) && isset($exif["IFD0"]["Orientation"])) {
			switch($exif["IFD0"]["Orientation"]) {
				case 3: // rotate 180°
					$degrees = 180;
					break;
				case 6: // Rotate 90°
					$degrees = 90;
					$tmp = $x;
					$x = $y;
					$y = $tmp;
					break;
				case 8: // Rotate 270°
					$degrees = -90;
					$tmp = $x;
					$x = $y;
					$y = $tmp;
					break;
				default: // unknown
					$degrees = 0;
					break;
			}
		}
	}
	/* end rotating */


	$factorx = $x / $image_x;
	$factory = $y / $image_y;
	$factor = ($factorx>$factory) ? $factory : $factorx;
	if($factor > $max_picture_scaling) $factor = $max_picture_scaling;
	$new_height = ceil($image_y * $factor);
	$new_width = ceil($image_x * $factor);

	if (function_exists('logh')) {
		logh("New size: $new_width by $new_height");
	}

	if ($gd_available>=1 && $gd_available<=9) {
		return(createScaled_GD($pic,$new_width,$new_height,$size,$degrees,$output,$force));
	} elseif ($gd_available==10) {
		return(createScaled_IM($pic,$new_width,$new_height,$size,$degrees,$output,$force));
	}
}

// createScaled($pic): creates a scaled for an specified image and saves it using ImageMagick.
// $pic: path to the picture
// $output: send jpeg to output
function createScaled_IM($pic,$new_width,$new_height,$size,$degrees,$output = true, $force=false){
	global $data_directory, $file_permissions, $album_directory, $im_path, $server_scaled_quality;
	$src = "$album_directory/$pic";
	$dest = getScaledFilePath($pic,$size);

	if (file_exists($dest))
	{
		if(filemtime($src) > filemtime($dest) or $force)
		{
			@unlink($dest);
		}
		else
		{
			return(false);
		}
	}

	$cmd = "$im_path " . escapeshellarg($src) . " -resize " . escapeshellarg("${new_width}x$new_height>") . ($degrees != 0 ? " -rotate ".escapeshellarg($degrees) : "") ." -strip ". escapeshellarg($dest);
	//echo $cmd;
	//header("X-TFT-Error-IM-Cmd: $cmd");
	// execute command, force stderr to stdout
	$out = `$cmd 2>&1`;

	if (trim($out)=='' || file_exists($dest)) {
		if (isset($file_permissions) && $file_permissions!='') chmod($dest,$file_permissions);
		if ($output) readfile($dest);
	} else {
		header("X-TFT-Error-IM: ImageMagick Error");
		log2file("ImageMagick Error: $out",TFT_ERROR);
		$lines = explode("\n",$out);
		for($i = 0; $i<count($lines); $i++) {
			header("X-TFT-Error-IM-Error-$i: " . trim($lines[$i]));
		}
		if ($output) readfile("images/default_error.gif");
	}
	return(true);
}

// createScaled($pic): creates a scaled for an specified image and saves it using GD.
// $pic: path to the picture
// $output: send jpeg to output
function createScaled_GD($pic,$new_width,$new_height,$size,$degrees,$output = true, $force=false){
	global $data_directory, $album_directory, $file_permissions, $gd_available, $server_scaled_quality, $thumb_quality, $server_scaled_caching, $scaledpic_text, $thumbnail_text, $date_format, $date_time_format;
	$src = "$album_directory/$pic";
	$dest = getScaledFilePath($pic,$size);

	if ($size==2) {
		$pictext = $scaledpic_text;
		$textsize = 2;
		$quality = $server_scaled_quality;
	} else {
		$pictext = $thumbnail_text;
		$textsize = 1;
		$quality = $thumb_quality;
	}

	if (file_exists($dest))
	{
		if(filemtime($src) > filemtime($dest) or $force)
		{
			@unlink($dest);
		}
		else
		{
			return(false);
		}
	}

	// Open the picture and get its size
	$imageinfo = GetImageSize($src);
	$error=false;
	$image=false;
	if(function_exists('memory_get_usage')) {
		$needed_mem = memory_get_usage()+(200*1024)+($imageinfo[0]*$imageinfo[1]*$fudge_factor*$imageinfo['channels']*$imageinfo['bits']/8)+($new_width*$new_height*$fudge_factor*3);
		if(return_bytes(ini_get('memory_limit')) < $needed_mem) {
			@ini_set('memory_limit', ceil($needed_mem/1048576)."M");
		}
		if(return_bytes(ini_get('memory_limit')) < $needed_mem) {
			$error = "Insufficient RAM to convert image!";
		}
	}

	if(! $error) {
		switch ($imageinfo[2]) {
			case 1: // GIF
				$image = @imagecreatefromgif($src);
				break;
			case 2: // JPEG
				$image = @imagecreatefromjpeg($src);
				break;
			case 3: // PNG
				$image = @imagecreatefrompng($src);
				break;
			default:
				$image = null;
				break;
		}
	}

	$image_x = $imageinfo[0];
	$image_y = $imageinfo[1];
	// create empty scaled and copy(resized) the picture

	if(!$error) {
		if(!$image)
			$error = "Image creating from source failed!";
		elseif($gd_available >= 2) {
			$scaled = @imagecreatetruecolor($new_width, $new_height);
			if(!$scaled) {
				$error="New image could not be created!";
			} else {
				$color_bg = imagecolorallocate($scaled,255,255,255);
				// using imagefill there there was an error using IIS
				if($color_bg != -1) imagefilledrectangle($scaled,0,0,$new_width, $new_height, $color_bg);
				if(imagecopyresampled($scaled, $image, 0, 0, 0, 0, $new_width, $new_height, $image_x, $image_y)==false) $error="Image could not be resampled!";
			}
		} else {
			$scaled = @imagecreate($new_width, $new_height);
			if(!$scaled) {
				$error="New image could not be created!";
			} else {
				$color_bg = imagecolorallocate($scaled,255,255,255);
				// using imagefill there there was an error using IIS
				if($color_bg != -1) imagefilledrectangle($scaled,0,0,$new_width, $new_height, $color_bg);
				if(imagecopyresized($scaled, $image, 0, 0, 0, 0, $new_width, $new_height, $image_x, $image_y)==false) $error="Image could not be resized!";
			}
		}
	}
	if($error) {
		if($textsize==1)
			$scaled=imagecreatetruecolor(180,30);
		else
			$scaled=imagecreatetruecolor(260,40);
		$pictext=="";
		$color_txt = imagecolorallocate($scaled,255,255,255);
		$color_bg = imagecolorallocate($scaled,128,0,0);
		imagefill($scaled,5,5,$color_bg);
		$quality = 100;
		$pictext = "";
		if($textsize==1) {
			imagestring ($scaled, 1, 5, 5, "Error while converting the image:", $color_txt);
			imagestring ($scaled, 1, 5, 15, $error, $color_txt);
		} else {
			imagestring ($scaled, 3, 5, 5, "Error while converting the image:", $color_txt);
			imagestring ($scaled, 3, 5, 20, $error, $color_txt);
		}
	}

	// delete original image
	if($image)
		imagedestroy($image);

	if($degrees!=0)
		$scaled = imagerotate($scaled, -$degrees, 0);

	if($degrees==90 || $degrees==-90) {
		$temp = $new_height;
		$new_height = $new_width;
		$new_width = $temp;
	}

	if($pictext!="") {
		$color_bg = imagecolorallocate($scaled,255,255,255);
		$color_txt = imagecolorallocate($scaled,0,0,0);
		$pictext=strtr($pictext, array(
			"%DATE%" => strftime($date_format),
			"%MDATE%" => strftime($date_format,filemtime($src)),
			"%MDATETIME%" => strftime($date_time_format,filemtime($src))
		));
		$pictext=iconv("UTF-8", "ISO-8859-2", $pictext);
/*		imagestring($scaled, $textsize, 4, $new_height-($textsize*8)-4, $pictext, $color_bg);
		imagestring($scaled, $textsize, 5, $new_height-($textsize*8)-4, $pictext, $color_bg);
		imagestring($scaled, $textsize, 4, $new_height-($textsize*8)-5, $pictext, $color_bg);
		imagestring($scaled, $textsize, 6, $new_height-($textsize*8)-5, $pictext, $color_bg);
		imagestring($scaled, $textsize, 5, $new_height-($textsize*8)-6, $pictext, $color_bg);
		imagestring($scaled, $textsize, 6, $new_height-($textsize*8)-6, $pictext, $color_bg);
		imagestring($scaled, $textsize, 4, $new_height-($textsize*8)-6, $pictext, $color_bg);
*/		imagestring($scaled, $textsize, 6, $new_height-($textsize*8)-4, $pictext, $color_bg);
		imagestring($scaled, $textsize, 5, $new_height-($textsize*8)-5, $pictext, $color_txt);
	}

	if ($server_scaled_caching) {
		// save the scaled file
		if(function_exists('logh')) logh("save image with $quality % to file $dest");
		imagejpeg($scaled, $dest, $quality);
		if (isset($file_permissions) && $file_permissions!='')
			chmod($dest,$file_permissions);
		// if ($output) readfile($dest);
	}
	if ($output) {
		if(function_exists('logh')) logh("output");
		imagejpeg($scaled);
	}
	imagedestroy($scaled);

	return(true);
}

/* END SECTION: scaler-functions
 */


/* BEGIN SECTION: album-list-functions
 *
 * build album lists for navigaion
 */

// navAlbumsSelectField(): show albums in a select field
// $album_array: Array of album data from getAlbums()
// $level: used to display increasing indentation on recursive calls
function navAlbumsSelectField($album_array, $parent_album='', $level=0) {
	global $tft_subdir, $_SESSION, $album, $filename_encoding, $show_number_of_images;
	$numberentries = 0;
	foreach($album_array as $album_name=>$album_info) {
		$album_dir=(empty($parent_album)? $album_name : $parent_album.'/'.$album_name);
		/* added by saschalorenz 2006-10-19 */
		if(isset($_SESSION['admin']) || (substr($album_name,0,1)!=".")) {
			/* added by saschalorenz 2005-03-14 */
			$numberentries+=1;
			echo "<option value=\"".iconv($filename_encoding, "UTF-8", $album_dir)."\"";
			if($album == $album_dir) echo " selected=\"selected\"";
			if($show_number_of_images && isset($album_info['files']) && count($album_info['files'])>0) {
				echo ">".str_repeat('&nbsp;', $level*3).iconv($filename_encoding, "UTF-8", $album_name)." (".count($album_info['files']).")</option>\n";
			} else {
				echo ">".str_repeat('&nbsp;', $level*3).iconv($filename_encoding, "UTF-8", $album_name)."</option>\n";
			}
			if(isset($album_info['subalbums']) and count($album_info['subalbums'])>0) {
				// call function again for subdirectory (recursive!), increasing the level
				navAlbumsSelectField($album_info['subalbums'], $album_dir, $level+1);
			}
		} // check if . or admin
	} // foreach()
}

// navAlbums(): show albums to build the navi-bar
// $album_array: Array of album data from getAlbums()
// $level: used to display increasing indentation on recursive calls
function navAlbums($album_array, $parent_album='', $level=0) {
	global $pdf_only_for_admin, $zip_only_for_admin, $tft_subdir, $_SESSION, $filename_encoding, $show_number_of_images;
	/*
	if(isset($_SESSION['admin'])) {
		$pdf = true;
		$zip = true;
	} else {
		$pdf = !($pdf_only_for_admin);
		$zip = !($zip_only_for_admin);
	}
	*/

	/* added by saschalorenz 2005-03-14 */
	$numberentries = 0;

	foreach($album_array as $album_name=>$album_info) {
		$album_dir=(empty($parent_album)? $album_name : $parent_album.'/'.$album_name);
		/* added by saschalorenz 2006-10-19 */
		if(isset($_SESSION['admin']) || (substr($album_name,0,1)!=".")) {
			$url = makeURL("",array("album"=>$album_dir,"page"=>"1"));
			/* added by saschalorenz 2005-03-14 */
			$numberentries+=1;
			if($numberentries == 1) echo "\n<ul class=\"navi\">\n";
			if($show_number_of_images && isset($album_info['files']) && count($album_info['files'])>0) {
				echo "<li class='navi'><a href='$url'>".iconv($filename_encoding,"UTF-8",$album_name)."</a> (".count($album_info['files']).") ";
			} else {
				echo "<li class='navi'><a href='$url'>".iconv($filename_encoding, "UTF-8", $album_name)."</a>";
			}

			if(isset($album_info['subalbums']) and count($album_info['subalbums'])>0) {
				// call function again for subdirectory (recursive!), increasing the level
				navAlbums($album_info['subalbums'], $album_dir, $level+1);
			}
			echo "</li>\n";
		} // check if . or admin
	} // foreach()
	if($numberentries>0) echo "</ul>\n";
}


// adminCacheAlbums(): show albums to build the navi-bar
// $album_array: Array of album data from getAlbums()
// $level: used to display increasing indentation on recursive calls
function adminCacheAlbums($album_array, $parent_album='', $level=0)
{
	global $data_directory,$admintext,$tft_subdir,$filename_encoding;
	echo "<ul class='navi'>";
	foreach($album_array as $album=>$album_info)
	{
		$album_dir=(empty($parent_album)? $album: $parent_album.'/'.$album);
		$url = makeURL('',array('album'=>$album_dir,'action'=>'cache_admin','action2'=>'build_cache'));
		if(isset($album_info['files']) and count($album_info['files'])>0) {
			$thumb_count=dirCountFiles('../'.$data_directory.'/thumbs/'.$album_dir);
			$scaled_count=dirCountFiles('../'.$data_directory.'/scaled/'.$album_dir);
			echo "<li class='navi'><a href='$url'>".iconv($filename_encoding, "UTF-8", $album)."</a> ";
			echo "(".count($album_info['files'])." ".$admintext[24].", $thumb_count ".$admintext[25].", $scaled_count ".$admintext[26].")\n";
		} else {
			echo "<li class='navi'><a href='$url'>".iconv($filename_encoding, "UTF-8", $album)."</a>\n";
		}

		if(isset($album_info['subalbums']) and count($album_info['subalbums'])>0) {
			// call function again for subdirectory (recursive!), increasing the level
			adminCacheAlbums($album_info['subalbums'], $album_dir, $level+1);
		}
		echo "</li>";
	}
	echo "</ul>";
}

// dirCountFiles(): count the files in a directory
// $dir: directory to count
function dirCountFiles($dir) {
	return(count(getFiles($dir)));
}

// getFiles(): get the files in a directory
// $dir: directory to get files for
function getFiles($dir)
{
	global $pic_extentions, $other_extentions;
	$file_list=array();

	if(is_dir($dir) and $fd = opendir($dir))
	{
		while($file = readdir($fd))
		{
			if(is_file("$dir/$file") && (preg_match($pic_extentions,$file) || preg_match($other_extentions,$file)))
			{
				$file_list[]="$dir/$file";
			}
		}
		closedir($fd);
	}

	return($file_list);
}

// getAlbums(): build album array to display navi-bar
// $album: begining album directory
function getAlbums($album = false){
	global $album_directory, $navsorting, $imgsorting, $pic_extentions, $other_extentions;
	$file_count=0;
	$dir = $album===false ? $album_directory : "$album_directory/$album";

	$files=array();
	$albums=array();
	$subalbums=array();
	$fd = opendir($dir);
	while($file = readdir($fd)) {
		if($file != "." && $file != ".." && $file != "CVS") {
			if(is_dir("$dir/$file") && @file_exists("$dir/$file/.")) {
				// call function again for subdirectory (recursive!)
				$subalbums[$file]=getAlbums($album===false ? "$file" : "$album/$file");
				switch($navsorting) {
					case 0: // no sorting
						$albums[$file]="";
						break;
					case 1:
					case -1:	// name
						$albums[$file]=$file;
						break;
					case 2:
					case -2: // date
						$albums[$file]=filemtime("$dir/$file");
						break;
				}
			} elseif(is_file("$dir/$file") && is_readable("$dir/$file") && (preg_match($pic_extentions,$file) || preg_match($other_extentions,$file))) {
				switch($imgsorting) {
					case 0: // no sorting
						$files[$file]="";
						break;
					case 1:
					case -1:	// name
						//$files[$file]=$file;
						$files[$file]=mb_strtolower($file);
						break;
					case 2:
					case -2: // date
						$files[$file]=filemtime("$dir/$file");
						break;
				}
			}
		}
	}
	closedir($fd);
	if($navsorting<0) arsort($albums);
	if($navsorting>0) asort($albums);
	if($imgsorting<0) arsort($files);
	if($imgsorting>0) asort($files);
	reset($albums);
	reset($files);
	foreach($albums as $option => $value) {
		$albums[$option] = $subalbums[$option];
	}
	if($album===false) {
		return($albums);
	}
	$out=array();
	if(isset($albums) and count($albums) > 0)
		$out['subalbums']=$albums;
	if(isset($files) and count($files) > 0)
		$out['files']=array_keys($files);
	return($out);

	// if(is_array($albums) and count($albums)>0)
		// return($albums);
	// else
		// return($file_count);
}

/* END SECTION: album-list-functions
 */

// used to get the real memory limit
function return_bytes($val) {
	$val = trim($val);
	$last = strtolower($val{strlen($val)-1});
	switch($last) {
		// The 'G' modifier is available since PHP 5.1.0
		case 'g':
			$val *= 1024;
		case 'm':
			$val *= 1024;
		case 'k':
			$val *= 1024;
	}
	return $val;
}

/* BEGIN SECTION: compatibility-functions
 *
 *	some functions to grant a higher compatibility level
 */

if(!function_exists("bcmod")) {
	function bcmod($a,$b) {
		return (($a*$b >= 0) ? ($b == 0 ? (0 / 0) : $a - floor($a/$b)*$b) : ($a < 0 ? $a - ceil($a/$b)*abs($b) : $a + ceil($a/$b)*abs($b)));
	}
}

if(!function_exists("sha1") && function_exists("mhash")) {
	function sha1($a) {
		return bin2hex(mhash(MHASH_SHA1,$a));
	}
}

if(!function_exists("imagerotate")) {
	// debian (+ ubuntu...) linux doesn't have an built-in imagerotate() so this is defined here
	function imagerotate($src_img, $angle, $bgcolor = 0) {
		$src_x = imagesx($src_img);
		$src_y = imagesy($src_img);
		if ($angle == 180) {
			$dest_x = $src_x;
			$dest_y = $src_y;
		} elseif (($angle == 90) || ($angle == -90)) {
			$dest_x = $src_y;
			$dest_y = $src_x;
		} else {
			return $src_img;
		}
		$rotate=imagecreatetruecolor($dest_x,$dest_y);
		imagealphablending($rotate, false);
		switch ($angle) {
			case -90:
				$dest_x--;
				for ($y = 0; $y < $src_y; $y++)
					for ($x = 0; $x < $src_x; $x++)
						imagesetpixel($rotate, $dest_x - $y, $x, imagecolorat($src_img, $x, $y));
				break;
			case 90:
				$dest_y--;
				for ($y = 0; $y < $src_y; $y++)
					for ($x = 0; $x < $src_x; $x++)
						imagesetpixel($rotate, $y, $dest_y - $x, imagecolorat($src_img, $x, $y));
				break;
			case 180:
				$dest_x--;
				$dest_y--;
				for ($y = 0; $y < $src_y; $y++)
					for ($x = 0; $x < $src_x; $x++)
						imagesetpixel($rotate, $dest_x - $x, $dest_y - $y, imagecolorat($src_img, $x, $y));
				break;
		}
		return $rotate;
	}
}

if (!function_exists('image_type_to_extension')) {
	function image_type_to_extension($type) {
		$e = array(1 => 'gif', 'jpeg', 'png', 'swf', 'psd', 'bmp', 'tiff', 'tiff', 'jpc', 'jp2', 'jpf', 'jb2', 'swc', 'aiff', 'wbmp', 'xbm', 'ico');
		if(isset($e[$type]))
			return '.'.$e[$type];
		else
			return false;
	}
}

if (!defined('FILE_USE_INCLUDE_PATH')) {
	define('FILE_USE_INCLUDE_PATH', 1);
}

if (!defined('FILE_APPEND')) {
	define('FILE_APPEND', 8);
}

/* END SECTION:   compatibility-functions
 */
?>