<?php
// $Id: gallery.php,v 1.31 2009/07/14 22:30:00 saschalorenz Exp $
$time_start = microtime(true);

// to avoid malfunction because of unexpected direct call
if(!isset($tft_subdir)) $tft_subdir = ".";
if(!isset($EmbeddedStickyUrlOptions)) $EmbeddedStickyUrlOptions = "";
if(!isset($showhtmlheader)) $showhtmlheader = true;

if(!is_dir($tft_subdir)) {
	include_once("404.php");
	exit();
}

chdir($tft_subdir);

$debug = isset($_REQUEST['debug']) ? 1 : 0;

include_once "config.inc";
if (file_exists("local_config.inc")) include_once "local_config.inc";
include_once "functions.inc";

if(isset($sessionpath) && ($sessionpath != "")) session_save_path($sessionpath);
if(isset($sessionname) && ($sessionname != "")) session_name($sessionname);
if (!headers_sent()) @session_start();

if (!isset($_SESSION["isinstalled"]) || ($_SESSION["isinstalled"]!=true)) {
	if(!file_exists("$data_directory/installed") && file_exists("install.php")) {
		include_once "install.php";
		exit;
	} else {
		$_SESSION["isinstalled"]=true;
	}
}

// plugin support
$use_plugins = $mediaplugin;
if(isset($_COOKIE["noplugins"]) && ($_COOKIE["noplugins"]=="true"))
	$use_plugins = false;


if(isset($_REQUEST['album'])) {
	if (file_exists(makeAlbumPath(iconv("UTF-8", $filename_encoding, $_REQUEST['album'])) . "/album.inc")) {
		include_once(makeAlbumPath(iconv("UTF-8", $filename_encoding, $_REQUEST['album'])) . "/album.inc");
	}
}

include_once "language/".getLanguageInclude($language);

// display GD error, help folks with lame hosting companies or misconfigured
// servers and prevents an ugly display of errors
if (!function_exists('imagejpeg') && $gd_available>=1 && $gd_available<=9) {
	echo "<div style='color: #A00000; border: 4 dashed red; padding: 10pt;'>".$txt_gd_warning."</div>";
	log2File("GD not installed, set gd_available to 0 to prevent this errormessage.", TFT_ERROR);
	exit;
}

setupStickyURLOptions();
setGlobal("album");
setGlobal("page");
setGlobal("pic");
setGlobal("thumb");
setGlobal("table_layout","tl");

if(!isset($album)) {
	if(($standard_album!="") && is_dir("$album_directory/".iconv("UTF-8", $filename_encoding, "$standard_album"))) {
		//In the case that the album is not set we have two options:
		//One: Check if the user want to show a default album and if exists
		//In other case: Just show a welcome message
		$album = iconv("UTF-8", $filename_encoding, "$standard_album");
	} else {
		$album = "";
	}
}
if(!isset($page)) $page=1;

$album = preg_replace("/(\/)+$/","",$album);
$album_path = $album=="" ? $album_directory : "$album_directory/$album";

// Set a standard album to start from, if none has been
// passed over as an URL-parameter

$tft_wintitle = $GLOBALS['txt_title'];

//check the parameters:
if(!checkAlbumParamter()) {
	$ip = getenv("REMOTE_ADDR");
	$forbidden_folder = $album;
	log2File("IP $ip trying to access forbidden folder $forbidden_folder. Exiting...", TFT_ERROR);
	header("HTTP/1.0 403 Forbidden");
	echo "<b>ACCESS DENIED!</b> <br/>$ip trying to access folder $forbidden_folder.";
	exit();
} elseif($album != '') {
	$tft_wintitle = preg_replace("/^(.*\/)+/","",$album)." &bull; ".$tft_wintitle;
}

if(isset($pic) && !empty($pic)) {
	if(strpos("/".$pic."/","/../")!==false || !file_exists($album_path."/".$pic)) {
		$ip = getenv("REMOTE_ADDR");
		$forbidden_folder = $album."/".$pic;
		log2File("IP $ip trying to access forbidden file $forbidden_folder. Exiting...", TFT_ERROR);
		header("HTTP/1.0 403 Forbidden");
		echo "<b>ACCESS DENIED!</b> <br/>$ip trying to access file $forbidden_folder.";
		exit();
	} else {
		$tft_wintitle = $pic." : ".$tft_wintitle;
	}
}

$tft_wintitle = iconv($filename_encoding, "UTF-8", $tft_wintitle);

if(!empty($_POST)) {
	if($_POST["action"]=="set password") {
		$pwpath = "$album_directory/$album/passwd";
		$fd = fopen($pwpath, "r");
		$givenpw = fgets($fd,15);
		fclose($fd);
		if($givenpw == crypt($_POST['tft_pwd'],"tftgallery")) {
			$_SESSION["pw".crc32($album)] = true;
		}
	}
}

if($showhtmlheader) {
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title><?php echo $tft_wintitle; ?></title>
<meta name="generator" content="TFTgallery <?php echo TFT_VERSION; ?> http://www.tftgallery.org/" />
<?php
if($searchengine)
	echo "<meta name='robots' content='index, follow' />\n";
else
	echo "<meta name='robots' content='noindex, nofollow' />\n";

if ($debug) {
	echo "<!"."-- style references -->\n";
	echo "<!"."-- tried %_REQUEST['style'] styles/${_REQUEST['style']} '" . isset($_REQUEST['style']) . ":" . file_exists("styles/${_REQUEST['style']}") . "' -->\n";
	echo "<!"."-- tried %{_COOKIE['personal_style'] styles/${_COOKIE['personal_style']} '" . isset($_COOKIE['personal_style']) . ":" . file_exists("styles/${_COOKIE['personal_style']}") . "' -->\n";
	echo "<!"."-- tried %GLOBALS['standard_style'] styles/${GLOBALS['standard_style']} '" . isset($GLOBALS['standard_style']) . ":" . file_exists("styles/${GLOBALS['standard_style']}") . "' -->\n";
	echo "<!"."-- tried %styles/default.css styles/default.css '" . file_exists("styles/default.css") . "' -->\n";
}

// URL override
if (isset($_REQUEST['style']) && file_exists("styles/${_REQUEST['style']}")) {
	if ($debug) echo "<!"."-- 1 TRUE tried styles/${_REQUEST['style']} -->\n";
	$style_sheet = $_REQUEST['style'];
}
// personal setting
elseif (isset($_COOKIE['personal_style']) && file_exists("styles/${_COOKIE['personal_style']}")) {
	if ($debug) echo "<!"."-- 2 TRUE tried styles/${_COOKIE['personal_style']} -->\n";
	$style_sheet = $_COOKIE['personal_style'];
}
// web site setting
elseif (isset($GLOBALS['standard_style']) && file_exists("styles/${GLOBALS['standard_style']}")) {
	if ($debug) echo "<!"."-- 3 TRUE tried styles/${GLOBALS['standard_style']} -->\n";
	$style_sheet = $GLOBALS['standard_style'];
}
// default
elseif (file_exists("styles/default.css")) {
	if ($debug) echo "<!"."-- 4 TRUE tried styles/default.css " . file_exists("styles/default.css") . " -->\n";
	$style_sheet = "default.css";
} else {
	echo "<style>\n";
	echo ".body { background-color: #e0e0e0; } \n";
	echo ".title, .naviarea, .mainarea, .location, .footer { margin: 3px; padding: 10px; border: 2px solid black; vertical-align: top; background-color: #b0b0b0;} \n";
	echo "div.naviarea { padding-left: 2px; float: left; width: 250px; } \n";
	echo "div.mainarea{ margin-left: 270px; text-align: center;} \n";
	echo "td.naviarea{ width: 1%; padding: 10px; vertical-align: top; white-space: nowrap; max-width: 250px; } \n";
	echo "td.mainarea{ width: 99%; vertical-align: top; text-align: center;} \n";
	echo "</style>\n";
}

d("Style: '$style_sheet'");

// selected style sheet
if (isset($style_sheet)) {
	echo "<link rel='stylesheet' type='text/css' href='$tft_subdir/styles/$style_sheet' />\n";
}
// styles specific override
if (file_exists("styles/local.css")) {
	echo "<link rel='stylesheet' type='text/css' href='$tft_subdir/styles/local.css' />\n";
}
// folder specific overides for styles
if (file_exists("styles/local_$style_sheet")) {
	echo "<link rel='stylesheet' type='text/css' href='$tft_subdir/styles/local_$style_sheet' />\n";
}
// individual album theme
if ($album_theme != "") {
	echo "<link rel='stylesheet' type='text/css' href='".$tft_subdir."/themes/".$album_theme."/style.css' />\n";
}
// individual album stylesheet
if (isset($_REQUEST['album']) && false!==($folder_css = albumStyleSheet($album))) {
	echo "<link rel='stylesheet' type='text/css' href='".$tft_subdir."/".makeURL("image.php",array("file"=>$folder_css,"scale"=>"4"))."' />\n";
}

/* change navigation when wrong style sheet is used */
if(preg_match("/^leftnavi_(.*)\.css$/i",$style_sheet))
	$tft_navigation = 1;
else if(preg_match("/^formnavi_(.*)\.css$/i",$style_sheet))
	$tft_navigation = 2;

if($use_lightbox2) {
?>
<link rel="stylesheet" href="lightbox2/css/lightbox.css" type="text/css" media="screen" />
<script type="text/javascript">
var lightboxsubdir = "";
</script>
<script src="lightbox2/js/prototype.js" type="text/javascript"></script>
<script src="lightbox2/js/scriptaculous.js?load=effects,builder" type="text/javascript"></script>
<script src="lightbox2/js/lightbox.js" type="text/javascript"></script>
<?php
}
?>
</head>
<body class="body">
<?php
} // $showhtmlheader

//if($debug) print_r($_COOKIE);
?>
<div class="title">
	<?php
		echo "$txt_title\n";
	?>
</div>

<div class="location">
	<?php
		require "location.php";
	?>
</div>

<?php
if($tft_navigation==1 && $table_layout) {
	$textbefore = "<table class='maintable'><tr>\n<td class='naviarea'>\n";
	$textbetween = "</td>\n<td class='mainarea'>\n";
	$textafter = "</td>\n</tr></table>\n";
} else {
	$textbefore = "<div class='leftarea'>\n<div class='naviarea'>\n";
	$textbetween = "</div>\n</div>\n<div class='mainarea'>\n";
	$textafter = "</div>\n";
}

echo $textbefore;
require "navigation.php";
echo $textbetween;
// Check if there is a password protected album. If so, show login dialog
$pwpath = "$album_directory/$album/passwd";
if(file_exists($pwpath) && (!isset($_SESSION["pw".crc32($album)]) || ($_SESSION["pw".crc32($album)] != true))) {
	echo "<h3>$txt_restricted_area</h3>";
	echo $txt_pw_needed_to_show_album;
	echo "<span class='thumbform'><form action=\"?".$_SERVER["QUERY_STRING"]."\" method=\"post\">";
	?>
	<input type="password" name="tft_pwd" size="20" /><br />
	<input type="hidden" name="action" value="set password" />
	<input type="submit" class='submit' />
	</form></span>
	<?php
} elseif(isset($_REQUEST["showcalendar"]) && ($_REQUEST["showcalendar"]==1)) {
	require "calendar.php";
} elseif(isset($page) && $page=="settings") {
	require "settingsform.php";
} elseif(isset($pic) && !empty($pic)) {
	require "picture.php";
} elseif(isset($page) && (!empty($page) && (!empty($album) || (empty($album) && !$show_welcome_message))) || (isset($_REQUEST["showcart"]) && ($_REQUEST["showcart"]==true) && !empty($_SESSION["cart"]))) {
	require "thumbnails.php";
} else {
	if(file_exists("$album_directory/description")) {
		$album_description = nl2br(htmlentities(file_get_contents("$album_directory/description")));
	} elseif(file_exists("$album_directory/description.txt")){
		$album_description = nl2br(htmlentities(file_get_contents("$album_directory/description.txt")));
	} elseif(file_exists("$album_directory/description.html")){
		$album_description = file_get_contents("$album_directory/description.html");
	} else {
		$album_description = $txt_welcome_message;
	}
	echo maskDescription($album_description);
}
echo $textafter;

require "footer.php";
echo "<p style=\"display:none;\">This page was generated in ".(microtime(true) - $time_start)." seconds.</p>";
if($showhtmlheader) {
?>
</body>
</html>
<?php
}
?>
