<?php
// $Id: image.php,v 1.11 2009/05/11 21:13:21 saschalorenz Exp $
include_once "config.inc";
if (file_exists("local_config.inc")) include_once "local_config.inc";
$filename = isset($_GET["file"]) ? iconv("UTF-8", $filename_encoding, $_GET['file']) : "";
if(get_magic_quotes_gpc()==1) {
	$filename = stripslashes($filename);
}
if(strpos($filename."/","../")!==false)
	$filename = "";
$album = substr($filename,0,strrpos($filename,'/')) or "";
$album = ($album=="" ? $album_directory : "$album_directory/$album");
if(file_exists($album."/album.inc")) {
	include_once($album."/album.inc");
}

if(isset($sessionpath) && ($sessionpath != "")) session_save_path($sessionpath);
if(isset($sessionname) && ($sessionname != "")) session_name($sessionname);
if (!headers_sent()) @session_start();

$scale = isset($_GET["scale"]) ? $_GET["scale"] : 0;
$attachment = isset($_GET["attachment"]) ? true : false;

switch ($scale) {
case 0: // original file
	$filename = $album_directory."/".$filename;
	if($dontshoworigpic != false) {
		header("HTTP/1.0 403 Forbidden");
		echo "<h2>403: Forbidden</h2>";
		echo "<p>You don't have access to the requested file!</p>";
		exit();
	}
	if(file_exists($filename) && is_file($filename)) {
		include "mimetypes.inc.php";
		preg_match("/.([a-z0-9]+)$/",strtolower($filename),$extension);
		$mimetype = isset($mimetypes[$extension[1]]) ? $mimetypes[$extension[1]] : "";
	} else {
		$filename = "";
	}
	$extension = "";
	break;
case 1: // thumbs
case 2: // scaled
	$subdir = ($scale == 1) ? "thumbs" : "scaled";
	$extension = $use_short_names ? (preg_match("/\.(jpg|jpeg)$/i",$filename) ? "" : ".jpg") : ".jpg";
	if(file_exists($data_directory."/$subdir/".$filename.$extension) && is_file($data_directory."/$subdir/".$filename.$extension)) {
		$mimetype = "image/jpg";
		$filename = $data_directory."/$subdir/".$filename;
	} else if(preg_match($pic_extentions,$filename)) {
		include_once('functions.inc');
		createScaled($filename,$scale,true);
		$mimetype = "image/jpg";
		$filename = $data_directory."/$subdir/".$filename;
	} else {
		$filename = "";
	}
	break;
case 3: // annotations
	$filename = $data_directory."/anno/".$filename;
	if(file_exists($filename) && is_file($filename)) {
		include "mimetypes.inc.php";
		preg_match("/.([a-z0-9]+)$/",strtolower($filename),$extension);
		$mimetype = isset($mimetypes[$extension[1]]) ? $mimetypes[$extension[1]] : "";
	} else {
		$filename = "";
	}
	$extension = "";
	break;
case 4: // album style sheet
	$filename = $album."/album.css";
	if(file_exists($filename) && is_file($filename)) {
		$mimetype = "text/css";
	} else {
		$filename = "";
	}
	$extension = "";
	break;
default:
	$filename = "";
	break;
}
if($filename != "") {
	preg_match("/^(.+)\/([^\/]+)$/",iconv("UTF-8", $filename_encoding, $_GET['file']),$name);
	$pwpath = "$album_directory/".$name[1]."/passwd";
	$referer = isset($_SERVER["HTTP_REFERER"]) ? parse_url($_SERVER["HTTP_REFERER"]) : "";
	if(file_exists($pwpath) && !(isset($_SESSION["pw".crc32($name[1])]) && ($_SESSION["pw".crc32($name[1])] == true))) {
		header("HTTP/1.0 403 Forbidden");
		echo "<h2>403: Forbidden</h2>";
		echo "<p>You don't have access to the requested file!</p>";
	} else if($allowdeeplink==false && $referer!="" && $referer["host"]!=$_SERVER["SERVER_NAME"]) {
		include_once("stolen.php");
	} else {
		if($mimetype != "") header("Content-Type: ".$mimetype);
		header("Content-Transfer-Encoding: binary");
		if($attachment==true) {
			header('Content-Disposition: attachment; filename="'.$name[2].$extension.'"');
		} else {
			header('Content-Disposition: inline; filename="'.$name[2].$extension.'"');
		}
		header("Last-Modified: ".gmdate('D, d M Y H:i:s',filemtime($filename.$extension)).' GMT');
		header('Expires: '.gmdate('D, d M Y H:i:s',time()+86400).' GMT');
		header('Cache-Control: max-age=86400');
		header('Pragma: ');
		header('Content-Length: ' . filesize($filename.$extension));
		readfile($filename.$extension);
	}
} else {
	include_once("404.php");
}
?>