<?php
// $Id: install.php,v 1.26 2009/05/22 23:23:30 saschalorenz Exp $
// to avoid malfunction because of unexpected direct call
if(!defined("TFT_VERSION")) {
	include_once("404.php");
	exit();
}

$permissions = array(
0=>"---",
1=>"--x",
2=>"-w-",
3=>"-wx",
4=>"r--",
5=>"r-x",
6=>"rw-",
7=>"rwx"
);

if($showhtmlheader == true) {
	if (!headers_sent()) header("Content-type: text/html; charset=UTF-8");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>TFTgallery Installation</title>
<link rel='stylesheet' type='text/css' href='admin/admin_area.css' />
</head>
<body class="admin_panel">
<?php } ?>
<div class="admintitle">TFTgallery Installation</div>
<?php
if(isset($_POST["step"]))
	$step = $_POST["step"];
else
	$step = 1;
?>
<table class='maintable'><tr>
<td class='naviarea'>
<ol class='navi'>
<li class='navi'><?php if($step==1) echo "<b>"; ?>Introduction<?php if($step==1) echo "</b>"; ?></li>
<li class='navi'><?php if($step==2) echo "<b>"; ?>Check PHP<?php if($step==2) echo "</b>"; ?></li>
<li class='navi'><?php if($step==3) echo "<b>"; ?>Check permissions<?php if($step==3) echo "</b>"; ?></li>
<li class='navi'><?php if($step==4) echo "<b>"; ?>Define settings<?php if($step==4) echo "</b>"; ?></li>
<li class='navi'><?php if($step==5) echo "<b>"; ?>Create folders<?php if($step==5) echo "</b>"; ?></li>
<li class='navi'><?php if($step==6) echo "<b>"; ?>Set login details<?php if($step==6) echo "</b>"; ?></li>
<li class='navi'><?php if($step==7) echo "<b>"; ?>Finalize installation<?php if($step==7) echo "</b>"; ?></li>
</ol>
</td>
<td class='mainarea'>
<div class="admin_item">
<?php
// workaround for IIS
$request_uri = isset($_SERVER["REQUEST_URI"]) ? $_SERVER["REQUEST_URI"] : $_SERVER["PHP_SELF"].(isset($_SERVER["QUERY_STRING"]) ? "?".$_SERVER["QUERY_STRING"] : "");
switch($step) {
case 7: //finalize installation
	$error = false;
	$salt = substr(md5(rand(0, 9999)), 0, 4);
	if($_POST["passwd"]!=$_POST["repeat"]) {
		$error = true;
		echo "<p><b>The two passwords differ!</b></p>";
	} else if(($_POST["username"]=="") || ($_POST["username"]=="")) {
		$error = true;
		echo "<p><b>Either the username or the password is empty!</b></p>";
	} else {
		$file = "<?php\n$"."adminhash = \"".($salt . sha1($salt . md5($_POST['username']))) .":". ($salt . sha1($salt .md5($_POST['passwd'])))."\";\n?>";
		$fp = @fopen("admin/passwd.inc.php","w");
		if($fp===false) {
			$error = true;
			echo "<p><b>The password file could not be created automatically!</b></p>";
		} else {
			flock($fp,2);
			fputs($fp,$file);
			flock($fp,3);
			fclose($fp);
			chmod("admin/passwd.inc.php", $file_permissions);
			echo "<p>The password file has been created successfully!</p>";
		}
	}

	if($error === false) {
		$fp = @fopen("$data_directory/installed","w");
		if($fp) {
			fclose($fp);
			chmod("$data_directory/installed",$file_permissions);
			echo "<p>This installer has been deactivated.</p>";
		} else {
			$error = true;
			echo "<p><b>This installer could not be deactivated! Please create an empty file <code>$data_directory/installed</code>!</b></p>";
		}
	}
	?>
<form action="<?php echo $request_uri; ?>" method="post" class="adminform">
<?php
	if($error == false) { ?>
<hr />
<p>Now the configuration of your TFTgallery is finished!</p>
<p>If you have any questions concerning TFTgallery, you can either:</p>
<ul>
<li>look in the <a href="http://www.tftgallery.org/goto=docs" target="_blank">TFTgallery Documentation</a></li>
<li>ask in the <a href="http://www.tftgallery.org/goto=forum" target="_blank">TFTgallery Forum</a></li>
<li>ask the TFTgallery author <a href="http://www.tftgallery.org/goto=contact" target="_blank">Sascha Lorenz</a></li>
</ul>
<p>If you want to be notified about new versions, feel free to join the <a href="http://www.tftgallery.org/goto=maillist" target="_blank">TFTgallery mailing list</a>.</p>
<input type="submit" value="Terminate installation" />
<?php } else { ?>
<p>An error occured during creating the password file or deactivating the installer.</p>
<input type="hidden" name="step" value="6" />
<input type="submit" value="Go back to step 6" />
<?php }
	echo "</form>";
	break;

case 6: // set admin password
	echo "<h3>Set login details</h3>";
	echo "<p>Now it's time to set up the administration username and password. Or do you want that anyone could enter the administration area?</p>";
	echo "<form name=\"tftstep6\" action=\"$request_uri\" method=\"post\" class=\"adminform\">";
	?>
	<table border="1">
	<tr><td>Set the username:</td><td><input type='text' size='20' name='username' /></td></tr>
	<tr><td>Use a secret password:</td><td><input type='password' size='20' name='passwd' /></td></tr>
	<tr><td>Repeat your password:</td><td><input type='password' size='20' name='repeat' /></td></tr>
	</table>
	<p>
	<input type="hidden" name="step" value="7" />
	<input type="submit" value="Go to step 7" /></p>
	<?php echo "</form>";
	break;

case 5: // writing the settings
	$error = false;
	echo "<h3>Write settings and create folders</h3>";
	echo "<p>Now the settings will be written to <code>local_config.inc</code>.</p>";
	$localconfig ="<?php\n//Automatically generated local_config.inc by the TFTgallery installer\n";

	$file_permissions = octdec($_POST['filepermuser'].$_POST['filepermgrp'].$_POST['filepermoth']);
	$subdir_permissions = octdec($_POST['subdirpermuser'].$_POST['subdirpermgrp'].$_POST['subdirpermoth']);
	
	$album_directory = (get_magic_quotes_gpc()==1 ? stripslashes($_POST['album_directory']) : $_POST['album_directory']);
	if(!file_exists($album_directory)) {
		if(mkdir($album_directory)) {
			chmod($album_directory,$subdir_permissions);
			echo "<p>The subdirectory <code>".$album_directory."</code> has been created successfully.</p>";
		} else {
			$error = true;
			echo "<p><b>An error occured during creating the folder <code>".$album_directory."</code></b></p>";
		}
	}
	$localconfig.='$album_directory = \''.$album_directory."';\n";

	$fp = @fopen($album_directory."/.htaccess","w");
	if($fp != false) {
		flock($fp,2);
		fputs($fp,"#automatically generated .htaccess file\n\nDeny from all\nOptions -Indexes\n");
		flock($fp,3);
		fclose($fp);
		chmod($album_directory."/.htaccess",$file_permissions);
		echo "<p>A file <code>".$album_directory."/.htaccess</code> has been created successfully.</p>";
	} else {
		$error = true;
		echo "<p><b>An error occured during creating the file <code>".$album_directory."/.htaccess</code>. Please try to delete the existing file using FTP.</b></p>";
	}

	$data_directory = (get_magic_quotes_gpc()==1 ? stripslashes($_POST['data_directory']) : $_POST['data_directory']);
	if(!file_exists($data_directory)) {
		if(mkdir($data_directory)) {
			chmod($data_directory,$subdir_permissions);
			echo "<p>The subdirectory <code>".$data_directory."</code> has been created successfully.</p>";
		} else {
			$error = true;
			echo "<p><b>An error occured during creating the folder <code>".$data_directory."</code></b></p>";
		}
	}
	$localconfig.='$data_directory = \''.$data_directory."';\n";

	$fp = @fopen($data_directory."/.htaccess","w");
	if($fp != false) {
		flock($fp,2);
		fputs($fp,"#automatically generated .htaccess file\n\nDeny from all\nOptions -Indexes\n");
		flock($fp,3);
		fclose($fp);
		chmod($data_directory."/.htaccess",$file_permissions);
		echo "<p>A file <code>".$data_directory."/.htaccess</code> has been created successfully.</p>";
	} else {
		$error = true;
		echo "<p><b>An error occured during creating the file <code>".$data_directory."/.htaccess</code>. Please try to delete the existing file using FTP.</b></p>";
	}

	$localconfig.='$standard_style = \''.addcslashes((get_magic_quotes_gpc()==1 ? stripslashes($_POST['standard_style']) : $_POST['standard_style']),"'")."';\n";
	$localconfig.='$tft_navigation = 2;'."\n";
	$localconfig.='$table_layout = false;'."\n";
	$localconfig.='$txt_title = \''.addcslashes((get_magic_quotes_gpc()==1 ? stripslashes($_POST['txt_title']) : $_POST['txt_title']),"'")."';\n";
	$localconfig.='$txt_welcome_message = \''.addcslashes((get_magic_quotes_gpc()==1 ? stripslashes($_POST['txt_welcome_message']) : $_POST['txt_welcome_message']),"'")."';\n";
	$localconfig.='$language = \''.addcslashes((get_magic_quotes_gpc()==1 ? stripslashes($_POST['language']) : $_POST['language']),"'")."';\n";
	$localconfig.='$gd_available= '.$_POST['gd_available'].";\n";
	if($_POST['gd_available']==10) {
		if(!isset($_POST['im_path']) || ($_POST['im_path']=="")) {
			$error = true;
			echo "<p><b>You forgot to specify the path to the ImageMagick converter!</b></p>";
		} else if(isset($_POST['im_path']) && !file_exists($_POST['im_path'])) {
			$error = true;
			echo "<p><b>It seems that the file <code>".$_POST['im_path']."</code> doesn't exist!</b></p>";
		}
		$localconfig.='$im_path = "'.addcslashes((get_magic_quotes_gpc()==1 ? stripslashes($_POST['im_path']) : $_POST['im_path']),"'")."\";\n";
	}
	$localconfig.='$adminlangfile = \'adminlang.'.$_POST['langadmin'].".inc';\n";
	$localconfig.='$file_permissions = 0'.$_POST['filepermuser'].$_POST['filepermgrp'].$_POST['filepermoth'].";\n";
	$localconfig.='$subdir_permissions = 0'.$_POST['subdirpermuser'].$_POST['subdirpermgrp'].$_POST['subdirpermoth'].";\n";
	$localconfig.="?>";
	if($error == false) {
		if(file_exists("local_config.inc") && isset($_POST['useoldlc']) && $_POST['useoldlc']=="true")
			$writemode = "a";
		else
			$writemode = "w";
		$fp = @fopen("local_config.inc",$writemode);
		if($fp == false) {
			$error = true;
			echo "<p><b>It seems that it is not possible to write the file <code>local_config.inc</code>, although I checked the permissions.</b></p>";
		} else {
			flock($fp,2);
			fputs($fp,$localconfig);
			flock($fp,3);
			fclose($fp);
			@chmod("local_config.inc",$file_permissions);
			echo "<p>The file <code>local_config.inc</code> has been written successfully.</p>";
		}
	}
?>

<form action="<?php echo $request_uri; ?>" method="post" class="adminform">
<?php
	if($error == false) { ?>
<p>The configuration file and the subdirectories could be created.</p>
<input type="hidden" name="step" value="6" />
<input type="submit" value="Go to step 6" />
<?php } else { ?>
<p>During the config file or subdirectory creation an error occured. Please try to fix the problems or ask your administrator for assistance.</p>
<input type="hidden" name="step" value="4" />
<input type="hidden" name="twousers" value="<?php echo $_POST["twousers"]; ?>" />
<input type="submit" value="Go back to step 4" />
<?php }
	echo "</form>";

	break;

case 4: // Define settings
	$error = false;
	$twousers = (isset($_POST["twousers"]) ? ($_POST["twousers"]=="false" ? false : true) : true);
	echo "<h3>Define settings</h3>";
	echo "<p>Here you can easily configure the settings of your gallery. After leaving the installer you can change them using the administration area.</p>";
	echo "<form name=\"tftstep4\" action=\"$request_uri\" method=\"post\" class=\"adminform\">";
	echo "<table border=\"1\">";

	// GALLERY TITLE
	echo "\n<tr><td>Set your own TFTgallery title:</td><td><input type='text' size='20' name='txt_title' value='".htmlspecialchars($txt_title,ENT_QUOTES)."' /></td></tr>";

	// WELCOME MESSAGE
	echo "\n<tr><td>Set your own welcome message:</td><td><input type='text' size='40' name='txt_welcome_message' value='".htmlspecialchars($txt_welcome_message,ENT_QUOTES)."' /></td></tr>";

	// DEFAULT LANGUAGE
	echo "<tr><td>Default gallery language:</td><td><select name='language' size='1'>";
	include_once "language/lang.inc";
	$fd = opendir("language");
	while($file = readdir($fd)) {
		if(preg_match("/^strings\.([a-z\-]+)\.inc$/i",$file,$matches) && is_file("language/$file")) {
			echo "\n<option value='".$matches[1]."'";
			if($language == $matches[1]) echo " selected='selected'";
			echo ">";
			$ulang_code = strtoupper($matches[1]);
			echo isset($lang_native[$ulang_code]) ? "${lang_native[$ulang_code]} (${lang[$ulang_code]})" : "${lang[$ulang_code]}";
			echo "</option>";
		}
	}
	closedir($fd);
	echo "</select></td></tr>\n";

	// DEFAULT ADMINISTRATION LANGUAGE
	echo "<tr><td>Default administration language:</td><td><select name='langadmin' size='1'>";
	$fd = opendir("language");
	while($file = readdir($fd)) {
		if(preg_match("/^adminlang\.(..)\.inc$/i",$file,$matches) && is_file("language/$file")) {
			echo "\n<option value='".$matches[1]."'";
			if($adminlangfile == 'adminlang.'.$matches[1].'.inc') echo " selected='selected'";
			echo ">";
			$ulang_code = strtoupper($matches[1]);
			echo isset($lang_native[$ulang_code]) ? "${lang_native[$ulang_code]} (${lang[$ulang_code]})" : "${lang[$ulang_code]}";
			echo "</option>";
		}
	}
	closedir($fd);
	echo "</select></td></tr>";

	/* STANDARD GALLERY LAYOUT */
	echo "\n<tr><td>standard gallery layout:</td><td><select name='standard_style' size='1'>";
	if(!preg_match("/^formnavi_(.)+\.css$/i",$standard_style))
		$standard_style = "formnavi_cucumbercool.css";
	$fd = opendir("styles");
	while($file = readdir($fd)) {
		if(!preg_match("/^local_/i",$file) && preg_match("/^formnavi_(.)+\.css$/i",$file,$matches1) && is_file("styles/$file")) {
			echo "\n<option value='$file'";
			if($standard_style == $file) echo " selected='selected'";
			echo ">$file</option>";
		}
	}
	closedir($fd);
	echo "</select><br /><small>All styles with the <code>formnavi_</code> prefix use the new album navigation combo box. If you prefer the \"traditional\" layout, you can switch back later using the configuration tool.</small></td></tr>";

	// SET ALBUMS DIRECTORY
	echo "\n<tr><td>Set album directory:</td><td><input type='text' size='20' name='album_directory' value='".htmlspecialchars($album_directory,ENT_QUOTES)."' /></td></tr>";

	// SET DATA DIRECTORY
	echo "\n<tr><td>Set data directory:</td><td><input type='text' size='20' name='data_directory' value='".htmlspecialchars($data_directory,ENT_QUOTES)."' /></td></tr>";

	// SET PERMISSIONS
	echo "\n<tr><td>file permissions:</td><td>";

	$perm=decoct($file_permissions);
	echo "<select name=\"filepermuser\" size=\"1\" style=\"font-family:monospace;\">";
	for($i=0;$i<8;$i+=2) {
		echo "<option value=\"$i\"";
		if($i == substr($perm,-3,1)) echo " selected='selected'";
		echo ">".$permissions[$i]."</option>";
	}
	echo "</select><select name=\"filepermgrp\" size=\"1\" style=\"font-family:monospace;\">";
	for($i=0;$i<8;$i+=2) {
		echo "<option value=\"$i\"";
		if($i == substr($perm,-2,1)) echo " selected='selected'";
		echo ">".$permissions[$i]."</option>";
	}
	echo "</select><select name=\"filepermoth\" size=\"1\" style=\"font-family:monospace;\">";
	for($i=0;$i<8;$i+=2) {
		echo "<option value=\"$i\"";
		if($i == substr($perm,-1,1)) echo " selected='selected'";
		echo ">".$permissions[$i]."</option>";
	}
	echo "</select>";
	if(substr($perm,-3,1)!="6")
		echo "<br /><b>Please give at least read and write permission to the owner (switch the first combo box to <code>rw-</code>).</b>";
	if($twousers==true)
		echo "<br /><b>If you want to access the gallery files using FTP, it is recommended to set the file permissions to <code>rw- rw- rw-</code>.</b>";
	echo "</td></tr>";

	/* subdirectory permission rights */
	echo "<tr><td>subdirectory permissions:</td><td>";
	$perm=decoct($subdir_permissions);
	echo "<select name=\"subdirpermuser\" size=\"1\" style=\"font-family:monospace;\">";
	for($i=0;$i<8;$i++) {
		echo "<option value=\"$i\"";
		if($i == substr($perm,-3,1)) echo " selected='selected'";
		echo ">".$permissions[$i]."</option>";
	}
	echo "</select><select name=\"subdirpermgrp\" size=\"1\" style=\"font-family:monospace;\">";
	for($i=0;$i<8;$i++) {
		echo "<option value=\"$i\"";
		if($i == substr($perm,-2,1)) echo " selected='selected'";
		echo ">".$permissions[$i]."</option>";
	}
	echo "</select><select name=\"subdirpermoth\" size=\"1\" style=\"font-family:monospace;\">";
	for($i=0;$i<8;$i++) {
		echo "<option value=\"$i\"";
		if($i == substr($perm,-1,1)) echo " selected='selected'";
		echo ">".$permissions[$i]."</option>";
	}
	echo "</select>";
	if(substr($perm,-3,1)!="7")
		echo "<br /><b>Please give at least read, write and execute permission to the owner (switch the first combo box to <code>rwx</code>).</b>";
	if($twousers==true)
		echo "<br /><b>If you want to access the gallery subdirectories using FTP (for image upload e.g.), it is recommended to set the subdirectory permissions to <code>rwx rwx rwx</code>.</b>";
	echo "</td></tr>\n";

	// SET IMAGE CONVERTING TOOL
	echo "<tr><td>image converting tool:</td><td><select 
	onchange=\"if(document.tftstep4.gd_available.value=='10') {document.tftstep4.im_path.disabled = false} else {document.tftstep4.im_path.disabled = true;}\" name=\"gd_available\">";
	echo "<option onclick=\"document.tftstep4.im_path.disabled = true;\" value=\"0\" ".(($gd_available == 0) ? " selected='selected'" : "").">no image conversion</option>";
	if(function_exists('imagecreate')) { // GD 1 available
		echo "<option value=\"1\" ".(($gd_available == 1) ? " selected='selected'" : "").">GD</option>";
	}
	if(function_exists('imagecreatetruecolor')) { // GD 2 available
		echo "<option value=\"2\" ".(($gd_available == 2) ? " selected='selected'" : "").">GD 2</option>";
	}
	echo "<option value=\"10\" ".(($gd_available === 10) ? " selected='selected'" : "").">ImageMagick</option>";
	echo "</select> ";

	echo "<input type='text' size='25' name='im_path' ".($gd_available === 10 ? "" : " disabled=\"disabled\"")." value='$im_path' /></td></tr>";

	?>
	</table>
	<p>
	<?php
	if(file_exists("local_config.inc"))
		echo "<input type=\"checkbox\" name=\"useoldlc\" value=\"true\" /> Don't replace the other settings in my existing <code>local_config.inc</code>!\n<br />";
	?>
	<input type="hidden" name="twousers" value="<?php echo $twousers; ?>" />
	<input type="hidden" name="step" value="5" />
	<input type="submit" value="Go to step 5" />
	</p>
	</form>
	<?php
	break;

case 3: // check permissions
	$error = false;
	$twousers = false; // will be true if there are two users accessing the gallery script: 1 = FTP access, 2 = WWW access
	echo "<h3>Check permissions</h3>";
	echo "<table border=\"1\">";

	// GALLERY WRITABLE?
	echo "<tr><td>gallery directory writable?</td><td>";
	if(is_writable("./")) {
		echo "OK";
		echo "</td></tr>\n";

		// ONE OR TWO USERS?
		echo "<tr><td>TFTgallery access</td><td>";
		$testfile = uniqid("file");
		$fp = @fopen($testfile,"w");
		if($fp != false) {
			fclose($fp);
			if(fileowner($testfile)==fileowner("install.php")) {
				echo "OK, the WWW user is the FTP user";
			} else {
				echo "OK, the WWW user is not the FTP user";
				$twousers = true;
			}
			unlink($testfile);
		} else {
			echo "<b>Hm, it seems that I cannot create a file although I checked the permission above...</b>";
			$error = true;
		}
		echo "</td></tr>\n";

		// GALLERY CONFIGURATION FILE WRITABLE?
		if(file_exists("local_config.inc")) {
			echo "<tr><td>Configuration file writable</td><td>";
			if(is_writable("local_config.inc")) {
				echo "OK";
			} else {
				echo "<b>not writable: Please use your FTP client and give write permissions (change permissions to <code>rw-rw-rw-</code>) to the file <code>local_config.inc</code></b>";
				$error = true;
			}
			echo "</td></tr>\n";
		}

		// GALLERY LOGFILE WRITABLE?
		if(file_exists("gallery.log")) {
			echo "<tr><td>Logfile writable</td><td>";
			if(is_writable("gallery.log")) {
				echo "OK: Logfile writable</li>";
			} else {
				echo "<b>not writable: Please use your FTP client and give write permissions (change permissions to <code>rw-rw-rw-</code>) to the file <code>gallery.log</code></b>";
				$error = true;
			}
			echo "</td></tr>\n";
		}

	} else {
		echo "<b>The TFTgallery installer cannot write into your gallery directory. Please use your FTP client to change the permissions to <code>rwxrwxrwx</code>.</b>";
		$error = true;
		echo "</td></tr>\n";
	}

	// LANGUAGE SUBDIRECTORY WRITABLE
	echo "<tr><td>language subdirectory writable?</td><td>";
	if(is_writable("language")) {
		echo "OK";
	} else {
		echo "<b>The TFTgallery installer cannot write into gallery's <code>language</code> directory. Please use your FTP client to change the permissions to <code>rwxrwxrwx</code>.</b>";
		$error = true;
	}
	echo "</td></tr>\n";

	// EXISTING ALBUM SUBDIRECTORY WRITABLE
	if(file_exists($album_directory)) {
		echo "<tr><td>album subdirectory writable?</td><td>";
		if(is_writable($album_directory)) {
			echo "OK";
		} else {
			echo "<b>The TFTgallery installer cannot write into gallery's <code>$album_directory</code> directory. Please use your FTP client to change the permissions to <code>rwxrwxrwx</code>.</b>";
			$error = true;
		}
		echo "</td></tr>\n";
		if(file_exists($album_directory."/.htaccess")) {
			echo "<tr><td>.htaccess file writable</td><td>";
			if(is_writable($album_directory."/.htaccess")) {
				echo "OK";
			} else {
				echo "<b>not writable: Please use your FTP client and give write permissions (change permissions to <code>rw-rw-rw-</code>) to the file <code>$album_directory/.htaccess</code></b>";
				$error = true;
			}
			echo "</td></tr>\n";
		}
	}

	// EXISTING DATA SUBDIRECTORY WRITABLE
	if(file_exists($data_directory)) {
		echo "<tr><td>data subdirectory writable?</td><td>";
		if(is_writable($data_directory)) {
			echo "OK";
		} else {
			echo "<b>The TFTgallery installer cannot write into gallery's <code>$data_directory</code> directory. Please use your FTP client to change the permissions to <code>rwxrwxrwx</code>.</b>";
			$error = true;
		}
		echo "</td></tr>\n";
		if(file_exists($data_directory."/.htaccess")) {
			echo "<tr><td>.htaccess file writable</td><td>";
			if(is_writable($data_directory."/.htaccess")) {
				echo "OK";
			} else {
				echo "<b>not writable: Please use your FTP client and give write permissions (change permissions to <code>rw-rw-rw-</code>) to the file <code>$data_directory/.htaccess</code></b>";
				$error = true;
			}
			echo "</td></tr>\n";
		}
	}

	// ADMIN SUBDIRECTORY WRITABLE
	echo "<tr><td>admin subdirectory writable?</td><td>";
	if(is_writable("admin")) {
		echo "OK";
	} else {
		echo "<b>The TFTgallery installer cannot write into gallery's <code>admin</code> directory. Please use your FTP client to change the permissions to <code>rwxrwxrwx</code>.</b>";
		$error = true;
	}
	echo "</td></tr>\n";

	// EXISTING PASSWORD FILE WRITABLE
	if(file_exists("admin/passwd.inc.php")) {
		echo "<tr><td>password file writable?</td><td>";
		if(is_writable("admin/passwd.inc.php")) {
			echo "OK";
		} else {
			echo "<b>The TFTgallery installer cannot write into the password file <code>admin/passwd.inc.php</code>. Please use your FTP client to change the permissions to <code>rw-rw-rw-</code>.</b>";
			$error = true;
		}
		echo "</td></tr>\n";
	}
	?>
	</table>
	<form action="<?php echo $request_uri; ?>" method="post" class="adminform">
	<?php
	if($error == false) { ?>
<p>Everything is all right with your permissions.</p>
<input type="hidden" name="twousers" value="<?php echo $twousers ? "true" : "false"; ?>" />
<input type="hidden" name="step" value="4" />
<input type="submit" value="Go to step 4" />
<?php } else { ?>
<p>During the checking an error occured. Please try to fix the problems or ask your administrator for assistance.</p>
<input type="hidden" name="step" value="3" />
<input type="submit" value="Check again" />
<?php }
	echo "</form>";
	break;
case 2: // check PHP environment
	$error = false;
	echo "<h3>Check PHP</h3>";
	echo "<table border=\"1\">";

	// PHP VERSION >= 4.2
	echo "<tr><td>PHP version &ge; 5.0</td><td>";
	if(version_compare(PHP_VERSION, "5.0")==-1) {
		echo "<b>Your PHP version ".PHP_VERSION." is insufficient for using TFTgallery.</b>";
		$error = true;
	} else {
		echo "OK";
	}
	echo "</td></tr>\n";

	// SESSIONS
	echo "<tr><td>PHP sessions</td><td>";
	if(function_exists("session_start")) {
		echo "OK";
	} else {
		echo "<b>Please enable PHP sessions. They are needed for running TFTgallery.</b>";
		$error = true;
	}
	echo "</td></tr>\n";

	// ICONV
	echo "<tr><td>iconv enabled</td><td>";
	if(function_exists("iconv")) {
		echo "OK";
	} else {
		echo "<b>iconv support is needed for handling 'international' file names.</b>";
		$error = true;
	}
	echo "</td></tr>\n";

	?>
	</table>
	<form action="<?php echo $request_uri; ?>" method="post" class="adminform">
	<?php
	if($error == false) { ?>
<p>Everything is all right with your PHP environment.</p>
<input type="hidden" name="step" value="3" />
<input type="submit" value="Go to step 3" />
<?php } else { ?>
<p>During the checking an error occured. Please try to fix the problems or ask your administrator for assistance.</p>
<input type="hidden" name="step" value="2" />
<input type="submit" value="Check again" />
<?php }
	echo "</form>";
	break;
default: // begin at step 1 if an illegal value is given
	?>
<h3>Welcome to TFTgallery</h3>
<p>Thank you for using a TFTgallery image gallery at your web page.</p>
<p>Now your gallery software has to be configured. It will take seven steps.</p>
<form action="<?php echo $request_uri; ?>" method="post" class="adminform">
<input type="hidden" name="step" value="2" />
<input type="submit" value="Go to step 2" />
</form>
<?php
}
?>
</div>
</td></tr></table>
</body>
</html>