<?php
/* $Id: calendar.de-de.inc,v 1.4 2008/01/18 19:13:44 saschalorenz Exp $
   Author: Sascha Lorenz <saschalorenz(at)users(dot)sf(dot)net>
   Calendar created due to ISO 8601: http://en.wikipedia.org/wiki/ISO_8601
   German holidays added: http://en.wikipedia.org/wiki/German_holidays
*/

// 1st day of the week, usually "Monday" = 1, in USA the week begins with "Sunday" = 0

$firstdayofweek = 1;

// 1st element is "Title sheet", then the 12 months

$month = array("Titelblatt","Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember");

// The word "Week" and then the 7 days of the week (beginning with monday)

$days = array("\nWoche", "\nMontag", "\nDienstag", "\nMittwoch", "\nDonnerstag", "\nFreitag", "\nSamstag", "\nSonntag");

$markedweekday = 7; // Sunday should be 'red'

// full holidays (day.month)
// in Germany: 01.01. = New Year's Day/Neujahr
//             01.05. = Labour Day/Tag der Arbeit
//             03.10. = German Unity Day/Tag der Deutschen Einheit
//             25.12. = Christmas Day/1. Weihnachtstag
//             26.12. = St. Stephen's Day/2. Weihnachtstag

$holiday = array(101, 105, 310, 2512, 2612);

// 'half' holidays (day.month)
// in Germany: 06.01. = Epiphany
//             08.08. = Peace Festival/Friedensfest (only in Augsburg)
//             15.08. = Assumption Day/Mariä Himmelfahrt
//             31.10. = Reformation Day/Reformationstag
//             01.11. = All Saints/Allerheiligen

$holiday1 = array(601, 808, 1508, 3110, 111);

// full holidays depending on easter sunday (days before/after easter sunday)
//  -2 is Good Friday / Karfreitag
//   0 is Easter Sunday / Ostersonntag
//   1 is Easter Monday / Ostermontag
//  39 is Ascension Day / Christi Himmelfahrt
//  49 is Pentecost / Pfingstsonntag
//  50 is Whitmonday / Pfingstmontag

$easter = array(-2, 0, 1, 39, 49, 50);

// half holidays depending on easter sunday (days before/after easter sunday)
// -47 is Mardi Gras / Faschingsdienstag (not a real holiday but also marked in every calendar)
//  50 is Corpus Christi / Fronleichnam

$easter1 = array(-47, 60);

function extraholidays() {
global $holiday, $holiday1, $year;
// here special holidays can be defined like the german Repentance Day ("Buß- und Bettag") at Wednesday before November 23
    $bussbettag = getdate(mktime(0,0,0,11,23,$year));
    $bussbettag = $bussbettag["wday"];
    if($bussbettag<4) $bussbettag+=7;
    array_push($holiday1,2611-($bussbettag*100));
}