<?php
/* $Id: calendar.en-us.inc,v 1.3 2008/01/18 19:13:44 saschalorenz Exp $
   Author: Sascha Lorenz <saschalorenz(at)users(dot)sf(dot)net>
   Calendar created due to ISO 8601: http://en.wikipedia.org/wiki/ISO_8601
   US holidays added: http://en.wikipedia.org/wiki/Public_holidays_of_the_United_States
*/

// 1st day of the week, usually "Monday" = 1, in USA the week begins with "Sunday" = 0

$firstdayofweek = 0;

// 1st element is "Title sheet", then the 12 months

$month = array("Title","January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");

// The word "Week" and then the 7 days of the week (beginning with the the day specified at $firstdayofweek)

$days = array("\nWeek", "\nSunday", "\nMonday", "\nTuesday", "\nWednesday", "\nThursday", "\nFriday", "\nSaturday");

$markedweekday = 0; // Sunday should be 'red'

// full holidays (ddmm)

$holiday = array(101, 407, 1111, 2512);

$holiday1 = array();

// full holidays depending on easter sunday (days before/after easter sunday)

$easter = array();

// half holidays depending on easter sunday (days before/after easter sunday)

$easter1 = array();

function extraholidays() {
global $holiday, $holiday1,$year;
// here special holidays can be defined like the German Repentance Day ("Buß- und Bettag") at Wednesday before November 23
// in USA: The "Martin Luther King Day" is celebrated at the Third Monday in January. So look at the last possible day
// (Jan 21) and subtract the day number (Sunday=0 to Saturday=6).
// In 2007 Jan 21 is a Sunday (0) + 7 = 7
// So you'll get 2101 - 800 = 1501

   $temp = getdate(mktime(0,0,0,1,21,$year));
   $temp = $temp["wday"];
   if($temp==0) $temp = 7;
   array_push($holiday,2101-($temp-1)*100);

   // Washington's Birthday: Third Monday in February
   $temp = getdate(mktime(0,0,0,2,21,$year));
   $temp = $temp["wday"];
   if($temp==0) $temp = 7;
   array_push($holiday,2102-($temp-1)*100);

   // Memorial Day: Last Monday in May
   $temp = getdate(mktime(0,0,0,5,31,$year));
   $temp = $temp["wday"];
   if($temp==0) $temp = 7;
   array_push($holiday,3105-($temp-1)*100);

   // Labor Day: First Monday in September
   $temp = getdate(mktime(0,0,0,9,7,$year));
   $temp = $temp["wday"];
   if($temp==0) $temp = 7;
   array_push($holiday,709-($temp-1)*100);

   // Columbus Day: Second Monday in October
   $temp = getdate(mktime(0,0,0,10,14,$year));
   $temp = $ColDay["wday"];
   if($temp==0) $temp = 7;
   array_push($holiday,1410-($temp-1)*100);

   // Thanksgiving Day: Fourth Thursday in November
   $temp = getdate(mktime(0,0,0,11,28,$year));
   $temp = $temp["wday"];
   if($temp<4) $temp += 7;
   array_push($holiday,2811-($temp-4)*100);
}