<?php
// $Id: pdf.php,v 1.18 2009/05/11 21:13:21 saschalorenz Exp $

include_once "config.inc";
if (file_exists("local_config.inc")) include_once "local_config.inc";
include_once "functions.inc";

require('fpdf.php');

if(isset($sessionpath) && ($sessionpath != "")) session_save_path($sessionpath);
if(isset($sessionname) && ($sessionname != "")) session_name($sessionname);
if (!headers_sent()) @session_start();

if(!empty($_REQUEST["album"])) {
	$album =  iconv("UTF-8", $filename_encoding, $_REQUEST["album"]);
	$album = get_magic_quotes_gpc()==1 ? stripslashes($album) : $album;
	$album_path = $album=="" ? $album_directory : "$album_directory/$album";

	if(!checkAlbumParamter()) die("specified album directory is not valid!");

	$pwpath = "$album_directory/$album/passwd";
	if(file_exists($pwpath) && !(isset($_SESSION["pw".crc32($album)]) && ($_SESSION["pw".crc32($album)] == true))) {
		die("You are not allowed to get a PDF from ".$album);
	}

	$liste = getFilelist($album);
	if(count($liste)<1) die("no displayable image in the specified directory!");
} elseif(isset($_REQUEST['mode']) and $_REQUEST['mode']=='cart' and is_array($_SESSION['cart'])) {
	$liste = $_SESSION['cart'];
	$album_path=$album_directory;
} else {
	die("no album directory specified");
}

$pdf_pagex = floor($pdf_pagex);
if ($pdf_pagex < 10) $pdf_pagex = 1024;

$pdf_pagey = floor($pdf_pagey);
if ($pdf_pagey < 10) $pdf_pagey = 768;

$pdf=new FPDF("P","pt",array($pdf_pagex,$pdf_pagey));
$pdf->Open();
$pdf->SetTitle($txt_title);
$pdf->SetCreator("TFTgallery http://www.tftgallery.org/");
$pdf->SetDisplayMode("fullpage","single");
if($pdf_slideshow) {
	$pdf->SetDrawColor(0);
	$pdf->SetFillColor(0);
} else {
	$pdf->SetDrawColor(255);
	$pdf->SetFillColor(255);
}

$pdf_rows_per_page = floor($pdf_rows_per_page);
if ($pdf_rows_per_page < 1) $pdf_rows_per_page = 1;
$maximagex = $pdf_pagex / $pdf_rows_per_page;

$pdf_pics_per_row = floor($pdf_pics_per_row);
if ($pdf_pics_per_row < 1) $pdf_pics_per_row = 1;
$maximagey = $pdf_pagey / $pdf_pics_per_row;

$i=0;
$j=-1;
foreach($liste as $item) {
	$file = $album_path."/".$item;
	if((is_file($file)) && preg_match($pic_extentions,$file)) {
		$imageinfo = @getimagesize($file);
		if(!empty($imageinfo)) {
			$ext = "";
			switch ($imageinfo[2]) {
				case 1: // GIF
					$image = imagecreatefromgif($file);
					$file = "data/tempimage$i.png";
					$ext = "png";
					imagepng($image, $file);
					imagedestroy($image);
					break;
				case 2: // JPEG
					$ext = "jpeg";
					break;
				case 3: // PNG
					$ext = "png";
					break;
				default: // else
					$ext = "";
					break;
			}
			if(($ext != "")) {
				$j++;
				if(($j % ($pdf_pics_per_row*$pdf_rows_per_page)) == 0) {
					$pdf->AddPage();
					if($pdf_slideshow) $pdf->Rect(0, 0, $pdf_pagex,$pdf_pagey, "F"); // black background for slide show
					$j=0;
				}

				$leftmargin = fmod($j, $pdf_pics_per_row) * $maximagex;
				$topmargin = floor(fmod($j, $pdf_pics_per_row*$pdf_rows_per_page) / $pdf_rows_per_page) * $maximagey;

				$factorx = $maximagex / $imageinfo[0];
				$factory = $maximagey / $imageinfo[1];
				$factor = ($factorx > $factory) ? $factory : $factorx;
				if((! $pdf_expandimages) && ($factor>1)) $factor = 1.0;

				$xmargin = ($maximagex/2)-($imageinfo[0]*$factor)/2;
				$ymargin = ($maximagey/2)-($imageinfo[1]*$factor)/2;

				$pdf->Image($file, $leftmargin+$xmargin, $topmargin+$ymargin, $imageinfo[0]*$factor, $imageinfo[1]*$factor, $ext);
				$pdf->Rect($leftmargin+$xmargin, $topmargin+$ymargin, $imageinfo[0]*$factor, $imageinfo[1]*$factor, "D");
				if(substr($file, 0, 14)=="data/tempimage")
					@unlink($file);
			}	// extension empty
		}	// empty $imageinfo
	}	// is file
	$i++;
}
if(headers_sent()) {
	@unlink("data/gallery.pdf");
	$pdf->Output("data/gallery.pdf","F");
	echo "<a href='data/gallery.pdf'>download PDF file</a>";
} else
	$pdf->Output("gallery.pdf","D");
