<?php
// $Id$
function pic_node_form($pic = NULL){
  /**
   * 表单与drupal略有不同
   * $form['settings'] 下是是表单的一些参数
   * $form['fields'] 则为表单字段
   */
  $form['settings'] = array(
    '#ajax_validate' => 1, // 是否ajax验证基本内容，即非必填内容等
    '#redirect' => url('admin/pic'), // 提交成功后跳转地址
  );
  $form['fields']['nid'] = array(
    '#type' => 'hidden',
    '#default_value' => $pic->nid,
    '#constant' => 1
  );  
  $form['fields']['url'] = array(
    '#title' => t('pic', '来源url'),
    '#type' => 'textfield',
    '#default_value' => $pic->url,
    '#weight' => -10,
    '#attributes' => array('size' => 100)
  ); 
  $form['fields']['litpic'] = array(
    '#title' => t('litpic', '缩略图'),
    '#type' => 'file',
	'#description' => isset($pic->litpic) ? '<img src="/'.get_litpic($pic,'60x60').'" /><a href="'.url('file/'.$pic->fid.'/delete').'" class="confirmajax" level="parent" target="_blank">删除</a>' : '',
    '#filesave' => false,// 系统处理上传文件
    '#validate' => array(
      'savepath' => 'pic',
      'no_insert' => true,
      'title' => '缩略图',
      'filename' => 'image',
      'image' => array(
        'type' => array('jpg', 'png', 'gif'),
		'size' => '600x400',
      ),
    ),
  );  
  
  // 调用一个字段组
  field_get_node_form('pic', 'my_field', $pic, $form, 0);
  
  $form['fields']['submit'] = array(
    '#type' => 'submit',
    '#submit' => 'pic_node_form_submit', // 提交时回调函数
    '#weight' => 100
  );
  
  return $form;
}

// 表单提交回调函数
function pic_node_form_submit($form, $v){
	if($v['url'] != ''){
		$f = my_file_down_image($v['url']);
	}elseif($_FILES['litpic']){
		$validate = array(
		  'savepath' => 'pic',
		  'no_insert' => false,
		  'title' => '缩略图',
		  'filename' => 'image',
		  'image' => array(
			'type' => array('jpg', 'png', 'gif'),
			//'size' => '600x400',
		  ),
		);
		$f = file_save_upload($_FILES['litpic'],$validate);
	}

	$v['fid'] = $f->fid;
	pic_save($v);
}