﻿/* Demo Note:  This demo uses a FileProgress class that handles the UI for displaying the file name and percent complete.
The FileProgress class is not part of SWFUpload.
*/


/* **********************
Event Handlers
These are my custom event handlers to make my
web application behave the way I went when SWFUpload
completes different tasks.  These aren't part of the SWFUpload
package.  They are part of my application.  Without these none
of the actions SWFUpload makes will show up in my application.
********************** */
function fileQueued(file) {
	try {
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setStatus("等待上传...");
		progress.toggleCancel(true, this);
        document.getElementById("button1").disabled = false;
	} catch (ex) {
		this.debug(ex);
	}

}

function fileQueueError(file, errorCode, message) {
	try {
		if (errorCode === SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED) {
			alert("您选择的图片过多." );
			return;
		}

		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setError();
		progress.toggleCancel(false);

		switch (errorCode) {
			case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
			progress.setStatus("您选择的文件超过了大小，请重新选择一个文件.");
			this.debug("Error Code: 文件太大, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
			case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
			progress.setStatus("您选择的文件内容为空，请重新选择一个文件.");
			this.debug("Error Code: Zero byte file, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
			case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
			progress.setStatus("Invalid File Type.");
			this.debug("Error Code: Invalid File Type, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
			default:
			if (file !== null) {
				progress.setStatus("Unhandled Error");
			}
			this.debug("Error Code: " + errorCode + ", File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		}
	} catch (ex) {
		this.debug(ex);
	}
}

function uploadStart(file) {
	try {
		/* I don't want to do any file validation or anything,  I'll just update the UI and
		return true to indicate that the upload should start.
		It's important to update the UI here because in Linux no uploadProgress events are called. The best
		we can do is say we are uploading.
		*/
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setStatus("Uploading...");
		progress.toggleCancel(true, this);

		//隐藏表单
		if(this.getFile() === null){
			document.getElementById("divMovieContainer").style.visibility = "";
		}else{
			document.getElementById("divMovieContainer").style.visibility = "hidden";
			document.getElementById("tips").style.visibility = "";
		}
	}
	catch (ex) {}

	return true;
}

function uploadProgress(file, bytesLoaded, bytesTotal) {
	try {
		var percent = Math.ceil((bytesLoaded / bytesTotal) * 100);

		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setProgress(percent);
		progress.setStatus("上传进度:"+percent + "%");
	} catch (ex) {
		this.debug(ex);
	}
}

function uploadSuccess(file, serverData) {
	try {
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		if(serverData != '成功'){
			//progress.setComplete();
			progress.setError();
			progress.setStatus(serverData);
			progress.toggleCancel(false);

			//减掉成功的
			var stats = this.getStats();
			this.setStats({
				successful_uploads: parseInt(stats.successful_uploads) - 1
			});


		}else{
			progress.setComplete();
			progress.setStatus("完成上传.");
			progress.toggleCancel(false);
			
		}

		//隐藏表单
		if(this.getFile() === null){
			document.getElementById("divMovieContainer").style.visibility = "";
			document.getElementById("tips").style.visibility = "hidden";
			//if(serverData == '成功')
			//{
				//成功数清0
				var stats = this.getStats();
				this.setStats({
					successful_uploads: 0
				});
				location.reload();
			//}
		}else{
			document.getElementById("divMovieContainer").style.visibility = "hidden";
			document.getElementById("tips").style.visibility = "";
		}

	} catch (ex) {
		this.debug(ex);
	}
}

function uploadError(file, errorCode, message) {
	try {
		var progress = new FileProgress(file, this.customSettings.progressTarget);
		progress.setError();
		progress.toggleCancel(false);
		switch (errorCode) {
			case SWFUpload.UPLOAD_ERROR.HTTP_ERROR:
			progress.setStatus("Upload Error: " + message);
			this.debug("Error Code: HTTP Error, File name: " + file.name + ", Message: " + message);
			//隐藏表单
			if(this.getFile() === null){
			    document.getElementById("button1").disabled = true;
				document.getElementById("divMovieContainer").style.visibility = "";
				document.getElementById("tips").style.visibility = "hidden";
			}
			break;
			case SWFUpload.UPLOAD_ERROR.UPLOAD_FAILED:
			progress.setStatus("Upload Failed.");
			this.debug("Error Code: Upload Failed, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
			case SWFUpload.UPLOAD_ERROR.IO_ERROR:
			progress.setStatus("Server (IO) Error");
			this.debug("Error Code: IO Error, File name: " + file.name + ", Message: " + message);
			break;
			case SWFUpload.UPLOAD_ERROR.SECURITY_ERROR:
			progress.setStatus("Security Error");
			this.debug("Error Code: Security Error, File name: " + file.name + ", Message: " + message);
			break;
			case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:
			progress.setStatus("Upload limit exceeded.");
			this.debug("Error Code: Upload Limit Exceeded, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
			case SWFUpload.UPLOAD_ERROR.FILE_VALIDATION_FAILED:
			progress.setStatus("Failed Validation.  Upload skipped.");
			this.debug("Error Code: File Validation Failed, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
			case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:
			progress.setStatus("您终止了上传，你可以继续或者重新选择.");
			progress.setCancelled();
			//隐藏表单
			if(this.getFile() === null){
			    document.getElementById("button1").disabled = true;
				document.getElementById("divMovieContainer").style.visibility = "";
				document.getElementById("tips").style.visibility = "hidden";
			}
			break;
			case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:
			progress.setStatus("您终止了上传，你可以继续或者重新选择.");
			//隐藏表单
			if(this.getFile() === null){
				document.getElementById("divMovieContainer").style.visibility = "";
				document.getElementById("tips").style.visibility = "hidden";
				
			}
			break;
			default:
			progress.setStatus("Unhandled Error: " + errorCode);
			this.debug("Error Code: " + errorCode + ", File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		}
	} catch (ex) {
		this.debug(ex);
	}
}

function uploadComplete(file) {
	this.startUpload()//上传下一个
}

function SWFUploadLoaded(){
	//隐藏表单
	if(this.getFile() === null){
		document.getElementById("divMovieContainer").style.visibility = "";
		document.getElementById("tips").style.visibility = "hidden";
	}else{
		document.getElementById("divMovieContainer").style.visibility = "hidden";
		document.getElementById("tips").style.visibility = "";
	}
}

