<?php
/***********************************************************************

  Copyright (C) 2006 Aizu Ikmal Ahmad (aizu@ikmal.com.my)

  This file is part of iFoto.

  iFoto is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 2 of the License,
  or (at your option) any later version.

  iFoto is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
  MA  02111-1307  USA

************************************************************************/

require('config.php');

define('SORT_BY', $sort_thumbs_by);
define('SORT_ORDER', $sort_thumbs_order);
define('STRIP_SORT_NUMBER', $strip_sort_number);
define('DISPLAY_HOMEPAGE_LAST_ADDTION', $display_home_last_addition);
define('THUMBS_PER_PAGE', $thumbs_per_page);
define('TILE_STYLE', $tile_style);

require('includes/functions.php');
require('includes/thumbnailer.php');

requirement_checker();

$template = 'default';
if(!is_file('templates/'.$template.'.html')){ errorMsg('Sorry, template '.$template.' does not exist.'); }

require('templates/'.$template.'.html');



function home_page(){
	?>
	<div id="homepage">
		<h3><font color="#FF6600">czhy</font>רð</h3>
		
		<br /><br />
		Բ鿴Ƭ.
		<br /><br />
		汾 : 1.0 (Non-MySQL)

		<?php if(DISPLAY_HOMEPAGE_LAST_ADDTION){html_LastAddition();} ?>

	</div>
	<?php
}

function html_stat(){



}

function html_nav(){

	echo '<ul>';
	echo '<li class="home_button"><a href="?">ҳ</a></li>';
	map_dirs('gallery/',0);
	echo '</ul>';
	$style_on_current = '';

}

function map_dirs($path,$level) {
	if(is_dir($path)) {
    	if($contents = opendir($path)) {
        	while(($node = readdir($contents)) !== false) {
            	if($node!="." && $node!="..") {
                	for($i=0;$i<$level;$i++) echo "  ";
                    	if(is_dir($path."/".$node)){
                    		if((urldecode(get_param('dir')) == str_replace('gallery//','',$path).'/'.$node) OR urldecode(get_param('dir')) == $node){$style_on_current = 'class="active"';}else{$style_on_current = '';}
                    		if($i == 0){
                    			echo '<li '.$style_on_current.'><a href="?dir='.urlencode($node).'" title="'.$node.'">'.$node.'</a></li>';
                    		}else{
                    			echo '<li '.$style_on_current.' style="margin-left:10px;"><a href="?dir='.str_replace('gallery//','',$path)."/".urlencode($node).'" title="'.$node.'" style="font-weight:normal;">'.$node.'</a></li>';
                    		}
                    	}
						map_dirs("$path/$node",$level+1);
				}
			}
		}
	}
}

function html_contents(){

	if(get_param('pic')){

		if(!get_param('dir')){ exit('<pre>Get dir error.</pre>'); }

		$current_image_list = readDirectory(get_param('dir'), true);

		$current_image_list = multi_array_sort($current_image_list, SORT_BY, SORT_ORDER);

		$total_images = count($current_image_list);

		$search_key = multi_array_search(get_param('pic'), $current_image_list);
		//pre($current_image_list);
		$current_key = $search_key[0];

		@$curr_image = $current_image_list[$current_key];
		@$prev_image = $current_image_list[$current_key-1];
		@$next_image = $current_image_list[$current_key+1];


		$max_width = 560;

		/* to avoid small image getting as big as $max_width */
		if($curr_image['width'] > $max_width){
			$img_width = $max_width;
		}else{
			$img_width = $curr_image['width'];
		}

		$curr_image_meta_id = str_replace('.jpg','',str_replace('data/thumbdata_','',$curr_image['thumb']));

		if(file_exists('data/desc_'.$curr_image_meta_id.'.desc')){
			$current_image_description = '<div class="description">'.implode ('', file ('data/desc_'.$curr_image_meta_id.'.desc')).'</div>';
		}else{
			$current_image_description = '';
		}

		?>

		<script language="JavaScript">
		<!-- Begin Image Preload

		image_prev = new Image();
		image_prev.src = "gallery/<?php echo $prev_image['dir']; ?>/<?php echo $prev_image['filename']; ?>";

		image_next = new Image();
		image_next.src = "gallery/<?php echo $next_image['dir']; ?>/<?php echo $next_image['filename']; ?>";

		// End -->
		</script>
		<div id="fullsize">

			<div class="menu">
				<div class="left">
					Photo <?php echo $current_key+1	; ?> from <?php echo $total_images; ?>
				</div>
				<div class="right">
					<?php if($current_key != 0){ ?><a href="?dir=<?php echo urlencode(get_param('dir')); ?>&pic=<?php echo urlencode($prev_image['title']); ?>" title="<?php echo $prev_image['title'];?>">Prev</a> | <?php }else{ ?> Prev | <?php }; ?>
					<?php if($current_key+1 != $total_images){ ?><a href="?dir=<?php echo urlencode(get_param('dir')); ?>&pic=<?php echo urlencode($next_image['title']); ?>" title="<?php echo $next_image['title'];?>">Next</a><?php }else{ ?> Next <?php }; ?>
				</div>
				<div class="clear">&nbsp;</div>
			</div>


			<div class="image_wrapper">
        		<div class="shadow">&nbsp;</div>
				<div class="image">
					<a href="gallery/<?php echo urldecode($curr_image['dir']); ?>/<?php echo urldecode($curr_image['filename']); ?>" rel="lightbox">
						<img src="gallery/<?php echo urldecode($curr_image['dir']); ?>/<?php echo urldecode($curr_image['filename']); ?>" width="<?php echo $img_width; ?>px" border="0">
					</a>
				</div>
			</div>

			<div class="title"><?php echo $curr_image['title']; ?></div>
			<?php echo $current_image_description;?>


			<div class="footer">
				<div class="thumb_wrapper prev">
	        		<div class="content">
	            		<div class="shadow">&nbsp;</div>
						<div class="thumb">
							<?php if($current_key != 0){ ?>
							<a href="?dir=<?php echo urlencode($prev_image['dir']); ?>&pic=<?php echo urlencode($prev_image['title']);?>" title="<?php echo $prev_image['title'];?>"><img src="<?php echo $prev_image['thumb'];?>" border="0"/></a>
							<?php }else{ ?>
							<img src="templates/default/first.jpg">
							<?php } ?>
						</div>
					</div>
				</div>

	        	<div class="desc">
					<ul>
	        		<li><b>ļ :</b> <?php echo $curr_image['filename']; ?></li>
					<li><b>ԭʼС :</b> <?php echo $curr_image['width']; ?>x<?php echo $curr_image['height']; ?> </li>
					<li><b>ϴʱ :</b> <?php echo date('l, j F Y',$curr_image['modified']); ?></li>
					<li><b>ļߴ :</b> <?php echo number_format($curr_image['filesize']/1024, 2, '.', '').' kb'; ?></li>
					</ul>
				</div>
	        	<div class="thumb_wrapper next">
	        		<div class="container">
	            		<div class="shadow">&nbsp;</div>
						<div class="thumb">
							<?php if($current_key+1 != $total_images){ ?>
							<a href="?dir=<?php echo urlencode($next_image['dir']); ?>&pic=<?php echo urlencode($next_image['title']);?>" title="<?php echo $next_image['title'];?>"><img src="<?php echo $next_image['thumb'];?>" border="0"/></a>
							<?php }else{ ?>
							<img src="templates/default/last.jpg">
							<?php } ?>
						</div>
					</div>
				</div>
				<div class="clear">&nbsp;</div>

				<div class="comments">
					<a name="comments"></a>
					<div class="list">

						<?php
						//comment processor upon post

						$filename = 'data/comments.dat';

						if(!is_file($filename)){$fp = fopen($filename, 'w'); fwrite($fp, ''); fclose($fp);}

						if(@$_POST['com_id'] && @$_POST['com_name'] && @$_POST['com_email'] && @$_POST['com_comment']){

							$current_time = time();

							$form_id		= @$_POST['com_id'];
							$form_name		= @$_POST['com_name'];
							$form_email		= @$_POST['com_email'];
							$form_website	= @$_POST['com_website'];
							$form_comment	= @$_POST['com_comment'];


							$raw_content = implode ('', file ($filename));

							if($raw_content){
								$comments_old = $raw_content . '}|+|{';
							}else{
								$comments_old = '';
							}

							$comments_new = serialize(array('id'=>$form_id, 'time'=>$current_time, 'name'=>$form_name, 'email'=>$form_email, 'website'=>$form_website, 'comment'=>$form_comment));

							$comment_to_store = $comments_old . $comments_new;

							//pre($comments_arr);

							if (is_writable($filename)) {

								$handle = fopen($filename, 'w');

								if (fwrite($handle, $comment_to_store) === FALSE) {
									echo 'Cannot write comment to comment data file';
									exit;
								}

								//echo 'file written';

								fclose($handle);

							}else{
								echo 'The file comment data file is not writable';
							}

						}


						$comments_data = implode ('', file ($filename));

						$comments_arr = explode('}|+|{', $comments_data);

						$current_image_id = str_replace('data/thumbdata_','',substr($curr_image['thumb'], 0, -4));

						foreach ($comments_arr as $comments_data){

							$comments_data = unserialize($comments_data);

							if($current_image_id == $comments_data['id']){

								?>
								<div class="entry">
									<div class="meta"><b><?php echo $comments_data['name'];?></b> <?php if($comments_data['website']){echo '(<a href="http://'.str_replace('http://','',$comments_data['website']).'" target="_blank">'.$comments_data['website'].'</a>)';}?> on <?php echo date('l, j F Y', $comments_data['time']);?></div>
									<div class="comment"><?php echo $comments_data['comment'];?></div>
								</div>
								<?

							}

						}

						?>

					</div>
					<div class="form">
						<form method="POST" action="./?dir=<?php echo urlencode(get_param('dir')) . '&pic=' . urlencode(get_param('pic')); ?>#comments">
							<input type="hidden" name="com_id" value="<?php echo str_replace('data/thumbdata_','',substr($curr_image['thumb'], 0, -4)); ?>">
							<br />
							<input type="text" name="com_name" value="" /> ()<br />
							email<br />
							<input type="text" name="com_email" value="" />  (ܣʾ) (required)<br />
							ҳ<br />
							<input type="text" name="com_website" value="" /><br />
							<br />
							<textarea name="com_comment"></textarea><br /><br />
							<input type="submit" name="submit" value="" />
						</form>
					</div>


				</div>

			</div>
		</div>
		<?php

	}elseif(get_param('dir')){

		$image_list_arr = readDirectory(get_param('dir'));

		//pre($image_list_arr);

		$image_list_arr = multi_array_sort($image_list_arr, SORT_BY, SORT_ORDER);

		if($image_list_arr){

	        $cols = 4;
	        $i = 1;
	        echo "<table align='center' width='50%' border ='0' cellpadding='0' cellspacing='0'><tr>";

	        foreach($image_list_arr as $image_key => $image){

	        	//using table style

	        	if(TILE_STYLE == 'table'){

		            if (is_int($i / $cols)) {
		                $table_tile_header = '<td align="center" valign="top">';
		                $table_tile_footer = '</td></tr><tr>';
					}else{
		                $table_tile_header = '<td align="center" valign="top">';
		                $table_tile_footer = '</td>';
		            }
		            $i++;

		            echo $table_tile_header;
					?>
		        	<div class="thumb_wrapper tile_table">
		        		<div class="container">
		        			<?php
		        			if($image['item_type'] == 'dir'){
		        				?>
		        				<div class="dir_icon"><a href="?dir=<?php echo urlencode($image['dir']); ?>/<?php echo urlencode($image['title']);?>"><img src="directory.jpg" border="0"/></a></div>
		        				<?
		        			}else{
		        				?>
		            			<div class="shadow">&nbsp;</div>
								<div class="thumb"><a href="?dir=<?php echo urlencode($image['dir']); ?>&pic=<?php echo urlencode($image['title']);?>"><img src="<?php echo $image['thumb']; ?>" border="0"/></a></div>
								<?
		        			}
		        			?>
						</div>
						<div class="title"><?php echo $image['title']; ?></div>
					</div>
					<?
					echo $table_tile_footer;

	        	}elseif(TILE_STYLE == 'css'){

		            //using true-css style
					?>
		        	<div class="thumb_wrapper tile">
		        		<div class="container">
		        			<?php
		        			if($image['item_type'] == 'dir'){
		        				?>
		        				<div class="dir_icon"><a href="?dir=<?php echo urlencode($image['dir']); ?>/<?php echo urlencode($image['title']);?>"><img src="directory.jpg" border="0"/></a></div>
		        				<?
		        			}else{
		        				?>
		            			<div class="shadow">&nbsp;</div>
								<div class="thumb"><a href="?dir=<?php echo urlencode($image['dir']); ?>&pic=<?php echo urlencode($image['title']);?>"><img src="<?php echo $image['thumb']; ?>" border="0"/></a></div>
								<?
		        			}
		        			?>
						</div>
						<div class="title"><?php echo $image['title']; ?></div>
					</div>
					<?

	        	}




	        }
	        echo "</tr></table>";

		}else{
			echo ' Ŷ˼飬ﾹȻûͼƬأ';
		}

	}else{
		home_page();
	}

}

function thumbs_generator(){

	?>
	<iframe id="thumbgen" name="thumbgen" style="width:0px; height:0px; border: 0px" src="thumb_generator.php?dir=<?php echo urlencode(get_param('dir')); ?>"></iframe>
	<?

}

function html_LastAddition(){

	?>
	<div class="latest">
		<p>Ƭ(<a href="#" onclick="javascript:popup_latestupdate();" title="Notes About Latest Added Photos">?</a>)</p>
		<?php
		$image_list_arr = readLastAddition();

		if($image_list_arr){

	        foreach($image_list_arr as $image_key => $image){

				?>
	        	<div class="thumb_wrapper tile">
	        		<div class="container">
	            		<div class="shadow">&nbsp;</div>
						<div class="thumb"><a href="?dir=<?php echo urlencode($image['dir']); ?>&pic=<?php echo urlencode($image['title']);?>"><img src="data/thumbdata_<?php echo base64_encode($image['dir'] . ']|[' . $image['filename'] . ']|[' . $image['last_modify']); ?>.jpg" border="0"/></a></div>
					</div>
					<div class="title"><?php echo $image['title']; ?></div>
				</div>
				<?
	        }

		}else{
			echo ' Ŷҵ졣ȻһƬҲû.';
		}

		?>
	</div>
	<?php

}

function readLastAddition(){

	$image_list_arr = array();

    $opendir = 'data';
    if ($handle = opendir($opendir)) {
        while (false !== ($file = readdir($handle))) {
            if ($file != '.' AND $file != '..' AND (substr($file,0,10) == 'thumbdata_')) {
            	$file_data_arr = explode(']|[', base64_decode(str_replace('thumbdata_','',$file)));

				/* i also dont know what the hell is this for */
            	$file_data_arr[2] = str_replace('','',$file_data_arr[2]);

            	//pre($file_data_arr);

            	$image_list_arr[] = array('dir' => $file_data_arr[0], 'filename' => $file_data_arr[1], 'title' => str_replace('_',' ',substr($file_data_arr[1],0,-4)), 'last_modify' => $file_data_arr[2]);
            }
        }
        closedir($handle);

		//krsort($image_list_arr);

        $image_list_arr = multi_array_sort($image_list_arr, 'last_modify', 'asc');

        $i = 1;
        $maximum_img_at_homepage = 4;
		$image_at_homepage = array();
        if($image_list_arr){

			foreach($image_list_arr as $image_list_key => $image_list_value){

				$image_at_homepage[$image_list_key] = $image_list_value;

	        	if($i == $maximum_img_at_homepage){ break; }
	        	$i++;
	        }

        }

        return $image_at_homepage;

    }else{

    	return false;

    }

}

?>