<?php
namespace admin\controller;

/**
 * 前台首页控制器
 * 主要获取首页聚合数据
 */
class AttrType extends Admin {
	
	//需要修改
	private $model="Home/AttrType"; //模型名称  /********注意修改模型名称********/
	private $pk="id"; //主键名称  
	private $keyword="name"; //主键名称  
	

	// 管理列表
	public function index(){
		M()->execute("CREATE TABLE IF NOT EXISTS `wp_attr` (
			  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
			  `type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '类型id',
			  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '名称',
			  `input_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '输入类型 0,1,2',
			  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '属性类型 0,1,2',
			  `index` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否可以筛选 0,1,2',
			  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
			  `islink` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '相关属性商品是否关联',
			  `group` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '属性分组',
			  PRIMARY KEY (`id`),
			  KEY `cat_id` (`type_id`)
			) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8");
		M()->execute("CREATE TABLE IF NOT EXISTS `wp_attr_goods` (
			  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
			  `attr_id` smallint(5) unsigned NOT NULL DEFAULT '0',
			  `value` text NOT NULL,
			  `price` varchar(255) NOT NULL DEFAULT '',
			  PRIMARY KEY (`id`),
			  KEY `goods_id` (`goods_id`),
			  KEY `attr_id` (`attr_id`)
			) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8");
		M()->execute("CREATE TABLE IF NOT EXISTS `wp_attr_type` (
			  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
			  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '名称',
			  `group` varchar(255) NOT NULL COMMENT '分组，一行一个',
			  PRIMARY KEY (`id`)
			) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8");
		M()->execute("CREATE TABLE IF NOT EXISTS `wp_attr_value` (
			  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
			  `value` varchar(255) NOT NULL DEFAULT '' COMMENT '值',
			  `attr_id` int(10) NOT NULL COMMENT '属性id',
			  `sort` int(11) NOT NULL COMMENT '排序',
			  PRIMARY KEY (`id`)
			) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8");
		
		
		$m=D($this->model);
		$where=array();
		$keyword=I($this->keyword,false);
		if($keyword!==false){
			$where[$this->keyword]=array('like',"%{$keyword}%");	
		}
		$order=$this->pk." desc";
		$count=$m->where($where)->count();
		$page       = new \source\Page($count,20); //3.2
		$nowPage = I("p",1);
		$this->page  = $page->show();
		$this->list=$m->order($order)->where($where)->page($nowPage.','.$page->listRows)->select();
		$this->display('index');
		
		
    }
	
	
	
	//添加
	public function add(){
		$m = D($this->model);
		if(IS_POST){
			//数据准备
			$m->create();
			$m->add();
			$this->redirect('index');
		}else{
			$this->display('index');
		}
	}
	
	//修改
	public function mod($id){
		$m = D($this->model);
		if(IS_POST){
			//数据准备
			$m->create();
			$m->save();
			$this->redirect('index');
		}else{
			$where[$this->pk]=$id;
			$this->modval = $m->where($where)->find();
			$this->display('index');
		}
	}
	
	//删除我的推广信息
	public function del($ids){
		//数据准备
		$m = D($this->model);
		$where[$this->pk]=array('in',$ids);
		$m->where($where)->delete();
		$this->redirect('index');
	}

}