<?php


namespace admin\controller;

/**
 * 模型数据管理控制器

 */
class Goods extends Admin {
	
	private $model="Home/Goods"; //模型名称  /********注意修改模型名称********/
	private $pk="id"; //主键名称  
	private $keyword="name"; //主键名称  

    /**
     * 显示指定模型列表数据
     * @param  String $model 模型标识
    
     */
    public function lists(){

		$m=D($this->model);
		$where=array();
		$keyword=I($this->keyword,false);
		if($keyword!==false){
			$where[$this->keyword]=array('like',"%{$keyword}%");	
		}
		$order=$this->pk." desc";
		$count=$m->where($where)->count();
		$page       = new \source\Page($count,20); //3.2
		$nowPage = I("p",1);
		$this->page  = $page->show();
		$this->list=$m->order($order)->where($where)->page($nowPage.','.$page->listRows)->select();
		$this->display();
		
		
    }

    public function del($ids){
		//数据准备
		$m = D($this->model);
		$where[$this->pk]=array('in',$ids);
		$m->where($where)->delete();
		$this->redirect('lists');
	}

	public function mod($id){
		$m = D($this->model);
		if(IS_POST){
			if($m->create()){
				$m->save();
				$data=I('goods_attrvalue');
	        	$attr_id=$data['attr_id'];
				$datalist=array();
				foreach ($attr_id as $k => $v) {
					$datalist[]=array(
						'goods_id'=>$id,
						'attr_id'=>$v,
						'value'=>$data['value'][$k],
						'price'=>$data['price'][$k],
					);
				}
				D('Home/GoodsAttrvalue')->addAll($datalist);
				$this->redirect('lists');
			}
		}else{
			
			//产品价格属性
			$where=array(
				'a.goods_id'=>$id
			);
			$m_goods_attrvalue_view=D('Home/GoodsAttrvalueView');
			$m_goods_attrvalue_view->viewFields  =  array(
				'goods_attrvalue'=>array('_as'=>'a',"id"=>'attrvalue_id','value','price'),
				'goods_attr'=>array('_as'=>'b','_on'=>'a.attr_id=b.id','id','name','input_type','attr_type','attr_values'),
			);
			$list_goods_attr_price=$m_goods_attrvalue_view->where($where)->group('attr_id')->select();
			foreach ($list_goods_attr_price as $k => &$v) {
				$where=array(
					'goods_id'=>$id,
					'attr_id'=>$v['id']
				);
				$v['list']=D('Home/GoodsAttrvalue')->where($where)->select();
				foreach ($v['list'] as $k1 => &$v1) {
					$v1['attr_values']=preg_split("/[,\r\n]+/s", $v['attr_values'],-1,PREG_SPLIT_NO_EMPTY);
				}
			}
			$this->list_goods_attr_price=$list_goods_attr_price;
			
			$where=array(
				'id'=>$id
			);
			$this->modval = $m->where($where)->find();
			$this->display();
		}
	}
    
	
    public function edit($model = null, $id = 0){
    	
        //获取模型信息
        $model = M('Model')->find($model);
        $model || $this->error('模型不存在！');

        if(IS_POST){
            $Model  =   D(parse_name(get_table_name($model['id']),1));
            // 获取模型的字段信息
            $Model  =   $this->checkAttr($Model,$model['id']);
            if($Model->create() && $Model->save()){
                $this->success('保存'.$model['title'].'成功！', U('lists?model='.$model['name']));
            } else {
                $this->error($Model->getError());
            }
        } else {
            $fields     = get_model_attribute($model['id']);

            //获取数据
            $data       = M(get_table_name($model['id']))->find($id);
            $data || $this->error('数据不存在！');

            $this->assign('model', $model);
            $this->assign('fields', $fields);
            $this->assign('data', $data);
            $this->meta_title = '编辑'.$model['title'];
            $this->display($model['template_edit']?$model['template_edit']:'');
        }
    }

    public function add(){
        $m = D($this->model);
		if(IS_POST){
			if($m->create()){
			    $id=$m->add();
				$data=I('goods_attrvalue');
	        	$attr_id=$data['attr_id'];
				$datalist=array();
				foreach ($attr_id as $k => $v) {
					$datalist[]=array(
						'goods_id'=>$id,
						'attr_id'=>$v,
						'value'=>$data['value'][$k],
						'price'=>$data['price'][$k],
					);
				}
				D('Home/GoodsAttrvalue')->addAll($datalist);
				$this->redirect('lists');
			}else{
				$this->error($m->getError());
			}
		}else{
			$this->display();
		}
    }
	
	public function attr_price($id){
		$m=D('GoodsAttrvalue');
		$data=array(
			'id'=>$id,
			'price'=>I('price')
		);
		if($m->create($data)){
		    $m->save();
		}
	}
	
	public function attr_price_del($id){
		$m=D('GoodsAttrvalue');
		$where=array(
			'id'=>$id,
		);
		$m->where($where)->delete();
	}
	
}