<?php


namespace admin\controller;

/**
 * 模型数据管理控制器

 */
class Think extends Admin {
	
	protected function _initialize(){
		parent::_initialize();
		$category_id=I('category_id',false);
		if($category_id){
		    //获取分类信息
			$this->category=M('Category')->cache(true)->find($category_id);
		}
    }
	
    /**
     * 显示指定模型列表数据
     * @param  String $model 模型标识
    
     */
    public function lists($model = null, $p = 0){
    	cookie('gourl',$_SERVER['REQUEST_URI']);
    	$this->category=M('Category')->find(I('category_id'));
        $model || $this->error('模型名标识必须！');
        $page = intval($p);
        $page = $page ? $page : 1; //默认显示第一页数据

        //获取模型信息
        $model = M('Model')->getByName($model);
        $model || $this->error('模型不存在！');

        //解析列表规则
        $fields = array();
		if(!empty($this->category['list_grid'])){
		    $model['list_grid']=$this->category['list_grid'];
		}
        $grids  = preg_split('/[;\r\n]+/s', trim($model['list_grid']),-1,PREG_SPLIT_NO_EMPTY);
        foreach ($grids as &$value) {
        	if(trim($value) === ''){
        		continue;
        	}
            // 字段:标题:链接:宽度
            $val      = explode(':', $value);
            // 支持多个字段显示
            $field   = explode(',', $val[0]);
            $value    = array('field' => $field, 'title' => $val[1],'width'=>$val[3],'align'=>$val[4]);
            if(isset($val[2])){
                // 链接信息
                $value['href']	=	$val[2];
                // 搜索链接信息中的字段信息
                preg_replace_callback('/\[([a-z_]+)\]/', function($match) use(&$fields){$fields[]=$match[1];}, $value['href']);
            }
            if(strpos($val[1],'|')){
                // 显示格式定义
                list($value['title'],$value['format'])    =   explode('|',$val[1]);
            }
            foreach($field as $val){
                $array	=	explode('|',$val);
                $fields[] = $array[0];
            }
			
        }
        // 过滤重复字段信息
        $fields =   array_unique($fields);
		//搜索
		if(!empty($this->category['list_grid_search'])){
			$model['list_grid_search']=$this->category['list_grid_search'];
		}
		$list_grid_search=preg_split("/[\r\n]+/s", $model['list_grid_search'],-1,PREG_SPLIT_NO_EMPTY);
		foreach($list_grid_search as $k=>&$v){
			$v=preg_split("/[\|]+/s", $v,-1,PREG_SPLIT_NO_EMPTY);
			if($v[1]=='position' && $_REQUEST[$v[0]]>0){
				$map['_string']='position & '.$_REQUEST['position'];
			}else if($v[1]=='like' && !empty($_REQUEST[$v[0]])){
				$map[$v[0]]=array('like','%'.$_REQUEST[$v[0]].'%');
			}else if($v[1]=='find_in_set' && !empty($_REQUEST[$v[0]])){
				$map[$v[0]]=array('find_in_set',$_REQUEST[$v[0]]);
			}else if($v[1]=='eq' && !empty($_REQUEST[$v[0]])){
				$map[$v[0]]=array('eq',$_REQUEST[$v[0]]);
			}
		}
		
		$category_id=I('category_id','');
		if(!empty($category_id)){
		    $map['category_id']=$category_id;
		}
        $row    = C('LIST_ROWS');

        //读取模型数据列表
        if($model['extend']){
            $name   = get_table_name($model['id']);
            $parent = get_table_name($model['extend']);
            $fix    = C("DB_PREFIX");

            $key = array_search('id', $fields);
            if(false === $key){
                array_push($fields, "{$fix}{$parent}.id as id");
            } else {
                $fields[$key] = "{$fix}{$parent}.id as id";
            }

            /* 查询记录数 */
            $count = M($parent)->join("INNER JOIN {$fix}{$name} ON {$fix}{$parent}.id = {$fix}{$name}.id")->where($map)->count();

            // 查询数据
            $data   = M($parent)
                ->join("INNER JOIN {$fix}{$name} ON {$fix}{$parent}.id = {$fix}{$name}.id")
                /* 查询指定字段，不指定则查询所有字段 */
                ->field(empty($fields) ? true : $fields)
                // 查询条件
                ->where($map)
                /* 默认通过id逆序排列 */
                ->order("{$fix}{$parent}.id DESC")
                /* 数据分页 */
                ->page($page, $row)
                /* 执行查询 */
                ->select();

        } else {
            if($model['need_pk']){
                in_array('id', $fields) || array_push($fields, 'id');
            }
            $name = parse_name(get_table_name($model['id']), true);
            $data = M($name)
                /* 查询指定字段，不指定则查询所有字段 */
                ->field(empty($fields) ? true : $fields)
                // 查询条件
                ->where($map)
                /* 默认通过id逆序排列 */
                ->order($model['need_pk']?'id DESC':'')
                /* 数据分页 */
                ->page($page, $row)
                /* 执行查询 */
                ->select();

            /* 查询记录总数 */
            $count = M($name)->where($map)->count();
        }

        //分页
        if($count > $row){
            $page = new \source\Page($count, $row);
            $page->setConfig('theme','%HEADER% %FIRST% %UP_PAGE% %LINK_PAGE% %DOWN_PAGE% %END%');
            $this->assign('_page', $page->show());
        }

        $data   =   $this->parseDocumentList($data,$model['id']);
        $this->assign('model', $model);
        $this->assign('list_grids', $grids);
        $this->assign('list_data', $data);
        $this->meta_title = $model['title'].'列表';
        $this->display($model['template_list']);
    }

    public function del($model = null, $ids=null){
        $model = M('Model')->find($model);
        $model || $this->error('模型不存在！');

        $ids = array_unique((array)I('ids',0));

        if ( empty($ids) ) {
            $this->error('请选择要操作的数据!');
        }

        $Model = M(get_table_name($model['id']));
        $map = array('id' => array('in', $ids) );
        if($Model->where($map)->delete()){
            $this->success('删除成功');
        } else {
            $this->error('删除失败！');
        }
    }

    /**
     * 设置一条或者多条数据的状态
     * @author huajie <banhuajie@163.com>
     */
    public function setStatus($model='Document'){
        return parent::setStatus($model);
    }
    
    public function edit($model = null, $id = 0){
        //获取模型信息
        $model = M('Model')->find($model);
        $model || $this->error('模型不存在！');

        if(IS_POST){
            $Model  =   D(parse_name(get_table_name($model['id']),1));
            // 获取模型的字段信息
            $Model  =   $this->checkAttr($Model,$model['id']);
            if($Model->create() && $Model->save()){
            	header("location:".cookie('gourl'));
            	//$this->redirect('lists?model='.$model['name']);
                //$this->success('保存'.$model['title'].'成功！', U('lists?model='.$model['name']));
            } else {
                $this->error($Model->getError());
            }
        } else {
            $fields     = get_model_attribute($model['id']);

            //获取数据
            $data       = M(get_table_name($model['id']))->find($id);
            $data || $this->error('数据不存在！');
			
			if($data['category_id']){
			    //获取分类信息
				$this->category=M('Category')->cache(true)->find($data['category_id']);
			}
			
            $this->assign('model', $model);
            $this->assign('fields', $fields);
            $this->assign('data', $data);
            $this->meta_title = '编辑'.$model['title'];
            $this->display($model['template_edit']?$model['template_edit']:'');
        }
    }

    public function add($model = null){
    	$this->category=M('Category')->find(I('category_id'));
        //获取模型信息
        $model = M('Model')->where(array('status' => 1))->find($model);
        $model || $this->error('模型不存在！');
        if(IS_POST){
            $Model  =   D(parse_name(get_table_name($model['id']),1));
            // 获取模型的字段信息
            $Model  =   $this->checkAttr($Model,$model['id']);
            if($Model->create() && $Model->add()){
                header("location:".cookie('gourl'));
                //$this->success('添加'.$model['title'].'成功！', U('lists?model='.$model['name'].'&category_id='.I('category_id')));
            } else {
                $this->error($Model->getError());
            }
        } else {

            $fields = get_model_attribute($model['id']);

            $this->assign('model', $model);
            $this->assign('fields', $fields);
            $this->meta_title = '新增'.$model['title'];
            $this->display($model['template_add']?$model['template_add']:'');
        }
    }

    protected function checkAttr($Model,$model_id){
        $fields     =   get_model_attribute($model_id,false);
        $validate   =   $auto   =   array();
        foreach($fields as $key=>$attr){
            if($attr['is_must']){// 必填字段
                $validate[]  =  array($attr['name'],'require',$attr['title'].'必须!');
            }
            // 自动验证规则
            if(!empty($attr['validate_rule'])) {
                $validate[]  =  array($attr['name'],$attr['validate_rule'],$attr['error_info']?$attr['error_info']:$attr['title'].'验证错误',0,$attr['validate_type'],$attr['validate_time']);
            }
            // 自动完成规则
            if(!empty($attr['auto_rule'])) {
                $auto[]  =  array($attr['name'],$attr['auto_rule'],$attr['auto_time'],$attr['auto_type']);
            }elseif('checkbox'==$attr['type']){ // 多选型
                $auto[] =   array($attr['name'],'arr2str',3,'function');
            }
        }
        return $Model->validate($validate)->auto($auto);
    }

	public function attr_price($id){
		$m=D('GoodsAttrvalue');
		$data=array(
			'id'=>$id,
			'price'=>I('price')
		);
		if($m->create($data)){
		    $m->save();
		}
	}
	
	public function attr_price_del($id){
		$m=D('GoodsAttrvalue');
		$where=array(
			'id'=>$id,
		);
		$m->where($where)->delete();
	}
}