<?php

/**
 * 106云盘自动发卡平台网盘系统
 * ============================================================================
 * 版权所有 2016-2028 扎兰屯市姝妍计算机服务有限公司，并保留所有权利。
 * 网站地址: http://www.106ym.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 */
function is_login(){
    $user = session('user_auth');
    if (empty($user)) {
        return 0;
    } else {
        return session('user_auth_sign') == data_auth_sign($user) ? $user['id'] : 0;
    }
}

/**
 * 检测当前用户是否为管理员
 * @return boolean true-管理员，false-非管理员

 */
function is_administrator($uid = null){
    $uid = is_null($uid) ? is_login() : $uid;
    return $uid && (intval($uid) === C('USER_ADMINISTRATOR'));
}

/**
 * 字符串转换为数组，主要用于把分隔符调整到第二个参数
 * @param  string $str  要分割的字符串
 * @param  string $glue 分割符
 * @return array

 */
function str2arr($str, $glue = ','){
    return explode($glue, $str);
}

/**
 * 数组转换为字符串，主要用于把分隔符调整到第二个参数
 * @param  array  $arr  要连接的数组
 * @param  string $glue 分割符
 * @return string

 */
function arr2str($arr, $glue = ','){
    return implode($glue, $arr);
}

/**
 * 字符串截取，支持中文和其他编码
 * @static
 * @access public
 * @param string $str 需要转换的字符串
 * @param string $start 开始位置
 * @param string $length 截取长度
 * @param string $charset 编码格式
 * @param string $suffix 截断显示字符
 * @return string
 */
function msubstr($str, $start=0, $length, $charset="utf-8", $suffix=true) {
    if(function_exists("mb_substr"))
        $slice = mb_substr($str, $start, $length, $charset);
    elseif(function_exists('iconv_substr')) {
        $slice = iconv_substr($str,$start,$length,$charset);
        if(false === $slice) {
            $slice = '';
        }
    }else{
        $re['utf-8']   = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
        $re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
        $re['gbk']    = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
        $re['big5']   = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
        preg_match_all($re[$charset], $str, $match);
        $slice = join("",array_slice($match[0], $start, $length));
    }
	if(strlen($str)>strlen($slice)){
		return $suffix ? $slice.'...' : $slice;
	}else{
		return $slice;
	}
    
}

/**
 * 系统加密方法
 * @param string $data 要加密的字符串
 * @param string $key  加密密钥
 * @param int $expire  过期时间 单位 秒
 * @return string

 */
function think_encrypt($data, $key = '', $expire = 0) {
    $key  = md5(empty($key) ? C('DATA_AUTH_KEY') : $key);
    $data = base64_encode($data);
    $x    = 0;
    $len  = strlen($data);
    $l    = strlen($key);
    $char = '';

    for ($i = 0; $i < $len; $i++) {
        if ($x == $l) $x = 0;
        $char .= substr($key, $x, 1);
        $x++;
    }

    $str = sprintf('%010d', $expire ? $expire + time():0);

    for ($i = 0; $i < $len; $i++) {
        $str .= chr(ord(substr($data, $i, 1)) + (ord(substr($char, $i, 1)))%256);
    }
    return str_replace(array('+','/','='),array('-','_',''),base64_encode($str));
}

/**
 * 系统解密方法
 * @param  string $data 要解密的字符串 （必须是think_encrypt方法加密的字符串）
 * @param  string $key  加密密钥
 * @return string

 */
function think_decrypt($data, $key = ''){
    $key    = md5(empty($key) ? C('DATA_AUTH_KEY') : $key);
    $data   = str_replace(array('-','_'),array('+','/'),$data);
    $mod4   = strlen($data) % 4;
    if ($mod4) {
       $data .= substr('====', $mod4);
    }
    $data   = base64_decode($data);
    $expire = substr($data,0,10);
    $data   = substr($data,10);

    if($expire > 0 && $expire < time()) {
        return '';
    }
    $x      = 0;
    $len    = strlen($data);
    $l      = strlen($key);
    $char   = $str = '';

    for ($i = 0; $i < $len; $i++) {
        if ($x == $l) $x = 0;
        $char .= substr($key, $x, 1);
        $x++;
    }

    for ($i = 0; $i < $len; $i++) {
        if (ord(substr($data, $i, 1))<ord(substr($char, $i, 1))) {
            $str .= chr((ord(substr($data, $i, 1)) + 256) - ord(substr($char, $i, 1)));
        }else{
            $str .= chr(ord(substr($data, $i, 1)) - ord(substr($char, $i, 1)));
        }
    }
    return base64_decode($str);
}

/**
 * 数据签名认证
 * @param  array  $data 被认证的数据
 * @return string       签名

 */
function data_auth_sign($data) {
    //数据类型检测
    if(!is_array($data)){
        $data = (array)$data;
    }
    ksort($data); //排序
    $code = http_build_query($data); //url编码并生成query字符串
    $sign = sha1($code); //生成签名
    return $sign;
}

/**
* 对查询结果集进行排序
* @access public
* @param array $list 查询结果
* @param string $field 排序的字段名
* @param array $sortby 排序类型
* asc正向排序 desc逆向排序 nat自然排序
* @return array
*/
function list_sort_by($list,$field, $sortby='asc') {
   if(is_array($list)){
       $refer = $resultSet = array();
       foreach ($list as $i => $data)
           $refer[$i] = &$data[$field];
       switch ($sortby) {
           case 'asc': // 正向排序
                asort($refer);
                break;
           case 'desc':// 逆向排序
                arsort($refer);
                break;
           case 'nat': // 自然排序
                natcasesort($refer);
                break;
       }
       foreach ( $refer as $key=> $val)
           $resultSet[] = &$list[$key];
       return $resultSet;
   }
   return false;
}

/**
 * 把返回的数据集转换成Tree
 * @param array $list 要转换的数据集
 * @param string $pid parent标记字段
 * @param string $level level标记字段
 * @return array

 */
function list_to_tree($list, $pk='id', $pid = 'pid', $child = '_child', $root = 0) {
    // 创建Tree
    $tree = array();
    if(is_array($list)) {
        // 创建基于主键的数组引用
        $refer = array();
        foreach ($list as $key => $data) {
            $refer[$data[$pk]] =& $list[$key];
        }
        foreach ($list as $key => $data) {
            // 判断是否存在parent
            $parentId =  $data[$pid];
            if ($root == $parentId) {
                $tree[] =& $list[$key];
            }else{
                if (isset($refer[$parentId])) {
                    $parent =& $refer[$parentId];
                    $parent[$child][] =& $list[$key];
                }
            }
        }
    }
    return $tree;
}

/**
 * 将list_to_tree的树还原成列表
 * @param  array $tree  原来的树
 * @param  string $child 孩子节点的键
 * @param  string $order 排序显示的键，一般是主键 升序排列
 * @param  array  $list  过渡用的中间数组，
 * @return array        返回排过序的列表数组
 * @author yangweijie <yangweijiester@gmail.com>
 */
function tree_to_list($tree, $child = '_child', $order='id', &$list = array()){
    if(is_array($tree)) {
        foreach ($tree as $key => $value) {
            $reffer = $value;
            if(isset($reffer[$child])){
                unset($reffer[$child]);
                tree_to_list($value[$child], $child, $order, $list);
            }
            $list[] = $reffer;
        }
        $list = list_sort_by($list, $order, $sortby='asc');
    }
    return $list;
}

/**
 * 格式化字节大小
 * @param  number $size      字节数
 * @param  string $delimiter 数字和单位分隔符
 * @return string            格式化后的带单位的大小

 */
function format_bytes($size, $delimiter = '') {
    $units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB');
    for ($i = 0; $size >= 1024 && $i < 5; $i++) $size /= 1024;
    return round($size, 2) . $delimiter . $units[$i];
}

/**
 * 设置跳转页面URL
 * 使用函数再次封装，方便以后选择不同的存储方式（目前使用cookie存储）

 */
function set_redirect_url($url){
    cookie('redirect_url', $url);
}

/**
 * 获取跳转页面URL
 * @return string 跳转页URL

 */
function get_redirect_url(){
    $url = cookie('redirect_url');
    return empty($url) ? __APP__ : $url;
}

/**
 * 处理插件钩子
 * @param string $hook   钩子名称
 * @param mixed $params 传入参数
 * @return void
 */
function hook($hook,$params=array()){
    \Think\Hook::listen($hook,$params);
}

/**
 * 获取插件类的类名
 * @param strng $name 插件名
 */
function get_addon_class($name){
    $class = "Addons\\{$name}\\{$name}Addon";
    return $class;
}

/**
 * 获取插件类的配置文件数组
 * @param string $name 插件名
 */
function get_addon_config($name){
    $class = get_addon_class($name);
    if(class_exists($class)) {
        $addon = new $class();
        return $addon->getconfig();
    }else {
        return array();
    }
}

/**
 * 插件显示内容里生成访问插件的url
 * @param string $url url
 * @param array $param 参数

 */
function addons_url($url, $param = array()){
    $url        = parse_url($url);
    $case       = C('URL_CASE_INSENSITIVE');
    $addons     = $case ? parse_name($url['scheme']) : $url['scheme'];
    $controller = $case ? parse_name($url['host']) : $url['host'];
    $action     = trim($case ? strtolower($url['path']) : $url['path'], '/');

    /* 解析URL带的参数 */
    if(isset($url['query'])){
        parse_str($url['query'], $query);
        $param = array_merge($query, $param);
    }

    /* 基础参数 */
    $params = array(
        '_addons'     => $addons,
        '_controller' => $controller,
        '_action'     => $action,
    );
    $params = array_merge($params, $param); //添加额外参数

    return U('Addons/execute', $params);
}

/**
 * 时间戳格式化
 * @param int $time
 * @return string 完整的时间显示
 * @author huajie <banhuajie@163.com>
 */
function time_format($time = NULL,$format='Y-m-d H:i'){
    $time = $time === NULL ? NOW_TIME : intval($time);
    return date($format, $time);
}

/**
 * 根据用户ID获取用户名
 * @param  integer $uid 用户ID
 * @return string       用户名
 */
function get_username($uid = 0){
    static $list;
    if(!($uid && is_numeric($uid))){ //获取当前登录用户名
        return session('user_auth.username');
    }

    /* 获取缓存数据 */
    if(empty($list)){
        $list = S('sys_active_user_list');
    }

    /* 查找用户信息 */
    $key = "u{$uid}";
    if(isset($list[$key])){ //已缓存，直接使用
        $name = $list[$key];
    } else { //调用接口获取用户信息
        $User = new User\Api\UserApi();
        $info = $User->info($uid);
        if($info && isset($info[1])){
            $name = $list[$key] = $info[1];
            /* 缓存用户 */
            $count = count($list);
            $max   = C('USER_MAX_CACHE');
            while ($count-- > $max) {
                array_shift($list);
            }
            S('sys_active_user_list', $list);
        } else {
            $name = '';
        }
    }
    return $name;
}

/**
 * 根据用户ID获取用户昵称
 * @param  integer $uid 用户ID
 * @return string       用户昵称
 */
function get_nickname($uid = 0){
    static $list;
    if(!($uid && is_numeric($uid))){ //获取当前登录用户名
        return session('user_auth.username');
    }

    /* 获取缓存数据 */
    if(empty($list)){
        $list = S('sys_user_nickname_list');
    }

    /* 查找用户信息 */
    $key = "u{$uid}";
    if(isset($list[$key])){ //已缓存，直接使用
        $name = $list[$key];
    } else { //调用接口获取用户信息
        $info = M('Member')->field('nickname')->find($uid);
        if($info !== false && $info['nickname'] ){
            $nickname = $info['nickname'];
            $name = $list[$key] = $nickname;
            /* 缓存用户 */
            $count = count($list);
            $max   = C('USER_MAX_CACHE');
            while ($count-- > $max) {
                array_shift($list);
            }
            S('sys_user_nickname_list', $list);
        } else {
            $name = '';
        }
    }
    return $name;
}

/**
 * 获取分类信息并缓存分类
 * @param  integer $id    分类ID
 * @param  string  $field 要获取的字段名
 * @return string         分类信息
 */
function get_category($id, $field = null){
    static $list;

    /* 非法分类ID */
    if(empty($id) || !is_numeric($id)){
        return '';
    }

    /* 读取缓存数据 */
    if(empty($list)){
        $list = S('sys_category_list');
    }

    /* 获取分类名称 */
    if(!isset($list[$id])){
        $cate = M('Category')->find($id);
        if(!$cate || 1 != $cate['status']){ //不存在分类，或分类被禁用
            return '';
        }
        $list[$id] = $cate;
        S('sys_category_list', $list); //更新缓存
    }
    return is_null($field) ? $list[$id] : $list[$id][$field];
}

/* 根据ID获取分类标识 */
function get_category_name($id){
    return get_category($id, 'name');
}

/* 根据ID获取分类名称 */
function get_category_title($id){
    return get_category($id, 'title');
}

/**
 * 获取顶级模型信息
 */
function get_top_model($model_id=null){
    $map   = array('status' => 1, 'extend' => 0);
    if(!is_null($model_id)){
        $map['id']  =   array('neq',$model_id);
    }
    $model = M('Model')->where($map)->field(true)->select();
    foreach ($model as $value) {
        $list[$value['id']] = $value;
    }
    return $list;
}

/**
 * 获取文档模型信息
 * @param  integer $id    模型ID
 * @param  string  $field 模型字段
 * @return array
 */
function get_document_model($id = null, $field = null){
    static $list;

    /* 非法分类ID */
    if(!(is_numeric($id) || is_null($id))){
        return '';
    }

    /* 读取缓存数据 */
    if(empty($list)){
        $list = S('DOCUMENT_MODEL_LIST');
    }

    /* 获取模型名称 */
    if(empty($list)){
       // $map   = array('status' => 1, 'extend' => 1);
		$map   = array('status' => 1);
        $model = M('Model')->where($map)->field(true)->select();
        foreach ($model as $value) {
            $list[$value['id']] = $value;
        }
        S('DOCUMENT_MODEL_LIST', $list); //更新缓存
    }

    /* 根据条件返回数据 */
    if(is_null($id)){
        return $list;
    } elseif(is_null($field)){
        return $list[$id];
    } else {
        return $list[$id][$field];
    }
}

/**
 * 解析UBB数据
 * @param string $data UBB字符串
 * @return string 解析为HTML的数据

 */
function ubb($data){
    //TODO: 待完善，目前返回原始数据
    return $data;
}

/**
 * 记录行为日志，并执行该行为的规则
 * @param string $action 行为标识
 * @param string $model 触发行为的模型名
 * @param int $record_id 触发行为的记录id
 * @param int $user_id 执行行为的用户id
 * @return boolean
 * @author huajie <banhuajie@163.com>
 */
function action_log($action = null, $model = null, $record_id = null, $user_id = null){

    //参数检查
    if(empty($action) || empty($model) || empty($record_id)){
        return '参数不能为空';
    }
    if(empty($user_id)){
        $user_id = is_login();
    }

    //查询行为,判断是否执行
    $action_info = M('Action')->getByName($action);
    if($action_info['status'] != 1){
        return '该行为被禁用或删除';
    }

    //插入行为日志
    $data['action_id']      =   $action_info['id'];
    $data['user_id']        =   $user_id;
    $data['action_ip']      =   ip2long(get_client_ip());
    $data['model']          =   $model;
    $data['record_id']      =   $record_id;
    $data['create_time']    =   NOW_TIME;

    //解析日志规则,生成日志备注
    if(!empty($action_info['log'])){
        if(preg_match_all('/\[(\S+?)\]/', $action_info['log'], $match)){
            $log['user']    =   $user_id;
            $log['record']  =   $record_id;
            $log['model']   =   $model;
            $log['time']    =   NOW_TIME;
            $log['data']    =   array('user'=>$user_id,'model'=>$model,'record'=>$record_id,'time'=>NOW_TIME);
            foreach ($match[1] as $value){
                $param = explode('|', $value);
                if(isset($param[1])){
                    $replace[] = call_user_func($param[1],$log[$param[0]]);
                }else{
                    $replace[] = $log[$param[0]];
                }
            }
            $data['remark'] =   str_replace($match[0], $replace, $action_info['log']);
        }else{
            $data['remark'] =   $action_info['log'];
        }
    }else{
        //未定义日志规则，记录操作url
        $data['remark']     =   '操作url：'.$_SERVER['REQUEST_URI'];
    }

    M('ActionLog')->add($data);

    if(!empty($action_info['rule'])){
        //解析行为
        $rules = parse_action($action, $user_id);

        //执行行为
        $res = execute_action($rules, $action_info['id'], $user_id);
    }
}

/**
 * 解析行为规则
 * 规则定义  table:$table|field:$field|condition:$condition|rule:$rule[|cycle:$cycle|max:$max][;......]
 * 规则字段解释：table->要操作的数据表，不需要加表前缀；
 *              field->要操作的字段；
 *              condition->操作的条件，目前支持字符串，默认变量{$self}为执行行为的用户
 *              rule->对字段进行的具体操作，目前支持四则混合运算，如：1+score*2/2-3
 *              cycle->执行周期，单位（小时），表示$cycle小时内最多执行$max次
 *              max->单个周期内的最大执行次数（$cycle和$max必须同时定义，否则无效）
 * 单个行为后可加 ； 连接其他规则
 * @param string $action 行为id或者name
 * @param int $self 替换规则里的变量为执行用户的id
 * @return boolean|array: false解析出错 ， 成功返回规则数组
 * @author huajie <banhuajie@163.com>
 */
function parse_action($action = null, $self){
    if(empty($action)){
        return false;
    }

    //参数支持id或者name
    if(is_numeric($action)){
        $map = array('id'=>$action);
    }else{
        $map = array('name'=>$action);
    }

    //查询行为信息
    $info = M('Action')->where($map)->find();
    if(!$info || $info['status'] != 1){
        return false;
    }

    //解析规则:table:$table|field:$field|condition:$condition|rule:$rule[|cycle:$cycle|max:$max][;......]
    $rules = $info['rule'];
    $rules = str_replace('{$self}', $self, $rules);
    $rules = explode(';', $rules);
    $return = array();
    foreach ($rules as $key=>&$rule){
        $rule = explode('|', $rule);
        foreach ($rule as $k=>$fields){
            $field = empty($fields) ? array() : explode(':', $fields);
            if(!empty($field)){
                $return[$key][$field[0]] = $field[1];
            }
        }
        //cycle(检查周期)和max(周期内最大执行次数)必须同时存在，否则去掉这两个条件
        if(!array_key_exists('cycle', $return[$key]) || !array_key_exists('max', $return[$key])){
            unset($return[$key]['cycle'],$return[$key]['max']);
        }
    }

    return $return;
}

/**
 * 执行行为
 * @param array $rules 解析后的规则数组
 * @param int $action_id 行为id
 * @param array $user_id 执行的用户id
 * @return boolean false 失败 ， true 成功
 * @author huajie <banhuajie@163.com>
 */
function execute_action($rules = false, $action_id = null, $user_id = null){
    if(!$rules || empty($action_id) || empty($user_id)){
        return false;
    }

    $return = true;
    foreach ($rules as $rule){

        //检查执行周期
        $map = array('action_id'=>$action_id, 'user_id'=>$user_id);
        $map['create_time'] = array('gt', NOW_TIME - intval($rule['cycle']) * 3600);
        $exec_count = M('ActionLog')->where($map)->count();
        if($exec_count > $rule['max']){
            continue;
        }

        //执行数据库操作
        $Model = M(ucfirst($rule['table']));
        $field = $rule['field'];
        $res = $Model->where($rule['condition'])->setField($field, array('exp', $rule['rule']));

        if(!$res){
            $return = false;
        }
    }
    return $return;
}

//基于数组创建目录和文件
function create_dir_or_files($files){
    foreach ($files as $key => $value) {
        if(substr($value, -1) == '/'){
            mkdir($value);
        }else{
            @file_put_contents($value, '');
        }
    }
}

if(!function_exists('array_column')){
    function array_column(array $input, $columnKey, $indexKey = null) {
        $result = array();
        if (null === $indexKey) {
            if (null === $columnKey) {
                $result = array_values($input);
            } else {
                foreach ($input as $row) {
                    $result[] = $row[$columnKey];
                }
            }
        } else {
            if (null === $columnKey) {
                foreach ($input as $row) {
                    $result[$row[$indexKey]] = $row;
                }
            } else {
                foreach ($input as $row) {
                    $result[$row[$indexKey]] = $row[$columnKey];
                }
            }
        }
        return $result;
    }
}

/**
 * 获取表名（不含表前缀）
 * @param string $model_id
 * @return string 表名
 * @author huajie <banhuajie@163.com>
 */
function get_table_name($model_id = null){
    if(empty($model_id)){
        return false;
    }
    $Model = M('Model');
    $name = '';
    $info = $Model->getById($model_id);
    if($info['extend'] != 0){
        $name = $Model->getFieldById($info['extend'], 'name').'_';
    }
    $name .= $info['name'];
    return $name;
}

/**
 * 获取属性信息并缓存
 * @param  integer $id    属性ID
 * @param  string  $field 要获取的字段名
 * @return string         属性信息
 */
function get_model_attribute($model_id, $group = true,$fields=true){
    static $list;

    /* 非法ID */
    if(empty($model_id) || !is_numeric($model_id)){
        return '';
    }

    /* 获取属性 */
    if(!isset($list[$model_id])){
        $map = array('model_id'=>$model_id);
        $extend = M('Model')->getFieldById($model_id,'extend');

        if($extend){
            $map = array('model_id'=> array("in", array($model_id, $extend)));
        }
        $info = M('Attribute')->where($map)->field($fields)->select();
        $list[$model_id] = $info;
    }

    $attr = array();
    if($group){
        foreach ($list[$model_id] as $value) {
            $attr[$value['id']] = $value;
        }
        $model     = M("Model")->field("field_sort,attribute_list,attribute_alias")->find($model_id);
        $attribute = explode(",", $model['attribute_list']);
        if (empty($model['field_sort'])) { //未排序
            $group = array(1 => array_merge($attr));
        } else {
            $group = json_decode($model['field_sort'], true);
            $keys = array_keys($group);
            foreach ($group as &$value) {
                foreach ($value as $key => $val) {
                    $value[$key] = $attr[$val];
                    unset($attr[$val]);
                }
            }

            if (!empty($attr)) {
                foreach ($attr as $key => $val) {
                    if (!in_array($val['id'], $attribute)) {
                        unset($attr[$key]);
                    }
                }
                $group[$keys[0]] = array_merge($group[$keys[0]], $attr);
            }
        }
        if (!empty($model['attribute_alias'])) {
            $alias  = preg_split('/[;\r\n]+/s', $model['attribute_alias']);
            $fields = array();
            foreach ($alias as &$value) {
                $val             = explode(':', $value);
                $fields[$val[0]] = $val[1];
            }
            foreach ($group as &$value) {
                foreach ($value as $key => $val) {
                    if (!empty($fields[$val['name']])) {
                        $value[$key]['title'] = $fields[$val['name']];
                    }
                }
            }
        }
        $attr = $group;
    }else{
        foreach ($list[$model_id] as $value) {
            $attr[$value['name']] = $value;
        }
    }
    return $attr;
}

/**
 * 调用系统的API接口方法（静态方法）
 * api('User/getName','id=5'); 调用公共模块的User接口的getName方法
 * api('Admin/User/getName','id=5');  调用Admin模块的User接口
 * @param  string  $name 格式 [模块名]/接口名/方法名
 * @param  array|string  $vars 参数
 */
function api($name,$vars=array()){
    $array     = explode('/',$name);
    $method    = array_pop($array);
    $classname = array_pop($array);
    $module    = $array? array_pop($array) : 'common';
    $callback  = $module.'\\api\\'.$classname.'Api::'.$method;
    if(is_string($vars)) {
        parse_str($vars,$vars);
    }
    return call_user_func_array($callback,$vars);
}

/**
 * 根据条件字段获取指定表的数据
 * @param mixed $value 条件，可用常量或者数组
 * @param string $condition 条件字段
 * @param string $field 需要返回的字段，不传则返回整个数据
 * @param string $table 需要查询的表
 * @author huajie <banhuajie@163.com>
 */
function get_table_field($value = null, $condition = 'id', $field = null, $table = null){
    if(empty($value) || empty($table)){
        return false;
    }

    //拼接参数
    $map[$condition] = $value;
    $info = M(ucfirst($table))->where($map);
    if(empty($field)){
        $info = $info->field(true)->find();
    }else{
        $info = $info->getField($field);
    }
    return $info;
}

/**
 * 获取链接信息
 * @param int $link_id
 * @param string $field
 * @return 完整的链接信息或者某一字段
 * @author huajie <banhuajie@163.com>
 */
function get_link($link_id = null, $field = 'url'){
    $link = '';
    if(empty($link_id)){
        return $link;
    }
    $link = M('Url')->getById($link_id);
    if(empty($field)){
        return $link;
    }else{
        return $link[$field];
    }
}

/**
 * 获取文档封面图片
 * @param int $cover_id
 * @param string $field
 * @return 完整的数据  或者  指定的$field字段值
 * @author huajie <banhuajie@163.com>
 */
function get_cover($cover_id, $field = null){
    if(empty($cover_id)){
        return false;
    }
    $picture = M('Picture')->where(array('status'=>1))->getById($cover_id);
    if($field == 'path'){
        if(!empty($picture['url'])){
            $picture['path'] = $picture['url'];
        }else{
            $picture['path'] = __ROOT__.$picture['path'];
        }
    }
    return empty($field) ? $picture : $picture[$field];
}

/**
 * 检查$pos(推荐位的值)是否包含指定推荐位$contain
 * @param number $pos 推荐位的值
 * @param number $contain 指定推荐位
 * @return boolean true 包含 ， false 不包含
 * @author huajie <banhuajie@163.com>
 */
function check_document_position($pos = 0, $contain = 0){
    if(empty($pos) || empty($contain)){
        return false;
    }

    //将两个参数进行按位与运算，不为0则表示$contain属于$pos
    $res = $pos & $contain;
    if($res !== 0){
        return true;
    }else{
        return false;
    }
}

/**
 * 生成推荐位的值
 * @return number 推荐位
 */
function _position($position){
    if(!is_array($position)){
        return 0;
    }else{
        $pos = 0;
        foreach ($position as $key=>$value){
            $pos += $value;		//将各个推荐位的值相加
        }
        return $pos;
    }
}

/**
 * 获取数据的所有子孙数据的id值
 * @author 朱亚杰 <xcoolcc@gmail.com>
 */

function get_stemma($pids,Model &$model, $field='id'){
    $collection = array();

    //非空判断
    if(empty($pids)){
        return $collection;
    }

    if( is_array($pids) ){
        $pids = trim(implode(',',$pids),',');
    }
    $result     = $model->field($field)->where(array('pid'=>array('IN',(string)$pids)))->select();
    $child_ids  = array_column ((array)$result,'id');

    while( !empty($child_ids) ){
        $collection = array_merge($collection,$result);
        $result     = $model->field($field)->where( array( 'pid'=>array( 'IN', $child_ids ) ) )->select();
        $child_ids  = array_column((array)$result,'id');
    }
    return $collection;
}

/**
 * 验证分类是否允许发布内容
 * @param  integer $id 分类ID
 * @return boolean     true-允许发布内容，false-不允许发布内容
 */
function check_category($id){
    if (is_array($id)) {
		$id['type']	=	!empty($id['type'])?$id['type']:2;
        $type = get_category($id['category_id'], 'type');
        $type = explode(",", $type);
        return in_array($id['type'], $type);
    } else {
        $publish = get_category($id, 'model_allow');
        return $publish ? true : false;
    }
}

/**
 * 检测分类是否绑定了指定模型
 * @param  array $info 模型ID和分类ID数组
 * @return boolean     true-绑定了模型，false-未绑定模型
 */
function check_category_model($info){
    $cate   =   get_category($info['category_id']);
    $array  =   explode(',', $info['pid'] ? $cate['model_sub'] : $cate['model']);
    return in_array($info['model_id'], $array);
}


/**
* 缓存文件名称
* @copyright 建站宝，问鼎科技旗下专业建站品牌
* @return   返回字符串
**/
if(!function_exists("filecachename")){
	function filecachename(){
		$str=md5(serialize(I()));
		$str=$str{0}.$str{1}.'/'.$str{2}.$str{3}.'/'.$str;
		return $str;
	}
}

/**
* 生成唯一编号
* @return    string
*/
if(!function_exists("wd_no")){
	function wd_no(){
		date_default_timezone_set ('Asia/Shanghai'); 
		$my_t=gettimeofday();
		if($my_t[usec]<100000) $my_t[usec]+=100000;	
		return date("YmdHis").$my_t[usec].rand(100000000,999999999);
	}
}

/**
 * post提交
 * @param     string  $url  提交数据地址，需要用全路径  例如 http://www.a.com
 * @param     object  $data array格式数据
 * @return    string  服务器返回
 */
if(!function_exists("wd_post")){
	function wd_post($url,$data){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		//指定post数据
		curl_setopt($ch, CURLOPT_POST, 1);
		//添加变量
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
		$output = curl_exec($ch);
		curl_close($ch);
		return $output;
	}
}

/****
换行
****/
if(!function_exists('wd_br')){
	function wd_br($str){
		return preg_replace('/[;\r\n]+/s', "<br>",$str);
	}
}

/**
 * 发送HTTP请求方法，目前只支持CURL发送请求
 * @param  string $url    请求URL
 * @param  array  $param  GET参数数组
 * @param  array  $data   POST的数据，GET请求时该参数无效
 * @param  string $method 请求方法GET/POST
 * @param  array $header  请求头
 * @return           响应数据
 */
if(!function_exists('wd_http')){
	function wd_http($url, $param=array(), $data =array(), $method = 'GET',$header=''){
		$opts = array(
	        CURLOPT_TIMEOUT        => 30,
	        CURLOPT_RETURNTRANSFER => 1,
	        CURLOPT_SSL_VERIFYPEER => false,
	        CURLOPT_SSL_VERIFYHOST => false,
	    );
	
	    /* 根据请求类型设置特定参数 */
	    $opts[CURLOPT_URL] = empty($param)?$url:$url . '?' . http_build_query($param);
	
	    if(strtoupper($method) == 'POST'){
	        $opts[CURLOPT_POST] = 1;
	        $opts[CURLOPT_POSTFIELDS] = $data;
	    }
		if($header){
			$header=is_array($header)?$header:array($header);
		    $opts[CURLOPT_HTTPHEADER] = array(
	            'Content-Type: application/json; charset=utf-8',  
	        );
			if(is_string($data)){
			    array_push($opts[CURLOPT_HTTPHEADER],'Content-Length: ' . strlen($data));
			}
			$opts[CURLOPT_HTTPHEADER] = array_merge($opts[CURLOPT_HTTPHEADER], $header);
		}
	    /* 初始化并执行curl请求 */
	    $ch = curl_init();
	    curl_setopt_array($ch, $opts);
	    $data  = curl_exec($ch);
	    $error = curl_error($ch);
	    curl_close($ch);
	
	    return  $data;
	}
}
/**
 * 删除文件夹
 * @param  string $url    请求URL
 * @param  array  $params 请求参数
 * @param  string $method 请求方法GET/POST
 * @return array  $data   响应数据
 */
if(!function_exists('wd_deldir')){
	function wd_deldir($dir)
	{
		//先删除目录下的文件：
		$dh = opendir($dir);
		while ($file = readdir($dh)) {
			if ($file != '.' && $file != '..') {
				$fullpath = $dir . '/' . $file;
				if (!is_dir($fullpath)) {
					unlink($fullpath);
				} else {
					wd_deldir($fullpath);
				}
			}
		}
		closedir($dh);
		//删除当前文件夹：
		if (rmdir($dir)) {
			return true;
		} else {
			return false;
		}
	}
}

/**
 * 返回数组的维度
 * @param  [type] $arr [description]
 * @return [type]      [description]
 */
if(!function_exists('arrayLevel')){
	function arrayLevel($arr){
		$al = array(0);
		function aL($arr,&$al,$level=0){
			if(is_array($arr)){
				$level++;
				$al[] = $level;
				foreach($arr as $v){
					aL($v,$al,$level);
				}
			}
		}
		aL($arr,$al);
		return max($al);
	}
} 



/****
sql
****/
if(!function_exists('wd_sql')){
	function wd_sql($sql){
		$re=M()->query($sql);
		return $re;
	}
}

/****
解析枚举类型数据
$model  模型id
$field  字段名称
示例
<volist name=":wd_parse_field_attr(5,'sptype')" id="v">
			<li <if condition="$_GET[type]==1">class="current"</if>><a href="{:U('Shop/lists?type='.$key.'&id='.I('id'))}">{$v}</a></li>
		</volist>
****/
if(!function_exists('wd_parse_field_attr')){
	function wd_parse_field_attr($model,$field){
		$m=M('attribute');
		$where=array();
		$where['model_id']=$model;
		$where['name']=$field;
		$extra=$m->where($where)->getField('extra');	
		$array = preg_split('/[,;\r\n]+/', trim($extra, ",;\r\n"));
		if(strpos($extra,':')){
			$value  =   array();
			foreach ($array as $val) {
				list($k, $v) = explode(':', $val);
				$value[$k]   = $v;
			}
		}else{
			$value  =   $array;
		}
		return $value;
	}
}

/**
 * @description 解析配置字段，格式为  field:name,title:姓名,remark:姓名可以用中英文
 * @version 1.0.1
 * @author 建站宝  QQ 613600010
 * @param $string 配置字符串
 * @return array
 */
if(!function_exists('get_config_attr')){
	function get_config_attr($string) {
	    $fields = preg_split("/[\r\n]+/s",$string ,-1,PREG_SPLIT_NO_EMPTY);
		if(!strpos($string,':')){
			return $fields;
		}
		$arr=array();
		foreach($fields as $k=>$v){
			$arr1=preg_split("/[,]+/s",$v ,-1,PREG_SPLIT_NO_EMPTY);
			foreach($arr1 as $k1=>$v1){
				$arr2=preg_split("/[\:]+/s",$v1 ,-1,PREG_SPLIT_NO_EMPTY);
				$arr[$k][$arr2[0]]=$arr2[1];
			}
		}
		return $arr;
	}
}

/****
发送短信

$params=array(
	'mobile'=>$mobile,
	'tpl_id'=>3159,
	'tpl_value'=>$tpl_value,
	'key'=>$key,
);

****/
if(!function_exists('wd_sms')){
	function wd_sms($params){
		$key=isset($params['key'])?$params['key']:"4f886712f872ea697a2cd8ee024dc37e";
		$url=isset($params['url'])?$params['url']:"http://v.juhe.cn/sms/send";
		$tpl_value=isset($params['tpl_value'])?$params['tpl_value']:"#code#={$code}";
		$tpl_id=isset($params['tpl_id'])?$params['tpl_id']:0;
		$mobile=isset($params['mobile'])?$params['mobile']:0;

		$params1=array(
			'mobile'=>$mobile,
			'tpl_id'=>$tpl_id,
			'tpl_value'=>urlencode($tpl_value),
			'key'=>$key,
		);
	
		$re=wd_http($url,$params1);
		$re=json_decode($re,true);
		$data=array(
			'status'=>0,
			'msg'=>''
		);
		if($re['error_code']==0){
			$data['status']=1;
			$data['msg']=$re['reason'];
		}else{
			$data['msg']=$re['reason'];	
		}
		return $data;
	}
}


/****
判断是否微信

****/
if(!function_exists('is_weixin')){
	function is_weixin(){
		$user_agent = $_SERVER['HTTP_USER_AGENT'];
		if(strpos($user_agent, 'MicroMessenger') !== false || strpos($user_agent, 'wxwork') !== false){
			return true;
		}else{
			return false;
		}
	}
}



//删除空格
function trimall($str){
    $qian=array(" ","　","\t","\n","\r","&nbsp;");
	$hou=array("","","","","","");
    return str_replace($qian,$hou,$str);    
}


// src=1时 返回src 路径，否则返回img图片标签
if(!function_exists("firstimg")){
	function firstimg($str,$src=0){
		$str1 = str_replace('"','',$str);
		preg_match('/<img[^>]*>/i',$str1,$str2);
		$str3 = array_shift($str2);
		$str4 = str_replace('<img ','',$str3);
		$str5 = '<img '.$str4;
		$str6 = str_replace(' alt= ',' ',$str5);
		if($src){
			preg_match('/src=.*(.jpg|.gif|.png)/i',$str6,$src);
			$src = str_replace('src=','',$src[0]);
			$src = preg_replace('/ .*/','',$src);
			return $src;
		}
		return $str6;
	}
}


/**
 * 获取分类id，含子类
 * @param  integer $id    分类ID
 * @return string         ids串
 */
if(!function_exists("get_category_ids")){
	function get_category_ids($id){
	    /* 非法分类ID */
	    if(empty($id) || !is_numeric($id)){
	        return '';
	    }
		$id_arr=D("Home/category")->where("pid=$id")->getField("id",true);
		if($id_arr){
			foreach ($id_arr as $k => $v) {
				get_category_ids($v);
			}
			$id_arr=array_merge($id_arr,array($id));	
			return   implode(",", $id_arr);
		}else{
			return $id;	
		}
	}
}


/**
* 创建文件夹
* @param     string  文件夹路径，真实物理路径
* @return    string
*/

if(!function_exists("mkdirs")){
	function mkdirs($path){
		if(!is_dir($path)){
			if(mkdirs(dirname($path))){
				mkdir($path,0777);
				return true;
			}
		}else{
			return true;
		}
	}
}


if(!function_exists("wd_img")){
	/**
	 * 图片处理
	 * @param  string  $file 原始图片路径
	 * @param  integer $width    缩略图最大宽度
	 * @param  integer $height   缩略图最大高度
	 * @param  integer $type     缩略图裁剪类型
	 * @param  string $bgcolor  填充背景颜色，默认FFFFFF
	 * @param  string $defaultimg  默认图片路径
	 * @param  string  $water 水印图片路径
	 * @param  integer $locate 水印位置
	 * @param  integer $alpha  水印透明度
	 * @return string          生成后图片路径
	 */
	function wd_img($file,$width,$height,$type=3,$bgcolor="FFFFFF",$make=1,$defaultimg="/wd_plus/sys_images/nophoto.jpg",$water="/data/water/water.png",$locate=5,$alpha=80){
		if(strpos(C('WEB_SITE_STATIC_DOAMIN'),'http')!==false){
			if($type==3){
			    $type=1;
			}else if($type==6){
				$type=3;
			}
			$url= C('WEB_SITE_STATIC_DOAMIN').$file."?imageView2/{$type}/w/{$width}/h/{$height}/q/100/interlace/1";
			header("location:$url");
		}
		if(!is_file(ROOT.$file)){
			$content = file_get_contents($file);
			$hash_path = md5($file);
			$path=ROOT.'/Data/Uploads/'.$hash_path{0}.$hash_path{1}.'/'.$hash_path{2}.$hash_path{3};
			mkdirs($path);
			file_put_contents($path.'/'.md5($file).'.'.pathinfo($file, PATHINFO_EXTENSION), $content);
			$file=$path.'/'.md5($file).'.'.pathinfo($file, PATHINFO_EXTENSION);	
		}else{
			$file=ROOT.$file;
		}
		$water=ROOT.$water;
		if($type==0){
			$type=2;
		}
		$hash_path = md5($file.$width.$height.$type.$bgcolor.$water.$locate.$alpha);
		$path ='/data/wdcache/imgcache/'.$hash_path{0}.$hash_path{1}.'/'.$hash_path{2}.$hash_path{3}.'/';
		if($make){
		    mkdirs(ROOT.$path);
		}
		$url= $path.$hash_path.'.'.end(explode(".",$file));
		if(is_file(ROOT.$url)){
			return $url;
		}
		$image = new \Wd\Image(1,$file);
		if(!$height){
			$height=$width*$image->height()/$image->width();
		}
		if(!$width){
			$width=$height*$image->width()/$image->height();
		}
		$image->thumb($width,$height,$type,$bgcolor,$make);
		if(is_file($water)){
			$image->water($water,$locate,$alpha);
		}
		$image->save(ROOT.$url);
		return $url;
	}
}


if(!function_exists("get_category_top")){
	/**
	 * 返回顶级分类
	 * @param  string  $id  分类id
	 * @return array          顶级分类
	 */
	function get_category_top($id){
		$pid=D('Home/Category')->where("id=$id")->getField('pid');
		if($pid==0){
		    $pid=$id;
		}
		$re=D('Home/Category')->where("id=$pid")->find();
		if($re['pid']!=0){
			get_category_top($re['pid']);
		}else{
			return $re;
		}
	}
}

/**
 * 栏目静态路径
 * @param  string  $id  分类id
 * @return array          顶级分类
 */
if(!function_exists("html_list")){
	function html_list(){
		if(isset($_REQUEST['category'])){
		    return $_REQUEST['category'].'/index';
		}else if(isset($_REQUEST['id'])){
			$p=isset($_REQUEST['p'])?$_REQUEST['p']:1;
			$category=get_category_top($_REQUEST['id']);
			return $category['name'].'/l-'.$_REQUEST['id'].'-'.$p;
		}
	}
}

/**
 * 详细页静态路径
 * @param  string  $id  分类id
 * @return array          顶级分类
 */
if(!function_exists("html_show")){
	function html_show(){
		if(isset($_REQUEST['id'])){
			$where=array(
				'id'=>$_REQUEST['id']
			);
			$category_id=M('Document')->cache(true)->where($where)->getField('category_id');
			$category=get_category_top($category_id);
			return $category['name'].'/'.$_REQUEST['id'];
		}
	}
}

/**
 * 判断是否手机访问
 * @return boole 布尔值
 */
if(!function_exists("isMobile")){
	function isMobile(){ 
	    // 如果有HTTP_X_WAP_PROFILE则一定是移动设备
	    if (isset ($_SERVER['HTTP_X_WAP_PROFILE']))
	    {
	        return true;
	    } 
	    // 如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
	    if (isset ($_SERVER['HTTP_VIA']) && stristr($_SERVER['HTTP_VIA'], "wap")){ 
	        return true;
	    } 
	    // 脑残法，判断手机发送的客户端标志,兼容性有待提高
	    if (isset ($_SERVER['HTTP_USER_AGENT']))
	    {
	        $clientkeywords = array ('nokia',
	            'sony',
	            'ericsson',
	            'mot',
	            'samsung',
	            'htc',
	            'sgh',
	            'lg',
	            'sharp',
	            'sie-',
	            'philips',
	            'panasonic',
	            'alcatel',
	            'lenovo',
	            'iphone',
	            'ipod',
	            'blackberry',
	            'meizu',
	            'android',
	            'netfront',
	            'symbian',
	            'ucweb',
	            'windowsce',
	            'palm',
	            'operamini',
	            'operamobi',
	            'openwave',
	            'nexusone',
	            'cldc',
	            'midp',
	            'wap',
	            'mobile',
	            'ios'
	            ); 
	        // 从HTTP_USER_AGENT中查找手机浏览器的关键字
	        if (preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT'])))
	        {
	            return true;
	        } 
	    } 
	    // 协议法，因为有可能不准确，放到最后判断
	    if (isset ($_SERVER['HTTP_ACCEPT']))
	    { 
	        // 如果只支持wml并且不支持html那一定是移动设备
	        // 如果支持wml和html但是wml在html之前则是移动设备
	        if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html'))))
	        {
	            return true;
	        } 
	    } 
	    return false;
	}
}



/**
 * 获取文章访问地址，废弃
 * @return string 
 */
if(!function_exists("arcurl")){
	function arcurl($id=0,$category_id=0){
		//获取分类信息
		$where=array('id'=>$category_id);
		$category_name=D('Home/Category')->where($where)->cache(true)->getField('name');
		if(empty($category_name)){
		    //获取顶级分类
			$category_top=get_category_top($category_id);
			$category_name=$category_top['name'];
		}
		return "/{$category_name}/{$id}".C("HTML_FILE_SUFFIX");
	}
}

/**
 * 获取文章访问地址
 * @return string 
 * @id  文章id
 * @category  栏目名称或id
 * 
 */
if(!function_exists("wd_url")){
	function wd_url($id=0,$category=0){
		if(!is_numeric($category)){
		    return "/{$category}/{$id}".C("HTML_FILE_SUFFIX");
		}
		//获取分类信息
		$where=array('id'=>$category);
		$category_name=D('Home/Category')->where($where)->cache(true)->getField('name');
		if(empty($category_name)){
		    //获取顶级分类
			$category_top=get_category_top($category);
			$category_name=$category_top['name'];
		}
		return "/{$category_name}/{$id}".C("HTML_FILE_SUFFIX");
	}
}

/**
 * 获取图集
 * @return array 
 */
if(!function_exists("wd_pics")){
	function wd_pics($ids=0){
		if(empty($ids)){
		    $ids=0;
		}
		$where=array(
			'id'=>array('in',(string)$ids)
		);
		return D('Home/Picture')->where($where)->select();
	}
}


/**
 * 获取广告
 * @param  int  $position  广告位id
 * @param  int  $category_id  栏目id
 * @return array 
 */
if(!function_exists("wd_ad")){
	function wd_ad($position=0,$category_id=0){
		$m=D('Home/Advert');
		//$where['stime']=array('elt',time());
		//$where['etime']=array('egt',time());
		if($category_id>0){
		    $where['_string']="position & {$position} and find_in_set({$category_id},category_id)";
		}else{
			$where['_string']="position & {$position}";
		}
		return $m->where($where)->select();
	}
}


//给文章里的图片加七牛处理地址
if(!function_exists("wd_content_img_qiniu")){
	function wd_content_img_qiniu($str,$param="?imageView2/2/w/800/q/80/interlace/1"){
		preg_match_all('/<img[^>]*>/i',$str,$imgs);
		$imgs_str="";
		$i=0;
		foreach($imgs[0] as $key=>$val){
			$i++;
			preg_match('/\s+src=["\']{1}([^"\']*)["\']{1}/i', $val, $src);
			preg_match('/\s+width=["\']{1}([^"\']*)["\']{1}/i', $val, $width);
			preg_match('/\s+height=["\']{1}([^"\']*)["\']{1}/i', $val, $height);
			$src=$src[1];
			if(strpos($src, 'http://www.lantian99.com.cn')!==false){
			  	$src1=C('WEB_SITE_STATIC_DOAMIN').str_replace('http://www.lantian99.com.cn','',$src);
			  	$str=str_replace($src,$src1,$str);
			}else if(strpos($src, 'http://')===false && strpos($src, 'https://')===false && strpos($src, '//')===false){
				$src1=C('WEB_SITE_STATIC_DOAMIN').$src.$param;
				$str=str_replace($src,$src1,$str);
			}else{
				$src1=$src;
			}
			$str=str_replace($width[0],'',$str);
			$str=str_replace($height[0],'',$str);
		}
		return $str;
	}
}


//php获取中文字符拼音首字母
if (!function_exists("get_firstcharter")) {
	function get_firstcharter($str) {
		if (empty($str)) {
			return '';
		}
		if(is_numeric($str{0})){
		    return $str{0};
		}
		$fchar = ord($str{0});
		if ($fchar >= ord('A') && $fchar <= ord('z'))
			return strtoupper($str{0});
		$s1 = iconv('UTF-8', 'gb2312', $str);
		$s2 = iconv('gb2312', 'UTF-8', $s1);
		$s = $s2 == $str ? $s1 : $str;
		$asc = ord($s{0}) * 256 + ord($s{1}) - 65536;
		if ($asc >= -20319 && $asc <= -20284)
			return 'A';
		if ($asc >= -20283 && $asc <= -19776)
			return 'B';
		if ($asc >= -19775 && $asc <= -19219)
			return 'C';
		if ($asc >= -19218 && $asc <= -18711)
			return 'D';
		if ($asc >= -18710 && $asc <= -18527)
			return 'E';
		if ($asc >= -18526 && $asc <= -18240)
			return 'F';
		if ($asc >= -18239 && $asc <= -17923)
			return 'G';
		if ($asc >= -17922 && $asc <= -17418)
			return 'H';
		if ($asc >= -17417 && $asc <= -16475)
			return 'J';
		if ($asc >= -16474 && $asc <= -16213)
			return 'K';
		if ($asc >= -16212 && $asc <= -15641)
			return 'L';
		if ($asc >= -15640 && $asc <= -15166)
			return 'M';
		if ($asc >= -15165 && $asc <= -14923)
			return 'N';
		if ($asc >= -14922 && $asc <= -14915)
			return 'O';
		if ($asc >= -14914 && $asc <= -14631)
			return 'P';
		if ($asc >= -14630 && $asc <= -14150)
			return 'Q';
		if ($asc >= -14149 && $asc <= -14091)
			return 'R';
		if ($asc >= -14090 && $asc <= -13319)
			return 'S';
		if ($asc >= -13318 && $asc <= -12839)
			return 'T';
		if ($asc >= -12838 && $asc <= -12557)
			return 'W';
		if ($asc >= -12556 && $asc <= -11848)
			return 'X';
		if ($asc >= -11847 && $asc <= -11056)
			return 'Y';
		if ($asc >= -11055 && $asc <= -10247)
			return 'Z';
		return null;
	}
}

/**
 * 获取枚举类型字段值
 * 分析枚举类型字段值 格式 a:名称1,b:名称2
 * 
 * @param  int  $model_id  模型id
 * @param  int  $field  字段名称
 * @return array  返回二维数组
 */
if (!function_exists("get_field_attr")) {
    function get_field_attr($model_id,$field){
    	
		$where = array('model_id'=>$model_id,'name'=>$field);
        $extend = M('Model')->getFieldById($model_id,'extend');
        if($extend){
            $where = array('model_id'=> array("in", array($model_id, $extend)),'name'=>$field);
        }
		
		$field=M('attribute')->where($where)->getField('extra');
		$field=preg_split("/[\r\n]+/s", $field,-1,PREG_SPLIT_NO_EMPTY);
		foreach($field as $k=>&$v){
			$v=preg_split("/[:]+/s", $v,-1,PREG_SPLIT_NO_EMPTY);
			if($value!==false && $v[0]==$value){
			    return $v[1];
			}
		}
		return $field;
	}
}


/**
 * 获取枚举类型字段值
 * 分析枚举类型字段值 格式 a:名称1,b:名称2
 * 
 * @param  int  $model_id  模型id
 * @param  int  $field  字段名称
 * @return array  返回二维数组
 */
if (!function_exists("get_field_attr_id_name")) {
    function get_field_attr_id_name($model_id,$field){
    	
		$where = array('model_id'=>$model_id,'name'=>$field);
        $extend = M('Model')->getFieldById($model_id,'extend');
        if($extend){
            $where = array('model_id'=> array("in", array($model_id, $extend)),'name'=>$field);
        }
		
		$field=M('attribute')->where($where)->getField('extra');
		$field=preg_split("/[\r\n]+/s", $field,-1,PREG_SPLIT_NO_EMPTY);
		foreach($field as $k=>&$v){
			$parr=preg_split("/[:]+/s", $v,-1,PREG_SPLIT_NO_EMPTY);
			$arr['id']=$parr[0];
			$arr['name']=$parr[1];
			$v=$arr;
		}
		return json_encode($field);
	}
}


/**
 * 获取地区名称
 * 
 * @param  string  $ids  id字符串
 * @param  string  $sign  分隔字符串
 * @return string  返回地区名称
 */
if (!function_exists("wd_get_area")) {
    function wd_get_area($ids,$sign=''){
		$m=M('Area');
		$re=$m->where(array('id'=>array('in',$ids)))->getField('name',true);
		if(empty($sign)){
		    return $re[0];
		}else{
			return implode($sign,$re);
		}
	}
}

/**
 * @description 读取摘要
 * @param $str 字符串
 * @return string
 */
if (!function_exists("dec")) {
    function dec($str,$length=200,$charset="utf-8", $suffix=true){
    	$str=strip_tags($str);
		$slice=mb_substr($str, 0, $length, $charset);
		if(strlen($str)>strlen($slice)){
			return $suffix ? $slice.'...' : $slice;
		}else{
			return $slice;
		}
	}
}


/**
 * @description 生成链接
 * @param $arr 数组 array('id'=>$v['id'],'type'=>'add,mod,del')  或id 或字符串栏目名称
 * @return string
 */
if (!function_exists("url")) {
    function url($arr){
    	$category_id=I('category_id','');
		$model_id=I('model_id','');
		$category_name=I('category_name','');
		$model_name=I('model_name','');
		$name='';
		if(!empty($category_name)){
		    $name=$category_name;
		}else if(!empty($model_name)){
			$name=$model_name;
		}else if(!empty($arr['category_name'])){
			$name=$arr['category_name'];
		}else if(!empty($arr['model_name'])){
			$name=$arr['model_name'];
		}else if(!empty($arr['category_id'])){
			$name=M('category')->where('id='.$arr['category_id'])->getField('name');
		}else if(!empty($arr['model_id'])){
			$name=M('model')->where('id='.$arr['model_id'])->getField('name');
		}
		if(is_numeric($arr)){
			return "/{$name}/{$arr}".C("HTML_FILE_SUFFIX");
		}
		if(is_string($arr)){
		    return "/{$arr}";
		}
		
    	if($arr['type']=='add' && $category_id>0){
    	    return U('add?category_id='.$category_id);
    	}else if($arr['type']=='add'){
    		return U('add?model_id='.$model_id);
    	}
		if($arr['type']=='mod' && $category_id>0 && !empty($arr['id'])){
    	    return U('mod?id='.$arr['id'].'&category_id='.$category_id);
    	}else if($arr['type']=='mod' && !empty($arr['id'])){
    		return U('mod?id='.$arr['id'].'&model_id='.$model_id);
    	}
		if($arr['type']=='del' && $category_id>0 && !empty($arr['id'])){
    	    return U('del?id='.$arr['id'].'&category_id='.$category_id);
    	}else if($arr['type']=='del' && !empty($arr['id'])){
    		return U('del?id='.$arr['id'].'&model_id='.$model_id);
    	}
		if($arr['type']=='show' && !empty($arr['id'])){
    	    return "/{$name}/{$arr['id']}".C("HTML_FILE_SUFFIX");
    	}
		if($arr['type']=='lists' || $arr['type']=='index'){
    	    return "/{$name}";
    	}
	}
}


/**
 * 根据枚举值获取枚举名称
 * 分析枚举类型字段值 格式 a:名称1,b:名称2
 * 
 * @param  int  $value  枚举值
 * @param  int  $model_id  模型id
 * @param  int  $field  字段名称
 * @param  int  $split  分隔符
 * @return string  返回枚举名称
 */
if (!function_exists("get_field_attr_name")) {
    function get_field_attr_name($value,$model_id,$field,$split=' '){
		$where = array('model_id'=>$model_id,'name'=>$field);
        $extend = M('Model')->getFieldById($model_id,'extend');
        if($extend){
            $where = array('model_id'=> array("in", array($model_id, $extend)),'name'=>$field);
        }
		$field=M('attribute')->where($where)->getField('extra');
		$field=preg_split("/[,\r\n]+/s", $field,-1,PREG_SPLIT_NO_EMPTY);
		$str='';
		$value=explode(',',$value);
		foreach($field as $k=>&$v){
			$v=preg_split("/[:]+/s", $v,-1,PREG_SPLIT_NO_EMPTY);
			if(in_array($v[0], $value)){
			    if($k==0){
			        $str=$v[1];
			    }else{
			    	$str=$str.' '.$v[1];
			    }
			}
		}
		return $str;
	}
}

 // 分析枚举类型配置值 格式 a:名称1,b:名称2
function parse_config_attr($string) {
    $array = preg_split('/[,;\r\n]+/', trim($string, ",;\r\n"));
    if(strpos($string,':')){
        $value  =   array();
        foreach ($array as $val) {
            list($k, $v) = explode(':', $val);
            $value[$k]   = $v;
        }
    }else{
        $value  =   $array;
    }
    return $value;
}


/**
 * @description 获取状态信息
 * @return string
 */
function get_status($id,$field,$model){
	$extra=M('attribute')->where(array('model_id'=>$model,'name'=>$field))->cache(true)->getField('extra');
	$extra=parse_config_attr($extra);
	foreach ($extra as $k => $v) {
		if($k==$id){
		    return $v;
		}	
	}
}


function get_status_all($field,$model){
	$extra=M('attribute')->where(array('model_id'=>$model,'name'=>$field))->getField('extra');
	$extra=parse_config_attr($extra);
	return $extra;
}

/*
 * 时间格式化
 */
function wd_date($format,$str){
	if(empty($str)){
	    return '';
	}else{
		return date($format,$str);
	}
}



/*
 * 模拟javascript getTime()函数
 */
function getTime() {
	list($t1, $t2) = explode(' ', microtime());
	return (float)sprintf('%.0f',(floatval($t1)+floatval($t2))*1000);
}

/*
 * 删除数组指定元素
 */
function array_remove($arr, $value){  
    if(!is_array($arr)){  
        return $arr;  
    }  
    foreach($arr as $k=>$v){  
        if($v == $value){  
            unset($arr[$k]);  
        }  
    }  
    return $arr;  
}





/*
 * *****************************
 */



/*
 * 用户网盘设置读取
 */
function userconfig_get($uid,$field=''){
	$userconfig=O('userconfig')->find(array(
		'pk'=>array(
			'pk1'=>$uid,
			'pk2'=>'',
			'pk3'=>'',
			'pk4'=>'',
		),
	));
	if($field){
	    return $userconfig[$field];
	}else{
		return $userconfig;
	}
}
function userconfig_get_bydomain($domain){
	$userconfig=O('userconfig')->find(array(
		'pk'=>array(
			'pk1'=>'domain_'.$domain,
			'pk2'=>'',
			'pk3'=>'',
			'pk4'=>'',
		),
	));
	return $userconfig;
}
/*
 * 用户网盘参数设置
 */
function userconfig_set($uid,$attr){
	$re=O('userconfig')->save(array(
		'pk'=>array(
			'pk1'=>$uid,
			'pk2'=>'',
			'pk3'=>'',
			'pk4'=>'',
		),
		'attr'=>$attr
	));
	return $re;
}


/*
 * 用户网盘文件统计
 */
function user_file_total($uid,$attr){
	$info=O('file')->find(array(
		'pk'=>array(
			'pk1'=>'file_total_'.$uid,
			'pk2'=>'',
			'pk3'=>'',
			'pk4'=>'',
		),
	));
	$attr['size']=$info['size']?$info['size']+$attr['size']:$attr['size'];
	O('file')->save(array(
		'pk'=>array(
			'pk1'=>'file_total_'.$uid,
			'pk2'=>'',
			'pk3'=>'',
			'pk4'=>'',
		),
		'attr'=>$attr
	));
}

/*
 * 中间星号
 */
function substr_cut($user_name,$firstlen=1,$lastlen=1){
    $strlen     = mb_strlen($user_name, 'utf-8');
	if($strlen==0){
		return '';
	}
    $firstStr     = mb_substr($user_name, 0, $firstlen, 'utf-8');
    $lastStr     = mb_substr($user_name, -$lastlen, $lastlen, 'utf-8');
    return $strlen == 2 ? $firstStr . str_repeat('*', mb_strlen($user_name, 'utf-8') - $lastlen) : $firstStr . str_repeat("*", $strlen - $firstlen-$lastlen) . $lastStr;
}

/*
 * 更新会员余额
 */
function member_money_set($uid){
	$member_money=M('money')->where(array('uid'=>$uid))->sum('price');
	$re=O('userconfig')->save(array(
		'pk'=>array(
			'pk1'=>$uid,
			'pk2'=>'',
			'pk3'=>'',
			'pk4'=>'',
		),
		'attr'=>array(
			'member_money'=>$member_money
		)
	));
}


function file_size($size){
	if ($size<1024) {
		return '1KB';
	}else if ($size<1048576) {
		return floor($size/1024).'KB';
	}else if($size<1073741824){
		return floor($size/1048576).'MB';
	}else if($size<1073741824){
		return (floor($size/1099511627776*100)/100).'GB';
	}
}

function get_domain($host) { 
	//$host = strtolower ($_REQUEST['url']); 
	if (strpos ( $host, '/' ) !== false) { 
	$parse = @parse_url ( $host ); 
	$host = $parse ['host']; 
	} 
	$topleveldomaindb = array ('com', 'edu', 'gov', 'int', 'mil', 'net', 'org', 'biz', 'info', 'pro', 'name', 'museum', 'coop', 'aero', 'xxx', 'idv', 'mobi', 'cc', 'me', 'vip', 'xin', 'top', 'xyz', 'wang', 'shop', 'site', 'club', 'fun', 'online', 'biz', 'red', 'link', 'ltd', 'mobi', 'org',  'pro', 'work', 'tv', 'kim', 'group', 'tech', 'store', 'ren', 'ink', 'live', 'wiki', '中文网', '我爱你', '中国' , '网址', '网店', '公司', '网络', 'com.cn', 'net.cn', 'org.cn', 'gov.cn'); 
	$str = ''; 
	foreach ( $topleveldomaindb as $v ) { 
	$str .= ($str ? '|' : '') . $v; 
	} 
	
	$matchstr = "[^\.]+\.(?:(" . $str . ")|\w{2}|((" . $str . ")\.\w{2}))$"; 
	if (preg_match ( "/" . $matchstr . "/ies", $host, $matchs )) { 
	$domain = $matchs ['0']; 
	} else { 
	$domain = $host; 
	} 
	return $domain; 
} 

function scan_file($path) {
  global $result;
  $files = scandir($path);
  foreach ($files as $file) {
    if ($file != '.' && $file != '..') {
      if (is_dir($path . '/' . $file)) {
        scan_file($path . '/' . $file);
      } else {
        $result[] = md5_file($path.$file);
      }
    }
  }
  return $result;
}