<?php
namespace member\controller;
class File extends Member {
/**
 * 106云盘自动发卡平台网盘系统
 * ============================================================================
 * 版权所有 2016-2028 扎兰屯市姝妍计算机服务有限公司，并保留所有权利。
 * 网站地址: http://www.106ym.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 */
	 
	public function lists($folder=''){
    	$uid=session("user_auth.id");
    	$spk = array (
		    'pk1' => $uid,
		    'pk2' => '', 
	        'pk3' => '',
	        'pk4' => array('type' => 'INF_MAX'),
		);
		$epk = array (
		    'pk1' => $uid,
		    'pk2' => '',
	        'pk3' => '',
	        'pk4' => array('type' => 'INF_MIN'),
		);
		$list=O('file')->select(array(
			'spk'=>$spk,
			'epk'=>$epk,
			'filter'=>array('status'=>array('eq',0),'folder'=>array('eq',$folder)),
		));
		$userconfig=userconfig_get($uid);
		if($userconfig['orderby']==1){
		    $list=array_sort($list,'pk4',SORT_DESC);
		}else if($userconfig['orderby']==2){
		    $list=array_sort($list,'name',SORT_ASC);
		}else if($userconfig['orderby']==3){
		    $list=array_sort($list,'about',SORT_ASC);
		}
		foreach ($list as $k => &$v) {
			//下载链接
			if(!empty($v['link'])){
				$v['downurl']=$v['link']; 
			}else if(isset($v['link'])){
				$v['downurl']=''; 
			}else{
				$qiniu_file=C($v['qiniu']);
				Vendor('Qiniu.autoload');
				$auth = new \Qiniu\Auth($qiniu_file['accessKey'], $qiniu_file['secretKey']);
				$v['downurl']=$auth->privateDownloadUrl('http://'.$qiniu_file['domain'].'/'.$v['key']);
			}
			//图标
			if(isset($v['link'])){
			    $v['icon']=S('STATIC').'/static/public/images/filetype/html.gif';
			}else if(in_array(array_pop(explode('.', $v['name'])), array('7z','asp','accdb','as','asm','avi','c','cfc','asp','aspx','bat','bmp','chm','css','cpp','cs','db','dll','doc','exe','file','fla','flv','fla','eip','gif','htm','h','html','htm','images','ini','jpeg','jpg','js','jsp','lnk','mdb','mov','mp3','pdf','php','png','ppt','psd','qt','quicktime','rar','reg','rm','rmvb','shtml','swf','tif','torrent','txt','vbs','video','video2','video3','vsd','wmv','xls','xml','xsl','zip','e'))){
				$v['icon']=S('STATIC').'/static/public/images/filetype/'.array_pop(explode('.', $v['name'])).'.gif';
			}else{
				$v['icon']=S('STATIC').'/static/public/images/filetype/eye.gif?v=20180305';
			}
		}
		
		$this->ajaxReturn($list);
		
    }
	
	public function lists_recycle($folder=''){
    	$uid=session("user_auth.id");
    	$spk = array (
		    'pk1' => $uid,
		    'pk2' => '',
	        'pk3' => '',
	        'pk4' => array('type' => 'INF_MAX'),
		);
		$epk = array (
		    'pk1' => $uid,
		    'pk2' => '',
	        'pk3' => '',
	        'pk4' => array('type' => 'INF_MIN'),
		);
		
		$list=O('file')->select(array(
			'spk'=>$spk,
			'epk'=>$epk,
			'filter'=>array('status'=>array('eq',-1),'folder'=>array('eq',$folder)),
		));
		$this->ajaxReturn($list);
		
    }
	
    public function add(){
    	$data=array(
			'folder'=>I('folder'),
			'folder_pids'=>I('folder_pids'),
			'key'=>I('key'),
			'file_key'=>I('file_key'),
			'qiniu'=>'QINIU_FILE1',
			'name'=>I('name'),
			'size'=>I('size'),
			'type'=>I('type'),
		);
		$re=O('file')->wdadd($data);
    	$this->ajaxReturn(array('status'=>1,'data'=>array($re)));
    }
    
    public function mod(){
    	$uid=session("user_auth.id");
		$attr=I('attr');
		$pk=array(
			'pk1'=>$uid,
			'pk2'=>I('pk2'),
			'pk3'=>I('pk3'),
			'pk4'=>I('pk4'),
		);
		if($attr['folder']){
		    $info_folder=O('folder')->find(array(
				'pk'=>array(
					'pk1'=>$uid,
					'pk2'=>'',
					'pk3'=>'',
					'pk4'=>$attr['folder']
				)
			));
			if(empty($info_folder['folder_pids'])){
				$folder_pids=$info_folder['pk4'];
			}else{
				$folder_pids=$info_folder['folder_pids'].','.$info_folder['pk4'];
			}
			$attr['folder_pids']=$folder_pids;
		}
    	$re=O('file')->save(array(
			'pk'=>$pk,
			'attr'=>$attr,
		));
    	$this->ajaxReturn($re);
    	
    	
    }
	
	public function del($pk='',$re=true){
    	$uid=session("user_auth.id");
		$pk=!empty($pk)?$pk:array(
			'pk1'=>$uid,
			'pk2'=>I('pk2',''),
			'pk3'=>I('pk3',''),
			'pk4'=>I('pk4',''),
		);
		$pk['pk1']=$uid;
		O('file')->delete(array('pk'=>$pk));
		if($re){
		    $this->ajaxReturn(array('status'=>1));
		}
    }
    
	//删除文件夹
	public function del_folder($pk='',$re=true){
    	$uid=session("user_auth.id");
		$pk=!empty($pk)?$pk:array(
			'pk1'=>$uid,
			'pk2'=>I('pk2',''),
			'pk3'=>I('pk3',''),
			'pk4'=>I('pk4',''),
		);
		$pk['pk1']=$uid;
		$info_folder=O('folder')->find(array('pk'=>$pk));
		//回收站文件
		$list_recycle=$this->recycle();
		foreach ($list_recycle as $k => $v) {
			$folder_pids=explode(',', $v['folder_pids']);
			if(in_array($info_folder['pk4'], $folder_pids)){
				$pk_file=array(
					'pk1'=>$v['pk1'],
					'pk2'=>$v['pk2'],
					'pk3'=>$v['pk3'],
					'pk4'=>$v['pk4'],
				);
			    $this->del($pk_file);
			}
		}
//		O('folder')->delete(array('pk'=>$pk));
		if($re){
		    $this->ajaxReturn(array('status'=>1));
		}
    	
    }
	
	//清空回收站
	public function del_all(){
    	$uid=session("user_auth.id");
		$spk = array (
		    'pk1' => $uid,
		    'pk2' => '',
	        'pk3' => '',
	        'pk4' => array('type' => 'INF_MAX'),
		);
		$epk = array (
		    'pk1' => $uid,
		    'pk2' => '',
	        'pk3' => '',
	        'pk4' => array('type' => 'INF_MIN'),
		);
		$list_file=O('file')->select(array(
			'spk'=>$spk,
			'epk'=>$epk,
			'filter'=>array('status'=>array('eq',-1)),
		));
		foreach ($list_file as $k => $v) {
			O('file')->delete(array(
				'pk'=>array(
					'pk1'=>$v['pk1'],
					'pk2'=>$v['pk2'],
					'pk3'=>$v['pk3'],
					'pk4'=>$v['pk4'],
				)
			));
		}
		
		$this->ajaxReturn(array('status'=>1));
    	
    }

	//回收站文件
	public function recycle(){
		$uid=session("user_auth.id");
		$spk = array (
		    'pk1' => $uid,
		    'pk2' => '',
	        'pk3' => '',
	        'pk4' => array('type' => 'INF_MAX'),
		);
		$epk = array (
		    'pk1' => $uid,
		    'pk2' => '',
	        'pk3' => '',
	        'pk4' => array('type' => 'INF_MIN'),
		);
		
		$list=O('file')->select(array(
			'spk'=>$spk,
			'epk'=>$epk,
			'filter'=>array('status'=>array('eq',-1)),
		));
		return $list;
	}
	
	//批量删除
	public function del_more(){
		$pk_arr=I('pk','');
		foreach ($pk_arr as $k => $v) {
			$pk=explode(',',$v);
			$pk=array(
				'pk1'=>$pk[0],
				'pk2'=>$pk[1],
				'pk3'=>$pk[2],
				'pk4'=>$pk[3],
			);
			$this->del($pk,false);
		}
		$this->ajaxReturn(array('status'=>1));
	}
    
    
    public function get_status_all($field,$model){
		$extra=M('attribute')->where(array('model_id'=>$model,'name'=>$field))->getField('extra');
		$extra=parse_config_attr($extra);
		return $extra;
	}

	
	//文件秒传检查及秒传
	public function check($key){
		$uid=session("user_auth.id");
		$re=O('filecheck')->find(array(
			'pk'=>array(
				'pk1'=>(string)$key,
				'pk2'=>'',
				'pk3'=>'',
				'pk4'=>''
			)
		));
		if($re){
//			$spk = array (
//			    'pk1' => array('type' => 'INF_MAX'),
//			    'pk2' => '',
//			    'pk3' => '',
//			    'pk4' => '',
//			);
//			$epk = array (
//			    'pk1' => array('type' => 'INF_MIN'),
//			    'pk2' => '',
//			    'pk3' => '',
//			    'pk4' => '',
//			);
//			
//			$list_file=O('file')->select(array(
//				'spk'=>$spk,
//				'epk'=>$epk,
//				'filter'=>array('file_key'=>array('eq',$key)),
//				'limit'=>1,
//				'filed'=>'',
//			));
//			$info_file=$list_file[0];
			if(empty($re['key']) || empty($key) || empty($re['qiniu']) || $re['qiniu']!='QINIU_FILE1' || empty($re['size']) || empty($re['type'])){
			    $this->ajaxReturn(array('status'=>0));
				exit;
			}
			$data=array(
				'folder'=>I('folder'),
				'folder_pids'=>I('folder_pids'),
				'key'=>$re['key'],
				'file_key'=>$key,
				'qiniu'=>$re['qiniu'],
				'name'=>I('name'),
				'size'=>$re['size'],
				'type'=>$re['type'],
			);
			$re=O('file')->wdadd($data);
		    $this->ajaxReturn(array('status'=>1,'data'=>array($re)));
		}else{
			$this->ajaxReturn(array('status'=>0));
		}
	}

	
	public function mimeType($qiniu,$key){
		$qiniu_file=C($qiniu);
		Vendor('Qiniu.autoload');
		$auth = new \Qiniu\Auth($qiniu_file['accessKey'], $qiniu_file['secretKey']);
		$BucketManager=new \Qiniu\Storage\BucketManager($auth);
		$re=$BucketManager->stat($qiniu_file['buket'],$key);
		$this->ajaxReturn($re[0]['mimeType']);
	}
	
	//删除多余上传的文件
//	public function del_by_key($qiniu,$key){
//		//删除文件
//		$qiniu_file=C($qiniu);
//		Vendor('Qiniu.autoload');
//		$auth = new \Qiniu\Auth($qiniu_file['accessKey'], $qiniu_file['secretKey']);
//		$BucketManager=new \Qiniu\Storage\BucketManager($auth);
//		$BucketManager->delete($qiniu_file['buket'],$key);
//	}
	
	
	public function link_add(){
    	$uid=session("user_auth.id");
		$file_id=(string)getTime();
		$pk=array(
			'pk1' => $uid,
	        'pk2' => '',
	        'pk3' => '',
	        'pk4' => $file_id,
		);
		$attr=array(
			'name' => I('name',''),  
			'folder'=>I('folder',''),
			'folder_pids' => I('folder_pids',''),               
	        'link'=>I('link',''),  
	        'status'=>0,
	        'about'=>I('about',''),
	        'ctime'=>time(),
	        'file_key'=>''
		);
		
		$data = array (
		    'pk' => $pk,
		    'attr' => $attr
		);
		$re=O('file')->add($data);
    	$this->ajaxReturn($re);
    }
	
	
	//添加卡密
	public function card_add(){
		$uid=session("user_auth.id");
		$file_id=I('file_id');
		$cards=I('cards','');
		$cards=preg_split("/[\r\n]+/s",$cards ,-1,PREG_SPLIT_NO_EMPTY);
		if(count($cards)>200){
		    $this->ajaxReturn(array('status'=>0,'info'=>'单次添加最多200条'));
		}
		$re=O('file')->find(array(
			'pk'=>array(
				'pk1'=>$uid,
				'pk2'=>'',
				'pk3'=>'',
				'pk4'=>$file_id,
			),
			'field'=>'card_num'
		));
		if($re['card_num']+count($cards)>1000){
		    $this->ajaxReturn(array('status'=>0,'info'=>'单个软件最多添加1000条卡密'));
		}
		$rows=array();
		foreach ($cards as $k => $v) {
			$rows[$k]['pk1']=$uid;
			$rows[$k]['pk2']='';
			$rows[$k]['pk3']='';
			$rows[$k]['pk4']=getTime()+$k;
			$rows[$k]['file_id']=$file_id;
			$rows[$k]['card']=trim($v);
			$rows[$k]['used']=0;
		}
		$re=O('card')->write(array(
			'add'=>$rows
		));
		$this->ajaxReturn(array('status'=>1,'info'=>$re));
	}

	//卡密列表
	public function card_list(){
		$npk=I('npk',false);
		$uid=session("user_auth.id");
		if($npk){
		    $spk=base64_decode($npk);
			$spk=json_decode($spk,true);
		}else{
			$spk = array (
			    'pk1' => $uid,
			    'pk2' => '',
			    'pk3' => '',
			    'pk4' => array('type' => 'INF_MAX'),
			);
		}
		
		$epk = array (
		    'pk1' => $uid,
		    'pk2' => '',
		    'pk3' => '',
		    'pk4' => array('type' => 'INF_MIN'),
		);
		
		
		$re=O('card')->select(array(
			'spk'=>$spk,
			'epk'=>$epk,
			'filter'=>array('used'=>array('eq',0),'file_id'=>array('eq',I('file_id'))),
			'limit'=>'100',
			'field'=>'',
			'page'=>true
		));
		$data=array();
		if($re['next_start_primary_key']){
		    $data['npk']=base64_encode(json_encode($re['next_start_primary_key']));
		}else{
			$data['npk']='';
		}
		$data['spk']=base64_encode(json_encode($spk));
		
		$data['data']=$re['rows'];
		if(IS_AJAX){
		    $this->ajaxReturn($data);
		}
	}
	
	
	//删除卡密
	public function card_del(){
		$uid=session("user_auth.id");
		$card_id=$_REQUEST['card_id'];
		if(is_array($card_id)){
		    foreach ($card_id as $k => &$v) {
		    	$v=json_decode($v,true);
				$v['pk1']=$uid;
		    }
			unset($v);
			$del=$card_id;
		}else{
			$pk=json_decode($card_id,true);
			$pk['pk1']=$uid;
			$del=array($pk);
		}
		O('card')->write(array(
			'del'=>$del
		));
		
		$this->ajaxReturn(array('status'=>1));
	}
	
	
	//清空卡密
	public function card_del_all(){
		$uid=session("user_auth.id");
		$file_id=I('file_id');
		$spk = array (
		    'pk1' => $uid,
		    'pk2' => '',
		    'pk3' => '',
		    'pk4' => array('type' => 'INF_MAX'),
		);
		$epk = array (
		    'pk1' => $uid,
		    'pk2' => '',
		    'pk3' => '',
		    'pk4' => array('type' => 'INF_MIN'),
		);
		
		$list=O('card')->select(array(
			'spk'=>$spk,
			'epk'=>$epk,
			'filter'=>array('file_id'=>array('eq',$file_id)),
			'filed'=>'pk1,pk2,pk3,pk4,file_id',
		));
		$count=count($list);
		$row=ceil($count/200);
		for($i=0;$i<$row;$i++){
			O('card')->write(array(
				'del'=>array_slice($list, $i*200,200)
			));
		}
		$this->ajaxReturn(array('status'=>1));
	}
	
}