<?php
namespace uhome\controller;

/**
 * 控制器
 * 
 */
class Pay extends Uhome {
	
	
	/**
	 * 文件购买
	 */
	public function file(){
		$pay_way=I('pay_way');
		$orderno=I('orderno',date('YmdHis') . str_pad(mt_rand(1, 99999), 5, '0', STR_PAD_LEFT));
		$email=I('email','');
		$mobile=I('mobile','');
		$pk=array(
			'pk1'=>I('pk1'),
			'pk2'=>I('pk2'),
			'pk3'=>I('pk3'),
			'pk4'=>I('pk4'),
		);
		$info_file=O('file')->find(array(
			'pk'=>$pk
		));
		$info_file['youhui']=preg_split("/[\r\n]+/s",$info_file['youhui'] ,-1,PREG_SPLIT_NO_EMPTY);
		foreach ($info_file['youhui'] as $k => &$v) {
			$v=preg_split("/[=]+/s", $v,-1,PREG_SPLIT_NO_EMPTY);
			if(I('num')>=$v[0]){
				$info_file['price']=$v[1];
			}
		}
		//库存
		if($info_file['iszengsong']=='赠送'){
			if($info_file['card_num']<I('num',1)){
				if(isMobile()){
				    $this->display('Msg_kucunbuzu_wap');
				}else{
					$this->display('Msg_kucunbuzu');
				}
				exit;
			}
		}
		
		$amount = $info_file['price']*I('num',1);
		unset($v);
		$price=$amount;
		if($mobile){
		    $amount+=0.1;
		}
		$data_two = array(
			'no'=>$orderno,
			'ctime'=>time(),
			'status'=> 0,
			'amount'=>$amount,
			'file_id'=>I('file_id'),
			'file_pk'=>json_encode($pk),
			'pay_way'=>'',
			'email'=>I('email'),
			'code'=>rand(100000,999999),
			'mobile'=>$mobile,
			'price'=>$price,
			'uid'=>$info_file['pk1'],
			'name'=>$info_file['name'],
			'num'=>I('num',0)
		);
		D('pub/FileLog')->create($data_two);
		D('pub/FileLog')->add();
		$param= array(
			'title'=>'文件购买',
			'orderno'=>$orderno,
			'amount'=>$amount,
			'notify_url'=>"http://{$_SERVER['HTTP_HOST']}/pay/file_notify/pay_way/".$pay_way,
			'return_url'=>"http://{$_SERVER['HTTP_HOST']}/pay/file_return",
			'model'=>'FileLog',
		);
		$info_pay=M('zhifutongdao')->where(array('id'=>$pay_way))->find();
		$class  =   "\pay\\".ucfirst($info_pay['name']);
		$pay=new $class();
		if($info_pay['type']==1){
		    $pay->pc($param);
		}else if($info_pay['type']==2 && $pay_way==14){
			$alipay=new \Wd\Alipay(array(
				'notify_url'=>"http://{$_SERVER['HTTP_HOST']}/pay/file_notify/pay_way/".$pay_way,
				'return_url'=>"http://{$_SERVER['HTTP_HOST']}/pay/file_return",
			));
			$alipay->wap($param);
		}else if($info_pay['type']==2 && $pay_way==15){
			$wxpay=new \weixin\Wxpay();
			$mweb_url=$wxpay->wap(array(
				'title'=>'文件购买',
				'orderno'=>$orderno,
				'amount'=>$amount,
				'notify_url'=>"http://{$_SERVER['HTTP_HOST']}/pay/file_notify/pay_way/".$pay_way,
			));
			session('mweb_url',$mweb_url);
			$this->redirect('wxpay_wap',array('orderno'=>$orderno));
		}else{
			$pay->wap($param);
		}
		
	}
	
	function wxpay_wap($orderno){
		$this->display();
	}
	
	/**
	 * 价格
	 */
	public function getPrice(){
		$mobile=I('mobile','');
		$pk=array(
			'pk1'=>I('pk1',''),
			'pk2'=>I('pk2',''),
			'pk3'=>I('pk3',''),
			'pk4'=>I('pk4',''),
		);
		$info_file=O('file')->find(array(
			'pk'=>$pk
		));
		$info_file['youhui']=preg_split("/[\r\n]+/s",$info_file['youhui'] ,-1,PREG_SPLIT_NO_EMPTY);
		foreach ($info_file['youhui'] as $k => &$v) {
			$v=preg_split("/[=]+/s", $v,-1,PREG_SPLIT_NO_EMPTY);
			if(I('num')>=$v[0]){
			    $info_file['price']=$v[1];
			}
		}
		$amount = $info_file['price']*I('num',1);
		unset($v);
		if($mobile){
		    $amount+=0.1;
		}
		$this->ajaxReturn(array('amount'=>$amount,'status'=>1));
	}

	/**
	 * 文件购买支付回调
	 */
	public function file_notify(){
		$info_pay=M('zhifutongdao')->where(array('id'=>$_GET['pay_way']))->find();
		$class  =   "\pay\\".ucfirst($info_pay['name']);
		
		
		$pay=new $class();
		$redata=$pay->check();
		if($redata){
			$where=array(
				'no'=>$redata['orderno'],
				'amount'=>$redata['amount'],
				'status'=>0,
			);
			
			
			D('pub/FileLog')->where($where)->save(array('status'=>1,'pay_way'=>$redata['pay_way'],'no'=>$redata['orderno']));
			$re=$pay->notifyReturn();
			echo $re;
		}
	}
	
	/**
	 * 支付成功跳转地址
	 */
	public function file_return($orderno=''){
		$orderno=I('out_trade_no',$orderno);
		$info_file_log=M('file_log')->where(array('no'=>$orderno,'status'=>1))->find();
		if($info_file_log){
		    $file_pk=json_decode($info_file_log['file_pk'],true);
			$this->userconfig=userconfig_get($file_pk['pk1']);
			$this->info_file_log=$info_file_log;
			if(IS_AJAX){
			    $this->ajaxReturn(array('status'=>1));
			}
			$this->display('Msg_filebuy_success');
		}else{
			header("location:http://www.".C('BEN_BZUSR').'/pub/reminder/error/info/订单不存在或未付款');
		}
    }
	
	/**
	 * 订单查询
	 */
	public function file_alipay_pc_return($order_no=''){
		$this->file_return($order_no);
	}
	
	/**
	 * 模板解析
	 */
	function view($data=array()){
		foreach ($data as $k => $v) {
			$this->$k=$v;
		}
		$this->display($data['tpl']);
	}
	
	/**
	 * 订单支付状态检测
	* $orderno 订单号
	* $model 订单存储模型
	*/
	public function order_check($orderno,$model='FileLog'){
		$where=array(
			'no'=>$orderno,
		);
		$status=D($model)->where($where)->getField('status');
		$this->ajaxReturn(array('status'=>$status));
    }
	
	
	public function order_search(){
		if(isMobile()){
		    $this->display('Pay_order_search_wap');
		}else{
			$this->display();
		}
    }
	
	
	
	
	/**********************以下部分废除 **********************/
	
	
	
	
	/**********************支付宝文件购买付款开始 **********************/
	//付款事项_支付方式_平台   示例_支付宝_电脑版  shili_alipay_wap
	public function file_alipay_wap(){
		$url= "{$_SERVER['HTTP_REFERER']}";
		$alipay=new \Wd\Alipay(array(
			'notify_url'=>"http://{$_SERVER['HTTP_HOST']}".'/pay/file_alipay_pc_notify',
			'return_url'=>$url.'/showdown/1',
		));
		$orderno=date('YmdHis') . str_pad(mt_rand(1, 99999), 5, '0', STR_PAD_LEFT);
		$email=I('email','');
		$mobile=I('mobile','');
		$pk=array(
			'pk1'=>I('pk1'),
			'pk2'=>I('pk2'),
			'pk3'=>I('pk3'),
			'pk4'=>I('pk4'),
		);
		$info_file=O('file')->find(array(
			'pk'=>$pk
		));
		$amount = $info_file['price'];
		if($mobile){
		    $amount+=0.1;
		}
		$data_two = array(
			'no'=>$orderno,
			'ctime'=>time(),
			'status'=> 0,
			'amount'=>$amount,
			'file_id'=>I('file_id'),
			'file_pk'=>json_encode($pk),
			'pay_way'=>'',
			'email'=>I('email'),
			'code'=>rand(100000,999999),
			'mobile'=>$mobile,
			'price'=>$info_file['price'],
			'uid'=>substr($info_file['pk1'], 5),
			'name'=>$info_file['name'],
		);
		D('pub/FileLog')->create($data_two);
		$re =D('pub/FileLog')->add();
		$data=array(
			'order_no'=>$orderno,
			'amount'=>$amount
		);
		$alipay->wap($data);
		
    }
	
	//支付成功异步处理地址 
	public function file_alipay_wap_notify(){
		
    }
	
	//支付成功跳转地址
	public function file_alipay_wap_return(){
		$alipay=new \Wd\Alipay();
		$data=$_GET;
		unset($data['domain']);
		if($alipay->check($data)){
			$this->display('Msg_filebuy_success');
		}
    }
	/**********************支付宝文件购买结束 **********************/
	
	
	public function file_wxpay_pc(){
		$orderno=date('YmdHis') . str_pad(mt_rand(1, 99999), 5, '0', STR_PAD_LEFT);
		$email=I('email','');
		$mobile=I('mobile','');
		$pk=array(
			'pk1'=>I('pk1'),
			'pk2'=>I('pk2'),
			'pk3'=>I('pk3'),
			'pk4'=>I('pk4'),
		);
		$info_file=O('file')->find(array(
			'pk'=>$pk
		));
		$amount = $info_file['price'];
		if($mobile){
		    $amount+=0.1;
		}
		$data_two = array(
			'no'=>$orderno,
			'ctime'=>time(),
			'status'=> 0,
			'amount'=>$amount,
			'file_id'=>I('file_id'),
			'file_pk'=>json_encode($pk),
			'pay_way'=>'wxpay',
			'email'=>I('email'),
			'code'=>rand(100000,999999),
			'mobile'=>$mobile,
			'price'=>$info_file['price'],
			'uid'=>$info_file['pk1'],
			'name'=>$info_file['name'],
		);
		D('pub/FileLog')->create($data_two);
		$re =D('pub/FileLog')->add();
		$data=array(
			'order_no'=>$orderno,
			'amount'=>$amount
		);
		$wxpay=new \weixin\Wxpay();
		$wxpay->parameters['body']=$info_file['name'];
		$wxpay->parameters['out_trade_no']=$orderno;
		$wxpay->parameters['total_fee']=$amount*100;
		$wxpay->parameters['notify_url']="http://{$_SERVER['HTTP_HOST']}".'/pay/file_wxpay_pc_notify';
		$this->orderno=$orderno;
		$this->code=$wxpay->getCodeApi();
		$this->ctime=time();
		$this->amount=$amount;
		$this->display('Pay_file_wxpay_pc');
	}

	public function file_wxpay_pc_notify(){
		$wxpay=new \weixin\Wxpay();
		$data=$wxpay->checkSign();
		if($data){
		    $where=array(
				'no'=>$data['out_trade_no'],
				'amount'=>$data['total_fee']/100,
				'status'=>0,
			);
			D('pub/FileLog')->where($where)->save(array('status'=>1,'no'=>$data['out_trade_no']));
			$wxpay->returnParameters["return_code"] == "SUCCESS";
			ob_clean();
			echo $wxpay->returnXml();
		}
    }
	
	
	public function file_wxpay_wap(){
		$orderno=date('YmdHis') . str_pad(mt_rand(1, 99999), 5, '0', STR_PAD_LEFT);
		$email=I('email','');
		$mobile=I('mobile','');
		$pk=array(
			'pk1'=>I('pk1'),
			'pk2'=>I('pk2'),
			'pk3'=>I('pk3'),
			'pk4'=>I('pk4'),
		);
		$info_file=O('file')->find(array(
			'pk'=>$pk
		));
		$amount = $info_file['price'];
		if($mobile){
		    $amount+=0.1;
		}
		$data_two = array(
			'no'=>$orderno,
			'ctime'=>time(),
			'status'=> 0,
			'amount'=>$amount,
			'file_id'=>I('file_id'),
			'file_pk'=>json_encode($pk),
			'pay_way'=>'wxpay',
			'email'=>I('email'),
			'code'=>rand(100000,999999),
			'mobile'=>$mobile,
			'price'=>$info_file['price'],
			'uid'=>$info_file['pk1'],
			'name'=>$info_file['name'],
		);
		D('pub/FileLog')->create($data_two);
		$re =D('pub/FileLog')->add();
		$data=array(
			'order_no'=>$orderno,
			'amount'=>$amount
		);
		$wxpay=new \weixin\Wxpay();
		$wxpay->parameters['body']=$info_file['name'];
		$wxpay->parameters['out_trade_no']=$orderno;
		$wxpay->parameters['total_fee']=$amount*100;
		$wxpay->parameters['notify_url']="http://{$_SERVER['HTTP_HOST']}".'/pay/file_wxpay_pc_notify';
		$this->orderno=$orderno;
		$url=$wxpay->getH5Api();
		header("location:$url");
	}
	
	
}