<?php
/**
 * 支付宝接口类
 */
namespace Wd;

class Alipay{
	private $config;
	
    public function __construct($config=array()){
		$url = "http://{$_SERVER['HTTP_HOST']}";
		$this->config['app_id']=isset($config['appId'])?$config['appId']:C('ALIPAY_appId');
		$this->config['merchant_private_key']=isset($config['rsaPrivateKey'])?$config['rsaPrivateKey']:C('ALIPAY_rsaPrivateKey');
		$this->config['alipay_public_key']=isset($config['alipayrsaPublicKey'])?$config['alipayrsaPublicKey']:C('ALIPAY_alipayrsaPublicKey');
		
		$this->config['notify_url']=isset($config['notify_url'])?$config['notify_url']:"{$url}/pay/".ACTION_NAME."_notify";
		$this->config['return_url']=isset($config['return_url'])?$config['return_url']:"{$url}/pay/".ACTION_NAME."_return";
		$this->config['charset']=isset($config['charset'])?$config['charset']:"UTF-8";
		$this->config['sign_type']=isset($config['sign_type'])?$config['sign_type']:"RSA2";
		$this->config['gatewayUrl']=isset($config['gatewayUrl'])?$config['gatewayUrl']:"https://openapi.alipay.com/gateway.do";
    }
    
	/**
    * 生成支付代码
    * @param   array   $param      订单信息
    */
	function go($param){
		$out_trade_no = $param['order_no'];
		$total_amount = $param['amount'];//付款金额，必填
		$passback_params=$param['passback_params']?$param['passback_params']:'1';
		if(empty($out_trade_no) || empty($total_amount)){
			header("Content-type: text/html; charset=utf-8");
		    echo '订单号或金额为空';die;
		}
	    $subject = isset($param['title'])?$param['title']:'订单'.$out_trade_no;//订单名称，必填
	    $body = isset($param['body'])?$param['body']:'订单'.$out_trade_no;//商品描述，可空
		$payRequestBuilder = new \alipay\pagepay\buildermodel\AlipayTradePagePayContentBuilder();
		$payRequestBuilder->setBody($body);
		$payRequestBuilder->setSubject($subject);
		$payRequestBuilder->setTotalAmount($total_amount);
		$payRequestBuilder->setOutTradeNo($out_trade_no);
		$payRequestBuilder->setBizContent(array(
			'passback_params'=>$passback_params
		));
		$aop = new \alipay\pagepay\service\AlipayTradeService($this->config);
		$response = $aop->pagePay($payRequestBuilder,$this->config['return_url'],$this->config['notify_url']);
		//输出表单
		var_dump($response);
	}


	/**
    * 生成电脑版网页支付代码
    * @param   array   $param      订单信息
    */
	function pc($param){
		$this->go($param);
	}

	/**
    * 生成手机版网页支付代码
    * @param   array   $param      订单信息
    */
	function wap($param){
		$out_trade_no = $param['orderno'];
		$subject = isset($param['title'])?$param['title']:'订单'.$out_trade_no;//订单名称，必填
		$total_amount = $param['amount'];//付款金额，必填
		$body = isset($param['body'])?$param['body']:'订单'.$out_trade_no;//商品描述，可空
	    $timeout_express="1m";//超时时间
	
	    $payRequestBuilder = new \alipay\wappay\buildermodel\AlipayTradeWapPayContentBuilder();
	    $payRequestBuilder->setBody($body);
	    $payRequestBuilder->setSubject($subject);
	    $payRequestBuilder->setOutTradeNo($out_trade_no);
	    $payRequestBuilder->setTotalAmount($total_amount);
	    $payRequestBuilder->setTimeExpress($timeout_express);
		$return_url=$param['return_url']?$param['return_url']:$this->config['return_url'];
		$notify_url=$param['notify_url']?$param['notify_url']:$this->config['notify_url'];
	
	    $payResponse = new \alipay\wappay\service\AlipayTradeService($this->config);
	    $result=$payResponse->wapPay($payRequestBuilder,$return_url,$notify_url);
	}
	
	
	/**
	 * 验签方法
	 * @param $arr 验签支付宝返回的信息，使用支付宝公钥。
	 * @return boolean
	 */
	function check($arr){
		if( isset($_POST['trade_status']) && $_POST['trade_status']!='TRADE_SUCCESS'){
		    return false;
		}
		$alipaySevice = new \alipay\pagepay\service\AlipayTradeService($this->config); 
		return $alipaySevice->check($arr);
	}
   
}