<?php
namespace aliyun\OTS\Handlers;

use aliyun\OTS;

class ErrorHandler
{
    private function logOTSServerException(RequestContext $context, \aliyun\OTS\OTSServerException $exception)
    {
        $errorLogger = $context->clientConfig->errorLogHandler;

        if ($errorLogger != null) {
            $errorLogger((string)$exception);
        }
    }

    public function handleBefore(RequestContext $context)
    {
        // empty
    }

    public function handleAfter(RequestContext $context)
    {
        if ($context->responseHttpStatus >= 200 && $context->responseHttpStatus < 300) {
            return;
        }else{
        	if(!is_array($context->responseBody)){
        		header("Content-Type:application/json; charset=utf-8");
        	    echo(json_encode(array('status'=>0,'info'=>$context->responseBody)));die;
        	}else{
        		echo($context->responseBody);die;
        	}
        }

        $error = new \Error();
        $errorCode = null;
        $errorMessage = null;

        try {
            $error->ParseFromString($context->responseBody);
            $errorCode = $error->code();
            $errorMessage = $error->message();
        } catch (\Exception $e) {

            // Sometimes the response body is not a valid Error PB Message,
            // in this case the user should get informed with http status
            $exception = new \aliyun\OTS\OTSServerException($context->apiName, $context->responseHttpStatus);
            $this->logOTSServerException($context, $exception);
            $context->otsServerException = $exception;
            return;
        }

        $requestId = null;
        if (isset($context->responseHeaders['x-ots-requestid'])) {
            $requestId = $context->responseHeaders['x-ots-requestid'];
        }

        $exception = new \aliyun\OTS\OTSServerException(
            $context->apiName, $context->responseHttpStatus,
            $errorCode, $errorMessage, $requestId);
			
        $this->logOTSServerException($context, $exception);
        $context->otsServerException = $exception;
    }
}

