<?php
namespace OpenSearch\Generated\Search;

/**
 * Autogenerated by Thrift Compiler (0.10.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


final class SearchType {
  const SEARCH = 0;
  const SCROLL = 1;
  static public $__names = array(
    0 => 'SEARCH',
    1 => 'SCROLL',
  );
}

final class SearchFormat {
  const XML = 0;
  const JSON = 1;
  const FULLJSON = 2;
  const PROTOBUF = 3;
  static public $__names = array(
    0 => 'XML',
    1 => 'JSON',
    2 => 'FULLJSON',
    3 => 'PROTOBUF',
  );
}

final class Order {
  const DECREASE = 0;
  const INCREASE = 1;
  static public $__names = array(
    0 => 'DECREASE',
    1 => 'INCREASE',
  );
}

class Config {
  static $_TSPEC;

  /**
   * app name 或 app id 或 app version
   * 
   * @var string[]
   */
  public $appNames = null;
  /**
   * @var int
   */
  public $start = 0;
  /**
   * @var int
   */
  public $hits = 15;
  /**
   * @var int
   */
  public $searchFormat =   0;
  /**
   * example:  query=config=start:0,hit:15,rerank_size:200,format:json,KVpairs=name:company_name,price:new_price&&query=id:'489013149'</p>
   * 
   * config.setCustomConfig(Lists.newArrayList("mykey1:name#company_name,price#new_price"));
   * 
   * 
   * 
   * @var string[]
   */
  public $customConfig = null;
  /**
   * example: cluster=daogou&&kvpairs=name:company_name&&query=笔筒</p>
   * 
   * config.setKvpairs("name:company_name,price:new_price");
   * 
   * 
   * 
   * @var string
   */
  public $kvpairs = null;
  /**
   * 获取搜索结果包含的字段列表(fetch_fields)
   * 
   * 
   * @var string[]
   */
  public $fetchFields = null;
  /**
   * 分区查询.  routeValue为分区键所对应的值.
   * 
   * 
   * @var string
   */
  public $routeValue = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appNames',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        2 => array(
          'var' => 'start',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'hits',
          'type' => TType::I32,
          ),
        5 => array(
          'var' => 'searchFormat',
          'type' => TType::I32,
          ),
        7 => array(
          'var' => 'customConfig',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        9 => array(
          'var' => 'kvpairs',
          'type' => TType::STRING,
          ),
        11 => array(
          'var' => 'fetchFields',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        13 => array(
          'var' => 'routeValue',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appNames'])) {
        $this->appNames = $vals['appNames'];
      }
      if (isset($vals['start'])) {
        $this->start = $vals['start'];
      }
      if (isset($vals['hits'])) {
        $this->hits = $vals['hits'];
      }
      if (isset($vals['searchFormat'])) {
        $this->searchFormat = $vals['searchFormat'];
      }
      if (isset($vals['customConfig'])) {
        $this->customConfig = $vals['customConfig'];
      }
      if (isset($vals['kvpairs'])) {
        $this->kvpairs = $vals['kvpairs'];
      }
      if (isset($vals['fetchFields'])) {
        $this->fetchFields = $vals['fetchFields'];
      }
      if (isset($vals['routeValue'])) {
        $this->routeValue = $vals['routeValue'];
      }
    }
  }

  public function getName() {
    return 'Config';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::LST) {
            $this->appNames = array();
            $_size0 = 0;
            $_etype3 = 0;
            $xfer += $input->readListBegin($_etype3, $_size0);
            for ($_i4 = 0; $_i4 < $_size0; ++$_i4)
            {
              $elem5 = null;
              $xfer += $input->readString($elem5);
              $this->appNames []= $elem5;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->start);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->hits);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->searchFormat);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::LST) {
            $this->customConfig = array();
            $_size6 = 0;
            $_etype9 = 0;
            $xfer += $input->readListBegin($_etype9, $_size6);
            for ($_i10 = 0; $_i10 < $_size6; ++$_i10)
            {
              $elem11 = null;
              $xfer += $input->readString($elem11);
              $this->customConfig []= $elem11;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 9:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->kvpairs);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 11:
          if ($ftype == TType::LST) {
            $this->fetchFields = array();
            $_size12 = 0;
            $_etype15 = 0;
            $xfer += $input->readListBegin($_etype15, $_size12);
            for ($_i16 = 0; $_i16 < $_size12; ++$_i16)
            {
              $elem17 = null;
              $xfer += $input->readString($elem17);
              $this->fetchFields []= $elem17;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 13:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->routeValue);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Config');
    if ($this->appNames !== null) {
      if (!is_array($this->appNames)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('appNames', TType::LST, 1);
      {
        $output->writeListBegin(TType::STRING, count($this->appNames));
        {
          foreach ($this->appNames as $iter18)
          {
            $xfer += $output->writeString($iter18);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->start !== null) {
      $xfer += $output->writeFieldBegin('start', TType::I32, 2);
      $xfer += $output->writeI32($this->start);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->hits !== null) {
      $xfer += $output->writeFieldBegin('hits', TType::I32, 3);
      $xfer += $output->writeI32($this->hits);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->searchFormat !== null) {
      $xfer += $output->writeFieldBegin('searchFormat', TType::I32, 5);
      $xfer += $output->writeI32($this->searchFormat);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->customConfig !== null) {
      if (!is_array($this->customConfig)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('customConfig', TType::LST, 7);
      {
        $output->writeListBegin(TType::STRING, count($this->customConfig));
        {
          foreach ($this->customConfig as $iter19)
          {
            $xfer += $output->writeString($iter19);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->kvpairs !== null) {
      $xfer += $output->writeFieldBegin('kvpairs', TType::STRING, 9);
      $xfer += $output->writeString($this->kvpairs);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->fetchFields !== null) {
      if (!is_array($this->fetchFields)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('fetchFields', TType::LST, 11);
      {
        $output->writeListBegin(TType::STRING, count($this->fetchFields));
        {
          foreach ($this->fetchFields as $iter20)
          {
            $xfer += $output->writeString($iter20);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->routeValue !== null) {
      $xfer += $output->writeFieldBegin('routeValue', TType::STRING, 13);
      $xfer += $output->writeString($this->routeValue);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * 
 * 传统搜索场景的主要目的是为了尽量短的时间内召回最符合的结果，所以对搜索结果进行了限制。在某些场景下需要提供更多的结果来进行分析工作，
 * 可以使用scroll接口来获取更多的结果，目前scorll只支持query与filter子句，sort子句无法支持。
 * 
 * 注意事项
 * <pre>
 *  1, start值无效，通过hit值设置每次返回的结果数，即后续查询都以第一次查询指定的hit值为准；
 *  2, aggregate、sort、distinct、排序表达式无效，如果传入，查询会报错且无结果；
 *  3, 第一次查询需要完整的query、index_name、AccessKeyId等参数，后面的查询不需要传这些参数（即使传入，也会被忽略），只需要传入上一次返回的scroll_id即可；
 *  4, 不支持多应用scroll查询；
 *  5, 每次查询都必须传scroll参数，如果不传，对于第一次查询，就按正常的查询；对于后续的查询，按scroll处理，但结果中无scroll_id返回。
 *  6, 返回结果均有第一次查询中的format决定，后续传scroll_id的响应格式均同第一次；
 *  7, 如果用户传入的scroll_id是非法的，那么查询会报错，返回结果格式为json。
 *  8, 第一次查询将不返回实际文档数据，只返回scroll_id，需要再次访问才能拿到搜索结果。
 *  </pre>
 */
class DeepPaging {
  static $_TSPEC;

  /**
   * 设置scroll请求的有效期
   * 
   * @param expire 指定的scroll请求有效期 默认 1m 表示一分钟，支持的时间单位包括：w=Week, d=Day, h=Hour, m=minute, s=second
   * 
   * @var string
   */
  public $scrollExpire = "1m";
  /**
   * @var string
   */
  public $scrollId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scrollExpire',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'scrollId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scrollExpire'])) {
        $this->scrollExpire = $vals['scrollExpire'];
      }
      if (isset($vals['scrollId'])) {
        $this->scrollId = $vals['scrollId'];
      }
    }
  }

  public function getName() {
    return 'DeepPaging';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->scrollExpire);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->scrollId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('DeepPaging');
    if ($this->scrollExpire !== null) {
      $xfer += $output->writeFieldBegin('scrollExpire', TType::STRING, 1);
      $xfer += $output->writeString($this->scrollExpire);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->scrollId !== null) {
      $xfer += $output->writeFieldBegin('scrollId', TType::STRING, 3);
      $xfer += $output->writeString($this->scrollId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class SortField {
  static $_TSPEC;

  /**
   * 排序方式字段名.
   * 
   * 
   * @var string
   */
  public $field = null;
  /**
   * 排序方式，有升序“INCREASE”和降序“DECREASE”两种方式。默认值为“DECREASE”
   * 
   * 
   * @var int
   */
  public $order =   0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'field',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'order',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['field'])) {
        $this->field = $vals['field'];
      }
      if (isset($vals['order'])) {
        $this->order = $vals['order'];
      }
    }
  }

  public function getName() {
    return 'SortField';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->field);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->order);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('SortField');
    if ($this->field !== null) {
      $xfer += $output->writeFieldBegin('field', TType::STRING, 1);
      $xfer += $output->writeString($this->field);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->order !== null) {
      $xfer += $output->writeFieldBegin('order', TType::I32, 3);
      $xfer += $output->writeI32($this->order);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * 排序字段及方式
 * 
 */
class Sort {
  static $_TSPEC;

  /**
   * @var \OpenSearch\Generated\Search\SortField[]
   */
  public $sortFields = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'sortFields',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\OpenSearch\Generated\Search\SortField',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['sortFields'])) {
        $this->sortFields = $vals['sortFields'];
      }
    }
  }

  public function getName() {
    return 'Sort';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::LST) {
            $this->sortFields = array();
            $_size21 = 0;
            $_etype24 = 0;
            $xfer += $input->readListBegin($_etype24, $_size21);
            for ($_i25 = 0; $_i25 < $_size21; ++$_i25)
            {
              $elem26 = null;
              $elem26 = new \OpenSearch\Generated\Search\SortField();
              $xfer += $elem26->read($input);
              $this->sortFields []= $elem26;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Sort');
    if ($this->sortFields !== null) {
      if (!is_array($this->sortFields)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('sortFields', TType::LST, 1);
      {
        $output->writeListBegin(TType::STRUCT, count($this->sortFields));
        {
          foreach ($this->sortFields as $iter27)
          {
            $xfer += $iter27->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * 排序相关度及表达式
 * 
 */
class Rank {
  static $_TSPEC;

  /**
   * @var int
   */
  public $reRankSize = 200;
  /**
   * 设置粗排表达式名称
   * 
   * 
   * @var string
   */
  public $firstRankName = null;
  /**
   * 设置粗排表达式名称
   * 
   * 
   * @var string
   */
  public $secondRankName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'reRankSize',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'firstRankName',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'secondRankName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['reRankSize'])) {
        $this->reRankSize = $vals['reRankSize'];
      }
      if (isset($vals['firstRankName'])) {
        $this->firstRankName = $vals['firstRankName'];
      }
      if (isset($vals['secondRankName'])) {
        $this->secondRankName = $vals['secondRankName'];
      }
    }
  }

  public function getName() {
    return 'Rank';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->reRankSize);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->firstRankName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->secondRankName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Rank');
    if ($this->reRankSize !== null) {
      $xfer += $output->writeFieldBegin('reRankSize', TType::I32, 1);
      $xfer += $output->writeI32($this->reRankSize);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->firstRankName !== null) {
      $xfer += $output->writeFieldBegin('firstRankName', TType::STRING, 3);
      $xfer += $output->writeString($this->firstRankName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->secondRankName !== null) {
      $xfer += $output->writeFieldBegin('secondRankName', TType::STRING, 5);
      $xfer += $output->writeString($this->secondRankName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * 增加了此内容后，fieldName字段可能会被截断、飘红等。
 * 
 */
class Summary {
  static $_TSPEC;

  /**
   * 指定的生效的字段。此字段必需为可分词的text类型的字段。
   * 
   * 
   * @var string
   */
  public $summary_field = null;
  /**
   * 指定结果集返回的词字段的字节长度，一个汉字为2个字节。
   * 
   * 
   * @var string
   */
  public $summary_len = null;
  /**
   * 指定用什么符号来标注未展示完的数据，例如“...”。
   * 
   * 
   * @var string
   */
  public $summary_ellipsis = "...";
  /**
   * 指定query命中几段summary内容。
   * 
   * 
   * @var string
   */
  public $summary_snippet = null;
  /**
   * 指定命中的query的标红标签，可以为em等。
   * 
   * 
   * @var string
   */
  public $summary_element = null;
  /**
   * 指定标签前缀。
   * 
   * 
   * @var string
   */
  public $summary_element_prefix = null;
  /**
   * 指定标签后缀。
   * 
   * 
   * @var string
   */
  public $summary_element_postfix = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'summary_field',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'summary_len',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'summary_ellipsis',
          'type' => TType::STRING,
          ),
        7 => array(
          'var' => 'summary_snippet',
          'type' => TType::STRING,
          ),
        9 => array(
          'var' => 'summary_element',
          'type' => TType::STRING,
          ),
        11 => array(
          'var' => 'summary_element_prefix',
          'type' => TType::STRING,
          ),
        13 => array(
          'var' => 'summary_element_postfix',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['summary_field'])) {
        $this->summary_field = $vals['summary_field'];
      }
      if (isset($vals['summary_len'])) {
        $this->summary_len = $vals['summary_len'];
      }
      if (isset($vals['summary_ellipsis'])) {
        $this->summary_ellipsis = $vals['summary_ellipsis'];
      }
      if (isset($vals['summary_snippet'])) {
        $this->summary_snippet = $vals['summary_snippet'];
      }
      if (isset($vals['summary_element'])) {
        $this->summary_element = $vals['summary_element'];
      }
      if (isset($vals['summary_element_prefix'])) {
        $this->summary_element_prefix = $vals['summary_element_prefix'];
      }
      if (isset($vals['summary_element_postfix'])) {
        $this->summary_element_postfix = $vals['summary_element_postfix'];
      }
    }
  }

  public function getName() {
    return 'Summary';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->summary_field);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->summary_len);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->summary_ellipsis);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->summary_snippet);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 9:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->summary_element);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 11:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->summary_element_prefix);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 13:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->summary_element_postfix);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Summary');
    if ($this->summary_field !== null) {
      $xfer += $output->writeFieldBegin('summary_field', TType::STRING, 1);
      $xfer += $output->writeString($this->summary_field);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->summary_len !== null) {
      $xfer += $output->writeFieldBegin('summary_len', TType::STRING, 3);
      $xfer += $output->writeString($this->summary_len);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->summary_ellipsis !== null) {
      $xfer += $output->writeFieldBegin('summary_ellipsis', TType::STRING, 5);
      $xfer += $output->writeString($this->summary_ellipsis);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->summary_snippet !== null) {
      $xfer += $output->writeFieldBegin('summary_snippet', TType::STRING, 7);
      $xfer += $output->writeString($this->summary_snippet);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->summary_element !== null) {
      $xfer += $output->writeFieldBegin('summary_element', TType::STRING, 9);
      $xfer += $output->writeString($this->summary_element);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->summary_element_prefix !== null) {
      $xfer += $output->writeFieldBegin('summary_element_prefix', TType::STRING, 11);
      $xfer += $output->writeString($this->summary_element_prefix);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->summary_element_postfix !== null) {
      $xfer += $output->writeFieldBegin('summary_element_postfix', TType::STRING, 13);
      $xfer += $output->writeString($this->summary_element_postfix);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * 添加统计信息(aggregate)
 * 
 * 一个关键词通常能命中数以万计的文档，用户不太可能浏览所有文档来获取信息。而用户感兴趣的
 * 可 能是一些统计类的信息，比如，查询“手机”这个关键词，想知道每个卖家所有商品中的最高价格。
 * 则可以按照卖家的user_id分组，统计每个小组中最大的price值，例如：
 * groupKey:user_id,aggFun:max(price)
 * 
 * 相关wiki，请查询：
 * @link http://docs.aliyun.com/?spm=5176.2020520121.103.8.VQIcGd&tag=tun#/pub/opensearch/api-reference/query-clause&aggregate-clause
 * 
 */
class Aggregate {
  static $_TSPEC;

  /**
   * 指定需要统计的字段名称。
   * 
   * 
   * @var string
   */
  public $groupKey = null;
  /**
   * 指定统计的方法。当前支持：count、max、min、sum等。
   * 
   * 
   * @var string
   */
  public $aggFun = null;
  /**
   * 指定统计范围。
   * 
   * 
   * @var string
   */
  public $range = null;
  /**
   * 最大组个数。
   * 
   * 
   * @var string
   */
  public $maxGroup = null;
  /**
   * 指定过滤某些统计。
   * 
   * 
   * @var string
   */
  public $aggFilter = null;
  /**
   * 指定抽样的阈值。
   * 
   * 
   * @var string
   */
  public $aggSamplerThresHold = null;
  /**
   * 指定抽样的步长。
   * 
   * 
   * @var string
   */
  public $aggSamplerStep = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'groupKey',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'aggFun',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'range',
          'type' => TType::STRING,
          ),
        7 => array(
          'var' => 'maxGroup',
          'type' => TType::STRING,
          ),
        9 => array(
          'var' => 'aggFilter',
          'type' => TType::STRING,
          ),
        11 => array(
          'var' => 'aggSamplerThresHold',
          'type' => TType::STRING,
          ),
        13 => array(
          'var' => 'aggSamplerStep',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['groupKey'])) {
        $this->groupKey = $vals['groupKey'];
      }
      if (isset($vals['aggFun'])) {
        $this->aggFun = $vals['aggFun'];
      }
      if (isset($vals['range'])) {
        $this->range = $vals['range'];
      }
      if (isset($vals['maxGroup'])) {
        $this->maxGroup = $vals['maxGroup'];
      }
      if (isset($vals['aggFilter'])) {
        $this->aggFilter = $vals['aggFilter'];
      }
      if (isset($vals['aggSamplerThresHold'])) {
        $this->aggSamplerThresHold = $vals['aggSamplerThresHold'];
      }
      if (isset($vals['aggSamplerStep'])) {
        $this->aggSamplerStep = $vals['aggSamplerStep'];
      }
    }
  }

  public function getName() {
    return 'Aggregate';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->groupKey);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->aggFun);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->range);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->maxGroup);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 9:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->aggFilter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 11:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->aggSamplerThresHold);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 13:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->aggSamplerStep);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Aggregate');
    if ($this->groupKey !== null) {
      $xfer += $output->writeFieldBegin('groupKey', TType::STRING, 1);
      $xfer += $output->writeString($this->groupKey);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->aggFun !== null) {
      $xfer += $output->writeFieldBegin('aggFun', TType::STRING, 3);
      $xfer += $output->writeString($this->aggFun);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->range !== null) {
      $xfer += $output->writeFieldBegin('range', TType::STRING, 5);
      $xfer += $output->writeString($this->range);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxGroup !== null) {
      $xfer += $output->writeFieldBegin('maxGroup', TType::STRING, 7);
      $xfer += $output->writeString($this->maxGroup);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->aggFilter !== null) {
      $xfer += $output->writeFieldBegin('aggFilter', TType::STRING, 9);
      $xfer += $output->writeString($this->aggFilter);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->aggSamplerThresHold !== null) {
      $xfer += $output->writeFieldBegin('aggSamplerThresHold', TType::STRING, 11);
      $xfer += $output->writeString($this->aggSamplerThresHold);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->aggSamplerStep !== null) {
      $xfer += $output->writeFieldBegin('aggSamplerStep', TType::STRING, 13);
      $xfer += $output->writeString($this->aggSamplerStep);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * 聚合打散条件(distinct)
 * 
 * 例如：检索关键词“手机”共获得10个结果，分别为：doc1，doc2，doc3，doc4，doc5，doc6，
 * doc7，doc8，doc9，doc10。其中前三个属于用户A，doc4-doc6属于用户B，剩余四个属于
 * 用户C。如果前端每页仅展示5个商品，则用户C将没有展示的机会。但是如果按照user_id进行抽
 * 取，每轮抽取1个，抽取2次，并保留抽取剩余的结果，则可以获得以下文档排列顺序：doc1、
 * doc4、doc7、doc2、doc5、doc8、doc3、doc6、doc9、doc10。可以看出，通过distinct
 * 排序，各个用户的 商品都得到了展示机会，结果排序更趋于合理。
 */
class Distinct {
  static $_TSPEC;

  /**
   * 为用户用于做distinct抽取的字段，该字段要求为可过滤字段。
   *  
   * 
   * @var string
   */
  public $key = null;
  /**
   * 为一次抽取的document数量，默认值为1。
   *  
   * 
   * @var int
   */
  public $distCount = 1;
  /**
   * 为抽取的次数，默认值为1。
   *  
   * 
   * @var int
   */
  public $distTimes = 1;
  /**
   * 为是否保留抽取之后剩余的结果，true为保留，false则丢弃，丢弃时totalHits的个数会减去被distinct而丢弃的个数，但这个结果不一定准确，默认为true。
   *  
   * 
   * @var bool
   */
  public $reserved = true;
  /**
   * 为过滤条件，被过滤的doc不参与distinct，只在后面的 排序中，这些被过滤的doc将和被distinct出来的第一组doc一起参与排序。默认是全部参与distinct。
   *  
   * 
   * @var string
   */
  public $distFilter = null;
  /**
   * 当reserved为false时，设置update_total_hit为true，则最终total_hit会减去被distinct丢弃的的数目（不一定准确），为false则不减； 默认为false。
   *  
   * 
   * @var bool
   */
  public $updateTotalHit = false;
  /**
   * 指定档位划分阈值。
   *  
   * 
   * @var string
   */
  public $grade = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'key',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'distCount',
          'type' => TType::I32,
          ),
        5 => array(
          'var' => 'distTimes',
          'type' => TType::I32,
          ),
        7 => array(
          'var' => 'reserved',
          'type' => TType::BOOL,
          ),
        9 => array(
          'var' => 'distFilter',
          'type' => TType::STRING,
          ),
        11 => array(
          'var' => 'updateTotalHit',
          'type' => TType::BOOL,
          ),
        13 => array(
          'var' => 'grade',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
      if (isset($vals['distCount'])) {
        $this->distCount = $vals['distCount'];
      }
      if (isset($vals['distTimes'])) {
        $this->distTimes = $vals['distTimes'];
      }
      if (isset($vals['reserved'])) {
        $this->reserved = $vals['reserved'];
      }
      if (isset($vals['distFilter'])) {
        $this->distFilter = $vals['distFilter'];
      }
      if (isset($vals['updateTotalHit'])) {
        $this->updateTotalHit = $vals['updateTotalHit'];
      }
      if (isset($vals['grade'])) {
        $this->grade = $vals['grade'];
      }
    }
  }

  public function getName() {
    return 'Distinct';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->key);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->distCount);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->distTimes);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->reserved);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 9:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->distFilter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 11:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->updateTotalHit);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 13:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->grade);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Distinct');
    if ($this->key !== null) {
      $xfer += $output->writeFieldBegin('key', TType::STRING, 1);
      $xfer += $output->writeString($this->key);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->distCount !== null) {
      $xfer += $output->writeFieldBegin('distCount', TType::I32, 3);
      $xfer += $output->writeI32($this->distCount);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->distTimes !== null) {
      $xfer += $output->writeFieldBegin('distTimes', TType::I32, 5);
      $xfer += $output->writeI32($this->distTimes);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->reserved !== null) {
      $xfer += $output->writeFieldBegin('reserved', TType::BOOL, 7);
      $xfer += $output->writeBool($this->reserved);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->distFilter !== null) {
      $xfer += $output->writeFieldBegin('distFilter', TType::STRING, 9);
      $xfer += $output->writeString($this->distFilter);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->updateTotalHit !== null) {
      $xfer += $output->writeFieldBegin('updateTotalHit', TType::BOOL, 11);
      $xfer += $output->writeBool($this->updateTotalHit);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->grade !== null) {
      $xfer += $output->writeFieldBegin('grade', TType::STRING, 13);
      $xfer += $output->writeString($this->grade);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Suggest {
  static $_TSPEC;

  /**
   * @var string
   */
  public $suggestName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'suggestName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['suggestName'])) {
        $this->suggestName = $vals['suggestName'];
      }
    }
  }

  public function getName() {
    return 'Suggest';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->suggestName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Suggest');
    if ($this->suggestName !== null) {
      $xfer += $output->writeFieldBegin('suggestName', TType::STRING, 1);
      $xfer += $output->writeString($this->suggestName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class SearchParams {
  static $_TSPEC;

  /**
   * config for search.
   * 
   * @var \OpenSearch\Generated\Search\Config
   */
  public $config = null;
  /**
   * 设定指定索引字段范围的搜索关键词(query)
   * 
   * 此query是查询必需的一部分，可以指定不同的索引名，并同时可指定多个查询及之间的关系
   * （AND, OR, ANDNOT, RANK）。
   * 
   * 例如查询subject索引字段的query:“手机”，可以设置为 query=subject:'手机'。
   * 
   * 上边例子如果查询price 在1000-2000之间的手机，其查询语句为： query=subject:'手机'
   * AND price:[1000,2000]
   * 
   * NOTE: text类型索引在建立时做了分词，而string类型的索引则没有分词。
   * 
   * @link http://docs.aliyun.com/?spm=5176.2020520121.103.8.VQIcGd&tag=tun#/pub/opensearch/api-reference/query-clause&query-clause
   * 
   * 
   * @var string
   */
  public $query = null;
  /**
   * 过滤规则(filter)
   * 
   * @var string
   */
  public $filter = null;
  /**
   * 排序字段及排序方式(sort)
   * 
   * @var \OpenSearch\Generated\Search\Sort
   */
  public $sort = null;
  /**
   * @var \OpenSearch\Generated\Search\Rank
   */
  public $rank = null;
  /**
   * 添加统计信息(aggregate)相关参数
   * 
   * @var \OpenSearch\Generated\Search\Aggregate[]
   */
  public $aggregates = null;
  /**
   * 聚合打散条件
   * 
   * @var \OpenSearch\Generated\Search\Distinct[]
   */
  public $distincts = null;
  /**
   * 动态摘要(summary)信息
   * 
   * @var \OpenSearch\Generated\Search\Summary[]
   */
  public $summaries = null;
  /**
   * 设置查询分析规则(qp)
   * 
   * @var string[]
   */
  public $queryProcessorNames = null;
  /**
   * @var \OpenSearch\Generated\Search\DeepPaging
   */
  public $deepPaging = null;
  /**
   * 关闭某些功能模块(disable)
   * 
   * 有如下场景需要考虑：
   * 1、如果要关闭整个qp的功能，则指定disableValue="qp"。
   * 2、要指定某个索引关闭某个功能，则可以指定disableValue="qp:function_name:index_names",
   *   其中index_names可以用“|”分隔，可以为index_name1|index_name2...
   * 3、如果要关闭多个function可以用“,”分隔，例如：disableValue="qp:function_name1:index_name1,qp:function_name2:index_name1"
   * 
   * qp有如下模块：
   * 1、spell_check: 检查用户查询串中的拼写错误，并给出纠错建议。
   * 2、term_weighting: 分析查询中每个词的重要程度，并将其量化成权重，权重较低的词可能不会参与召回。
   * 3、stop_word: 根据系统内置的停用词典过滤查询中无意义的词
   * 4、synonym: 根据系统提供的通用同义词库和语义模型，对查询串进行同义词扩展，以便扩大召回。
   * 
   * example:
   * "qp" 标示关闭整个qp
   * "qp:spell_check" 标示关闭qp的拼音纠错功能。
   * "qp:stop_word:index_name1|index_name2" 标示关闭qp中index_name1和index_name2上的停用词功能。
   * 
   * key 需要禁用的函数名称
   * value 待禁用函数的详细说明
   * 
   * @var array
   */
  public $disableFunctions = null;
  /**
   * @var array
   */
  public $customParam = null;
  /**
   * 下拉提示是搜索服务的基础功能，在用户输入查询词的过程中，智能推荐候选query，减少用户输入，帮助用户尽快找到想要的内容。
   * OpenSearch下拉提示在实现了中文前缀，拼音全拼，拼音首字母简拼查询等通用功能的基础上，实现了基于用户文档内容的query智能识别。
   * 用户通过控制台的简单配置，就能拥有专属的定制下拉提示。此外，控制台上还提供了黑名单，推荐词条功能，让用户进一步控制下拉提示
   * 的结果，实现更灵活的定制。
   * 
   * 
   * @var \OpenSearch\Generated\Search\Suggest
   */
  public $suggest = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        3 => array(
          'var' => 'config',
          'type' => TType::STRUCT,
          'class' => '\OpenSearch\Generated\Search\Config',
          ),
        5 => array(
          'var' => 'query',
          'type' => TType::STRING,
          ),
        7 => array(
          'var' => 'filter',
          'type' => TType::STRING,
          ),
        9 => array(
          'var' => 'sort',
          'type' => TType::STRUCT,
          'class' => '\OpenSearch\Generated\Search\Sort',
          ),
        11 => array(
          'var' => 'rank',
          'type' => TType::STRUCT,
          'class' => '\OpenSearch\Generated\Search\Rank',
          ),
        13 => array(
          'var' => 'aggregates',
          'type' => TType::SET,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\OpenSearch\Generated\Search\Aggregate',
            ),
          ),
        15 => array(
          'var' => 'distincts',
          'type' => TType::SET,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\OpenSearch\Generated\Search\Distinct',
            ),
          ),
        17 => array(
          'var' => 'summaries',
          'type' => TType::SET,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\OpenSearch\Generated\Search\Summary',
            ),
          ),
        19 => array(
          'var' => 'queryProcessorNames',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        21 => array(
          'var' => 'deepPaging',
          'type' => TType::STRUCT,
          'class' => '\OpenSearch\Generated\Search\DeepPaging',
          ),
        23 => array(
          'var' => 'disableFunctions',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        27 => array(
          'var' => 'customParam',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        29 => array(
          'var' => 'suggest',
          'type' => TType::STRUCT,
          'class' => '\OpenSearch\Generated\Search\Suggest',
          ),
        );
    }
    $this->rank = new \OpenSearch\Generated\Search\Rank(array(
      "reRankSize" => 200,
    ));
    if (is_array($vals)) {
      if (isset($vals['config'])) {
        $this->config = $vals['config'];
      }
      if (isset($vals['query'])) {
        $this->query = $vals['query'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['sort'])) {
        $this->sort = $vals['sort'];
      }
      if (isset($vals['rank'])) {
        $this->rank = $vals['rank'];
      }
      if (isset($vals['aggregates'])) {
        $this->aggregates = $vals['aggregates'];
      }
      if (isset($vals['distincts'])) {
        $this->distincts = $vals['distincts'];
      }
      if (isset($vals['summaries'])) {
        $this->summaries = $vals['summaries'];
      }
      if (isset($vals['queryProcessorNames'])) {
        $this->queryProcessorNames = $vals['queryProcessorNames'];
      }
      if (isset($vals['deepPaging'])) {
        $this->deepPaging = $vals['deepPaging'];
      }
      if (isset($vals['disableFunctions'])) {
        $this->disableFunctions = $vals['disableFunctions'];
      }
      if (isset($vals['customParam'])) {
        $this->customParam = $vals['customParam'];
      }
      if (isset($vals['suggest'])) {
        $this->suggest = $vals['suggest'];
      }
    }
  }

  public function getName() {
    return 'SearchParams';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->config = new \OpenSearch\Generated\Search\Config();
            $xfer += $this->config->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->query);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->filter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 9:
          if ($ftype == TType::STRUCT) {
            $this->sort = new \OpenSearch\Generated\Search\Sort();
            $xfer += $this->sort->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 11:
          if ($ftype == TType::STRUCT) {
            $this->rank = new \OpenSearch\Generated\Search\Rank();
            $xfer += $this->rank->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 13:
          if ($ftype == TType::SET) {
            $this->aggregates = array();
            $_size28 = 0;
            $_etype31 = 0;
            $xfer += $input->readSetBegin($_etype31, $_size28);
            for ($_i32 = 0; $_i32 < $_size28; ++$_i32)
            {
              $elem33 = null;
              $elem33 = new \OpenSearch\Generated\Search\Aggregate();
              $xfer += $elem33->read($input);
              if (is_scalar($elem33)) {
                $this->aggregates[$elem33] = true;
              } else {
                $this->aggregates []= $elem33;
              }
            }
            $xfer += $input->readSetEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 15:
          if ($ftype == TType::SET) {
            $this->distincts = array();
            $_size34 = 0;
            $_etype37 = 0;
            $xfer += $input->readSetBegin($_etype37, $_size34);
            for ($_i38 = 0; $_i38 < $_size34; ++$_i38)
            {
              $elem39 = null;
              $elem39 = new \OpenSearch\Generated\Search\Distinct();
              $xfer += $elem39->read($input);
              if (is_scalar($elem39)) {
                $this->distincts[$elem39] = true;
              } else {
                $this->distincts []= $elem39;
              }
            }
            $xfer += $input->readSetEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 17:
          if ($ftype == TType::SET) {
            $this->summaries = array();
            $_size40 = 0;
            $_etype43 = 0;
            $xfer += $input->readSetBegin($_etype43, $_size40);
            for ($_i44 = 0; $_i44 < $_size40; ++$_i44)
            {
              $elem45 = null;
              $elem45 = new \OpenSearch\Generated\Search\Summary();
              $xfer += $elem45->read($input);
              if (is_scalar($elem45)) {
                $this->summaries[$elem45] = true;
              } else {
                $this->summaries []= $elem45;
              }
            }
            $xfer += $input->readSetEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 19:
          if ($ftype == TType::LST) {
            $this->queryProcessorNames = array();
            $_size46 = 0;
            $_etype49 = 0;
            $xfer += $input->readListBegin($_etype49, $_size46);
            for ($_i50 = 0; $_i50 < $_size46; ++$_i50)
            {
              $elem51 = null;
              $xfer += $input->readString($elem51);
              $this->queryProcessorNames []= $elem51;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 21:
          if ($ftype == TType::STRUCT) {
            $this->deepPaging = new \OpenSearch\Generated\Search\DeepPaging();
            $xfer += $this->deepPaging->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 23:
          if ($ftype == TType::MAP) {
            $this->disableFunctions = array();
            $_size52 = 0;
            $_ktype53 = 0;
            $_vtype54 = 0;
            $xfer += $input->readMapBegin($_ktype53, $_vtype54, $_size52);
            for ($_i56 = 0; $_i56 < $_size52; ++$_i56)
            {
              $key57 = '';
              $val58 = '';
              $xfer += $input->readString($key57);
              $xfer += $input->readString($val58);
              $this->disableFunctions[$key57] = $val58;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 27:
          if ($ftype == TType::MAP) {
            $this->customParam = array();
            $_size59 = 0;
            $_ktype60 = 0;
            $_vtype61 = 0;
            $xfer += $input->readMapBegin($_ktype60, $_vtype61, $_size59);
            for ($_i63 = 0; $_i63 < $_size59; ++$_i63)
            {
              $key64 = '';
              $val65 = '';
              $xfer += $input->readString($key64);
              $xfer += $input->readString($val65);
              $this->customParam[$key64] = $val65;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 29:
          if ($ftype == TType::STRUCT) {
            $this->suggest = new \OpenSearch\Generated\Search\Suggest();
            $xfer += $this->suggest->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('SearchParams');
    if ($this->config !== null) {
      if (!is_object($this->config)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('config', TType::STRUCT, 3);
      $xfer += $this->config->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->query !== null) {
      $xfer += $output->writeFieldBegin('query', TType::STRING, 5);
      $xfer += $output->writeString($this->query);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      $xfer += $output->writeFieldBegin('filter', TType::STRING, 7);
      $xfer += $output->writeString($this->filter);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->sort !== null) {
      if (!is_object($this->sort)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('sort', TType::STRUCT, 9);
      $xfer += $this->sort->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->rank !== null) {
      if (!is_object($this->rank)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('rank', TType::STRUCT, 11);
      $xfer += $this->rank->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->aggregates !== null) {
      if (!is_array($this->aggregates)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('aggregates', TType::SET, 13);
      {
        $output->writeSetBegin(TType::STRUCT, count($this->aggregates));
        {
          foreach ($this->aggregates as $iter66 => $iter67)
          {
            if (is_scalar($iter67)) {
            $xfer += $iter66->write($output);
            } else {
            $xfer += $iter67->write($output);
            }
          }
        }
        $output->writeSetEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->distincts !== null) {
      if (!is_array($this->distincts)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('distincts', TType::SET, 15);
      {
        $output->writeSetBegin(TType::STRUCT, count($this->distincts));
        {
          foreach ($this->distincts as $iter68 => $iter69)
          {
            if (is_scalar($iter69)) {
            $xfer += $iter68->write($output);
            } else {
            $xfer += $iter69->write($output);
            }
          }
        }
        $output->writeSetEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->summaries !== null) {
      if (!is_array($this->summaries)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('summaries', TType::SET, 17);
      {
        $output->writeSetBegin(TType::STRUCT, count($this->summaries));
        {
          foreach ($this->summaries as $iter70 => $iter71)
          {
            if (is_scalar($iter71)) {
            $xfer += $iter70->write($output);
            } else {
            $xfer += $iter71->write($output);
            }
          }
        }
        $output->writeSetEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->queryProcessorNames !== null) {
      if (!is_array($this->queryProcessorNames)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('queryProcessorNames', TType::LST, 19);
      {
        $output->writeListBegin(TType::STRING, count($this->queryProcessorNames));
        {
          foreach ($this->queryProcessorNames as $iter72)
          {
            $xfer += $output->writeString($iter72);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deepPaging !== null) {
      if (!is_object($this->deepPaging)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('deepPaging', TType::STRUCT, 21);
      $xfer += $this->deepPaging->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->disableFunctions !== null) {
      if (!is_array($this->disableFunctions)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('disableFunctions', TType::MAP, 23);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->disableFunctions));
        {
          foreach ($this->disableFunctions as $kiter73 => $viter74)
          {
            $xfer += $output->writeString($kiter73);
            $xfer += $output->writeString($viter74);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->customParam !== null) {
      if (!is_array($this->customParam)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('customParam', TType::MAP, 27);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->customParam));
        {
          foreach ($this->customParam as $kiter75 => $viter76)
          {
            $xfer += $output->writeString($kiter75);
            $xfer += $output->writeString($viter76);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->suggest !== null) {
      if (!is_object($this->suggest)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('suggest', TType::STRUCT, 29);
      $xfer += $this->suggest->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

final class Constant extends \Thrift\Type\TConstant {
  static protected $CONFIG_CLAUSE_START;
  static protected $CONFIG_CLAUSE_HIT;
  static protected $CONFIG_CLAUSE_RERANK_SIZE;
  static protected $CONFIG_CLAUSE_FORMAT;
  static protected $SORT_CLAUSE_INCREASE;
  static protected $SORT_CLAUSE_DECREASE;
  static protected $SORT_CLAUSE_RANK;
  static protected $DISTINCT_CLAUSE_DIST_KEY;
  static protected $DISTINCT_CLAUSE_DIST_COUNT;
  static protected $DISTINCT_CLAUSE_DIST_TIMES;
  static protected $DISTINCT_CLAUSE_RESERVED;
  static protected $DISTINCT_CLAUSE_DIST_FILTER;
  static protected $DISTINCT_CLAUSE_UPDATE_TOTAL_HIT;
  static protected $DISTINCT_CLAUSE_GRADE;
  static protected $AGGREGATE_CLAUSE_GROUP_KEY;
  static protected $AGGREGATE_CLAUSE_AGG_FUN;
  static protected $AGGREGATE_CLAUSE_RANGE;
  static protected $AGGREGATE_CLAUSE_MAX_GROUP;
  static protected $AGGREGATE_CLAUSE_AGG_FILTER;
  static protected $AGGREGATE_CLAUSE_AGG_SAMPLER_THRESHOLD;
  static protected $AGGREGATE_CLAUSE_AGG_SAMPLER_STEP;
  static protected $SUMMARY_PARAM_SUMMARY_FIELD;
  static protected $SUMMARY_PARAM_SUMMARY_LEN;
  static protected $SUMMARY_PARAM_SUMMARY_ELLIPSIS;
  static protected $SUMMARY_PARAM_SUMMARY_SNIPPET;
  static protected $SUMMARY_PARAM_SUMMARY_ELEMENT;
  static protected $SUMMARY_PARAM_SUMMARY_ELEMENT_PREFIX;
  static protected $SUMMARY_PARAM_SUMMARY_ELEMENT_POSTFIX;
  static protected $FORMAT_PARAM;

  static protected function init_CONFIG_CLAUSE_START() {
    return "start";
  }

  static protected function init_CONFIG_CLAUSE_HIT() {
    return "hit";
  }

  static protected function init_CONFIG_CLAUSE_RERANK_SIZE() {
    return "rerank_size";
  }

  static protected function init_CONFIG_CLAUSE_FORMAT() {
    return "format";
  }

  static protected function init_SORT_CLAUSE_INCREASE() {
    return "+";
  }

  static protected function init_SORT_CLAUSE_DECREASE() {
    return "-";
  }

  static protected function init_SORT_CLAUSE_RANK() {
    return "RANK";
  }

  static protected function init_DISTINCT_CLAUSE_DIST_KEY() {
    return "dist_key";
  }

  static protected function init_DISTINCT_CLAUSE_DIST_COUNT() {
    return "dist_count";
  }

  static protected function init_DISTINCT_CLAUSE_DIST_TIMES() {
    return "dist_times";
  }

  static protected function init_DISTINCT_CLAUSE_RESERVED() {
    return "reserved";
  }

  static protected function init_DISTINCT_CLAUSE_DIST_FILTER() {
    return "dist_filter";
  }

  static protected function init_DISTINCT_CLAUSE_UPDATE_TOTAL_HIT() {
    return "update_total_hit";
  }

  static protected function init_DISTINCT_CLAUSE_GRADE() {
    return "grade";
  }

  static protected function init_AGGREGATE_CLAUSE_GROUP_KEY() {
    return "group_key";
  }

  static protected function init_AGGREGATE_CLAUSE_AGG_FUN() {
    return "agg_fun";
  }

  static protected function init_AGGREGATE_CLAUSE_RANGE() {
    return "range";
  }

  static protected function init_AGGREGATE_CLAUSE_MAX_GROUP() {
    return "max_group";
  }

  static protected function init_AGGREGATE_CLAUSE_AGG_FILTER() {
    return "agg_filter";
  }

  static protected function init_AGGREGATE_CLAUSE_AGG_SAMPLER_THRESHOLD() {
    return "agg_sampler_threshold";
  }

  static protected function init_AGGREGATE_CLAUSE_AGG_SAMPLER_STEP() {
    return "agg_sampler_step";
  }

  static protected function init_SUMMARY_PARAM_SUMMARY_FIELD() {
    return "summary_field";
  }

  static protected function init_SUMMARY_PARAM_SUMMARY_LEN() {
    return "summary_len";
  }

  static protected function init_SUMMARY_PARAM_SUMMARY_ELLIPSIS() {
    return "summary_ellipsis";
  }

  static protected function init_SUMMARY_PARAM_SUMMARY_SNIPPET() {
    return "summary_snippet";
  }

  static protected function init_SUMMARY_PARAM_SUMMARY_ELEMENT() {
    return "summary_element";
  }

  static protected function init_SUMMARY_PARAM_SUMMARY_ELEMENT_PREFIX() {
    return "summary_element_prefix";
  }

  static protected function init_SUMMARY_PARAM_SUMMARY_ELEMENT_POSTFIX() {
    return "summary_element_postfix";
  }

  static protected function init_FORMAT_PARAM() {
    return "format";
  }
}


